#!/usr/bin/env bash
# The script is a simple bash script that lists all the files in the bins directory
# and writes the full path of each file to a file called filenames.txt.
#
# The script is executed by the following command:
# $ ./get_filenames.sh
#
# The script creates a file called filenames.txt in the same directory as the script.
# filenames.txt may be freely moved to any location.
# The scripts expects the bins directory to be in the same directory as the script.

set -euo pipefail

SCRIPT_ROOT=$(dirname $(readlink -f "$0"))

if test -f filenames.txt; then
    echo "filenames.txt already exists"
    exit 1
fi

if ! test -d "${SCRIPT_ROOT}/bins"; then
    echo "bins directory does not exist"
    exit 1
fi

FILES_IN_BIN_DIR=$(ls "${SCRIPT_ROOT}/bins" | wc -l)
if ! test ${FILES_IN_BIN_DIR} -eq 64; then
    echo "Expected 64 files in bins directory, found ${FILES_IN_BIN_DIR} files"
    exit 1
fi

for file in $(ls "${SCRIPT_ROOT}/bins"); do
    echo "${SCRIPT_ROOT}/bins/${file}" >> filenames.txt
done

echo "filenames.txt created"
