 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_SEEDS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEEDS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// MemoryManager

template <typename TValue, typename TSPec, typename TFree> class MemoryManager;       	// "projects/library/seqan/seeds/memoryManager_base.h"(46)

//____________________________________________________________________________
// PropertyMap

template <typename TValue, typename TSPec> class PropertyMap;       	// "projects/library/seqan/seeds/propertyMap.h"(41)

//____________________________________________________________________________
// Seed

template <typename TPosition, typename TSpecSeed> class Seed;       	// "projects/library/seqan/seeds/seed_base.h"(102)

//____________________________________________________________________________
// SeedIterator

struct SeedIterator;       	// "projects/library/seqan/seeds/seedSet_iterator.h"(32)

//____________________________________________________________________________
// SeedSet

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec > class SeedSet;       	// "projects/library/seqan/seeds/seedSet_base.h"(98)

//____________________________________________________________________________
// SortProcess

template <class TTriple> struct SortProcess;       	// "projects/library/seqan/seeds/seedSet_base.h"(1333)

//____________________________________________________________________________
// _Chain_Merge

struct _Chain_Merge;       	// "projects/library/seqan/seeds/seed_base.h"(54)

//____________________________________________________________________________
// _Free_Int

struct _Free_Int;       	// "projects/library/seqan/seeds/memoryManager_int.h"(45)

//____________________________________________________________________________
// _Free_Pointer

struct _Free_Pointer;       	// "projects/library/seqan/seeds/memoryManager_base.h"(42)

//____________________________________________________________________________
// _Seed_multi

struct _Seed_multi;       	// "projects/library/seqan/seeds/seed_multi.h"(27)

//____________________________________________________________________________
// _Seed_simple

struct _Seed_simple;       	// "projects/library/seqan/seeds/seed_base.h"(31)

//____________________________________________________________________________
// _extendSeed_GappedXDrop

struct _extendSeed_GappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(66)

//____________________________________________________________________________
// _extendSeed_Match

struct _extendSeed_Match;       	// "projects/library/seqan/seeds/seed_base.h"(59)

//____________________________________________________________________________
// _extendSeed_UnGappedXDrop

struct _extendSeed_UnGappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(63)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// FreeMemoryInt

typedef Tag<_Free_Int> const FreeMemoryInt;       	// "projects/library/seqan/seeds/memoryManager_int.h"(46)

//____________________________________________________________________________
// FreeMemoryPointer

typedef Tag<_Free_Pointer> const FreeMemoryPointer;       	// "projects/library/seqan/seeds/memoryManager_base.h"(43)

//____________________________________________________________________________
// GappedXDrop

typedef Tag<_extendSeed_GappedXDrop> const GappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(67)

//____________________________________________________________________________
// MatchExtend

typedef Tag<_extendSeed_Match> const MatchExtend;       	// "projects/library/seqan/seeds/seed_base.h"(60)

//____________________________________________________________________________
// Merge

typedef Tag<_Chain_Merge> const Merge;       	// "projects/library/seqan/seeds/seed_base.h"(55)

//____________________________________________________________________________
// MultiSeed

typedef Tag<_Seed_multi> const MultiSeed;       	// "projects/library/seqan/seeds/seed_multi.h"(28)

//____________________________________________________________________________
// SimpleSeed

typedef Tag<_Seed_simple> const SimpleSeed;       	// "projects/library/seqan/seeds/seed_base.h"(32)

//____________________________________________________________________________
// UngappedXDrop

typedef Tag<_extendSeed_UnGappedXDrop> const UngappedXDrop;       	// "projects/library/seqan/seeds/seed_base.h"(64)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _banded_gotoh

template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> TScoreValue _banded_gotoh(Matrix<TScoreValue, TMatrixSpec> & matrix_diag, Matrix<TScoreValue, TMatrixSpec> & matrix_vert, Matrix<TScoreValue, TMatrixSpec> & matrix_hori, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> & init_diag, String<TScoreValue> & init_vert, String<TScoreValue> & init_hori);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(120)
template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> TScoreValue _banded_gotoh(Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(291)

//____________________________________________________________________________
// _banded_gotoh_rectangle_first

template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> void _banded_gotoh_rectangle_first(Matrix<TScoreValue, TMatrixSpec> & matrix_diag, Matrix<TScoreValue, TMatrixSpec> & matrix_vert, Matrix<TScoreValue, TMatrixSpec> & matrix_hori, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> & init_diag, String<TScoreValue> & init_vert, String<TScoreValue> & init_hori);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(1420)

//____________________________________________________________________________
// _banded_gotoh_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TMatrixSpec, typename TValue> void _banded_gotoh_trace(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, TValue position_);       	// "projects/library/seqan/seeds/banded_align.h"(547)

//____________________________________________________________________________
// _banded_gotoh_trace2

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TMatrixSpec> typename Size<Matrix<TScoreValue, TMatrixSpec> >::Type _banded_gotoh_trace2(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, Iter< Matrix<TScoreValue, TMatrixSpec>, PositionIterator > source_ );       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(385)

//____________________________________________________________________________
// _banded_needleman_wunsch

template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> TScoreValue _banded_needleman_wunsch(Matrix<TScoreValue, TMatrixSpec> & matrix_, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> init);       	// "projects/library/seqan/seeds/banded_chain_align.h"(166)
template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> TScoreValue _banded_needleman_wunsch(Matrix<TScoreValue, TMatrixSpec> & matrix_, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(39)

//____________________________________________________________________________
// _banded_needleman_wunsch_rectangle_first

template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> void _banded_needleman_wunsch_rectangle_first(Matrix<TScoreValue, TMatrixSpec> & matrix_, Seed<TValue, TSpecSeed> const &seed, TValue k, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> init);       	// "projects/library/seqan/seeds/banded_chain_align.h"(1140)

//____________________________________________________________________________
// _banded_needleman_wunsch_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> void _banded_needleman_wunsch_trace(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(206)

//____________________________________________________________________________
// _banded_needleman_wunsch_trace2

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> typename Size<Matrix<TScoreValue, TSourceSpec> >::Type _banded_needleman_wunsch_trace2(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, TSourceSpec> & matrix, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_chain_align.h"(333)

//____________________________________________________________________________
// _calculateBandedSeed

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateBandedSeed(TSeed const &seed, TDiff k, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(579)

//____________________________________________________________________________
// _calculateBandedSeedGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateBandedSeedGotoh(TSeed const &seed, TDiff k, TMatrix &matrix_diag, TMatrix &matrix_vert, TMatrix &matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString &score_str_diag, TScoreString &score_str_vert, TScoreString &score_str_hori, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(526)

//____________________________________________________________________________
// _calculateFirstRectangle

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateFirstRectangle(TSeed const &seed, TDiff k, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(658)

//____________________________________________________________________________
// _calculateFirstRectangleGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateFirstRectangleGotoh(TSeed const &seed, TDiff k, TMatrix &matrix_diag, TMatrix &matrix_vert, TMatrix &matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString &score_str_diag, TScoreString &score_str_vert, TScoreString &score_str_hori, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(621)

//____________________________________________________________________________
// _calculateLastRectangle

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateLastRectangle(TSeed const &seed, TDiff k, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(706)

//____________________________________________________________________________
// _calculateLastRectangleGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateLastRectangleGotoh(TSeed const &seed, TDiff k, TMatrix & matrix_diag, TMatrix & matrix_vert, TMatrix & matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString & score_str_diag, TScoreString & score_str_vert, TScoreString & score_str_hori, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(676)

//____________________________________________________________________________
// _calculateRectangle

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateRectangle(TSeed const &seed, TSeed const &seed2, TDiff k_begin, TDiff k_end, TMatrix &matrix_, TString *p_seq1, TString *p_seq2, TScoreString &score_str, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > &alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(784)

//____________________________________________________________________________
// _calculateRectangleGotoh

template <typename TSeed, typename TString, typename TDiff, typename TMatrix, typename TScoreString, typename TValue, typename TAlign, typename TScoreMatrix> void _calculateRectangleGotoh(TSeed const &seed, TSeed const &seed2, TDiff k_begin, TDiff k_end, TMatrix & matrix_diag, TMatrix & matrix_vert, TMatrix & matrix_hori, TString *p_seq1, TString *p_seq2, TScoreString &score_str_diag, TScoreString &score_str_vert, TScoreString &score_str_hori, TValue &score_length, vector<map<TValue,Pair<TValue, TAlign> > > & alignmentVector, TScoreMatrix const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(768)

//____________________________________________________________________________
// _calculateScoringValue

template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue dPos, TValue &, Manhattan);       	// "projects/library/seqan/seeds/seedSet_base.h"(40)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue &, TValue &, QueryDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(46)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed const &seed, TValue &, TValue dPos, TValue &, DatabaseDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(52)
template <typename TValue, typename TSeed> inline TValue _calculateScoringValue(TSeed &, TValue &, TValue &, TValue &, NoGapCost);       	// "projects/library/seqan/seeds/seedSet_base.h"(58)
template <typename TValue, typename TScore> inline TScore _calculateScoringValue(TValue qPos1, TValue dPos1, TValue qPos2, TValue dPos2, Score<TScore, Simple> const &matrix, Manhattan);       	// "projects/library/seqan/seeds/seedSet_score.h"(37)
template <typename TValue, typename TScore> inline TScore _calculateScoringValue(TValue qPos1, TValue&, TValue qPos2, TValue &, Score<TScore, Simple> const &matrix, QueryDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(49)
template <typename TValue, typename TScore> inline TScore _calculateScoringValue(TValue &, TValue dPos1, TValue &, TValue dPos2, Score<TScore, Simple> const &matrix, DatabaseDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(61)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed &, TValue &, TValue &, Score<TScore, Simple> &, NoGapCost);       	// "projects/library/seqan/seeds/seedSet_score.h"(72)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue dPos, TValue &, TScore score, Manhattan);       	// "projects/library/seqan/seeds/seedSet_score.h"(85)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed const &seed, TValue qPos, TValue &, TValue &, TScore score, QueryDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(97)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed const &seed, TValue &, TValue dPos, TValue &, TScore score, DatabaseDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(109)
template <typename TValue, typename TSeed, typename TScore> inline TValue _calculateScoringValue(TSeed &, TValue &, TValue &, TValue &, TScore &, NoGapCost);       	// "projects/library/seqan/seeds/seedSet_score.h"(121)

//____________________________________________________________________________
// _constructAlignment

template <typename TValue, typename TAlign, typename TAlign2> void _constructAlignment(vector<map<TValue,Pair<TValue, TAlign> > >const &me, TAlign2 &wholeAlignment);       	// "projects/library/seqan/seeds/banded_chain_align.h"(121)

//____________________________________________________________________________
// _deleteAlignment

template <typename TValue, typename TAlign, typename TSize> void _deleteAlignment(vector<map<TValue,Pair<TValue, TAlign> > > &me, TSize old_end, TSize new_end);       	// "projects/library/seqan/seeds/banded_chain_align.h"(538)

//____________________________________________________________________________
// _extendSeed

template <typename TValue, typename TText> void _extendSeed(Triple<TValue,TValue,TValue> &position, Segment<String<TText> const, InfixSegment> qSeg, Segment<String<TText> const, InfixSegment> dSeg);       	// "projects/library/seqan/seeds/seedSet_base.h"(1321)

//____________________________________________________________________________
// _findPrev

template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type _findPrev(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find, SkiplistPath<TValue, TSpec> & path);       	// "projects/library/seqan/seeds/global_seed_chain.h"(34)
template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type _findPrev(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find);       	// "projects/library/seqan/seeds/global_seed_chain.h"(46)

//____________________________________________________________________________
// _findSeedsChain

template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, MultiSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> >::Value> > >::Type >::iterator _findSeedsChain(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(1491)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> >::Value> > >::Type >::iterator _findSeedsChain(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(1666)

//____________________________________________________________________________
// _findSeedsMerge

template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> >::Value> > >::Type >::iterator _findSeedsMerge(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length_, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_base.h"(1531)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> typename std::multimap<TValue, typename Size<String<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> >::Value> > >::Type >::iterator _findSeedsMerge(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue , typename ScoreType<TScoringSpec>::Type score, int gapDistance);       	// "projects/library/seqan/seeds/seedSet_score.h"(1703)

//____________________________________________________________________________
// _gapFill

template <typename TValue, typename TText> void _gapFill(TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, std::list<Triple<TValue, TValue, TValue> > &diagList, String<TText> const &query, String<TText> const &database, TValue q);       	// "projects/library/seqan/seeds/seedSet_base.h"(1354)

//____________________________________________________________________________
// _getDiagSet

template <typename TPosition> inline const std::list<Triple<TPosition, TPosition, TPosition> >& _getDiagSet(Seed<TPosition,MultiSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(191)
template <typename TPosition> inline std::list<Triple<TPosition, TPosition, TPosition> >& _getDiagSet(Seed<TPosition,MultiSeed> & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(198)

//____________________________________________________________________________
// _getFirstDiag

template <typename TPosition> Triple<TPosition, TPosition, TPosition>& _getFirstDiag(Seed<TPosition,MultiSeed> & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(225)
template <typename TPosition> const Triple<TPosition, TPosition, TPosition>& _getFirstDiag(Seed<TPosition,MultiSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(232)

//____________________________________________________________________________
// _getLastDiag

template <typename TPosition> Triple<TPosition, TPosition, TPosition>& _getLastDiag(Seed<TPosition,MultiSeed> & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(239)
template <typename TPosition> const Triple<TPosition, TPosition, TPosition>& _getLastDiag(Seed<TPosition,MultiSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(246)

//____________________________________________________________________________
// _getPosition

template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type _getPosition(MemoryManager<TValue,Block<SPACE>, TFree > const &manager, const void* pointer);       	// "projects/library/seqan/seeds/memoryManager_base.h"(344)

//____________________________________________________________________________
// _gotoh2

template <typename TScoreValue, typename TMatrixSpec, typename TString> void _gotoh2(Matrix<TScoreValue, TMatrixSpec> & matrix_diag, Matrix<TScoreValue, TMatrixSpec> & matrix_vert, Matrix<TScoreValue, TMatrixSpec> & matrix_hori, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(1176)

//____________________________________________________________________________
// _gotoh_rectangle

template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> void _gotoh_rectangle(Matrix<TScoreValue, TMatrixSpec> & matrix_diag, Matrix<TScoreValue, TMatrixSpec> & matrix_vert, Matrix<TScoreValue, TMatrixSpec> & matrix_hori, Seed<TValue, TSpecSeed> const &seed1, Seed<TValue, TSpecSeed> const &seed2, TValue k_begin, TValue k_end, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> & init_diag, String<TScoreValue> & init_vert, String<TScoreValue> & init_hori);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(871)

//____________________________________________________________________________
// _gotoh_trace_lastRectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TMatrixSpec> TScoreValue _gotoh_trace_lastRectangle(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, Iter< Matrix<TScoreValue, TMatrixSpec>, PositionIterator > source_);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(456)

//____________________________________________________________________________
// _gotoh_trace_rectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TMatrixSpec, typename TValue, typename TMatrix> TValue _gotoh_trace_rectangle(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, TMatrixSpec>, PositionIterator > & diag_source, TMatrix & diag_matrix_, TMatrix & vert_matrix_, TMatrix & hori_matrix_, TValue width_stop, TValue height_stop);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(1344)

//____________________________________________________________________________
// _mergeTwoSeeds

template <typename TPosition, typename TSpecSeed> void _mergeTwoSeeds(Seed<TPosition, TSpecSeed> &firstSeed, Seed<TPosition, TSpecSeed> const &secondSeed, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(442)
template <typename TPosition, typename TSpecSeed> void _mergeTwoSeeds(Seed<TPosition, TSpecSeed> &firstSeed, TPosition q, TPosition d, TPosition l, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(462)
template <typename TPosition> void _mergeTwoSeeds(Seed<TPosition, SimpleSeed> &firstSeed, TPosition qlPos, TPosition dlPos, TPosition qrPos, TPosition drPos, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(481)
template <typename TValue, typename TSeedSpec> void _mergeTwoSeeds(Seed<TValue, TSeedSpec> &seed, TValue qPos, TValue dPos, TValue length, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(987)
template <typename TValue> void _mergeTwoSeeds(Seed<TValue, SimpleSeed> &firstSeed, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(1007)
template <typename TValue> void _mergeTwoSeeds(Seed<TValue, MultiSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(1030)
template <typename TValue, typename TText, typename TValue2> void _mergeTwoSeeds(Seed<TValue, MultiSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, Score<TValue2, Simple> const &scoreMatrix, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1127)
template <typename TValue, typename TText> void _mergeTwoSeeds(Seed<TValue, MultiSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, TValue q, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(1273)
template <typename TPosition> void _mergeTwoSeeds(Seed<TPosition, MultiSeed> &firstSeed, TPosition qPos, TPosition dPos, TPosition length, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(264)
template <typename TPosition> void _mergeTwoSeeds(Seed<TPosition, MultiSeed> &firstSeed, Seed<TPosition, MultiSeed> const &secondSeed, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(313)

//____________________________________________________________________________
// _mergeTwoSeedsScore

template <typename TPosition, typename TSpecSeed, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, TSpecSeed> &firstSeed, TPosition3 &score1, Seed<TPosition, TSpecSeed> const &secondSeed, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(512)
template <typename TPosition, typename TPosition2, typename TSpecSeed, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, TSpecSeed> &firstSeed, TPosition3 &score1, TPosition q, TPosition d, TPosition l, TPosition3 score2, Score<TPosition2, Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(539)
template <typename TPosition, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, SimpleSeed> &firstSeed, TPosition3 &score1, TPosition qlPos, TPosition dlPos, TPosition qrPos, TPosition drPos, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_base.h"(565)
template <typename TValue, typename TSeedSpec> void _mergeTwoSeedsScore(Seed<TValue, TSeedSpec> &seed, TValue qPos, TValue dPos, TValue length, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(754)
template <typename TValue> void _mergeTwoSeedsScore(Seed<TValue, SimpleSeed> &firstSeed, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(774)
template <typename TValue, typename TScore, typename TText, typename TGapCost> TValue _mergeTwoSeedsScore(Seed<TValue, SimpleSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, Score<TScore, Simple> const &scoreMatrix, TGapCost tag, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(938)
template <typename TValue, typename TScore, typename TText, typename TGapCost> TValue _mergeTwoSeedsScore(Seed<TValue, MultiSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, Score<TScore, Simple> const &scoreMatrix, TGapCost tag, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(1000)
template <typename TValue, typename TText, typename TScore, typename TGapCosts> TScore _mergeTwoSeedsScore(Seed<TValue, SimpleSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue q, TGapCosts tag, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1247)
template <typename TValue, typename TText, typename TScore, typename TGapCosts> TScore _mergeTwoSeedsScore(Seed<TValue, MultiSeed> &firstSeed, TValue qPos, TValue dPos, TValue length, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue q, TGapCosts tag, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1307)
template <typename TPosition, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, MultiSeed> &firstSeed, TPosition3 &score1, TPosition qPos, TPosition dPos, TPosition length, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(380)
template <typename TPosition, typename TPosition2, typename TPosition3, typename TGapCost> void _mergeTwoSeedsScore(Seed<TPosition, MultiSeed> &firstSeed, TPosition3 &score1, Seed<TPosition, MultiSeed> const &secondSeed, TPosition3 score2, Score<TPosition2,Simple> const &scoreMatrix, TGapCost &, Merge);       	// "projects/library/seqan/seeds/seed_multi.h"(449)

//____________________________________________________________________________
// _needleman_wunsch_rectangle

template <typename TScoreValue, typename TMatrixSpec, typename TString, typename TValue, typename TSpecSeed> void _needleman_wunsch_rectangle(Matrix<TScoreValue, TMatrixSpec> & matrix_, Seed<TValue, TSpecSeed> const &seed1, Seed<TValue, TSpecSeed> const &seed2, TValue k_begin, TValue k_end, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, String<TScoreValue> init);       	// "projects/library/seqan/seeds/banded_chain_align.h"(875)

//____________________________________________________________________________
// _needleman_wunsch_trace_lastRectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> int _needleman_wunsch_trace_lastRectangle(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_chain_align.h"(423)

//____________________________________________________________________________
// _needleman_wunsch_trace_rectangle

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec, typename TValue, typename TMatrix> TValue _needleman_wunsch_trace_rectangle(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_, TMatrix matrix, TValue width_stop, TValue height_stop);       	// "projects/library/seqan/seeds/banded_chain_align.h"(1042)

//____________________________________________________________________________
// _qualityReached

template <typename TSeed, typename TScore> inline bool _qualityReached(TSeed &, TScore score, TScore qualityValue, SeedScore);       	// "projects/library/seqan/seeds/seedSet_base.h"(74)
template <typename TSeed, typename TScore> inline bool _qualityReached(TSeed const &seed, TScore , TScore qualityValue, SeedLength);       	// "projects/library/seqan/seeds/seedSet_base.h"(80)

//____________________________________________________________________________
// _raiseMemory

template <typename TValue, unsigned int SPACE, typename TFree> void _raiseMemory(MemoryManager<TValue,Block<SPACE>, TFree > &manager, typename Size<String<TValue, Block<SPACE> > >::Type leng);       	// "projects/library/seqan/seeds/memoryManager_base.h"(266)
template <typename TValue, unsigned int SPACE> void _raiseMemory(MemoryManager<TValue,Block<SPACE>, FreeMemoryInt > &manager, typename Size<String<TValue, Block<SPACE> > >::Type leng);       	// "projects/library/seqan/seeds/memoryManager_int.h"(260)

//____________________________________________________________________________
// _rec_delete

template <typename TAlign, typename TValue> void _rec_delete(vector<map<TValue,Pair<TValue, TAlign> > > &vec, TValue index, TValue position);       	// "projects/library/seqan/seeds/banded_chain_align.h"(509)

//____________________________________________________________________________
// _scoreMap

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline PropertyMap<TValue, Block<BLOCK_SIZE<SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> >::Value> >* _scoreMap(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_score.h"(328)

//____________________________________________________________________________
// addSeed

template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(487)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qBeginPos, TValue dBeginPos, TValue qEndPos, TValue dEndPos, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(507)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(525)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, MultiSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, MultiSeed> const &seed, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(544)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length_, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_base.h"(762)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_base.h"(793)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_base.h"(825)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(866)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, SimpleSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(898)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(924)
template <typename TValue, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, MultiSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, MultiSeed> const &seed, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_base.h"(951)
template <typename TValue, typename TSeedSpec, typename TText, typename TValue2, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1056)
template <typename TValue, typename TValue2, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, MultiSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, MultiSeed> const &seed, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1089)
template <typename TValue, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, MultiSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(1183)
template <typename TValue, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeed(SeedSet<TValue, MultiSeed, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, Seed<TValue, MultiSeed> const &seed, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(1223)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TScore, typename TSeedSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(344)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TSeedSpec> inline bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(371)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TScore> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, TValue qBeginPos, TValue dBeginPos, TValue qEndPos, TValue dEndPos, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(386)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TScore> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(412)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TScore> bool addSeed(SeedSet<TValue, MultiSeed, TScoringSpec, TSpec> &set, Seed<TValue, MultiSeed> const &seed, TScore score, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(439)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(479)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(511)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, typename ScoreType<TScoringSpec>::Type score, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(523)
template <typename TValue, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, typename ScoreType<TScoringSpec>::Type score, int gapDistance, Merge);       	// "projects/library/seqan/seeds/seedSet_score.h"(555)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TSeedSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(604)
template <typename TValue, typename TSpec, typename TScoringSpec, typename TSeedSpec> inline bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(640)
template <typename TValue, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, TValue qlPos, TValue dlPos, TValue qrPos, TValue drPos, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(656)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, Seed<TValue, TSeedSpec> const &seed, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(686)
template <typename TValue, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, MultiSeed, TScoringSpec, TSpec> &set, Seed<TValue, MultiSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, int gapDistance, SimpleChain);       	// "projects/library/seqan/seeds/seedSet_score.h"(717)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec, typename TSpecSeed> bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(807)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec, typename TSpecSeed> inline bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(843)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, MultiSeed, TScoringSpec, TSpec> &set, Seed<TValue, MultiSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(858)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(898)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec, typename TSpecSeed> bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1071)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec, typename TSpecSeed> inline bool addSeed(SeedSet<TValue, TSpecSeed, TScoringSpec, TSpec> &set, TValue qPos, TValue dPos, TValue length, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1115)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, MultiSeed, TScoringSpec, TSpec> &set, Seed<TValue, MultiSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1130)
template <typename TValue, typename TText, typename TSpec, typename TScoringSpec> bool addSeed(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &set, Seed<TValue, SimpleSeed> const &seed, typename ScoreType<TScoringSpec>::Type score, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1188)

//____________________________________________________________________________
// addSeedSet

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> bool addSeedSet(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> const &source, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(1553)
template <typename TValue, typename TSeedSpec, typename TAlgoSpec, typename TSpec, typename TScoringSpec> bool addSeedSet(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> const &source, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1570)
template <typename TValue, typename TSeedSpec, typename TText, typename TSpec, typename TScoringSpec, typename TAlgoSpec> bool addSeedSet(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> const &source, String<TText> const &query, String<TText> const &database, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1598)

//____________________________________________________________________________
// addSeeds

template <typename TValue, typename TSeedSpec, typename TIterator, typename TAlgoSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TIterator begin, TIterator end, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(571)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TText, typename TValue2, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TIterator begin, TIterator end, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(611)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TIterator begin, TIterator end, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(637)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TAlgoSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer &source, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(660)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer const &source, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(684)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TText, typename TValue2, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer const &source, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_base.h"(704)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TText, typename TSpec, typename TQualityFactor, typename TGapCosts> bool addSeeds(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set, TContainer const &source, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_base.h"(731)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TAlgoSpec, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1381)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(1408)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TText, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, String<TText> const &query, String<TText> const &database, int gapDistance, Chaos);       	// "projects/library/seqan/seeds/seedSet_score.h"(1427)
template <typename TValue, typename TSeedSpec, typename TIterator, typename TIterator2, typename TText, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TIterator begin, TIterator end, TIterator2 scoreBegin, String<TText> const &query, String<TText> const &database, int gapDistance, Blat);       	// "projects/library/seqan/seeds/seedSet_score.h"(1454)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TContainer2, typename TAlgoSpec, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TContainer const &source, TContainer2 const &scoreSource, int gapDistance, TAlgoSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1477)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TContainer2, typename TSpec, typename TScoringSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TContainer const &source, TContainer2 &scoreSource, Single);       	// "projects/library/seqan/seeds/seedSet_score.h"(1503)
template <typename TValue, typename TSeedSpec, typename TContainer, typename TContainer2, typename TText, typename TSpec, typename TScoringSpec, typename TAlgoSpec> bool addSeeds(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, TContainer const &source, TContainer2 const &scoreSource, String<TText> const &query, String<TText> const &database, int gapDistance, TAlgoSpec algoSpec);       	// "projects/library/seqan/seeds/seedSet_score.h"(1523)

//____________________________________________________________________________
// addSeedsIt

template <typename TSeedSet, typename TIterator> bool addSeedsIt(TSeedSet &set, TIterator begin, TIterator end, Single);       	// "projects/library/seqan/seeds/seedSet_base.h"(593)

//____________________________________________________________________________
// append

template <typename TValue, typename TSeedSpec, typename TContainer2, typename TSpecScoring, typename TSpec> void append(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &target, TContainer2 &source);       	// "projects/library/seqan/seeds/seedSet_base.h"(265)
template <typename TValue, typename TSeedSpec, typename TContainer1, typename TContainer2, typename TSpec, typename TScoringSpec> void append(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, TContainer1 &seedSource, TContainer2 &scoreSource);       	// "projects/library/seqan/seeds/seedSet_score.h"(252)

//____________________________________________________________________________
// appendDiag

template <typename TPosition> void appendDiag(Seed<TPosition,MultiSeed> & seed, Triple<TPosition, TPosition, TPosition> diag);       	// "projects/library/seqan/seeds/seed_multi.h"(218)

//____________________________________________________________________________
// appendValue

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline void appendValue(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &target, Seed<TValue, TSeedSpec> &seed);       	// "projects/library/seqan/seeds/seedSet_base.h"(277)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec, typename TValue2> void appendValue(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &target, Seed<TValue, TSeedSpec> &seed, TValue2 score);       	// "projects/library/seqan/seeds/seedSet_score.h"(270)

//____________________________________________________________________________
// assign

template <typename TValue, unsigned int SPACE, typename TFree, typename TSource> inline void assign( MemoryManager<TValue, Block<SPACE>, TFree>& target, TSource const& source);       	// "projects/library/seqan/seeds/memoryManager_base.h"(177)
template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( MemoryManager<TValue, Block<SPACE>, FreeMemoryInt>& target, TSource const& source);       	// "projects/library/seqan/seeds/memoryManager_int.h"(168)
template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( PropertyMap<TValue, Block<SPACE> >& target, TSource const& source);       	// "projects/library/seqan/seeds/propertyMap.h"(125)

//____________________________________________________________________________
// assignValue

template <typename TValue, unsigned int SPACE, typename TFree, typename TPosition> void assignValue(MemoryManager<TValue,Block<SPACE>, TFree > &manager, TPosition pos, TValue value);       	// "projects/library/seqan/seeds/memoryManager_base.h"(361)
template <typename TValue, unsigned int SPACE, typename TPosition> void assignValue(MemoryManager<TValue,Block<SPACE>, FreeMemoryInt > &manager, TPosition pos, TValue value);       	// "projects/library/seqan/seeds/memoryManager_int.h"(316)

//____________________________________________________________________________
// bandedAlignment

template <typename TSource, typename TSpec, typename TScoreValue, typename TValue, typename TSpecSeed> TScoreValue bandedAlignment(Align<TSource, TSpec> & align_, Seed<TValue, TSpecSeed> const & seed, TValue k, Score<TScoreValue, Simple> const & score_, NeedlemanWunsch);       	// "projects/library/seqan/seeds/banded_align.h"(620)
template <typename TSource, typename TSpec, typename TScoreValue, typename TValue, typename TSpecSeed> TScoreValue bandedAlignment(Align<TSource, TSpec> & align_, Seed<TValue, TSpecSeed> const & seed, TValue k, Score<TScoreValue, Simple> const & score_, Gotoh);       	// "projects/library/seqan/seeds/banded_align.h"(642)
template <typename TSource, typename TSpec, typename TScoreValue, typename TValue, typename TSpecSeed> TScoreValue bandedAlignment(Align<TSource, TSpec> & align_, Seed<TValue, TSpecSeed> const & seed, TValue k, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/seeds/banded_align.h"(678)

//____________________________________________________________________________
// bandedChainAlignment

template <typename TContainer, typename TValue, typename TScore, typename TAlign> TScore bandedChainAlignment(TContainer const &seedChain, TValue k, TAlign &whole_alignment, Score< TScore, Simple> const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(49)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec>, Standard >::Type begin(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(286)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> const, Standard>::Type begin(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> const &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(305)

//____________________________________________________________________________
// capacity

template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(MemoryManager<TValue, Block<SPACE>, TFree > const & me);       	// "projects/library/seqan/seeds/memoryManager_base.h"(253)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(MemoryManager<TValue, Block<SPACE>, FreeMemoryInt > const & me);       	// "projects/library/seqan/seeds/memoryManager_int.h"(247)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(PropertyMap<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/seeds/propertyMap.h"(203)

//____________________________________________________________________________
// chain_to_alignment_gotoh

template <typename TContainer, typename TValue, typename TScore, typename TAlign> TScore chain_to_alignment_gotoh(TContainer const &seedChain, TValue k, TAlign & whole_alignment, Score< TScore, Simple> const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align_affine.h"(34)

//____________________________________________________________________________
// chain_to_alignment_needlemanwunsch

template <typename TContainer, typename TValue, typename TScore, typename TAlign> TScore chain_to_alignment_needlemanwunsch(TContainer const &seedChain, TValue k, TAlign & whole_alignment, Score< TScore, Simple> const &scoreMatrix);       	// "projects/library/seqan/seeds/banded_chain_align.h"(62)

//____________________________________________________________________________
// clear

template <typename TValue, unsigned int SPACE, typename TFree> inline void clear(MemoryManager<TValue, Block<SPACE>, TFree >& me);       	// "projects/library/seqan/seeds/memoryManager_base.h"(221)
template <typename TValue, unsigned int SPACE> inline void clear(MemoryManager<TValue, Block<SPACE>, FreeMemoryInt >& me);       	// "projects/library/seqan/seeds/memoryManager_int.h"(215)
template <typename TValue, unsigned int SPACE> inline void clear(PropertyMap<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/seeds/propertyMap.h"(172)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TQualityFactor, typename TGapCosts> void clear(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(338)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> void clear(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_score.h"(300)

//____________________________________________________________________________
// delete_everything

template <typename TValue, typename TSeedSpec, typename TQualityFactor, typename TGapCosts> void delete_everything(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, void> >, void> &deletionTarget, TValue currentPos);       	// "projects/library/seqan/seeds/seedSet_base.h"(1454)
template <typename TValue, typename TSeedSpec, typename TQualityFactor, typename TGapCosts, typename TScore> void delete_everything(SeedSet<TValue, TSeedSpec, const Tag<Scoring_Scheme<TQualityFactor, TGapCosts, TScore> >, void> &deletionTarget, TValue currentPos);       	// "projects/library/seqan/seeds/seedSet_score.h"(1628)

//____________________________________________________________________________
// end

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec>, Standard >::Type end(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(295)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline typename Iterator<SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> const, Standard>::Type end(SeedSet<TValue,TSeedSpec, TSpecScoring, TSpec> const &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(314)

//____________________________________________________________________________
// endDiagonal

template <typename TPosition, typename TSpecSeed> inline TPosition endDiagonal(Seed<TPosition, TSpecSeed> const &me);       	// "projects/library/seqan/seeds/seed_base.h"(185)
template <typename TPosition> inline TPosition endDiagonal(Seed<TPosition, MultiSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(89)

//____________________________________________________________________________
// extendSeed

template <typename TPosition, typename TSpecSeed, typename TText> void extendSeed(Seed<TPosition, TSpecSeed> &seed, String<TText> const &query, String<TText> const &database, TPosition direction, MatchExtend);       	// "projects/library/seqan/seeds/seed_base.h"(621)
template <typename TPosition, typename TSpecSeed, typename TText, typename TScore> void extendSeed(Seed<TPosition,TSpecSeed> &seed, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TPosition direction, UngappedXDrop);       	// "projects/library/seqan/seeds/seed_base.h"(662)
template <typename TPosition, typename TText, typename TScore> void extendSeed(Seed<TPosition,SimpleSeed> &seed, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, String<TText> &query, String<TText> &database, TPosition direction, GappedXDrop);       	// "projects/library/seqan/seeds/seed_base.h"(728)
template <typename TPosition, typename TText, typename TTPosition> void extendSeed(Seed<TPosition,MultiSeed> &seed, TPosition scoreDropOff, Score<TTPosition, Simple> const &scoreMatrix, String<TText> &query, String<TText> &database, TPosition direction, GappedXDrop);       	// "projects/library/seqan/seeds/seed_multi.h"(514)

//____________________________________________________________________________
// extendSeedScore

template <typename TValue, typename TSeedSpec, typename TText, typename TValue2, typename TValue3> void extendSeedScore(Seed<TValue, TSeedSpec> &seed, TValue3 &currentScore, Score<TValue2, Simple> const &matrix, String<TText> const &query, String<TText> const &database, int direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1903)
template <typename TValue, typename TSeedSpec, typename TText, typename TScore> void extendSeedScore(Seed<TValue,TSeedSpec> &seed, TScore &currentScore, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue direction, UngappedXDrop);       	// "projects/library/seqan/seeds/seedSet_score.h"(1950)
template <typename TValue, typename TText, typename TScore> void extendSeedScore(Seed<TValue,SimpleSeed> &seed, TScore &currentScore, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue direction, GappedXDrop);       	// "projects/library/seqan/seeds/seedSet_score.h"(2025)
template <typename TValue, typename TText, typename TScore> void extendSeedScore(Seed<TValue,MultiSeed> &seed, TScore &currentScore, TScore scoreDropOff, Score<TScore, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, TValue direction, GappedXDrop);       	// "projects/library/seqan/seeds/seedSet_score.h"(2287)

//____________________________________________________________________________
// extendSeeds

template <typename TContainer, typename TText> void extendSeeds(TContainer &seedSet, String<TText> &query, String<TText> &database, int direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_base.h"(1606)
template <typename TIterator, typename TText> void extendSeeds(TIterator begin, TIterator end, String<TText> &query, String<TText> &database, int direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_base.h"(1622)
template <typename TContainer, typename TText, typename TextendSeedSpec, typename TValue, typename TValue2> void extendSeeds(TContainer &seedSet, TValue scoreDropOff, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int direction, TextendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(1637)
template <typename TIterator, typename TextendSeedSpec, typename TValue, typename TText> void extendSeeds(TIterator begin, TIterator end, TValue scoreDropOff, Score<TValue, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int direction, TextendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_base.h"(1656)

//____________________________________________________________________________
// extendSeedsScore

template <typename TContainer, typename TContainer2, typename TText, typename TValue> void extendSeedsScore(TContainer &seedSet, TContainer2 &scores, Score<TValue, Simple> const &matrix, String<TText> const &query, String<TText> const &database, int direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1764)
template <typename TValue, typename TSeedSpec, typename TSpec, typename TText, typename TScoringSpec> void extendSeedsScore(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &seedSet, String<TText> const &query, String<TText> const &database, int direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1785)
template <typename TIterator, typename TIterator2, typename TText, typename TValue> void extendSeedsScore(TIterator begin, TIterator end, TIterator2 itScore, Score<TValue, Simple> const &matrix, String<TText> const &query, String<TText> const &database, int direction, MatchExtend);       	// "projects/library/seqan/seeds/seedSet_score.h"(1805)
template <typename TContainer, typename TText, typename TContainer2, typename TextendSeedSpec, typename TValue, typename TValue2> void extendSeedsScore(TContainer &seedSet, TContainer2 &scores, TValue scoreDropOff, Score<TValue2, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int direction, TextendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1822)
template <typename TText, typename TExtendSeedSpec, typename TValue, typename TSpec, typename TScoringSpec> void extendSeedsScore(SeedSet<TValue, SimpleSeed, TScoringSpec, TSpec> &seedSet, TValue scoreDropOff, String<TText> const &query, String<TText> const &database, int direction, TExtendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1843)
template <typename TText, typename TExtendSeedSpec, typename TValue, typename TSpec, typename TScoringSpec> void extendSeedsScore(SeedSet<TValue, MultiSeed, TScoringSpec, TSpec> &seedSet, TValue scoreDropOff, String<TText> const &query, String<TText> const &database, int direction, TExtendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1862)
template <typename TIterator, typename TIterator2, typename TExtendSeedSpec, typename TValue, typename TText> void extendSeedsScore(TIterator begin, TIterator end, TIterator2 itScore, TValue scoreDropOff, Score<TValue, Simple> const &scoreMatrix, String<TText> const &query, String<TText> const &database, int direction, TExtendSeedSpec tag);       	// "projects/library/seqan/seeds/seedSet_score.h"(1884)

//____________________________________________________________________________
// getAlignment

template <typename TPosition, typename TText, typename TPosition2> int getAlignment(Seed<TPosition,MultiSeed> &seed, Align<String<TText>, ArrayGaps> &aligned, String<TText> &query, String<TText> &database, Score<TPosition2, Simple> &scoreMatrix);       	// "projects/library/seqan/seeds/seed_multi.h"(791)

//____________________________________________________________________________
// getScoreMatrix

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline Score<int,Simple> getScoreMatrix(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_score.h"(292)

//____________________________________________________________________________
// globalChaining

template <typename TValue, typename TSeedSpec, typename TScoreSpec, typename TSpec, typename TTargetContainer> typename ScoreType<TScoreSpec>::Type globalChaining(SeedSet<TValue, TSeedSpec, TScoreSpec, TSpec> const &source, TTargetContainer &result);       	// "projects/library/seqan/seeds/global_seed_chain.h"(70)
template <typename TValue, typename TValue2, typename TSeedSpec, typename TScoreSpec, typename TSpec, typename TTargetContainer, typename TScore> TScore globalChaining(SeedSet<TValue, TSeedSpec, TScoreSpec, TSpec> const &source, TTargetContainer &result, TScore gapCost, TValue2 xLength, TValue2 yLength);       	// "projects/library/seqan/seeds/global_seed_chain.h"(143)

//____________________________________________________________________________
// goNext

template <typename TSeedSet> inline Iter<TSeedSet, SeedIterator >& goNext(Iter<TSeedSet, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(211)

//____________________________________________________________________________
// insertTriple

template <typename TValue, typename TChainElement> void insertTriple(Map<Pair<TValue, TChainElement*> > &list, TChainElement* pElement);       	// "projects/library/seqan/seeds/global_seed_chain.h"(213)

//____________________________________________________________________________
// leftDiagonal

template <typename TPosition, typename TSpecSeed> inline TPosition leftDiagonal(Seed<TPosition, TSpecSeed> const &seed);       	// "projects/library/seqan/seeds/seed_base.h"(290)

//____________________________________________________________________________
// leftDim0

template <typename TPosition, typename TSpecSeed> inline TPosition leftDim0(Seed<TPosition, TSpecSeed> const &seed);       	// "projects/library/seqan/seeds/seed_base.h"(222)
template <typename TPosition> inline TPosition leftDim0(Seed<TPosition, MultiSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(97)

//____________________________________________________________________________
// leftDim1

template <typename TPosition, typename TSpecSeed> inline TPosition leftDim1(Seed<TPosition, TSpecSeed> const &seed);       	// "projects/library/seqan/seeds/seed_base.h"(256)
template <typename TPosition> inline TPosition leftDim1(Seed<TPosition, MultiSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(113)

//____________________________________________________________________________
// leftPosition

template <typename TPosition, typename TSpecSeed, typename TSize> inline TPosition leftPosition(Seed<TPosition, TSpecSeed> & me, TSize dim);       	// "projects/library/seqan/seeds/seed_base.h"(196)

//____________________________________________________________________________
// length

template <typename TPosition, typename TSpecSeed> inline TPosition length(Seed<TPosition, TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(316)
template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type length(MemoryManager<TValue, Block<SPACE>, TFree > const & me);       	// "projects/library/seqan/seeds/memoryManager_base.h"(241)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(MemoryManager<TValue, Block<SPACE>, FreeMemoryInt > const & me);       	// "projects/library/seqan/seeds/memoryManager_int.h"(235)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(PropertyMap<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/seeds/propertyMap.h"(191)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline int length(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(322)
template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline int length(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> const &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(330)
template <typename TPosition> inline TPosition length(Seed<TPosition, MultiSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(128)

//____________________________________________________________________________
// maximumDistance

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline TValue maximumDistance(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(413)

//____________________________________________________________________________
// obtainID

template <typename TValue, unsigned int SPACE, typename TFree> inline typename Size<String<TValue, Block<SPACE> > >::Type obtainID(MemoryManager<TValue,Block<SPACE>,TFree > &manager);       	// "projects/library/seqan/seeds/memoryManager_base.h"(312)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type obtainID(MemoryManager<TValue,Block<SPACE>,FreeMemoryInt > &manager);       	// "projects/library/seqan/seeds/memoryManager_int.h"(286)

//____________________________________________________________________________
// operator!=

template <typename TSeedSet> inline bool operator!=(Iter<TSeedSet, SeedIterator > it1, Iter<TSeedSet, SeedIterator > it2);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(263)

//____________________________________________________________________________
// operator*

template <typename TSeedSet> inline typename Reference<Iter<TSeedSet, SeedIterator> const>::Type operator* (Iter<TSeedSet, SeedIterator> & me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(247)
template <typename TSeedSet> inline typename Reference<Iter<TSeedSet const, SeedIterator> const>::Type operator* (Iter<TSeedSet const, SeedIterator> & me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(255)

//____________________________________________________________________________
// operator++

template <typename TSeedSet> inline Iter<TSeedSet, SeedIterator >& operator++(Iter<TSeedSet, SeedIterator > &me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(202)

//____________________________________________________________________________
// operator--

template <typename TSeedSet> inline Iter<TSeedSet, SeedIterator >& operator--(Iter<TSeedSet, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(220)

//____________________________________________________________________________
// qualityValue

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline TValue qualityValue(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set);       	// "projects/library/seqan/seeds/seedSet_base.h"(430)

//____________________________________________________________________________
// raiseMemory

template <typename TValue, unsigned int SPACE> void raiseMemory(PropertyMap<TValue,Block<SPACE> > &manager);       	// "projects/library/seqan/seeds/propertyMap.h"(214)

//____________________________________________________________________________
// releaseID

template <typename TValue, unsigned int SPACE, typename TFree, typename TPosition> void releaseID(MemoryManager<TValue,Block<SPACE>, TFree > &manager, TPosition pos);       	// "projects/library/seqan/seeds/memoryManager_base.h"(292)
template <typename TValue, unsigned int SPACE, typename TPosition> void releaseID(MemoryManager<TValue,Block<SPACE>, FreeMemoryInt > &manager, TPosition pos);       	// "projects/library/seqan/seeds/memoryManager_int.h"(275)

//____________________________________________________________________________
// rightDiagonal

template <typename TPosition, typename TSpecSeed> inline TPosition rightDiagonal(Seed<TPosition,TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(307)

//____________________________________________________________________________
// rightDim0

template <typename TPosition, typename TSpecSeed> inline TPosition rightDim0(Seed<TPosition,TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(239)
template <typename TPosition> inline TPosition rightDim0(Seed<TPosition, MultiSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(105)

//____________________________________________________________________________
// rightDim1

template <typename TPosition, typename TSpecSeed> inline TPosition rightDim1(Seed<TPosition,TSpecSeed> const & seed);       	// "projects/library/seqan/seeds/seed_base.h"(273)
template <typename TPosition> inline TPosition rightDim1(Seed<TPosition, MultiSeed> const & seed);       	// "projects/library/seqan/seeds/seed_multi.h"(120)

//____________________________________________________________________________
// rightPosition

template <typename TPosition, typename TSpecSeed, typename TSize> inline TPosition rightPosition(Seed<TPosition, TSpecSeed> & me, TSize dim);       	// "projects/library/seqan/seeds/seed_base.h"(205)

//____________________________________________________________________________
// scoreSeed

template <typename TPosition, typename TText, typename TScore> TScore scoreSeed(Seed<TPosition, MultiSeed> &seed, String<TText> &query, String<TText> &database, Score<TScore, Simple> &matrix);       	// "projects/library/seqan/seeds/seed_multi.h"(916)

//____________________________________________________________________________
// seedScore

template <typename TSeedSet> inline typename ScoreType<typename ScoringScheme<TSeedSet>::Type>::Type & seedScore(Iter<TSeedSet, SeedIterator > it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(278)
template <typename TSeedSet> inline typename ScoreType<typename ScoringScheme<TSeedSet>::Type>::Type const& seedScore(Iter<TSeedSet const, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(288)

//____________________________________________________________________________
// setLeftDiagonal

template <typename TPosition, typename TSpecSeed> inline void setLeftDiagonal(Seed<TPosition, TSpecSeed> &me, TPosition diag);       	// "projects/library/seqan/seeds/seed_base.h"(407)

//____________________________________________________________________________
// setLeftDim0

template <typename TPosition, typename TSpecSeed> inline void setLeftDim0(Seed<TPosition, TSpecSeed> &me, TPosition start);       	// "projects/library/seqan/seeds/seed_base.h"(335)
template <typename TPosition> inline void setLeftDim0(Seed<TPosition, MultiSeed> &seed, TPosition start);       	// "projects/library/seqan/seeds/seed_multi.h"(139)

//____________________________________________________________________________
// setLeftDim1

template <typename TPosition, typename TSpecSeed> inline void setLeftDim1(Seed<TPosition, TSpecSeed> &me, TPosition start);       	// "projects/library/seqan/seeds/seed_base.h"(371)
template <typename TPosition> inline void setLeftDim1(Seed<TPosition, MultiSeed> &seed, TPosition start);       	// "projects/library/seqan/seeds/seed_multi.h"(162)

//____________________________________________________________________________
// setMaximumDistance

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline void setMaximumDistance(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set, TValue distance);       	// "projects/library/seqan/seeds/seedSet_base.h"(377)

//____________________________________________________________________________
// setQualityValue

template <typename TValue, typename TSeedSpec, typename TSpecScoring, typename TSpec> inline void setQualityValue(SeedSet<TValue, TSeedSpec, TSpecScoring, TSpec> &set, TValue value);       	// "projects/library/seqan/seeds/seedSet_base.h"(396)

//____________________________________________________________________________
// setRightDiagonal

template <typename TPosition, typename TSpecSeed> inline void setRightDiagonal(Seed<TPosition,TSpecSeed> & seed, TPosition diag);       	// "projects/library/seqan/seeds/seed_base.h"(425)

//____________________________________________________________________________
// setRightDim0

template <typename TPosition, typename TSpecSeed> inline void setRightDim0(Seed<TPosition,TSpecSeed> & me, TPosition end);       	// "projects/library/seqan/seeds/seed_base.h"(353)
template <typename TPosition> inline void setRightDim0(Seed<TPosition,MultiSeed> & seed, TPosition end);       	// "projects/library/seqan/seeds/seed_multi.h"(152)

//____________________________________________________________________________
// setRightDim1

template <typename TPosition, typename TSpecSeed> inline void setRightDim1(Seed<TPosition,TSpecSeed> & me, TPosition end);       	// "projects/library/seqan/seeds/seed_base.h"(389)
template <typename TPosition> inline void setRightDim1(Seed<TPosition,MultiSeed> & seed, TPosition end);       	// "projects/library/seqan/seeds/seed_multi.h"(175)

//____________________________________________________________________________
// setScore

template <typename TSeedSet, typename TSize> void setScore(Iter<TSeedSet, SeedIterator > &it, TSize score);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(296)

//____________________________________________________________________________
// setScoreMatrix

template <typename TValue, typename TSeedSpec, typename TSpec, typename TScoringSpec> inline void setScoreMatrix(SeedSet<TValue, TSeedSpec, TScoringSpec, TSpec> &set, Score<int,Simple> matrix);       	// "projects/library/seqan/seeds/seedSet_score.h"(283)

//____________________________________________________________________________
// startDiagonal

template <typename TPosition, typename TSpecSeed> inline TPosition startDiagonal(Seed<TPosition, TSpecSeed> const &me);       	// "projects/library/seqan/seeds/seed_base.h"(168)
template <typename TPosition> inline TPosition startDiagonal(Seed<TPosition, MultiSeed> const &seed);       	// "projects/library/seqan/seeds/seed_multi.h"(82)

//____________________________________________________________________________
// value

template <typename TValue, unsigned int SPACE, typename TFree, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( MemoryManager<TValue, Block<SPACE>, TFree >& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_base.h"(203)
template <typename TValue, unsigned int SPACE, typename TFree, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value(MemoryManager<TValue, Block<SPACE>, TFree > const& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_base.h"(213)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( MemoryManager<TValue, Block<SPACE>, FreeMemoryInt >& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_int.h"(196)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( MemoryManager<TValue, Block<SPACE>, FreeMemoryInt > const& stack, TPos const pos);       	// "projects/library/seqan/seeds/memoryManager_int.h"(207)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( PropertyMap<TValue, Block<SPACE> >& stack, TPos const pos);       	// "projects/library/seqan/seeds/propertyMap.h"(152)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( PropertyMap<TValue, Block<SPACE> > const& stack, TPos const pos);       	// "projects/library/seqan/seeds/propertyMap.h"(163)
template <typename TSeedSet> inline typename Reference<Iter<TSeedSet, SeedIterator> >::Type value(Iter<TSeedSet, SeedIterator > &it);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(229)
template <typename TSeedSet> inline typename Reference<Iter<TSeedSet, SeedIterator> const>::Type value(Iter<TSeedSet, SeedIterator> const &me);       	// "projects/library/seqan/seeds/seedSet_iterator.h"(237)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

