 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_REFINEMENT_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_REFINEMENT_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Alignment

template <typename TStringSet, typename TCargo , typename TSpec > struct Alignment;       	// "projects/library/seqan/refinement/graph_impl_align.h"(98)

//____________________________________________________________________________
// Annotation

template <typename TSequence, typename TValue, typename TSpec > class Annotation;       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(33)

//____________________________________________________________________________
// CgVizFormat_

struct CgVizFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(86)

//____________________________________________________________________________
// FastaFormat_

struct FastaFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(66)

//____________________________________________________________________________
// FastaReadFormat_

struct FastaReadFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(76)

//____________________________________________________________________________
// FragmentInfo

template <typename TId , typename TSize > class FragmentInfo;       	// "projects/library/seqan/refinement/graph_impl_align.h"(150)

//____________________________________________________________________________
// IntervalAndCargo

template <typename TValue , typename TCargo > class IntervalAndCargo;       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(42)

//____________________________________________________________________________
// IntervalTree

template <typename TValue , typename TCargo > class IntervalTree;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(43)

//____________________________________________________________________________
// IntervalTreeNode

template <typename TInterval, typename TSpec > class IntervalTreeNode;       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(285)

//____________________________________________________________________________
// ListType

template <typename T> struct ListType;       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(462)

//____________________________________________________________________________
// MsfFormat_

struct MsfFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(56)

//____________________________________________________________________________
// PointAndCargo

template <typename TValue , typename TCargo > class PointAndCargo;       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(154)

//____________________________________________________________________________
// StoreIntervals

struct StoreIntervals;       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(281)

//____________________________________________________________________________
// StorePointsOnly

struct StorePointsOnly;       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(280)

//____________________________________________________________________________
// TagComputeCenter_

struct TagComputeCenter_;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(176)

//____________________________________________________________________________
// TagExactRefinement_

struct TagExactRefinement_;       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(30)

//____________________________________________________________________________
// TagInexactRefinement_

struct TagInexactRefinement_;       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(31)

//____________________________________________________________________________
// TagMidCenter_

struct TagMidCenter_;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(181)

//____________________________________________________________________________
// TagRandomCenter_

struct TagRandomCenter_;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(186)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CgVizFormat

typedef Tag<CgVizFormat_> const CgVizFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(87)

//____________________________________________________________________________
// ComputeCenter

typedef Tag<TagComputeCenter_> const ComputeCenter;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(177)

//____________________________________________________________________________
// ExactRefinement

typedef Tag<TagExactRefinement_> const ExactRefinement;       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(31)

//____________________________________________________________________________
// FastaFormat

typedef Tag<FastaFormat_> const FastaFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(67)

//____________________________________________________________________________
// FastaReadFormat

typedef Tag<FastaReadFormat_> const FastaReadFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(77)

//____________________________________________________________________________
// InexactRefinement

typedef Tag<TagInexactRefinement_> const InexactRefinement;       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(32)

//____________________________________________________________________________
// MidCenter

typedef Tag<TagMidCenter_> const MidCenter;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(182)

//____________________________________________________________________________
// MsfFormat

typedef Tag<MsfFormat_> const MsfFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(57)

//____________________________________________________________________________
// RandomCenter

typedef Tag<TagRandomCenter_> const RandomCenter;       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(187)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __heaviestCommonSubsequence

template <typename TKey, typename TValue, typename TPositions, typename TSize, typename TVertexDescriptor, typename TString> inline void __heaviestCommonSubsequence(std::map<TKey, TValue>&, TPositions const&, TSize const, TSize const, TVertexDescriptor const, TString const&, TString const&, Nothing&);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1785)
template <typename TKey, typename TValue, typename TPositions, typename TSize, typename TVertexDescriptor, typename TString, typename TOutString> inline void __heaviestCommonSubsequence(std::map<TKey, TValue>& posToSlotMap, TPositions const& positions, TSize const m, TSize const n, TVertexDescriptor const nilVertex, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1801)

//____________________________________________________________________________
// __writeCargo

template <typename TFile, typename TStringSet, typename TSpec, typename TEdge> inline void __writeCargo(TFile & file, Graph<Alignment<TStringSet, void, TSpec> > const&, TEdge const&);       	// "projects/library/seqan/refinement/graph_impl_align.h"(918)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TEdge> inline void __writeCargo(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, TEdge const& edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(928)

//____________________________________________________________________________
// _addAnnotationCuts

template <typename TValue, typename TAliString, typename TGraph, typename TPropertyMap, typename TStringSet, typename TMap, typename TTagSpec> inline void _addAnnotationCuts(String<std::set<TValue> > &, TAliString &, String<TGraph> &, String<TPropertyMap> &, TStringSet &, TMap &, bool, TValue, Tag<TTagSpec>);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(133)
template <typename TValue, typename TAliString, typename TGraph, typename TPropertyMap, typename TStringSet, typename TMap, typename TAnnoString, typename TTagSpec> inline void _addAnnotationCuts(String<std::set<TValue> > & all_nodes, TAliString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, TStringSet & seq, TMap & seq_map, TAnnoString & annotation, TValue min_fragment_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(153)

//____________________________________________________________________________
// _addNodeAnnotation

template <typename TPropertyMap, typename TStringSet, typename TMap, typename TAnnoString, typename TAliGraph,typename TTagSpec> inline void _addNodeAnnotation(TStringSet &, TMap &, TAnnoString & annotation, TPropertyMap & pm, TAliGraph & ali_g, Tag<TTagSpec>);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(200)

//____________________________________________________________________________
// _appendIntervalTreeNodeLists

template <typename TInterval> void _appendIntervalTreeNodeLists(IntervalTreeNode<TInterval,StoreIntervals> & knot,TInterval & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(412)
template <typename TInterval> void _appendIntervalTreeNodeLists(IntervalTreeNode<TInterval,StorePointsOnly> & knot,TInterval & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(439)

//____________________________________________________________________________
// _buildIntervalsForAllSequences

template <typename TInterval, typename TStringSet, typename TAlignmentString, typename TSeqMap> void _buildIntervalsForAllSequences(TAlignmentString & alis, String<String<TInterval> > & intervals, TStringSet & seqs, TSeqMap & seq_map);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(138)

//____________________________________________________________________________
// _calcIntervalTreeNodeCenterLeft

template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterLeft(TIntervals & intervals, TValue &, TValue &, Tag<TagRandomCenter_> const);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(489)
template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterLeft(TIntervals &, TValue & last_center, TValue & center, Tag<TagMidCenter_> const);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(512)

//____________________________________________________________________________
// _calcIntervalTreeNodeCenterRight

template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterRight(TIntervals & intervals, TValue &, TValue &, Tag<TagRandomCenter_> const);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(501)
template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterRight(TIntervals &, TValue & last_center, TValue & center, Tag<TagMidCenter_> const);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(523)

//____________________________________________________________________________
// _calcIntervalTreeRootCenter

template <typename TIntervals> typename Value<typename Value<TIntervals>::Type>::Type _calcIntervalTreeRootCenter(TIntervals & intervals);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(534)

//____________________________________________________________________________
// _copyGraph

template <typename TStringSet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest, bool);       	// "projects/library/seqan/refinement/graph_impl_align.h"(310)
template <typename TStringSet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/refinement/graph_impl_align.h"(325)

//____________________________________________________________________________
// _createIntervalTree

template <typename TGraph, typename TPropertyMap, typename TIntervalPointer, typename TValue> void _createIntervalTree(TGraph & g, TPropertyMap & pm, String<TIntervalPointer*> & intervals, typename VertexDescriptor<TGraph>::Type & knot, TValue, TValue center, typename VertexDescriptor<TGraph>::Type len, Tag<TagComputeCenter_> const tag);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(325)
template <typename TGraph, typename TPropertyMap, typename TSpec, typename TInterval, typename TValue> void _createIntervalTree(TGraph & g, TPropertyMap & pm, String<TInterval*> & intervals, typename VertexDescriptor<TGraph>::Type & knot, TValue last_center, TValue center, typename VertexDescriptor<TGraph>::Type len, Tag<TSpec> const tag);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(417)

//____________________________________________________________________________
// _getClosestRefinedNeighbor

template <typename TAliGraph, typename TVertexDescriptor,typename TValue> TValue _getClosestRefinedNeighbor(TAliGraph & ali_g, TVertexDescriptor & vd, TValue seq, TValue pos);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(77)

//____________________________________________________________________________
// _getCutBeginPos

template <typename TAliGraph,typename TValue> void _getCutBeginPos(TAliGraph & ali_g, typename VertexDescriptor<TAliGraph>::Type & act_knot, TValue seq, TValue act_pos, TValue & cut_act_pos);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(116)

//____________________________________________________________________________
// _getCutEndPos

template <typename TAliGraph,typename TValue> void _getCutEndPos(TAliGraph & ali_g, typename VertexDescriptor<TAliGraph>::Type & end_knot, TValue seq, TValue end_pos, TValue & cut_end_pos);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(94)

//____________________________________________________________________________
// _getEdgeIdManager

template <typename TStringSet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(296)

//____________________________________________________________________________
// _getOtherSequenceAndProject

template <typename TSource,typename TSpec,typename TValue,typename TMap> void _getOtherSequenceAndProject(Align<TSource,TSpec> & segment, TMap & seq_map, TValue seq_i_id, TValue node_i, TValue & seq_j_id, TValue & node_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_align.h"(41)
template <typename TAlignment,typename TValue, typename TMap> void _getOtherSequenceAndProject(Graph<TAlignment> & segment, TMap &, TValue seq_i_id, TValue pos_i, TValue & seq_j_id, TValue & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_aligngraph.h"(43)
template <typename TFragSize, typename TFragSpec,typename TValue, typename TMap> void _getOtherSequenceAndProject(Fragment<TFragSize,TFragSpec> & segment, TMap &, TValue seq_i_id, TValue pos_i, TValue & seq_j_id, TValue & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(43)

//____________________________________________________________________________
// _getSeqBeginAndEnd

template <typename TAliSource,typename TAliSpec, typename TValue> void _getSeqBeginAndEnd(Align<TAliSource,TAliSpec> & segment, std::map<const void * ,int> & seq_map, TValue & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/refinement/graph_algorithm_refine_align.h"(79)
template <typename TValue,typename TAlign,typename TId> void _getSeqBeginAndEnd(Graph<TAlign> & segment, std::map<const void * ,int> &, TId & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/refinement/graph_algorithm_refine_aligngraph.h"(62)
template <typename TFragSize, typename TFragSpec, typename TValue> void _getSeqBeginAndEnd(Fragment<TFragSize,TFragSpec> & segment, std::map<const void * ,int> &, TValue & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(65)

//____________________________________________________________________________
// _getVertexIdManager

template <typename TStringSet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(285)

//____________________________________________________________________________
// _getVertexString

template <typename TStringSet, typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(274)

//____________________________________________________________________________
// _greater_compI2_ITree

template <typename TPair> bool _greater_compI2_ITree(TPair const& p1, TPair const& p2);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(267)

//____________________________________________________________________________
// _less_compI1_ITree

template <typename TPair> bool _less_compI1_ITree(TPair const& p1, TPair const& p2);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(261)

//____________________________________________________________________________
// _makeAlignmentGraphFromRefinedSegments

template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, bool);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(350)
template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TAnnoString,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, TAnnoString & annotation);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(382)

//____________________________________________________________________________
// _makePointerInterval

template <typename TIntervals, typename TIntervalPointers> void _makePointerInterval(TIntervals & intervals,TIntervalPointers & interval_pointers);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(193)

//____________________________________________________________________________
// _makeRefinedGraphEdges

template <typename TAlignmentString,typename TPropertyMap,typename TStringSet,typename TSeqMap, typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & pm, TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagInexactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(143)
template <typename TAlignmentString,typename TStringSet,typename TSeqMap, typename TPropertyMap,typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & pm, TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(273)

//____________________________________________________________________________
// _makeRefinedGraphNodes

template <typename TStringSet,typename TValue,typename TAliGraph> void _makeRefinedGraphNodes(String<std::set<TValue> > & all_nodes, TStringSet & seqs, TAliGraph & ali_g);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(228)

//____________________________________________________________________________
// _refine

template <typename TValue, typename TAlignmentString, typename TStringSet,typename TGraph, typename TPropertyMap,typename TSeqMap, typename TTagSpec> inline void _refine(TValue node_i, TValue seq_i_id, TStringSet & seqs, TSeqMap & seq_map, TAlignmentString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, String<std::set<TValue> > & all_nodes, TValue min_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(89)

//____________________________________________________________________________
// _setIntervalTreeNode

template <typename TValue, typename TInterval> void _setIntervalTreeNode(IntervalTreeNode<TInterval,StoreIntervals> & knot,TValue center,TInterval & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(400)
template <typename TValue, typename TInterval> void _setIntervalTreeNode(IntervalTreeNode<TInterval,StorePointsOnly> & knot,TValue center,TInterval & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(425)

//____________________________________________________________________________
// addEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/refinement/graph_impl_align.h"(566)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/refinement/graph_impl_align.h"(579)

//____________________________________________________________________________
// addInterval

template <typename TGraph, typename TPropertyMap, typename TInterval> void addInterval(TGraph & g, TPropertyMap & pm, TInterval interval);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(563)
template <typename TValue, typename TCargo, typename TInterval> void addInterval(IntervalTree<TValue,TCargo> & itree, TInterval interval);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(648)
template <typename TValue, typename TCargo> void addInterval(IntervalTree<TValue,TCargo> & itree, TValue begin, TValue end, TCargo cargo);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(659)
template <typename TValue, typename TCargo> void addInterval(IntervalTree<TValue,TCargo> & itree, TValue begin, TValue end);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(674)

//____________________________________________________________________________
// addVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TId, typename TPos, typename TLength> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TId id, TPos begin, TLength len);       	// "projects/library/seqan/refinement/graph_impl_align.h"(475)

//____________________________________________________________________________
// assignStringSet

template <typename TString, typename TDefault, typename TCargo, typename TSpec, typename TDefault2> inline void assignStringSet(Graph<Alignment<StringSet<TString, Dependent<TDefault> >, TCargo, TSpec> >& g, StringSet<TString, Dependent<TDefault2> >& sStr);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1183)
template <typename TString, typename TDefault, typename TCargo, typename TSpec, typename TDefault2> inline void assignStringSet(Graph<Alignment<StringSet<TString, Dependent<TDefault> >, TCargo, TSpec> >& g, StringSet<TString, Owner<TDefault2> >& sStr);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1202)

//____________________________________________________________________________
// atBegin

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(138)

//____________________________________________________________________________
// atEnd

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(158)

//____________________________________________________________________________
// cargo

template <typename TValue, typename TCargo> TCargo & cargo(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(122)
template <typename TValue, typename TCargo> TCargo & cargo(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(230)

//____________________________________________________________________________
// clear

template <typename TStringSet, typename TCargo, typename TSpec> inline void clear(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(427)

//____________________________________________________________________________
// clearEdges

template <typename TStringSet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(392)

//____________________________________________________________________________
// clearVertices

template <typename TStringSet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(402)

//____________________________________________________________________________
// convertAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TComponentMap, typename TOrderMap, typename TComponentLength> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TComponentMap& component, TOrderMap& order, TComponentLength& compLength);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1519)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1628)

//____________________________________________________________________________
// createIntervalTree

template <typename TGraph, typename TPropertyMap, typename TIntervals, typename TSpec> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, Tag<TSpec> const tag);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(218)
template <typename TGraph, typename TPropertyMap, typename TIntervals> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(254)
template <typename TGraph, typename TPropertyMap, typename TIntervals, typename TSpec> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, typename Value<typename Value<TIntervals>::Type>::Type center, Tag<TSpec> const tag);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(268)
template <typename TGraph, typename TPropertyMap, typename TIntervals> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, typename Value<typename Value<TIntervals>::Type>::Type center);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(306)

//____________________________________________________________________________
// createTreesForAllSequences

template <typename TGraph, typename TPropertyMap, typename TAlignmentString, typename TSequence, typename TSetSpec, typename TValue, typename TSeqMap> void createTreesForAllSequences(String<TGraph> & gs, String<TPropertyMap> & pms, TAlignmentString & alis, StringSet<TSequence,TSetSpec> & seqs, TSeqMap & seq_map, TValue numSequences);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(179)

//____________________________________________________________________________
// cutIsOk

template <typename TValue> inline bool cutIsOk(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue pos_i, typename std::set<TValue>::iterator iter, TValue min_len, Tag<TagInexactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(44)
template <typename TValue> inline bool cutIsOk(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue, typename std::set<TValue>::iterator iter, TValue, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(42)

//____________________________________________________________________________
// degree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type degree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/refinement/graph_impl_align.h"(462)

//____________________________________________________________________________
// empty

template <typename TStringSet, typename TCargo, typename TSpec> inline bool empty(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(382)

//____________________________________________________________________________
// findEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type findEdge(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/refinement/graph_impl_align.h"(669)

//____________________________________________________________________________
// findIntervals

template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervals(TGraph & g, TPropertyMap & pm, TValue query, String<TCargo> & result);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(704)
template <typename TValue,typename TCargo> void findIntervals(IntervalTree<TValue,TCargo> & it, TValue query, String<TCargo> & result);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(775)

//____________________________________________________________________________
// findIntervalsExcludeTouching

template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervalsExcludeTouching(TGraph & g, TPropertyMap & pm, TValue query, String<TCargo> & result);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(789)
template <typename TValue,typename TCargo> void findIntervalsExcludeTouching(IntervalTree<TValue,TCargo> & it, TValue query, String<TCargo> & result);       	// "projects/library/seqan/refinement/graph_impl_interval_tree.h"(865)

//____________________________________________________________________________
// findVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId, typename TPos> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type findVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId id, TPos pos);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1369)

//____________________________________________________________________________
// fragmentBegin

template <typename TSequence,typename TValue,typename TSpec> typename Position<TSequence>::Type& fragmentBegin(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(93)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& fragmentBegin(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1324)

//____________________________________________________________________________
// fragmentLength

template <typename TSequence,typename TValue,typename TSpec> typename Size<TSequence>::Type& fragmentLength(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(101)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& fragmentLength(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1346)

//____________________________________________________________________________
// getAdjacencyMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(657)

//____________________________________________________________________________
// getAnnoScore

template <typename TAliGraph,typename TScore, typename TPropertyMap> typename Value<TScore>::Type getAnnoScore(TAliGraph &, TPropertyMap & pm, typename VertexDescriptor<TAliGraph>::Type vd1, typename VertexDescriptor<TAliGraph>::Type vd2, TScore &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(252)
template <typename TAliGraph,typename TScore> typename Value<TScore>::Type getAnnoScore(TAliGraph &, bool, typename VertexDescriptor<TAliGraph>::Type, typename VertexDescriptor<TAliGraph>::Type, TScore &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(284)

//____________________________________________________________________________
// getCargo

template <typename TValue, typename TCargo> TCargo getCargo(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(130)
template <typename TValue, typename TCargo> TCargo getCargo(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(238)

//____________________________________________________________________________
// getFirstCoveredPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type getFirstCoveredPosition(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSeqId const id);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1441)

//____________________________________________________________________________
// getLastCoveredPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type getLastCoveredPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId id);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1484)

//____________________________________________________________________________
// getLeftBoundary

template <typename TValue, typename TCargo> TValue getLeftBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(106)
template <typename TValue, typename TCargo> TValue getLeftBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(214)

//____________________________________________________________________________
// getProjectedPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId, typename TPosition, typename TSeqId2, typename TPosition2> inline void getProjectedPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId const id1, TPosition const pos1, TSeqId2& id2, TPosition2& pos2);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1387)

//____________________________________________________________________________
// getRightBoundary

template <typename TValue, typename TCargo> TValue getRightBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(114)
template <typename TValue, typename TCargo> TValue getRightBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(222)

//____________________________________________________________________________
// getScore

template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TAliSource,typename TAliSpec,typename TValue> TScoreValue getScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet &, Align<TAliSource,TAliSpec> & segment, TValue pos_i, TValue pos_j, TValue len, TValue);       	// "projects/library/seqan/refinement/graph_algorithm_refine_align.h"(103)
template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TAlignment,typename TValue> TScoreValue getScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet & seqs, Graph<TAlignment> & segment, TValue pos_i, TValue pos_j, TValue len, TValue len_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_aligngraph.h"(178)
template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TFragment,typename TFragPos,typename TFragSize> TScoreValue getScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet & seqs, TFragment& segment, TFragPos pos_i, TFragPos pos_j, TFragSize len, TFragSize);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(154)
template <typename TScoreValue,typename TStringSet,typename TFragPos,typename TFragSize, typename TSpec> TScoreValue getScore(Score<TScoreValue, Simple> & score_type, TStringSet &, Fragment<TFragSize,ExactFragment<TSpec> > &, TFragPos, TFragPos, TFragSize len, TFragSize);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(185)
template <typename TScoreValue,typename TStringSet,typename TAlign,typename TValue, typename TSize> TScoreValue getScore(TScoreValue &, TStringSet &, TAlign &, TValue, TValue, TSize, TSize);       	// "projects/library/seqan/refinement/graph_algorithm_refine_scoring.h"(42)

//____________________________________________________________________________
// getStringSet

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Host<Graph<Alignment<TStringSet, TCargo, TSpec> > const>::Type& getStringSet(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1225)

//____________________________________________________________________________
// getValue

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(118)

//____________________________________________________________________________
// goBegin

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(148)

//____________________________________________________________________________
// goEnd

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(169)

//____________________________________________________________________________
// goNext

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(179)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(260)

//____________________________________________________________________________
// goPrevious

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(193)

//____________________________________________________________________________
// heaviestCommonSubsequence

template <typename TStringSet, typename TCargo, typename TSpec, typename TString, typename TOutString> inline TCargo heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1905)
template <typename TStringSet, typename TCargo, typename TSpec, typename TString> inline TCargo heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2);       	// "projects/library/seqan/refinement/graph_impl_align.h"(2020)

//____________________________________________________________________________
// inDegree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type inDegree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/refinement/graph_impl_align.h"(451)

//____________________________________________________________________________
// label

template <typename TSequence,typename TValue,typename TSpec> TValue label(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(109)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1269)

//____________________________________________________________________________
// leftBoundary

template <typename TValue, typename TCargo> TValue & leftBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(90)
template <typename TValue, typename TCargo> TValue & leftBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(198)

//____________________________________________________________________________
// matchRefinement

template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TAnnoString,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(307)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TAnnoString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(327)
template <typename TAlignmentString, typename TOutGraph, typename TAnnoString, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(349)
template <typename TAlignmentString,typename TAnnoString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(372)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(253)
template <typename TAlignmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(274)
template <typename TAlignmentString, typename TAnnotation, typename TOutGraph, typename TSequence, typename TSetSpec, typename TScore,typename TTagSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TScore & score_type, TOutGraph & ali_graph, typename Size<typename Value<TAlignmentString>::Type>::Type min_fragment_len, TAnnotation & annotation, Tag<TTagSpec> const tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(425)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(537)
template <typename TFragmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TFragmentString & matches, StringSet<TSequence, TSetSpec> & strSet, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(565)

//____________________________________________________________________________
// numEdges

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type numEdges(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(362)

//____________________________________________________________________________
// numVertices

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type numVertices(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(372)

//____________________________________________________________________________
// operator!=

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(229)

//____________________________________________________________________________
// operator==

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(217)

//____________________________________________________________________________
// outDegree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type outDegree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/refinement/graph_impl_align.h"(440)

//____________________________________________________________________________
// rebuildGraph

template <typename TStringSet, typename TCargo, typename TSpec> inline void rebuildGraph(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1697)

//____________________________________________________________________________
// removeEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/refinement/graph_impl_align.h"(591)
template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(602)

//____________________________________________________________________________
// removeInEdges

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(624)

//____________________________________________________________________________
// removeOutEdges

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(613)

//____________________________________________________________________________
// removeVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TVD> inline void removeVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVD const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(543)

//____________________________________________________________________________
// rightBoundary

template <typename TValue, typename TCargo> TValue & rightBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(98)
template <typename TValue, typename TCargo> TValue & rightBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/refinement/graph_impl_interval_types.h"(206)

//____________________________________________________________________________
// sequenceId

template <typename TSequence,typename TValue,typename TSpec> typename Id<TSequence>::Type& sequenceId(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(85)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Id<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& sequenceId(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1301)

//____________________________________________________________________________
// sourceVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type sourceVertex(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(646)

//____________________________________________________________________________
// stringSet

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Host<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& stringSet(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1247)

//____________________________________________________________________________
// targetVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type targetVertex(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(635)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(240)

//____________________________________________________________________________
// transpose

template <typename TStringSet, typename TCargo, typename TSpec> inline void transpose(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/refinement/graph_impl_align.h"(341)
template <typename TStringSet, typename TCargo, typename TSpec> inline void transpose(Graph<Alignment<TStringSet, TCargo, TSpec> >&);       	// "projects/library/seqan/refinement/graph_impl_align.h"(352)

//____________________________________________________________________________
// updateCutPosition

template <typename TSize, typename TSpec,typename TPos> inline void updateCutPosition(Fragment<TSize, ExactReversableFragment<TSpec> > & f, TPos & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(54)
template <typename TFrag,typename TPos> inline void updateCutPosition(TFrag &, TPos &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(70)

//____________________________________________________________________________
// value

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(128)

//____________________________________________________________________________
// write

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/refinement/graph_impl_align.h"(682)
template <typename TFile, typename TSpec, typename TNames> inline void write(TFile & file, Graph<TSpec> const& g, TNames const& names, FastaFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(813)
template <typename TFile, typename TSpec, typename TNames> inline void write(TFile & file, Graph<TSpec> const& g, TNames const& names, MsfFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(852)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> inline void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames const& names, CgVizFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(941)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TAlignmentMatrix, typename TOldBegEndPos, typename TReadBegEndPos, typename TGappedConsensus> inline void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TAlignmentMatrix const& mat, TOldBegEndPos const& oldBegEndPos, TReadBegEndPos const& readBegEndPos, TGappedConsensus const& gappedConsensus, FastaReadFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1065)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

