 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_MISC_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MISC_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CommandLineOption

class CommandLineOption;       	// "projects/library/seqan/misc/misc_cmdparser.h"(84)

//____________________________________________________________________________
// CommandLineParser

class CommandLineParser;       	// "projects/library/seqan/misc/misc_cmdparser.h"(303)

//____________________________________________________________________________
// EditEnvironment

template <typename TDistanceSpec, unsigned DISTANCE > struct EditEnvironment;       	// "projects/library/seqan/misc/edit_environment.h"(28)

//____________________________________________________________________________
// Enumerator

template <typename TObject, typename TSpec > class Enumerator;       	// "projects/library/seqan/misc/edit_environment.h"(49)

//____________________________________________________________________________
// Object

template <typename TElement> struct Object;       	// "projects/library/seqan/misc/misc_base.h"(56)

//____________________________________________________________________________
// OptionType

struct OptionType;       	// "projects/library/seqan/misc/misc_cmdparser.h"(65)

//____________________________________________________________________________
// PriorityHeap

struct PriorityHeap;       	// "projects/library/seqan/misc/priority_type_base.h"(31)

//____________________________________________________________________________
// PriorityType

template <typename TValue , typename TLess , typename TSpec > class PriorityType;       	// "projects/library/seqan/misc/priority_type_base.h"(49)

//____________________________________________________________________________
// Set

template <typename TKey> struct Set;       	// "projects/library/seqan/misc/misc_set.h"(549)

//____________________________________________________________________________
// _EnumeratorHammingModifier

template <typename TSize> struct _EnumeratorHammingModifier;       	// "projects/library/seqan/misc/edit_environment.h"(126)

//____________________________________________________________________________
// _EnumeratorLevenshteinModifier

template <typename TSize> struct _EnumeratorLevenshteinModifier;       	// "projects/library/seqan/misc/edit_environment.h"(346)

//____________________________________________________________________________
// _MersenneBuffer

template <typename T > struct _MersenneBuffer;       	// "projects/library/seqan/misc/misc_random.h"(56)

//____________________________________________________________________________
// _SetLess

template <typename TElement> struct _SetLess;       	// "projects/library/seqan/misc/misc_set.h"(366)

//____________________________________________________________________________
// _SetObjVector

template <typename TSet> struct _SetObjVector;       	// "projects/library/seqan/misc/misc_set.h"(71)

//____________________________________________________________________________
// _SetSetVector

template <typename TSet> struct _SetSetVector;       	// "projects/library/seqan/misc/misc_set.h"(56)

//____________________________________________________________________________
// _VectorSet

template <typename TElement, typename TSpec> class _VectorSet;       	// "projects/library/seqan/misc/misc_set.h"(43)
template <typename TElement , typename TSpec > class _VectorSet;       	// "projects/library/seqan/misc/misc_set.h"(91)

//____________________________________________________________________________
// _VectorSetIterator

struct _VectorSetIterator;       	// "projects/library/seqan/misc/misc_set.h"(161)

//____________________________________________________________________________
// _VectorSetKeySize

template <typename TElement> struct _VectorSetKeySize;       	// "projects/library/seqan/misc/misc_set.h"(50)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _VectorSetIterator_

typedef Tag<_VectorSetIterator> _VectorSetIterator_;       	// "projects/library/seqan/misc/misc_set.h"(162)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _adjustHeapTowardLeaves

template <typename TValue, typename TLess, typename TSize> inline void _adjustHeapTowardLeaves( PriorityType<TValue, TLess, PriorityHeap> & me, TValue element, TSize h, TSize i );       	// "projects/library/seqan/misc/priority_type_heap.h"(271)

//____________________________________________________________________________
// _adjustHeapTowardRoot

template <typename TValue, typename TLess, typename TSize> inline void _adjustHeapTowardRoot( PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element, TSize h );       	// "projects/library/seqan/misc/priority_type_heap.h"(220)

//____________________________________________________________________________
// _allMandatorySet

inline bool _allMandatorySet(CommandLineParser & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(606)

//____________________________________________________________________________
// _assignOptionValue

template <typename TErrorStream> bool _assignOptionValue(CommandLineParser & me, unsigned option_index, CharString const & _val, TErrorStream & estream);       	// "projects/library/seqan/misc/misc_cmdparser.h"(633)

//____________________________________________________________________________
// _copyHeapElement

template <typename TValue, typename TLess, typename TSize> inline void _copyHeapElement (PriorityType<TValue, TLess, PriorityHeap> & me, TSize i, TSize & h);       	// "projects/library/seqan/misc/priority_type_heap.h"(143)
template <typename TValue, typename TLess, typename TSize> inline void _copyHeapElement (PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element, TSize h);       	// "projects/library/seqan/misc/priority_type_heap.h"(153)

//____________________________________________________________________________
// _dataHost

template <typename TText, typename TSpec> inline Holder<TText> & _dataHost(Enumerator<TText, TSpec> &enumerator);       	// "projects/library/seqan/misc/edit_environment.h"(112)
template <typename TText, typename TSpec> inline Holder<TText> const & _dataHost(Enumerator<TText, TSpec> const &enumerator);       	// "projects/library/seqan/misc/edit_environment.h"(117)

//____________________________________________________________________________
// _isDigit

template <typename TChar> inline bool _isDigit(TChar const c);       	// "projects/library/seqan/misc/misc_cmdparser.h"(22)

//____________________________________________________________________________
// _isDouble

template <typename TString> inline bool _isDouble(TString const s);       	// "projects/library/seqan/misc/misc_cmdparser.h"(30)

//____________________________________________________________________________
// _isInt

template <typename TString> inline bool _isInt(TString const s);       	// "projects/library/seqan/misc/misc_cmdparser.h"(51)

//____________________________________________________________________________
// _parseAppName

inline CharString _parseAppName(CharString const & candidate);       	// "projects/library/seqan/misc/misc_cmdparser.h"(616)

//____________________________________________________________________________
// _usage

template <typename TStream> inline void _usage(CommandLineParser & me, TStream & target);       	// "projects/library/seqan/misc/misc_cmdparser.h"(460)

//____________________________________________________________________________
// _writeOptName

template <typename TStream> inline void _writeOptName(TStream & target, CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(263)

//____________________________________________________________________________
// addOption

inline void addOption(CommandLineParser & me,CommandLineOption const & opt);       	// "projects/library/seqan/misc/misc_cmdparser.h"(376)

//____________________________________________________________________________
// adjustTop

template <typename TValue, typename TLess> inline void adjustTop (PriorityType<TValue, TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(170)

//____________________________________________________________________________
// appendCmdLine

inline void appendCmdLine(CommandLineParser & me,CharString const & new_cmdLine);       	// "projects/library/seqan/misc/misc_cmdparser.h"(434)

//____________________________________________________________________________
// argumentCount

inline Size<String<CharString> >::Type argumentCount(CommandLineParser & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(1028)

//____________________________________________________________________________
// atEnd

template <typename TSet> inline bool atEnd(Iter<TSet, _VectorSetIterator_> const &a);       	// "projects/library/seqan/misc/misc_set.h"(322)

//____________________________________________________________________________
// begin

template <typename TElement, typename TSpec> inline typename Iterator< _VectorSet<TElement, TSpec> >::Type begin(_VectorSet<TElement, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(281)
template <typename TElement, typename TSpec> inline typename Iterator< _VectorSet<TElement, TSpec> const>::Type begin(_VectorSet<TElement, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(287)
template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > begin(Enumerator<TObject, TSpec> &enumerator, Standard);       	// "projects/library/seqan/misc/edit_environment.h"(697)
template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > begin(Enumerator<TObject, TSpec> const &enumerator, Standard);       	// "projects/library/seqan/misc/edit_environment.h"(702)

//____________________________________________________________________________
// clear

template <typename TValue, typename TLess> inline void clear (PriorityType<TValue,TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(82)
template <typename TValue, typename TSpec> finline void clear(_VectorSet<TValue, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(215)

//____________________________________________________________________________
// empty

template <typename TValue, typename TLess> inline bool empty(PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(91)

//____________________________________________________________________________
// end

template <typename TElement, typename TSpec> inline typename Iterator< _VectorSet<TElement, TSpec> >::Type end(_VectorSet<TElement, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(294)
template <typename TElement, typename TSpec> inline typename Iterator< _VectorSet<TElement, TSpec> const>::Type end(_VectorSet<TElement, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(300)
template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > end(Enumerator<TObject, TSpec> &enumerator, Standard);       	// "projects/library/seqan/misc/edit_environment.h"(712)
template <typename TObject, typename TSpec > inline Iter< Enumerator<TObject, TSpec>, Standard > end(Enumerator<TObject, TSpec> const &enumerator, Standard);       	// "projects/library/seqan/misc/edit_environment.h"(719)

//____________________________________________________________________________
// eof

template <typename TSet> inline bool eof(Iter<TSet, _VectorSetIterator_> const &a);       	// "projects/library/seqan/misc/misc_set.h"(317)

//____________________________________________________________________________
// erase

template <typename TKey, typename TValue, typename TSpec> finline void erase(TKey const &key, _VectorSet<TValue, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(245)

//____________________________________________________________________________
// find

template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< _VectorSet<TKey2, TSpec> >::Type find(TKey const &key, _VectorSet<TKey2, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(260)
template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< _VectorSet<TKey2, TSpec> const>::Type find(TKey const &key, _VectorSet<TKey2, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(270)

//____________________________________________________________________________
// geomRand

template <typename T> inline T geomRand();       	// "projects/library/seqan/misc/misc_random.h"(159)

//____________________________________________________________________________
// getArgumentValue

inline bool getArgumentValue(CommandLineParser & me, unsigned position, CharString & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(1011)

//____________________________________________________________________________
// getOptionValue

inline bool getOptionValue(CommandLineParser & me,char const & shortName, bool & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(872)
inline bool getOptionValue(CommandLineParser & me,CharString const & longName, bool & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(886)
inline bool getOptionValue(CommandLineParser & me,char const & shortName, CharString & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(903)
inline bool getOptionValue(CommandLineParser & me,CharString const & longName, CharString & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(918)
inline bool getOptionValue(CommandLineParser & me,char const & shortName, int & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(935)
inline bool getOptionValue(CommandLineParser & me,CharString const & longName, int & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(950)
inline bool getOptionValue(CommandLineParser & me,char const & shortName, double & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(967)
inline bool getOptionValue(CommandLineParser & me,CharString const & longName, double & val);       	// "projects/library/seqan/misc/misc_cmdparser.h"(982)

//____________________________________________________________________________
// goBegin

template <typename TObject, unsigned DISTANCE > inline void goBegin(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "projects/library/seqan/misc/edit_environment.h"(195)
template <typename TObject, unsigned DISTANCE > inline void goBegin(Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> & it);       	// "projects/library/seqan/misc/edit_environment.h"(498)

//____________________________________________________________________________
// goEnd

template <typename TObject, unsigned DISTANCE > inline void goEnd(Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "projects/library/seqan/misc/edit_environment.h"(239)
template <typename TObject, unsigned DISTANCE > inline void goEnd(Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> & it);       	// "projects/library/seqan/misc/edit_environment.h"(525)

//____________________________________________________________________________
// hasOption

bool hasOption(CommandLineParser & me, CharString const & _long);       	// "projects/library/seqan/misc/misc_cmdparser.h"(397)
bool hasOption(CommandLineParser const & me, CharString const & _long);       	// "projects/library/seqan/misc/misc_cmdparser.h"(403)
bool hasOption(CommandLineParser & me, const char _short);       	// "projects/library/seqan/misc/misc_cmdparser.h"(410)
bool hasOption(CommandLineParser const & me, const char _short);       	// "projects/library/seqan/misc/misc_cmdparser.h"(416)

//____________________________________________________________________________
// help

template <typename TStream> inline void help(CommandLineParser & me, TStream & target);       	// "projects/library/seqan/misc/misc_cmdparser.h"(505)
inline void help(CommandLineParser & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(563)

//____________________________________________________________________________
// helpText

inline CharString & helpText(CommandLineOption & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(197)
inline const CharString & helpText(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(202)

//____________________________________________________________________________
// in

template <typename TKey, typename TValue, typename TSpec> finline bool in(TKey const &key, _VectorSet<TValue, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(254)

//____________________________________________________________________________
// insert

template <typename TElement, typename TSetKey, typename TSpec> finline void insert(TElement const &element, _VectorSet<TSetKey, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(222)
template <typename TElement, typename TSetKey, typename TSetObject, typename TPairSpec, typename TSpec> finline void insert(TElement const &element, _VectorSet< Pair<TSetKey, TSetObject, TPairSpec>, TSpec > &set);       	// "projects/library/seqan/misc/misc_set.h"(235)

//____________________________________________________________________________
// isBooleanOption

inline const bool isBooleanOption(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(229)

//____________________________________________________________________________
// isDebugOption

inline const bool isDebugOption(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(244)

//____________________________________________________________________________
// isDoubleOption

inline const bool isDoubleOption(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(234)

//____________________________________________________________________________
// isIntOption

inline const bool isIntOption(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(239)

//____________________________________________________________________________
// isOptionMandatory

inline const bool isOptionMandatory(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(249)

//____________________________________________________________________________
// isSet

inline bool isSet(CommandLineParser & me,char const & shortName);       	// "projects/library/seqan/misc/misc_cmdparser.h"(580)
inline bool isSet(CommandLineParser & me,CharString const & longName);       	// "projects/library/seqan/misc/misc_cmdparser.h"(592)

//____________________________________________________________________________
// isStringOption

inline const bool isStringOption(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(224)

//____________________________________________________________________________
// keyOf

template <typename TElement> inline typename Key<TElement>::Type & keyOf(TElement & element);       	// "projects/library/seqan/misc/misc_base.h"(73)
template <typename TElement> inline typename Key<TElement const>::Type & keyOf(TElement const & element);       	// "projects/library/seqan/misc/misc_base.h"(79)
template <typename TKey, typename TObject, typename TSpec> inline TKey & keyOf(Pair<TKey, TObject, TSpec> &element);       	// "projects/library/seqan/misc/misc_base.h"(85)
template <typename TKey, typename TObject, typename TSpec> inline TKey const & keyOf(Pair<TKey, TObject, TSpec> const &element);       	// "projects/library/seqan/misc/misc_base.h"(90)
template <typename TSet> inline typename Key<TSet>::Type keyOf(Iter<TSet, _VectorSetIterator_> &it);       	// "projects/library/seqan/misc/misc_set.h"(330)
template <typename TSet> inline typename Key<TSet>::Type keyOf(Iter<TSet, _VectorSetIterator_> const &it);       	// "projects/library/seqan/misc/misc_set.h"(335)

//____________________________________________________________________________
// length

template <typename TValue, typename TLess> inline typename Size<PriorityType<TValue, TLess, PriorityHeap> >::Type length( PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(101)
template <typename TObject, typename TSpec> inline typename Size< _VectorSet<TObject, TSpec> >::Type length(_VectorSet<TObject, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(152)
template <typename TObject, unsigned DISTANCE > inline typename Size< Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> > >::Type length(Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> > const & me);       	// "projects/library/seqan/misc/edit_environment.h"(317)
template <typename TObject, unsigned DISTANCE > inline typename Size< Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> > >::Type length(Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> > const & me);       	// "projects/library/seqan/misc/edit_environment.h"(641)

//____________________________________________________________________________
// longName

inline CharString & longName(CommandLineOption & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(126)
inline const CharString & longName(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(131)

//____________________________________________________________________________
// mtRand

inline unsigned long mtRand();       	// "projects/library/seqan/misc/misc_random.h"(116)

//____________________________________________________________________________
// mtRandInit

inline void mtRandInit(bool _doSRand );       	// "projects/library/seqan/misc/misc_random.h"(87)
inline void mtRandInit();       	// "projects/library/seqan/misc/misc_random.h"(107)

//____________________________________________________________________________
// objectOf

template <typename TKey, typename TObject, typename TSpec> inline TObject & objectOf(Pair<TKey, TObject, TSpec> &element);       	// "projects/library/seqan/misc/misc_base.h"(100)
template <typename TKey, typename TObject, typename TSpec> inline TObject const & objectOf(Pair<TKey, TObject, TSpec> const &element);       	// "projects/library/seqan/misc/misc_base.h"(105)
template <typename TSet> inline typename Object<TSet>::Type & objectOf(Iter<TSet, _VectorSetIterator_> &it);       	// "projects/library/seqan/misc/misc_set.h"(341)
template <typename TSet> inline typename Object<TSet>::Type & objectOf(Iter<TSet, _VectorSetIterator_> const &it);       	// "projects/library/seqan/misc/misc_set.h"(346)

//____________________________________________________________________________
// operator!=

template <typename TSet> inline bool operator!=(Iter<TSet, _VectorSetIterator_> const &a, Iter<TSet, _VectorSetIterator_> const &b);       	// "projects/library/seqan/misc/misc_set.h"(312)
template <typename TObject, unsigned DISTANCE> inline bool operator!= ( Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & b);       	// "projects/library/seqan/misc/edit_environment.h"(784)
template <typename TObject, unsigned DISTANCE> inline bool operator!= ( Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & b);       	// "projects/library/seqan/misc/edit_environment.h"(806)

//____________________________________________________________________________
// operator*

template <typename TObject, typename TSpec > inline TObject const & operator* (Iter<Enumerator<TObject, TSpec>, Standard> & it);       	// "projects/library/seqan/misc/edit_environment.h"(178)
template <typename TObject, typename TSpec > inline TObject const & operator* (Iter<Enumerator<TObject, TSpec>, Standard> const & it);       	// "projects/library/seqan/misc/edit_environment.h"(185)

//____________________________________________________________________________
// operator++

template <typename TObject, unsigned DISTANCE > inline Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & operator++ (Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> & it);       	// "projects/library/seqan/misc/edit_environment.h"(254)
template <typename TObject, unsigned DISTANCE > inline Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> & operator++ (Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> &it);       	// "projects/library/seqan/misc/edit_environment.h"(542)

//____________________________________________________________________________
// operator<<

template <typename TStream> inline TStream & operator<< (TStream & target, CommandLineOption const & source);       	// "projects/library/seqan/misc/misc_cmdparser.h"(290)

//____________________________________________________________________________
// operator==

template <typename TSet> inline bool operator==(Iter<TSet, _VectorSetIterator_> const &a, Iter<TSet, _VectorSetIterator_> const &b);       	// "projects/library/seqan/misc/misc_set.h"(307)
template <typename TObject, unsigned DISTANCE> inline bool operator== ( Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<HammingDistance, DISTANCE> >, Standard> const & b);       	// "projects/library/seqan/misc/edit_environment.h"(734)
template <typename TObject, unsigned DISTANCE> inline bool operator== ( Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & a, Iter<Enumerator<TObject, EditEnvironment<LevenshteinDistance, DISTANCE> >, Standard> const & b);       	// "projects/library/seqan/misc/edit_environment.h"(756)

//____________________________________________________________________________
// parse

template <typename TErrorStream> bool parse(CommandLineParser & me,int argc, const char *argv[], TErrorStream & estream);       	// "projects/library/seqan/misc/misc_cmdparser.h"(680)
inline bool parse(CommandLineParser & me,int argc, const char *argv[]);       	// "projects/library/seqan/misc/misc_cmdparser.h"(852)

//____________________________________________________________________________
// pop

template <typename TValue, typename TLess> inline void pop (PriorityType<TValue, TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(249)

//____________________________________________________________________________
// push

template <typename TValue, typename TLess> inline void push (PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element);       	// "projects/library/seqan/misc/priority_type_heap.h"(198)

//____________________________________________________________________________
// requiredArguments

inline void requiredArguments(CommandLineParser & me,unsigned count);       	// "projects/library/seqan/misc/misc_cmdparser.h"(450)

//____________________________________________________________________________
// setHelpText

inline void setHelpText(CommandLineOption & me, CharString const & newHelp);       	// "projects/library/seqan/misc/misc_cmdparser.h"(217)

//____________________________________________________________________________
// setLongName

inline void setLongName(CommandLineOption & me, CharString const & newName);       	// "projects/library/seqan/misc/misc_cmdparser.h"(146)

//____________________________________________________________________________
// setOptionType

inline void setOptionType(CommandLineOption & me,const int _newOpt);       	// "projects/library/seqan/misc/misc_cmdparser.h"(254)

//____________________________________________________________________________
// setShortName

inline void setShortName(CommandLineOption & me, char const & newName);       	// "projects/library/seqan/misc/misc_cmdparser.h"(181)

//____________________________________________________________________________
// shortHelp

template <typename TStream> inline void shortHelp(CommandLineParser & me, TStream & target);       	// "projects/library/seqan/misc/misc_cmdparser.h"(484)

//____________________________________________________________________________
// shortName

inline char & shortName(CommandLineOption & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(162)
inline const char & shortName(CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(167)

//____________________________________________________________________________
// top

template <typename TValue, typename TLess> inline TValue & top(PriorityType<TValue, TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(126)
template <typename TValue, typename TLess> inline TValue const & top(PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(134)

//____________________________________________________________________________
// write

template <typename TStream> inline void write(TStream & target, CommandLineOption const & me);       	// "projects/library/seqan/misc/misc_cmdparser.h"(278)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

