 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_UTILS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_UTILS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ConfigOptions

template <typename TKey, typename TValue> class ConfigOptions;       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(183)

//____________________________________________________________________________
// _AAGroupsDayhoff

struct _AAGroupsDayhoff;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(234)

//____________________________________________________________________________
// _AAGroupsLiA10

struct _AAGroupsLiA10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(966)

//____________________________________________________________________________
// _AAGroupsLiB10

struct _AAGroupsLiB10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(863)

//____________________________________________________________________________
// _AAGroupsMurphy

struct _AAGroupsMurphy;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(550)

//____________________________________________________________________________
// _AAGroupsSeB10

struct _AAGroupsSeB10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1176)

//____________________________________________________________________________
// _AAGroupsSeB14

struct _AAGroupsSeB14;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1280)

//____________________________________________________________________________
// _AAGroupsSeB6

struct _AAGroupsSeB6;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(340)

//____________________________________________________________________________
// _AAGroupsSeB8

struct _AAGroupsSeB8;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(445)

//____________________________________________________________________________
// _AAGroupsSeV10

struct _AAGroupsSeV10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1070)

//____________________________________________________________________________
// _AAGroupsSolisD10

struct _AAGroupsSolisD10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(759)

//____________________________________________________________________________
// _AAGroupsSolisG10

struct _AAGroupsSolisG10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(654)

//____________________________________________________________________________
// _Rna5

struct _Rna5;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(118)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsDayhoff

template <typename T > struct _Translate_Table_AA_2_AAGroupsDayhoff;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(188)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsLiA10

template <typename T > struct _Translate_Table_AA_2_AAGroupsLiA10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(921)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsLiB10

template <typename T > struct _Translate_Table_AA_2_AAGroupsLiB10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(818)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsMurphy

template <typename T > struct _Translate_Table_AA_2_AAGroupsMurphy;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(505)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1131)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB14

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB14;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1235)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB6

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB6;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(295)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB8

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB8;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(400)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeV10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeV10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1025)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSolisD10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSolisD10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(714)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSolisG10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSolisG10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(609)

//____________________________________________________________________________
// _Translate_Table_Ascii_2_Rna5

template <typename T > struct _Translate_Table_Ascii_2_Rna5;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(72)

//____________________________________________________________________________
// _Translate_Table_Byte_2_Rna5

template <typename T > struct _Translate_Table_Byte_2_Rna5;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(43)

//____________________________________________________________________________
// _Translate_Table_Rna5_2_Ascii

template <typename T > struct _Translate_Table_Rna5_2_Ascii;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(33)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AAGroupsDayhoff

typedef SimpleType<unsigned char, _AAGroupsDayhoff> AAGroupsDayhoff;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(235)

//____________________________________________________________________________
// AAGroupsLiA10

typedef SimpleType<unsigned char, _AAGroupsLiA10> AAGroupsLiA10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(967)

//____________________________________________________________________________
// AAGroupsLiB10

typedef SimpleType<unsigned char, _AAGroupsLiB10> AAGroupsLiB10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(864)

//____________________________________________________________________________
// AAGroupsMurphy

typedef SimpleType<unsigned char, _AAGroupsMurphy> AAGroupsMurphy;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(551)

//____________________________________________________________________________
// AAGroupsSeB10

typedef SimpleType<unsigned char, _AAGroupsSeB10> AAGroupsSeB10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1177)

//____________________________________________________________________________
// AAGroupsSeB14

typedef SimpleType<unsigned char, _AAGroupsSeB14> AAGroupsSeB14;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1281)

//____________________________________________________________________________
// AAGroupsSeB6

typedef SimpleType<unsigned char, _AAGroupsSeB6> AAGroupsSeB6;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(341)

//____________________________________________________________________________
// AAGroupsSeB8

typedef SimpleType<unsigned char, _AAGroupsSeB8> AAGroupsSeB8;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(446)

//____________________________________________________________________________
// AAGroupsSeV10

typedef SimpleType<unsigned char, _AAGroupsSeV10> AAGroupsSeV10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1071)

//____________________________________________________________________________
// AAGroupsSolisD10

typedef SimpleType<unsigned char, _AAGroupsSolisD10> AAGroupsSolisD10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(760)

//____________________________________________________________________________
// AAGroupsSolisG10

typedef SimpleType<unsigned char, _AAGroupsSolisG10> AAGroupsSolisG10;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(655)

//____________________________________________________________________________
// Rna5

typedef SimpleType<unsigned char, _Rna5> Rna5;       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(119)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _alignTiming

template <typename TText> inline void _alignTiming(std::clock_t& startTime, TText const& text);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(426)

//____________________________________________________________________________
// _createEdgeAttributes

template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Directed<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(223)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Undirected<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(234)
template <typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(245)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(256)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(278)
template <typename TStringSet, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Alignment<TStringSet, void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(299)
template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(310)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(332)

//____________________________________________________________________________
// _createEmptyEdgeAttributes

template <typename TSpec, typename TEdgeAttributes> inline void _createEmptyEdgeAttributes(Graph<TSpec> const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(204)

//____________________________________________________________________________
// _createNodeAttributes

template <typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(122)
template <typename TSpec, typename TNodeAttributes, typename TNameMap> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap, TNameMap const& nameMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(149)
template <typename TStringSet, typename TCargo, typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNodeAttributes& nodeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(174)

//____________________________________________________________________________
// _createTrieNodeAttributes

template <typename TAlphabet, typename TCargo, typename TSpec, typename TNodeMap> inline void _createTrieNodeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, String<String<unsigned int> > pos, TNodeMap& nodeMap);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(85)

//____________________________________________________________________________
// _loadSequences

template <typename TPath, typename TStringSet, typename TNames> inline unsigned int _loadSequences(TPath const& in_path, TStringSet& origStrSet, TNames& names);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(388)

//____________________________________________________________________________
// _markRootVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(34)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Directed<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(48)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Undirected<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(59)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(71)

//____________________________________________________________________________
// _parse_isAlphanumericChar

template <typename TChar> inline bool _parse_isAlphanumericChar(TChar const c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(100)

//____________________________________________________________________________
// _parse_isDigit

template <typename TChar> inline bool _parse_isDigit(TChar const c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(69)

//____________________________________________________________________________
// _parse_isLetter

template <typename TChar> inline bool _parse_isLetter(TChar const c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(80)

//____________________________________________________________________________
// _parse_readDouble

template <typename TFile, typename TChar> inline double _parse_readDouble(TFile & file, TChar& c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(125)

//____________________________________________________________________________
// _parse_readIdentifier

template <typename TFile, typename TChar> inline String<char> _parse_readIdentifier(TFile & file, TChar& c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(141)

//____________________________________________________________________________
// _parse_readNumber

template <typename TFile, typename TChar> inline int _parse_readNumber(TFile & file, TChar& c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(109)

//____________________________________________________________________________
// _parse_readWord

template <typename TFile, typename TChar> inline String<char> _parse_readWord(TFile & file, TChar& c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(157)

//____________________________________________________________________________
// _parse_skipLine

template <typename TFile, typename TChar> inline void _parse_skipLine(TFile& file, TChar& c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(39)

//____________________________________________________________________________
// _parse_skipWhitespace

template <typename TFile, typename TChar> inline void _parse_skipWhitespace(TFile& file, TChar& c);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(56)

//____________________________________________________________________________
// _stringToNumber

template <typename T, typename TString> inline T const _stringToNumber(TString& str);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(365)

//____________________________________________________________________________
// _writeEdgeType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(510)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(522)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(534)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(546)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(558)

//____________________________________________________________________________
// _writeGraphFooter

template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(363)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(374)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(385)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(427)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(439)

//____________________________________________________________________________
// _writeGraphType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(450)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(462)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(474)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(486)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(498)

//____________________________________________________________________________
// assign

inline void assign(Ascii& target, Rna5 const & source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(132)
inline void assign(Rna5 & target, Byte c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(142)
inline void assign(Rna5 & target, Ascii c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(152)
inline void assign(Rna5 & target, Unicode c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(163)
inline void assign(AAGroupsDayhoff & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(246)
inline void assign(AAGroupsDayhoff & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(256)
inline void assign(AAGroupsDayhoff & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(266)
inline void assign(AAGroupsDayhoff & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(276)
inline void assign(AAGroupsSeB6 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(352)
inline void assign(AAGroupsSeB6 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(362)
inline void assign(AAGroupsSeB6 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(372)
inline void assign(AAGroupsSeB6 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(382)
inline void assign(AAGroupsSeB8 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(457)
inline void assign(AAGroupsSeB8 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(467)
inline void assign(AAGroupsSeB8 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(477)
inline void assign(AAGroupsSeB8 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(487)
inline void assign(AAGroupsMurphy & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(562)
inline void assign(AAGroupsMurphy & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(572)
inline void assign(AAGroupsMurphy & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(582)
inline void assign(AAGroupsMurphy & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(592)
inline void assign(AAGroupsSolisG10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(666)
inline void assign(AAGroupsSolisG10 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(676)
inline void assign(AAGroupsSolisG10 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(686)
inline void assign(AAGroupsSolisG10 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(696)
inline void assign(AAGroupsSolisD10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(771)
inline void assign(AAGroupsSolisD10 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(781)
inline void assign(AAGroupsSolisD10 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(791)
inline void assign(AAGroupsSolisD10 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(801)
inline void assign(AAGroupsLiB10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(875)
inline void assign(AAGroupsLiB10 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(885)
inline void assign(AAGroupsLiB10 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(895)
inline void assign(AAGroupsLiB10 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(905)
inline void assign(AAGroupsLiA10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(978)
inline void assign(AAGroupsLiA10 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(988)
inline void assign(AAGroupsLiA10 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(998)
inline void assign(AAGroupsLiA10 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1008)
inline void assign(AAGroupsSeV10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1082)
inline void assign(AAGroupsSeV10 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1092)
inline void assign(AAGroupsSeV10 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1102)
inline void assign(AAGroupsSeV10 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1112)
inline void assign(AAGroupsSeB10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1188)
inline void assign(AAGroupsSeB10 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1198)
inline void assign(AAGroupsSeB10 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1208)
inline void assign(AAGroupsSeB10 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1218)
inline void assign(AAGroupsSeB14 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1292)
inline void assign(AAGroupsSeB14 & target, Byte const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1302)
inline void assign(AAGroupsSeB14 & target, Ascii const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1312)
inline void assign(AAGroupsSeB14 & target, Unicode const c_source);       	// "projects/library/seqan/graph_utils/graph_utility_alphabets.h"(1322)
template <typename TKey, typename TValue, typename TKey1, typename TValue1> inline void assign(ConfigOptions<TKey, TValue>& cfgOpt, TKey1& key1, TValue1& value1);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(237)

//____________________________________________________________________________
// assignHelp

template <typename TKey, typename TValue,typename TValue1> inline void assignHelp(ConfigOptions<TKey, TValue>& cfgOpt, TValue1& value1);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(321)

//____________________________________________________________________________
// assignKeys

template <typename TKey, typename TValue, typename TContainer, typename TSize> inline void assignKeys(ConfigOptions<TKey, TValue>& cfgOpt, TContainer& params, TSize numKeys);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(216)
template <typename TKey, typename TValue, typename TContainer> inline void assignKeys(ConfigOptions<TKey, TValue>& cfgOpt, TContainer& params);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(226)

//____________________________________________________________________________
// begin

template <typename TKey, typename TValue> inline typename Iterator<ConfigOptions<TKey, TValue> >::Type begin(ConfigOptions<TKey, TValue>& cfgOpt);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(270)

//____________________________________________________________________________
// end

template <typename TKey, typename TValue> inline typename Iterator<ConfigOptions<TKey, TValue> >::Type end(ConfigOptions<TKey, TValue>& cfgOpt);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(279)

//____________________________________________________________________________
// getValue

template <typename TKey, typename TValue, typename TKey1> inline TValue getValue(ConfigOptions<TKey, TValue>& cfgOpt, TKey1& key1);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(261)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TKey, typename TValue> inline TStream & operator<< (TStream & target, ConfigOptions<TKey, TValue>& source);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(310)

//____________________________________________________________________________
// parseCmdLine

template <typename TKey, typename TValue> inline bool parseCmdLine(int argc, const char *argv[], ConfigOptions<TKey, TValue>& cfgOpt);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(340)

//____________________________________________________________________________
// value

template <typename TKey, typename TValue, typename TKey1> inline TValue& value(ConfigOptions<TKey, TValue>& cfgOpt, TKey1& key1);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(247)

//____________________________________________________________________________
// valueHelp

template <typename TKey, typename TValue> inline TValue& valueHelp(ConfigOptions<TKey, TValue>& cfgOpt);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(330)

//____________________________________________________________________________
// write

template <typename TFile, typename TSpec, typename TNodeAttributes, typename TEdgeAttributes> void write(TFile & file, Graph<TSpec> const& g, TNodeAttributes const& nodeMap, TEdgeAttributes const& edgeMap, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(577)
template <typename TFile, typename TSpec> inline void write(TFile & file, Graph<TSpec> const& g, DotDrawing);       	// "projects/library/seqan/graph_utils/graph_drawing.h"(635)
template <typename TFile, typename TKey, typename TValue, typename TIDString> inline void write(TFile & target, ConfigOptions<TKey, TValue>& cfgOpt, TIDString const &, Raw);       	// "projects/library/seqan/graph_utils/graph_utility_parsing.h"(291)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

