 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_TYPES_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_TYPES_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator_

struct AdjacencyIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(173)

//____________________________________________________________________________
// Alphabet

template <typename T> struct Alphabet;       	// "projects/library/seqan/graph_types/graph_base.h"(83)

//____________________________________________________________________________
// Automaton

template <typename TAlphabet , typename TCargo , typename TSpec > struct Automaton;       	// "projects/library/seqan/graph_types/graph_interface.h"(41)

//____________________________________________________________________________
// AutomatonEdgeArray

template <typename TEdge, typename TAlphabet> class AutomatonEdgeArray;       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(34)

//____________________________________________________________________________
// BfsIterator_

struct BfsIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(181)

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "projects/library/seqan/graph_types/graph_base.h"(54)

//____________________________________________________________________________
// DfsPreorder_

struct DfsPreorder_;       	// "projects/library/seqan/graph_types/graph_base.h"(189)

//____________________________________________________________________________
// Directed

template <typename TCargo , typename TSpec > struct Directed;       	// "projects/library/seqan/graph_types/graph_interface.h"(29)

//____________________________________________________________________________
// EdgeDescriptor

template <typename T> struct EdgeDescriptor;       	// "projects/library/seqan/graph_types/graph_base.h"(45)

//____________________________________________________________________________
// EdgeIdHandler

template <typename T> struct EdgeIdHandler;       	// "projects/library/seqan/graph_types/graph_base.h"(100)

//____________________________________________________________________________
// EdgeIterator_

struct EdgeIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(157)

//____________________________________________________________________________
// EdgeStump

template <typename TCargo , bool TList , bool TSource , bool TId , typename TSpec > class EdgeStump;       	// "projects/library/seqan/graph_types/graph_base.h"(203)

//____________________________________________________________________________
// EdgeType

template <typename T> struct EdgeType;       	// "projects/library/seqan/graph_types/graph_base.h"(69)

//____________________________________________________________________________
// ExactFragment

template <typename TSpec > struct ExactFragment;       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(33)

//____________________________________________________________________________
// ExactReversableFragment

template <typename TSpec > struct ExactReversableFragment;       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(37)

//____________________________________________________________________________
// Fragment

template <typename TSize , typename TSpec > class Fragment;       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(45)

//____________________________________________________________________________
// Graph

template <typename TSpec > class Graph;       	// "projects/library/seqan/graph_types/graph_interface.h"(62)

//____________________________________________________________________________
// GraphIterator

template <typename TSpec> struct GraphIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(34)

//____________________________________________________________________________
// Hmm

template <typename TAlphabet , typename TCargo , typename TSpec > struct Hmm;       	// "projects/library/seqan/graph_types/graph_interface.h"(45)

//____________________________________________________________________________
// IdManager

template <typename TIdType , typename TSpec > class IdManager;       	// "projects/library/seqan/graph_types/graph_base.h"(233)
template <typename TIdType, typename TSpec> class IdManager;       	// "projects/library/seqan/graph_types/graph_idmanager.h"(45)

//____________________________________________________________________________
// InternalAdjacencyIterator

template <typename TSpec > struct InternalAdjacencyIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(50)

//____________________________________________________________________________
// InternalBfsIterator

template <typename TSpec > struct InternalBfsIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(54)

//____________________________________________________________________________
// InternalDfsIterator

template <typename TSpec > struct InternalDfsIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(58)

//____________________________________________________________________________
// InternalEdgeIterator

template <typename TSpec > struct InternalEdgeIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(42)

//____________________________________________________________________________
// InternalMap

template <typename TContainer, unsigned int const MemberId > struct InternalMap;       	// "projects/library/seqan/graph_types/graph_property.h"(235)

//____________________________________________________________________________
// InternalOutEdgeIterator

template <typename TSpec > struct InternalOutEdgeIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(46)

//____________________________________________________________________________
// InternalPointerMap

template <typename TPropmap, TPropmap const Instance> struct InternalPointerMap;       	// "projects/library/seqan/graph_types/graph_property.h"(495)

//____________________________________________________________________________
// InternalVertexIterator

template <typename TSpec > struct InternalVertexIterator;       	// "projects/library/seqan/graph_types/graph_iterator.h"(38)

//____________________________________________________________________________
// OutEdgeIterator_

struct OutEdgeIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(165)

//____________________________________________________________________________
// Tree

template <typename TCargo , typename TSpec > struct Tree;       	// "projects/library/seqan/graph_types/graph_interface.h"(37)

//____________________________________________________________________________
// TreeTag_

struct TreeTag_;       	// "projects/library/seqan/graph_types/graph_base.h"(127)

//____________________________________________________________________________
// Undirected

template <typename TCargo , typename TSpec > struct Undirected;       	// "projects/library/seqan/graph_types/graph_interface.h"(33)

//____________________________________________________________________________
// VertexIdHandler

template <typename T> struct VertexIdHandler;       	// "projects/library/seqan/graph_types/graph_base.h"(113)
template <typename T> struct VertexIdHandler;       	// "projects/library/seqan/graph_types/graph_base.h"(254)

//____________________________________________________________________________
// VertexIterator_

struct VertexIterator_;       	// "projects/library/seqan/graph_types/graph_base.h"(149)

//____________________________________________________________________________
// WithoutEdgeId_

struct WithoutEdgeId_;       	// "projects/library/seqan/graph_types/graph_base.h"(122)

//____________________________________________________________________________
// WordGraph

template <typename TSpec > struct WordGraph;       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(28)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator

typedef Tag<AdjacencyIterator_> const AdjacencyIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(174)

//____________________________________________________________________________
// BfsIterator

typedef Tag<BfsIterator_> const BfsIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(182)

//____________________________________________________________________________
// DfsPreorder

typedef Tag<DfsPreorder_> const DfsPreorder;       	// "projects/library/seqan/graph_types/graph_base.h"(190)

//____________________________________________________________________________
// EdgeIterator

typedef Tag<EdgeIterator_> const EdgeIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(158)

//____________________________________________________________________________
// OutEdgeIterator

typedef Tag<OutEdgeIterator_> const OutEdgeIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(166)

//____________________________________________________________________________
// TreeTag

typedef Tag<TreeTag_> const TreeTag;       	// "projects/library/seqan/graph_types/graph_base.h"(128)

//____________________________________________________________________________
// VertexIterator

typedef Tag<VertexIterator_> const VertexIterator;       	// "projects/library/seqan/graph_types/graph_base.h"(150)

//____________________________________________________________________________
// WithoutEdgeId

typedef Tag<WithoutEdgeId_> const WithoutEdgeId;       	// "projects/library/seqan/graph_types/graph_base.h"(123)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _addLetterToOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TPropertyMap, typename TChar> inline void _addLetterToOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TPropertyMap& supplyState, TChar const c);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(67)

//____________________________________________________________________________
// _addStringToTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeyword, typename TPos> inline void _addStringToTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeyword const& str, TPos const& keywordIndex);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(71)

//____________________________________________________________________________
// _assignId

template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es, TId2 const id);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(926)
template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TSpec>*, TId2 const);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(937)
template <typename TCargo, bool TList, bool TSource, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TreeTag>*, TId2 const);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(947)

//____________________________________________________________________________
// _copyGraph

template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(174)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(216)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(160)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(203)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest, bool transp);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(141)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(163)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(139)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(183)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest, bool);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(138)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(185)

//____________________________________________________________________________
// _createVertices

template <typename TSpec, typename TVertexDescriptor> inline void _createVertices(Graph<TSpec>& g, TVertexDescriptor const maxId);       	// "projects/library/seqan/graph_types/graph_interface.h"(392)

//____________________________________________________________________________
// _getEdgeIdManager

template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(133)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(141)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(145)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(127)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(124)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(124)

//____________________________________________________________________________
// _getId

template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> const>::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(956)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(966)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> const>::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(976)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(987)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(998)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(1009)
template <typename TId> inline TId _getId(TId const id);       	// "projects/library/seqan/graph_types/graph_interface.h"(381)

//____________________________________________________________________________
// _getInfinity

template <typename T> inline T const _getInfinity();       	// "projects/library/seqan/graph_types/graph_interface.h"(342)
template <> inline double const _getInfinity();       	// "projects/library/seqan/graph_types/graph_interface.h"(352)

//____________________________________________________________________________
// _getInfinityDistance

template <typename TWeightMap> inline typename Value<TWeightMap>::Type _getInfinityDistance(TWeightMap const&);       	// "projects/library/seqan/graph_types/graph_interface.h"(361)
template <typename T> inline T const _getInfinityDistance();       	// "projects/library/seqan/graph_types/graph_interface.h"(371)

//____________________________________________________________________________
// _getVertexIdManager

template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getVertexIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(117)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getVertexIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(125)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(134)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(116)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(113)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(113)

//____________________________________________________________________________
// _getVertexString

template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Tree<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(106)
template <typename TAlphabet, typename TCargo, typename TSpec> inline String<AutomatonEdgeArray<typename EdgeType<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type, TAlphabet> >& _getVertexString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(123)
template <typename TAlphabet, typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(105)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Directed<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(102)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Undirected<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(102)

//____________________________________________________________________________
// _goNextInternal

template <typename TGraph, typename TSpec> inline void _goNextInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(270)

//____________________________________________________________________________
// _goPreviousInternal

template <typename TGraph, typename TSpec> inline void _goPreviousInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(342)

//____________________________________________________________________________
// _rebuildParentMap

template <typename TCargo, typename TSpec> inline void _rebuildParentMap(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(150)

//____________________________________________________________________________
// addChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor parent);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(881)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(896)

//____________________________________________________________________________
// addEdge

template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(101)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TChars> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TChars const* chars);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(128)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(142)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(453)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child, TCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(484)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(404)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(427)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(363)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(376)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(549)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo const cargo);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(580)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor source, TVertexDescriptor target);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(396)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(441)

//____________________________________________________________________________
// addEdges

template <typename TSpec, typename TEdgeArray, typename TSize> inline void addEdges(Graph<TSpec>& dest, TEdgeArray const edges, TSize const size);       	// "projects/library/seqan/graph_types/graph_interface.h"(421)

//____________________________________________________________________________
// addVertex

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addVertex(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(399)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(365)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(297)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEmission> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TEmission const& emis);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(322)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addVertex(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(476)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addVertex(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(361)

//____________________________________________________________________________
// assignBeginState

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignBeginState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(592)

//____________________________________________________________________________
// assignCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TCargo2 const& t);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(451)
template <bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<void, TList, TSource, TId, TSpec>*, TCargo2 const&);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(462)

//____________________________________________________________________________
// assignEmissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TEmisProb> inline void assignEmissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state, TAlphabet const symbol, TEmisProb const eProb);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(906)

//____________________________________________________________________________
// assignEndState

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignEndState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(616)

//____________________________________________________________________________
// assignNextS

template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, true, TId, TSpec>* es, EdgeStump<TCargo, true, true, TId, TSpec>* es2);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(807)
template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, false, TId, TSpec>*, EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(819)

//____________________________________________________________________________
// assignNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline void assignNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es, EdgeStump<TCargo, true, TSource, TId, TSpec>* es2);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(717)

//____________________________________________________________________________
// assignProperty

template <typename TPropertyMap, typename TDescriptor, typename TValue> inline void assignProperty(TPropertyMap& pm, TDescriptor const d, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(135)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(318)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(330)
template <typename T, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<T, 0>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(342)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline void assignProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(550)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline void assignProperty(TValue TClass:: * ptr_to_member, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph_types/graph_property.h"(665)

//____________________________________________________________________________
// assignRoot

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(731)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(727)

//____________________________________________________________________________
// assignSource

template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es, TVertexDescriptor const s);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(578)
template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, false, TId, TSpec>*, TVertexDescriptor const);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(589)

//____________________________________________________________________________
// assignTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TVertexDescriptor const t);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(487)

//____________________________________________________________________________
// assignTransitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TTransProb> inline void assignTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state1, TVertexDescriptor const state2, TTransProb const t);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(804)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor, typename TTransProb> inline void assignTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >&, TEdgeDescriptor e, TTransProb const t);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(819)

//____________________________________________________________________________
// atBegin

template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(225)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(196)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(199)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(266)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(206)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(525)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(535)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(546)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(556)

//____________________________________________________________________________
// atEnd

template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(249)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(213)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(216)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(311)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(226)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(606)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(616)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(626)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(636)

//____________________________________________________________________________
// beginState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& beginState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(637)

//____________________________________________________________________________
// cargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(392)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(402)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(413)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(424)

//____________________________________________________________________________
// childVertex

template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type childVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(987)

//____________________________________________________________________________
// clear

template <typename TCargo, typename TSpec> inline void clear(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(331)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(294)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(254)
template <typename TCargo, typename TSpec> inline void clear(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(354)
template <typename TCargo, typename TSpec> inline void clear(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(306)

//____________________________________________________________________________
// clearEdges

template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(296)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(270)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(229)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(302)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(250)

//____________________________________________________________________________
// clearVertices

template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(318)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(282)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(239)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(333)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(294)

//____________________________________________________________________________
// collectLeaves

template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TSet> inline void collectLeaves(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const root, TSet& set1);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1046)

//____________________________________________________________________________
// createOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(113)

//____________________________________________________________________________
// createOracleOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracleOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "projects/library/seqan/graph_types/graph_impl_oracle.h"(145)

//____________________________________________________________________________
// createRoot

template <typename TCargo, typename TSpec> inline void createRoot(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(746)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void createRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(697)

//____________________________________________________________________________
// createTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(126)

//____________________________________________________________________________
// createTrieOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrieOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph_types/graph_impl_trie.h"(164)

//____________________________________________________________________________
// degree

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type degree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(389)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(355)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(287)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type degree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(454)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type degree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(352)

//____________________________________________________________________________
// emissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo& emissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state, TAlphabet const symbol);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(874)

//____________________________________________________________________________
// empty

template <typename TCargo, typename TSpec> inline bool empty(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(286)
template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(260)
template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(219)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(280)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(240)

//____________________________________________________________________________
// endState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& endState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(656)

//____________________________________________________________________________
// findEdge

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type findEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(653)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v, TLabel const c);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(612)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TLabel const c);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(630)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(465)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type findEdge(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(900)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type findEdge(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(724)

//____________________________________________________________________________
// fragmentBegin

template <typename TSize, typename TSpec, typename TVal> inline TSize& fragmentBegin(Fragment<TSize, TSpec> const& f, TVal const seqId);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(157)

//____________________________________________________________________________
// fragmentLength

template <typename TSize, typename TSpec, typename TVal> inline TSize& fragmentLength(Fragment<TSize, TSpec> const& f, TVal const);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(171)
template <typename TSize, typename TSpec> inline TSize& fragmentLength(Fragment<TSize, TSpec> const& f);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(181)

//____________________________________________________________________________
// getAdjacencyMatrix

template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Tree<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(625)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(579)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(454)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Directed<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(849)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Undirected<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(690)

//____________________________________________________________________________
// getBeginState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type getBeginState(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(675)

//____________________________________________________________________________
// getCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(336)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(346)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(356)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(367)

//____________________________________________________________________________
// getEmissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo getEmissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const state, TAlphabet const symbol);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(844)

//____________________________________________________________________________
// getEndState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type getEndState(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(694)

//____________________________________________________________________________
// getIdLowerBound

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type getIdLowerBound(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(254)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type getIdLowerBound(IdManager<void, TSpec> const&);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(431)

//____________________________________________________________________________
// getIdUpperBound

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type getIdUpperBound(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(231)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type getIdUpperBound(IdManager<void, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(419)

//____________________________________________________________________________
// getNextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* getNextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(895)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* getNextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(905)

//____________________________________________________________________________
// getNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(771)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(782)

//____________________________________________________________________________
// getNil

template <typename T> inline T const getNil(T *);       	// "projects/library/seqan/graph_types/graph_interface.h"(318)
template <typename T> inline T const getNil();       	// "projects/library/seqan/graph_types/graph_interface.h"(327)

//____________________________________________________________________________
// getProjectedPosition

template <typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactFragment<TSpec> > const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(195)
template <typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactReversableFragment<TSpec> > const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(224)

//____________________________________________________________________________
// getProperty

template <typename TPropertyMap, typename TDescriptor> inline typename GetValue<TPropertyMap const>::Type getProperty(TPropertyMap const& pm, TDescriptor const d);       	// "projects/library/seqan/graph_types/graph_property.h"(206)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> const>::Type getProperty(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(419)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type getProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(430)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> const>::Type getProperty(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(441)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type getProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(452)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> const>::Type getProperty(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(463)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type getProperty(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(474)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> const>::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(583)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(595)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue getProperty(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(688)

//____________________________________________________________________________
// getRoot

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type getRoot(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(769)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(779)

//____________________________________________________________________________
// getSource

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(657)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(667)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(677)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(688)

//____________________________________________________________________________
// getSuccessor

template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const& chars);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(210)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const* chars);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(231)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TChar> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getSuccessor(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor vertex, TChar const c);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(843)

//____________________________________________________________________________
// getTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(541)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(551)

//____________________________________________________________________________
// getTransitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo getTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const state1, TVertexDescriptor const state2);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(721)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline TCargo getTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(736)

//____________________________________________________________________________
// getValue

template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(185)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(164)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(166)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(186)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(166)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(420)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(430)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(440)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(450)

//____________________________________________________________________________
// goBegin

template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(236)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(205)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(208)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(288)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(216)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(566)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(576)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(586)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(596)

//____________________________________________________________________________
// goEnd

template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(259)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(221)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(224)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(332)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(236)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(646)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(656)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(667)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(677)

//____________________________________________________________________________
// goNext

template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(293)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(303)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(229)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(232)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(354)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(246)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(687)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(697)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(707)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(720)

//____________________________________________________________________________
// goPrevious

template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(368)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(378)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(398)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(279)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(761)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(775)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(789)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(812)

//____________________________________________________________________________
// hostGraph

template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(215)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(188)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(191)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(243)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(196)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(515)

//____________________________________________________________________________
// idCount

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type idCount(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(278)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type idCount(IdManager<void, TSpec> const& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(442)

//____________________________________________________________________________
// idInUse

template <typename TIdType, typename TSpec, typename TId> inline bool idInUse(IdManager<TIdType, TSpec> const& idm, TId const id);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(301)
template <typename TSpec, typename TId> inline bool idInUse(IdManager<void, TSpec> const&, TId const);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(454)

//____________________________________________________________________________
// inDegree

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type inDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(364)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(326)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(276)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type inDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(415)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type inDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(340)

//____________________________________________________________________________
// isLeaf

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isLeaf(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(803)

//____________________________________________________________________________
// isReversed

template <typename TSize, typename TSpec> inline bool isReversed(Fragment<TSize, ExactReversableFragment<TSpec> > const& f);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(250)

//____________________________________________________________________________
// isRoot

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(780)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(807)

//____________________________________________________________________________
// label

template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(461)
template <typename TSize, typename TSpec, typename TStringSet, typename TVal> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Fragment<TSize, TSpec> const& f, TStringSet& str, TVal const seqId);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(129)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(972)

//____________________________________________________________________________
// nextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(842)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(852)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(861)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(872)

//____________________________________________________________________________
// nextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(739)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(749)

//____________________________________________________________________________
// numChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numChildren(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(851)

//____________________________________________________________________________
// numEdges

template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(254)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(240)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(199)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numEdges(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(243)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numEdges(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(220)

//____________________________________________________________________________
// numTreeEdges

template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numTreeEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(827)

//____________________________________________________________________________
// numVertices

template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numVertices(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(276)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(250)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(209)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numVertices(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(264)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numVertices(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(230)

//____________________________________________________________________________
// obtainId

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type obtainId(IdManager<TIdType, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(142)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type obtainId(IdManager<void, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(387)

//____________________________________________________________________________
// operator!=

template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(430)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(280)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(283)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(444)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(324)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(902)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(914)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(926)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(938)

//____________________________________________________________________________
// operator*

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(205)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(180)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(183)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(218)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(186)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(505)

//____________________________________________________________________________
// operator++

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(319)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(330)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(249)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(258)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(252)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(261)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(365)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(376)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(256)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(267)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(738)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(749)

//____________________________________________________________________________
// operator--

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(394)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(405)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(409)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(420)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(289)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(300)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(830)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(841)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & target, Graph<TSpec> const& source);       	// "projects/library/seqan/graph_types/graph_interface.h"(443)

//____________________________________________________________________________
// operator==

template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(418)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(269)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(272)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(433)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(313)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(854)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(866)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(878)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(890)

//____________________________________________________________________________
// outDegree

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type outDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(342)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(305)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(265)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type outDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(379)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type outDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(317)

//____________________________________________________________________________
// parentVertex

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1011)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(1022)

//____________________________________________________________________________
// parseString

template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type parseString(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor const vertex, TIterator beginIt, TIterator endIt);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(244)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TIterator beginIt, TIterator endIt);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(880)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const& chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(901)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const* chars);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(913)

//____________________________________________________________________________
// property

template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap>::Type property(TPropertyMap& pm, TDescriptor const d);       	// "projects/library/seqan/graph_types/graph_property.h"(165)
template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap const>::Type property(TPropertyMap const& pm, TDescriptor const d);       	// "projects/library/seqan/graph_types/graph_property.h"(176)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type& property(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(353)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> const>::Type& property(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(364)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type& property(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(375)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> const>::Type& property(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(386)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type& property(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(397)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> const>::Type& property(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_property.h"(408)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type& property(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(561)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> const>::Type& property(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(572)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue& property(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_types/graph_property.h"(677)

//____________________________________________________________________________
// releaseAll

template <typename TIdType, typename TSpec> inline void releaseAll(IdManager<TIdType, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(209)
template <typename TSpec> inline void releaseAll(IdManager<void, TSpec>& idm);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(409)

//____________________________________________________________________________
// releaseId

template <typename TIdType, typename TSpec, typename TId> inline void releaseId(IdManager<TIdType, TSpec>& idm, TId const id);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(177)
template <typename TSpec, typename TId> inline void releaseId(IdManager<void, TSpec>& idm, TId const);       	// "projects/library/seqan/graph_types/graph_idmanager.h"(399)

//____________________________________________________________________________
// removeAllChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeAllChildren(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(954)

//____________________________________________________________________________
// removeChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(927)

//____________________________________________________________________________
// removeEdge

template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(156)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(500)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(536)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(449)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(466)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(388)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(399)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(618)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(654)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(459)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(547)

//____________________________________________________________________________
// removeInEdges

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(565)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(506)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(421)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(734)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(656)

//____________________________________________________________________________
// removeOutEdges

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(547)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(482)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(410)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(703)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(638)

//____________________________________________________________________________
// removeVertex

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(428)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(387)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(350)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(509)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(381)

//____________________________________________________________________________
// resizeEdgeMap

template <typename TSpec, typename TPropertyMap> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "projects/library/seqan/graph_types/graph_property.h"(101)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec> const&, InternalMap<TContainer, MemberId>&);       	// "projects/library/seqan/graph_types/graph_property.h"(299)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec>&, InternalMap<TContainer, MemberId>&);       	// "projects/library/seqan/graph_types/graph_property.h"(308)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec>&, InternalPointerMap<TPropmap, Instance>&);       	// "projects/library/seqan/graph_types/graph_property.h"(530)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec> const&, InternalPointerMap<TPropmap, Instance>&);       	// "projects/library/seqan/graph_types/graph_property.h"(540)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec> const&, TValue TClass:: *);       	// "projects/library/seqan/graph_types/graph_property.h"(645)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec>&, TValue TClass:: *);       	// "projects/library/seqan/graph_types/graph_property.h"(654)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "projects/library/seqan/graph_types/graph_property.h"(725)

//____________________________________________________________________________
// resizeVertexMap

template <typename TSpec, typename TPropertyMap> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "projects/library/seqan/graph_types/graph_property.h"(72)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "projects/library/seqan/graph_types/graph_property.h"(707)

//____________________________________________________________________________
// root

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type& root(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(759)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& root(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(753)

//____________________________________________________________________________
// sequenceId

template <typename TSize, typename TSpec, typename TVal> inline typename Id<Fragment<TSize, TSpec> >::Type sequenceId(Fragment<TSize, TSpec> const& f, TVal const seqId);       	// "projects/library/seqan/graph_types/graph_impl_fragment.h"(143)

//____________________________________________________________________________
// source

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type& source(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(599)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(609)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(620)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(632)

//____________________________________________________________________________
// sourceVertex

template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(441)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type sourceVertex(Graph<Tree<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(604)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(548)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(443)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type sourceVertex(Graph<Directed<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(816)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(949)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type sourceVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(678)

//____________________________________________________________________________
// target

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& target(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(509)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type target(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph_types/graph_edgestump.h"(519)

//____________________________________________________________________________
// targetVertex

template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type targetVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(451)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type targetVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(593)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(536)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(432)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type targetVertex(Graph<Directed<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(783)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Directed<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(981)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Tree<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(991)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Undirected<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1001)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(1015)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type targetVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(667)

//____________________________________________________________________________
// transitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo& transitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state1, TVertexDescriptor const state2);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(763)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline TCargo& transitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >&, TEdgeDescriptor e);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(777)

//____________________________________________________________________________
// transpose

template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(231)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(242)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(218)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(228)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(177)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(187)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(210)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(220)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(199)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const&);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(211)

//____________________________________________________________________________
// value

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_edge.h"(195)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_bfs.h"(172)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_dfs.h"(174)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_vertex.h"(208)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_adjacency.h"(176)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(462)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(472)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(483)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph_types/graph_iterator_outedge.h"(493)

//____________________________________________________________________________
// write

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_wordgraph.h"(173)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Tree<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_tree.h"(685)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_automaton.h"(647)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_hmm.h"(478)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Directed<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_directed.h"(924)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Undirected<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph_types/graph_impl_undirected.h"(755)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

