 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_MSA_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_MSA_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BlastLib_

struct BlastLib_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(54)

//____________________________________________________________________________
// FractionalScore_

struct FractionalScore_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(42)

//____________________________________________________________________________
// FrequencyCounting_

struct FrequencyCounting_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(50)

//____________________________________________________________________________
// GlobalPairwise_Library_

struct GlobalPairwise_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(50)

//____________________________________________________________________________
// KmerDistance_

struct KmerDistance_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(49)

//____________________________________________________________________________
// Kmer_Library_

struct Kmer_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(67)

//____________________________________________________________________________
// Lcs_Library_

struct Lcs_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(76)

//____________________________________________________________________________
// LibraryDistance_

struct LibraryDistance_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(41)

//____________________________________________________________________________
// LocalPairwise_Library_

struct LocalPairwise_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(59)

//____________________________________________________________________________
// MSA_Dna_

struct MSA_Dna_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(57)

//____________________________________________________________________________
// MSA_Genome_

struct MSA_Genome_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(65)

//____________________________________________________________________________
// MSA_ProteinCustom_

struct MSA_ProteinCustom_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(48)

//____________________________________________________________________________
// MSA_Protein_

struct MSA_Protein_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(40)

//____________________________________________________________________________
// MummerLib_

struct MummerLib_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(64)

//____________________________________________________________________________
// NewickFormat_

struct NewickFormat_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(75)

//____________________________________________________________________________
// TCoffeeLib_

struct TCoffeeLib_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(44)

//____________________________________________________________________________
// UpgmaAvg_

struct UpgmaAvg_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(299)

//____________________________________________________________________________
// UpgmaMax_

struct UpgmaMax_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(289)

//____________________________________________________________________________
// UpgmaMin_

struct UpgmaMin_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(279)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BlastLib

typedef Tag<BlastLib_> const BlastLib;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(55)

//____________________________________________________________________________
// FractionalScore

typedef Tag<FractionalScore_> const FractionalScore;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(43)

//____________________________________________________________________________
// FrequencyCounting

typedef Tag<FrequencyCounting_> const FrequencyCounting;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(51)

//____________________________________________________________________________
// GlobalPairwise_Library

typedef Tag<GlobalPairwise_Library_> const GlobalPairwise_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(51)

//____________________________________________________________________________
// KmerDistance

typedef Tag<KmerDistance_> const KmerDistance;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(50)

//____________________________________________________________________________
// Kmer_Library

typedef Tag<Kmer_Library_> const Kmer_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(68)

//____________________________________________________________________________
// Lcs_Library

typedef Tag<Lcs_Library_> const Lcs_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(77)

//____________________________________________________________________________
// LibraryDistance

typedef Tag<LibraryDistance_> const LibraryDistance;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(42)

//____________________________________________________________________________
// LocalPairwise_Library

typedef Tag<LocalPairwise_Library_> const LocalPairwise_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(60)

//____________________________________________________________________________
// MSA_Dna

typedef Tag<MSA_Dna_> const MSA_Dna;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(58)

//____________________________________________________________________________
// MSA_Genome

typedef Tag<MSA_Genome_> const MSA_Genome;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(66)

//____________________________________________________________________________
// MSA_Protein

typedef Tag<MSA_Protein_> const MSA_Protein;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(41)

//____________________________________________________________________________
// MSA_ProteinCustom

typedef Tag<MSA_ProteinCustom_> const MSA_ProteinCustom;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(49)

//____________________________________________________________________________
// MummerLib

typedef Tag<MummerLib_> const MummerLib;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(65)

//____________________________________________________________________________
// NewickFormat

typedef Tag<NewickFormat_> const NewickFormat;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(76)

//____________________________________________________________________________
// TCoffeeLib

typedef Tag<TCoffeeLib_> const TCoffeeLib;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(45)

//____________________________________________________________________________
// UpgmaAvg

typedef Tag<UpgmaAvg_> const UpgmaAvg;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(300)

//____________________________________________________________________________
// UpgmaMax

typedef Tag<UpgmaMax_> const UpgmaMax;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(290)

//____________________________________________________________________________
// UpgmaMin

typedef Tag<UpgmaMin_> const UpgmaMin;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(280)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __getAlignmentStatistics

template <typename TFragment, typename TSpec1, typename TString, typename TSpec2, typename TValue, typename TSpec, typename TSize> inline void __getAlignmentStatistics(String<TFragment, TSpec1>& matches, StringSet<TString, TSpec2>& pairSet, String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, TSize from);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(480)
template <typename TFragment, typename TSpec1, typename TString, typename TSpec2, typename TCargo, typename TSpec, typename TSize> inline void __getAlignmentStatistics(String<TFragment, TSpec1>& matches, StringSet<TString, TSpec2>& pairSet, Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, TSize from);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(509)
template <typename TFragment, typename TSpec, typename TString, typename TSpec2, typename TSize> inline void __getAlignmentStatistics(String<TFragment, TSpec>&, StringSet<TString, TSpec2>&, Nothing&, TSize, TSize, TSize, TSize);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(536)

//____________________________________________________________________________
// __resizeWithRespectToDistance

template <typename TValue, typename TSpec, typename TSize> inline void __resizeWithRespectToDistance(String<TValue, TSpec>& dist, TSize nseq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(441)
template <typename TCargo, typename TSpec, typename TSize> inline void __resizeWithRespectToDistance(Graph<Undirected<TCargo, TSpec> >& dist, TSize nseq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(453)
template <typename TSize> inline void __resizeWithRespectToDistance(Nothing&, TSize);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(465)

//____________________________________________________________________________
// _addNewEdgesFoundByTriplet

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexString, typename TCargoString> inline void _addNewEdgesFoundByTriplet(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(463)

//____________________________________________________________________________
// _assignNewCargos

template <typename TStringSet, typename TCargo, typename TSpec, typename TCargoMap> inline void _assignNewCargos(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TCargoMap& newCargoMap);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(444)

//____________________________________________________________________________
// _buildAlignmentGraph

template <typename TValue, typename TScore, typename TStringSet, typename TCargo, typename TSpec> void _buildAlignmentGraph(String<TValue> const& mat, TScore const& scType, Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(435)

//____________________________________________________________________________
// _buildLeafString

template <typename TStringSet, typename TCargo, typename TSpec, typename TPosition, typename TSequence> inline void _buildLeafString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TPosition const pos, TSequence& alignSeq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(38)

//____________________________________________________________________________
// _createAlignmentGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TOutGraph> inline void _createAlignmentGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TOutGraph& gOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(72)

//____________________________________________________________________________
// _createMatchingGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TEdgeMap, typename TOutGraph> inline void _createMatchingGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TEdgeMap& edgeMap, TOutGraph& gOut, TEdgeMap& edgeMapOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(446)

//____________________________________________________________________________
// _debugMatches

template <typename TStringSet, typename TMatches> void _debugMatches(TStringSet& str, TMatches& matches);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(578)

//____________________________________________________________________________
// _debugRefinedMatches

template <typename TGraph> void _debugRefinedMatches(TGraph& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(615)

//____________________________________________________________________________
// _getTupelString

template <typename TString, typename TTupelString, typename TKTup, typename TAlphabet> inline void _getTupelString(TString const& str, TTupelString& tupelString, TKTup const ktup, TAlphabet);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_kmer.h"(39)

//____________________________________________________________________________
// _parse_readSequenceData

template <typename TFile, typename TChar, typename TString> inline void _parse_readSequenceData(TFile & file, TChar & c, TString& str);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(91)

//____________________________________________________________________________
// _performTripletExtension

template <typename TStringSet, typename TCargo, typename TSpec, typename TCargoMap, typename TVertexString, typename TCargoString> inline void _performTripletExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TCargoMap& newCargoMap, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(277)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet, typename TCargoMap, typename TVertexString, typename TCargoString> inline void _performTripletExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1, TCargoMap& newCargoMap, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(335)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet, typename TCargoMap, typename TVertexString, typename TCargoString> inline void _performTripletExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1, TSet const& set2, TCargoMap& newCargoMap, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(389)

//____________________________________________________________________________
// _readLibrary

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _readLibrary(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(109)

//____________________________________________________________________________
// _recursiveProgressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence> inline void _recursiveProgressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(116)

//____________________________________________________________________________
// _recursiveProgressiveMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence> inline void _recursiveProgressiveMatching(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(672)

//____________________________________________________________________________
// _upgmaTreeMerge

template <typename TMatrix, typename TActive, typename TSize> inline typename Value<TMatrix>::Type _upgmaTreeMerge(TMatrix const& mat, TActive const& active, TSize index_i, TSize index_j, TSize i, TSize nseq, UpgmaAvg);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(315)
template <typename TMatrix, typename TActive, typename TSize> inline typename Value<TMatrix>::Type _upgmaTreeMerge(TMatrix const& mat, TActive const&, TSize index_i, TSize index_j, TSize i, TSize nseq, UpgmaMin);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(339)
template <typename TMatrix, typename TActive, typename TSize> inline typename Value<TMatrix>::Type _upgmaTreeMerge(TMatrix const& mat, TActive const&, TSize index_i, TSize index_j, TSize i, TSize nseq, UpgmaMax);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(365)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMax);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(388)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMin);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(416)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const& active, TEdgeDescriptor best, UpgmaAvg);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(452)

//____________________________________________________________________________
// alignmentEvaluation

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TSize> inline typename Value<TScore>::Type alignmentEvaluation(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type, TSize& gapExCount, TSize& gapCount, TSize& pairCount, String<TSize>& numPairs, TSize& len);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(725)

//____________________________________________________________________________
// combineGraphs

template <typename TStringSet, typename TCargo, typename TSpec, typename TWeights, typename TLibraries> inline void combineGraphs(Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TLibraries& libs, TWeights& weights, FractionalScore);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(69)
template <typename TStringSet, typename TCargo, typename TSpec, typename TLibraries> inline void combineGraphs(Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TLibraries& libs, FrequencyCounting);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(167)
template <typename TStringSet, typename TCargo, typename TSpec, typename TLibraries> inline void combineGraphs(Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TLibraries& libs, FractionalScore);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(217)
template <typename TStringSet, typename TCargo, typename TSpec, typename TLibraries> inline void combineGraphs(Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TLibraries& libs);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(248)

//____________________________________________________________________________
// generatePrimaryLibrary

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TPairList> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPairList& pList, TScore const& score_type, Lcs_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(203)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TAlphabet, typename TSize> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, TSize ktup, TAlphabet, Kmer_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(272)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TSize> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, TSize ktup, Kmer_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(340)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, Kmer_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(352)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, Lcs_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(366)
template <typename TStringSet, typename TCargo, typename TSpec, typename TPairList, typename TScore> void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPairList& pList, TScore const& score_type, LocalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(382)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, LocalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(427)
template <typename TStringSet, typename TCargo, typename TSpec, typename TPairList, typename TDistance, typename TAlignConfig, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPairList& pList, TDistance& dist, TScore const& score_type, TAlignConfig const& ac, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(550)
template <typename TStringSet, typename TCargo, typename TSpec, typename TPairList, typename TDistance, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPairList& pList, TDistance& dist, Score<TScoreValue, TScoreSpec> const& score_type, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(642)
template <typename TStringSet, typename TCargo, typename TSpec, typename TDistance, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TDistance& dist, Score<TScoreValue, TScoreSpec> const& score_type, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(655)
template <typename TStringSet, typename TCargo, typename TSpec, typename TId, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, String<Pair<TId, TId> >& pList, Score<TScoreValue, TScoreSpec> const& score_type, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(671)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TScoreSpec> const& score_type, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(684)
template <typename TStringSet, typename TCargo, typename TSpec, typename TPairList, typename TScoreValue, typename TScoreSpec, typename TAlignConfig> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPairList& pList, Score<TScoreValue, TScoreSpec> const& score_type, TAlignConfig const& ac, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(702)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TScoreSpec, typename TAlignConfig> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TScoreSpec> const& score_type, TAlignConfig const& ac, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(716)

//____________________________________________________________________________
// getAlignmentStatistics

template <typename TFragment, typename TSpec1, typename TStringSet, typename TPos, typename TSize1, typename TAlphabet> inline void getAlignmentStatistics(String<TFragment, TSpec1> const& matches, TStringSet& str, TPos const from, TPos const to, TSize1& matchLength, TSize1& overlapLength, TSize1& alignLength, TAlphabet);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(130)
template <typename TFragment, typename TSpec1, typename TStringSet, typename TPos, typename TSize> inline void getAlignmentStatistics(String<TFragment, TSpec1>& matches, TStringSet& str, TPos from, TPos to, TSize& matchLength, TSize& overlapLength, TSize& alignLength);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(183)

//____________________________________________________________________________
// getDistanceMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, LibraryDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(68)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize, typename TAlphabet> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, TAlphabet, KmerDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(134)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, KmerDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(164)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, KmerDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(176)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(210)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TString, typename TSpec, typename THitMatrix, typename TSize, typename TAlphabet> inline void getKmerSimilarityMatrix(StringSet<TString, TSpec> const& strSet, THitMatrix& mat, TSize ktup, TAlphabet);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_kmer.h"(81)

//____________________________________________________________________________
// globalAlignment

template <typename TString, typename TSpec, typename TName, typename TSpec2, typename TConfigOptions, typename TAlignmentGraph> inline void globalAlignment(StringSet<TString, TSpec> const& seqSet, StringSet<TName, TSpec2> const& nameSet, TConfigOptions& cfgOpt, TAlignmentGraph& gOut, MSA_Protein);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(82)
template <typename TString, typename TSpec, typename TName, typename TSpec2, typename TConfigOptions, typename TAlignmentGraph> inline void globalAlignment(StringSet<TString, TSpec> const& seqSet, StringSet<TName, TSpec2> const& nameSet, TConfigOptions& cfgOpt, TAlignmentGraph& gOut, MSA_ProteinCustom);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(216)
template <typename TString, typename TSpec, typename TName, typename TSpec2, typename TConfigOptions, typename TAlignmentGraph> inline void globalAlignment(StringSet<TString, TSpec> const& seqSet, StringSet<TName, TSpec2> const& nameSet, TConfigOptions& cfgOpt, TAlignmentGraph& gOut, MSA_Genome);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(310)
template <typename TString, typename TSpec, typename TName, typename TSpec2, typename TConfigOptions, typename TAlignmentGraph> inline void globalAlignment(StringSet<TString, TSpec> const& seqSet, StringSet<TName, TSpec2> const& nameSet, TConfigOptions& cfgOpt, TAlignmentGraph& gOut, MSA_Dna);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(372)
template <typename TString, typename TSpec, typename TDependentSequenceSet, typename TCargo, typename TSpec2, typename TTag> inline void globalAlignment(StringSet<TString, TSpec> const& seqSet, Graph<Alignment<TDependentSequenceSet, TCargo, TSpec2> >& gOut, TTag);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(452)

//____________________________________________________________________________
// heaviestMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TString, typename TOutString> inline TCargo heaviestMatching(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(489)

//____________________________________________________________________________
// iterativeProgressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TScore, typename TOutGraph> inline TCargo iterativeProgressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TScore const& score_type, TOutGraph& gOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(319)

//____________________________________________________________________________
// metaGlobalAlignment

template <typename TString, typename TSpec, typename TName, typename TSpec2, typename TConfigOptions, typename TScore, typename TAlignmentGraph> inline void metaGlobalAlignment(StringSet<TString, TSpec> const& seqSet, StringSet<TName, TSpec2> const& nameSet, TConfigOptions& cfgOpt, TScore& scType, TAlignmentGraph& gOut, MSA_Protein);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(472)
template <typename TString, typename TSpec, typename TName, typename TSpec2, typename TConfigOptions, typename TAlignmentGraph> inline void metaGlobalAlignment(StringSet<TString, TSpec> const& seqSet, StringSet<TName, TSpec2> const& nameSet, TConfigOptions& cfgOpt, TAlignmentGraph& gOut, MSA_Protein);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(546)

//____________________________________________________________________________
// progressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(175)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph, typename TSize> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut, TSize seqPerGroup);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(202)

//____________________________________________________________________________
// progressiveMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TEdgeMap, typename TOutGraph> inline void progressiveMatching(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TEdgeMap& edgeMap, TOutGraph& gOut, TEdgeMap& edgeMapOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(713)

//____________________________________________________________________________
// read

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TCoffeeLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(239)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, TCoffeeLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(276)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, FastaAlign);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(396)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TScoreType> void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TNames const& origNames, TScoreType const& scType, FastaAlign);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(505)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TEdgeMap> void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TNames& names, TEdgeMap& edgeMap, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(566)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TNames& names, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(681)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TEdgeMap> void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TNames& names, TEdgeMap& edgeMap, MummerLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(784)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> inline void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TNames& names, MummerLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(889)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void read(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, NewickFormat);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(907)

//____________________________________________________________________________
// selectPairsForLibraryGeneration

template <typename TStringSet, typename TCargo, typename TSpec, typename TPairList> inline void selectPairsForLibraryGeneration(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPairList& pList);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(94)

//____________________________________________________________________________
// slowNjTree

template <typename TStringSpec, typename TCargo, typename TSpec> inline void slowNjTree(String<double, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(59)

//____________________________________________________________________________
// sumOfPairsScore

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(607)

//____________________________________________________________________________
// sumOfPairsScoreInd

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScoreInd(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(663)

//____________________________________________________________________________
// tripletLibraryExtension

template <typename TStringSet, typename TCargo, typename TSpec> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(506)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(532)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1, TSet const& set2);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(560)

//____________________________________________________________________________
// upgmaTree

template <typename TStringValue, typename TStringSpec, typename TCargo, typename TSpec, typename TTag> inline void upgmaTree(String<TStringValue, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g, TTag);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(491)
template <typename TValue, typename TSpec1, typename TCargo, typename TSpec2, typename TTag> inline void upgmaTree(Graph<Undirected<TValue, TSpec1> >& pairGraph, Graph<Tree<TCargo, TSpec2> >& g, TTag);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(611)
template <typename TDistance, typename TCargo, typename TSpec> inline void upgmaTree(TDistance& dist, Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(738)

//____________________________________________________________________________
// write

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TCoffeeLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(312)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TEdgeMap> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TEdgeMap& edgeMap, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(694)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(761)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

