 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_ALIGN_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_ALIGN_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AlignConfig

template <bool TTop , bool TLeft , bool TRight , bool TBottom , typename TSpec > class AlignConfig;       	// "projects/library/seqan/graph_align/graph_align_config.h"(52)

//____________________________________________________________________________
// _TraceBack

struct _TraceBack;       	// "projects/library/seqan/graph_align/graph_align_base.h"(75)

//____________________________________________________________________________
// _TraceBackGotoh

struct _TraceBackGotoh;       	// "projects/library/seqan/graph_align/graph_align_base.h"(133)

//____________________________________________________________________________
// _Translate_Table_Byte_2_TraceBack

template <typename T > struct _Translate_Table_Byte_2_TraceBack;       	// "projects/library/seqan/graph_align/graph_align_base.h"(38)

//____________________________________________________________________________
// _Translate_Table_Byte_2_TraceBackGotoh

template <typename T > struct _Translate_Table_Byte_2_TraceBackGotoh;       	// "projects/library/seqan/graph_align/graph_align_base.h"(91)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// TraceBack

typedef SimpleType<unsigned char, _TraceBack> TraceBack;       	// "projects/library/seqan/graph_align/graph_align_base.h"(76)

//____________________________________________________________________________
// TraceBackGotoh

typedef SimpleType<unsigned char, _TraceBackGotoh> TraceBackGotoh;       	// "projects/library/seqan/graph_align/graph_align_base.h"(134)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _align_gotoh

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _align_gotoh(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, typename Value<TTrace>::Type& initialDir, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(162)

//____________________________________________________________________________
// _align_gotoh_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair, typename TVal> inline void _align_gotoh_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex, TVal const initialDir);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(40)

//____________________________________________________________________________
// _align_hirschberg

template <typename TTrace, typename TStringSet, typename TScoreValue, typename TSpec> TScoreValue _align_hirschberg(TTrace& trace, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, Hirschberg);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(122)

//____________________________________________________________________________
// _align_hirschberg_trace

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTrace> void _align_hirschberg_trace(TAlign& align, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTrace& trace);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(41)

//____________________________________________________________________________
// _align_needleman_wunsch

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _align_needleman_wunsch(TTrace & trace, TStringSet const & str, TScore const & sc, TValPair & overallMaxValue, TIndexPair & overallMaxIndex, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(121)

//____________________________________________________________________________
// _align_needleman_wunsch_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair> void _align_needleman_wunsch_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(41)

//____________________________________________________________________________
// _align_smith_waterman

template <typename TTrace, typename TStringSet, typename TScore, typename TSize, typename TForbidden> inline typename Value<TScore>::Type _align_smith_waterman(TTrace& trace, TStringSet const& str, TScore const & sc, typename Value<TTrace>::Type& initialDir, TSize& best_row, TSize& best_col, TForbidden& forbidden);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(162)

//____________________________________________________________________________
// _align_smith_waterman_island

template <typename TTrace, typename TStringSet, typename TScore, typename TIslandMax, typename TIslandIndex> inline typename Value<TIslandMax>::Type _align_smith_waterman_island(TTrace& trace, TStringSet const& str, TScore const & sc, TIslandMax& islandMax, TIslandIndex& islandIndex);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman_island.h"(40)

//____________________________________________________________________________
// _align_smith_waterman_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TVal, typename TSize, typename TForbidden> inline void _align_smith_waterman_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TVal const initialDir, TSize best_row, TSize best_col, TForbidden& forbidden);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(42)

//____________________________________________________________________________
// _align_trace_print

template <typename TFile, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(TFile& file, TStringSet const& str, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(157)
template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet2, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TStringSet2 const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(210)
template <typename TFragment, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(String<TFragment>& matches, TStringSet const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const seqLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(236)
template <typename TVertexDescriptor, typename TSpec, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(String<String<TVertexDescriptor, TSpec> >& nodeString, TStringSet const& str, TId const, TPos const pos1, TId const, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(265)

//____________________________________________________________________________
// _globalAlignment

template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(246)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(274)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(337)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(364)
template <typename TAlign, typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(484)
template <typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(507)

//____________________________________________________________________________
// _initFirstColumn

template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, false, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "projects/library/seqan/graph_align/graph_align_config.h"(162)
template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, true, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(174)

//____________________________________________________________________________
// _initFirstRow

template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<false, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "projects/library/seqan/graph_align/graph_align_config.h"(186)
template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<true, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(198)

//____________________________________________________________________________
// _localAlignment

template <typename TAlign, typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet const& str, TScore const& sc, SmithWaterman);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(325)
template <typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TStringSet const& str, TScore const& sc, SmithWaterman);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(354)
template <typename TAlign, typename TStringSet, typename TForbidden, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet& str, TForbidden& forbidden, TScore const& sc, SmithWatermanClump);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman_clump.h"(41)
template <typename TAlign, typename TStringSet, typename TPropertyMap, typename TScore, typename TSize1> inline void _localAlignment(TAlign& align, TStringSet const& str, TPropertyMap& propMap, TScore const& sc, TSize1 numAlignments, SmithWatermanClump);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman_clump.h"(84)
template <typename TAlign, typename TStringSet, typename TPropertyMap, typename TScore, typename TSize1> inline void _localAlignment(TAlign& align, TStringSet const& str, TPropertyMap& propMap, TScore const& sc, TSize1 numAlignments, SmithWatermanIsland);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman_island.h"(213)

//____________________________________________________________________________
// _processLastColumn

template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _processLastColumn(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TColumn const& column);       	// "projects/library/seqan/graph_align/graph_align_config.h"(243)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _processLastColumn(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TColumn const& column);       	// "projects/library/seqan/graph_align/graph_align_config.h"(257)

//____________________________________________________________________________
// _processLastRow

template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _processLastRow(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue1&, TIndex1&, TValue2 const, TIndex2 const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(212)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _processLastRow(AlignConfig<TTop, TLeft, TRight, true, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const index);       	// "projects/library/seqan/graph_align/graph_align_config.h"(226)

//____________________________________________________________________________
// _retrieveMaxOfAlignment

template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue> inline typename TValue::first_type _retrieveMaxOfAlignment(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue& maxValue);       	// "projects/library/seqan/graph_align/graph_align_config.h"(279)
template <bool TTop, bool TLeft, typename TSpec, typename TValue> inline typename TValue::first_type _retrieveMaxOfAlignment(AlignConfig<TTop, TLeft, false, true, TSpec> const, TValue& maxValue);       	// "projects/library/seqan/graph_align/graph_align_config.h"(290)
template <bool TTop, bool TLeft, typename TSpec, typename TValue> inline typename TValue::first_type _retrieveMaxOfAlignment(AlignConfig<TTop, TLeft, true, true, TSpec> const, TValue& maxValue);       	// "projects/library/seqan/graph_align/graph_align_config.h"(301)

//____________________________________________________________________________
// convertScoringMatrix

template <typename TSourceValue, typename TType, typename TTargetValue, typename TSequenceValue, typename TSpec, typename TVal1, typename TVal2> inline void convertScoringMatrix(Score<TSourceValue, TType> const & in, Score<TTargetValue, ScoreMatrix<TSequenceValue, TSpec> > & out, TVal1 gapExtend, TVal2 gapOpen);       	// "projects/library/seqan/graph_align/graph_align_base.h"(333)
template <typename TSourceValue, typename TType, typename TTargetValue, typename TSequenceValue, typename TSpec> inline void convertScoringMatrix(Score<TSourceValue, TType> const & in, Score<TTargetValue, ScoreMatrix<TSequenceValue, TSpec> > & out);       	// "projects/library/seqan/graph_align/graph_align_base.h"(352)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(64)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(78)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(90)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(103)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(115)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(129)

//____________________________________________________________________________
// localAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(166)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(177)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue localAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(189)

//____________________________________________________________________________
// multiLocalAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TPropertyMap, typename TScoreValue, typename TSpec2, typename TSize, typename TTag> inline void multiLocalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TPropertyMap& edgeMap, Score<TScoreValue, TSpec2> const& sc, TSize numAlignments, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(223)
template <typename TAlign, typename TStringSet, typename TPropertyMap, typename TScoreValue, typename TSpec2, typename TSize, typename TTag> inline void multiLocalAlignment(TAlign& file, TStringSet const& str, TPropertyMap& edgeMap, Score<TScoreValue, TSpec2> const& sc, TSize numAlignments, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(277)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

