 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_ALGORITHMS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_ALGORITHMS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __weighted_bipartite_matching

template <typename TSpec, typename TVertexMap, typename TWeightMap, typename TEdges> inline typename Value<TWeightMap>::Type __weighted_bipartite_matching(Graph<TSpec>& g, TVertexMap& vertMap, TWeightMap& weightMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1554)

//____________________________________________________________________________
// _bipartite_matching

template <typename TSpec, typename TVertexMap, typename TEdges> inline typename Size<Graph<TSpec> >::Type _bipartite_matching(Graph<TSpec>& g, TVertexMap& vertMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1500)

//____________________________________________________________________________
// _build_residual_graph

template <typename TSpec, typename TCapMap, typename TFlowMap, typename TResidualGraph> void _build_residual_graph(Graph<TSpec> const& g, TCapMap const& capacity, TFlowMap const& flow, TResidualGraph& rG);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1232)

//____________________________________________________________________________
// _cc_visit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TComponents, typename TVal> void _cc_visit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TComponents& components, TVal& label);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(387)

//____________________________________________________________________________
// _dfs_visit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap, typename TVal> void _dfs_visit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish, TVal& time);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(150)

//____________________________________________________________________________
// _extend_shortest_paths

template <typename TMatrix, typename TPredecessor, typename TInfDist> void _extend_shortest_paths(TMatrix& local, TMatrix& w, TPredecessor& predecessor, TInfDist const infDist);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1030)

//____________________________________________________________________________
// _get_minimum_aug

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor> inline typename Size<Graph<TSpec> >::Type _get_minimum_aug(Graph<TSpec> const& rG, TPredecessorMap& predecessor, TVertexDescriptor const source, TVertexDescriptor sink);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1272)

//____________________________________________________________________________
// _initialize_all_pairs

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void _initialize_all_pairs(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& matrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(986)

//____________________________________________________________________________
// _initialize_single_source

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> inline void _initialize_single_source(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(686)

//____________________________________________________________________________
// _nextInSortedSequence

template <typename TSortedSequence, typename TIterator> inline typename TSortedSequence::const_iterator _nextInSortedSequence(TSortedSequence const& list, TIterator const& prev);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(64)

//____________________________________________________________________________
// _previousInSortedSequence

template <typename TSortedSequence, typename TKey> inline typename TSortedSequence::const_iterator _previousInSortedSequence(TSortedSequence const& list, TKey const key);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(35)

//____________________________________________________________________________
// _print_all_pairs_shortest_path

template <typename TSpec, typename TPredecessor, typename TVertexDescriptor> inline void _print_all_pairs_shortest_path(Graph<TSpec> const& g, TPredecessor& predecessor, TVertexDescriptor const i, TVertexDescriptor const j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(964)

//____________________________________________________________________________
// _print_path

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor, typename TNameMap> inline void _print_path(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor const source, TVertexDescriptor const v, TNameMap const& nameMap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(647)
template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor1, typename TVertexDescriptor2> inline void _print_path(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor1 const source, TVertexDescriptor2 const v);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(666)

//____________________________________________________________________________
// _relax

template <typename TSpec, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap, typename TVertexDescriptor, typename TEdgeDescriptor> inline void _relax(Graph<TSpec> const& g, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance, TVertexDescriptor const u, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(713)

//____________________________________________________________________________
// all_pairs_shortest_path

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void all_pairs_shortest_path(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1087)

//____________________________________________________________________________
// backwardAlgorithm

template <typename TAlphabet, typename TCargo, typename TSpec, typename TSequence> inline TCargo backwardAlgorithm(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(216)

//____________________________________________________________________________
// bellman_ford_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> bool bellman_ford_algorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(818)

//____________________________________________________________________________
// breadth_first_search

template <typename TSpec, typename TVertexDescriptor, typename TPredecessorMap, typename TDistanceMap> void breadth_first_search(Graph<TSpec> const& g, TVertexDescriptor const source, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(88)

//____________________________________________________________________________
// connected_components

template <typename TSpec, typename TComponents> typename Size<Graph<TSpec> >::Type connected_components(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(421)

//____________________________________________________________________________
// dag_shortest_path

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dag_shortest_path(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(755)

//____________________________________________________________________________
// depth_first_search

template <typename TSpec, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap> void depth_first_search(Graph<TSpec> const& g, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(198)

//____________________________________________________________________________
// dijkstra

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dijkstra(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(890)

//____________________________________________________________________________
// floyd_warshall

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void floyd_warshall(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1136)

//____________________________________________________________________________
// ford_fulkerson

template <typename TSpec, typename TVertexDescriptor, typename TCapMap, typename TFlowMap> typename Value<TFlowMap>::Type ford_fulkerson(Graph<TSpec> const& g, TVertexDescriptor const source, TVertexDescriptor const sink, TCapMap const& capacity, TFlowMap& flow);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1331)

//____________________________________________________________________________
// forwardAlgorithm

template <typename TAlphabet, typename TCargo, typename TSpec, typename TSequence> inline TCargo forwardAlgorithm(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(149)

//____________________________________________________________________________
// heaviestIncreasingSubsequence

template <typename TString, typename TWeightMap, typename TPositions> inline typename Value<TWeightMap>::Type heaviestIncreasingSubsequence(TString const& str, TWeightMap const& weights, TPositions& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(267)

//____________________________________________________________________________
// kruskals_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TEdges> void kruskals_algorithm(Graph<TSpec> const& g, TVertexDescriptor const, TWeightMap const& weight, TEdges& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(562)

//____________________________________________________________________________
// longestCommonSubsequence

template <typename TString1, typename TString2, typename TNeighborhoodSize, typename TFinalPos> inline void longestCommonSubsequence(TString1 const& str1, TString2 const& str2, TNeighborhoodSize nSize, TFinalPos& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(175)
template <typename TString1, typename TString2, typename TFinalPos> inline void longestCommonSubsequence(TString1 const& str1, TString2 const& str2, TFinalPos& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(236)

//____________________________________________________________________________
// longestIncreasingSubsequence

template <typename TString, typename TPositions> inline void longestIncreasingSubsequence(TString const& str, TPositions& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(92)

//____________________________________________________________________________
// path_growing_algorithm

template <typename TSpec, typename TWeightMap, typename TEdgeMap> typename Value<TWeightMap>::Type path_growing_algorithm(Graph<TSpec>& g, TWeightMap const& weightMap, TEdgeMap& edgeMap1);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1422)

//____________________________________________________________________________
// prims_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap> void prims_algorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(484)

//____________________________________________________________________________
// strongly_connected_components

template <typename TSpec, typename TComponents> void strongly_connected_components(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(308)

//____________________________________________________________________________
// topological_sort

template <typename TSpec, typename TVertexDescriptor> void topological_sort(Graph<TSpec> const& g, String<TVertexDescriptor>& topSort);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(255)

//____________________________________________________________________________
// transitive_closure

template <typename TSpec, typename TMatrix> void transitive_closure(Graph<TSpec> const& g, TMatrix& closure);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1186)

//____________________________________________________________________________
// viterbiAlgorithm

template <typename TAlphabet, typename TCargo, typename TSpec, typename TSequence, typename TPath> inline TCargo viterbiAlgorithm(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& hmm, TSequence const& seq, TPath& path);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(54)

//____________________________________________________________________________
// weighted_bipartite_matching

template <typename TSpec, typename TVertexMap, typename TWeightMap, typename TEdges> inline typename Value<TWeightMap>::Type weighted_bipartite_matching(Graph<TSpec>& g, TVertexMap& vertMap, TWeightMap& weightMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1720)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

