 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_FIND_MOTIF_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_FIND_MOTIF_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// FrequencyDistribution

template <typename TValue, typename TSpec > class FrequencyDistribution;       	// "projects/library/seqan/find_motif/frequency_distribution.h"(49)

//____________________________________________________________________________
// MotifFinder

template <typename TValue, typename TSpec> class MotifFinder;       	// "projects/library/seqan/find_motif/find_motif_base.h"(47)

//____________________________________________________________________________
// OMOPS

struct OMOPS;       	// "projects/library/seqan/find_motif/sequence_model_types.h"(56)

//____________________________________________________________________________
// OOPS

struct OOPS;       	// "projects/library/seqan/find_motif/sequence_model_types.h"(41)

//____________________________________________________________________________
// Pseudocount

template <typename TValue, typename TSpec> class Pseudocount;       	// "projects/library/seqan/find_motif/pseudocount_base.h"(44)

//____________________________________________________________________________
// TCM

struct TCM;       	// "projects/library/seqan/find_motif/sequence_model_types.h"(99)

//____________________________________________________________________________
// ZOOPS

struct ZOOPS;       	// "projects/library/seqan/find_motif/sequence_model_types.h"(71)

//____________________________________________________________________________
// _CMode

struct _CMode;       	// "projects/library/seqan/find_motif/pseudocount_mode_c.h"(45)

//____________________________________________________________________________
// _EPatternBranching

struct _EPatternBranching;       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(54)

//____________________________________________________________________________
// _PMS1

struct _PMS1;       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(51)

//____________________________________________________________________________
// _PMSP

struct _PMSP;       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(47)

//____________________________________________________________________________
// _PMode

struct _PMode;       	// "projects/library/seqan/find_motif/pseudocount_mode_p.h"(46)

//____________________________________________________________________________
// _Projection

struct _Projection;       	// "projects/library/seqan/find_motif/find_motif_projection.h"(48)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CMode

typedef Tag<_CMode> CMode;       	// "projects/library/seqan/find_motif/pseudocount_mode_c.h"(46)

//____________________________________________________________________________
// EPatternBranching

typedef Tag<_EPatternBranching> const EPatternBranching;       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(55)

//____________________________________________________________________________
// PMS1

typedef Tag<_PMS1> const PMS1;       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(52)

//____________________________________________________________________________
// PMSP

typedef Tag<_PMSP> const PMSP;       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(48)

//____________________________________________________________________________
// PMode

typedef Tag<_PMode> PMode;       	// "projects/library/seqan/find_motif/pseudocount_mode_p.h"(47)

//____________________________________________________________________________
// Projection

typedef Tag<_Projection> const Projection;       	// "projects/library/seqan/find_motif/find_motif_projection.h"(49)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _buildVariants

template <typename TIntVect, typename TStringIter, typename TType, typename TBitset, typename TValue, typename TSpec> void _buildVariants(TIntVect & variants, TStringIter l_mer_begin, TType const & d, TBitset const & bitset, Shape<TValue, TSpec> & shape);       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(726)

//____________________________________________________________________________
// _computeBucketThreshold

template <typename TType> TType _computeBucketThreshold(TType const & alp_size, TType const & l, TType const & d, TType const & m_total, TType const & k);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(260)

//____________________________________________________________________________
// _computeEStep

template <typename TMatrix, typename TProfile, typename TIter, typename TType> void _computeEStep(TMatrix & matrix_w, double & joint_log_likelihood, TProfile & profile, TIter dataset_start, TType const & t, TType const & l, OOPS const & );       	// "projects/library/seqan/find_motif/em_algorithm.h"(122)
template <typename TMatrix, typename TProfile, typename TIter, typename TType> void _computeEStep(TMatrix & matrix_w, double & joint_log_likelihood, TProfile & profile, TIter dataset_start, double & gamma, TType const & t, TType const & l, ZOOPS const & );       	// "projects/library/seqan/find_motif/em_algorithm.h"(348)
template <typename TMatrix, typename TProfile, typename TIter, typename TType> void _computeEStep(TMatrix & matrix_w, double & joint_log_likelihood, TProfile & profile, TIter dataset_start, double & lambda, TType const & t, TType const & l, TCM const & );       	// "projects/library/seqan/find_motif/em_algorithm.h"(613)

//____________________________________________________________________________
// _computeLikelihoodRatioOfLMer

template <typename TStrIter, typename TProfile> double _computeLikelihoodRatioOfLMer(TStrIter l_mer_begin, TStrIter l_mer_end, TProfile const & profile);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(1051)

//____________________________________________________________________________
// _computeLikelihoodRatioOfLMers

template <typename TStrings, typename TProfile> double _computeLikelihoodRatioOfLMers(TStrings const & l_mers, TProfile const & profile);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(1090)

//____________________________________________________________________________
// _computeMStep

template <typename TProfile, typename TIter, typename TMatrix, typename TType> void _computeMStep(TProfile & profile, TIter dataset_start, TMatrix const & matrix_w, TType const & t, TType const & l, OOPS const & );       	// "projects/library/seqan/find_motif/em_algorithm.h"(220)
template <typename TProfile, typename TIter, typename TMatrix, typename TType> void _computeMStep(TProfile & profile, TIter dataset_start, TMatrix const & matrix_w, TType const & t, TType const & l, ZOOPS const & );       	// "projects/library/seqan/find_motif/em_algorithm.h"(477)
template <typename TProfile, typename TIter, typename TMatrix, typename TType> void _computeMStep(TProfile & profile, TIter dataset_start, TMatrix const & matrix_w, TType const & t, TType const & l, TCM const & );       	// "projects/library/seqan/find_motif/em_algorithm.h"(709)

//____________________________________________________________________________
// _computeNumOfTrials

template <typename TType> TType _computeNumOfTrials(TType const & t, TType const & l, TType const & d, TType const & k, TType const & s, double const & prob_q);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(310)

//____________________________________________________________________________
// _computeProjectionSize

template <typename TType> TType _computeProjectionSize(TType const & alp_size, TType const & l, TType const & d, TType const & m_total);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(220)

//____________________________________________________________________________
// _filteringStep

template <typename TBucketAr, typename TArray, typename TType, typename TStrings, typename TPositions> void _filteringStep(TBucketAr & buckets, TArray & count_ar, TType & num_of_relevant_buckets, TStrings & dataset, TPositions & positions, TType const & l, TType const & s);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(490)

//____________________________________________________________________________
// _getLMersWithTheLargestLikelihoodRatio

template <typename TStrings, typename TIter, typename TType, typename TProfile> void _getLMersWithTheLargestLikelihoodRatio(TStrings & l_mers, TIter dataset_start, TIter dataset_end, TProfile const & profile, TType const & l);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(986)

//____________________________________________________________________________
// _getVariantsOfBitset

template <typename TStrings, typename TType> void _getVariantsOfBitset(TStrings & bitsets, TType const & l, TType const & d);       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(669)

//____________________________________________________________________________
// _refinementStep

template <typename TString, typename TType> int _refinementStep(TString & consensus_seq, String<TString> const & l_mers, String<TString> & dataset, TType const & l, TType const & d, bool const & is_exact, OOPS const & oops);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(556)
template <typename TString, typename TType> int _refinementStep(TString & consensus_seq, String<TString> const & l_mers, String<TString> & dataset, TType const & l, TType const & d, bool const & is_exact, OMOPS const & );       	// "projects/library/seqan/find_motif/find_motif_projection.h"(637)
template <typename TString, typename TType> int _refinementStep(TString & consensus_seq, String<TString> const & l_mers, String<TString> & dataset, TType const & l, TType const & d, bool const & is_exact, ZOOPS const & zoops);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(715)
template <typename TString, typename TType> int _refinementStep(TString & consensus_seq, String<TString> const & l_mers, String<TString> & dataset, TType const & l, TType const & d, bool const & is_exact, TCM const & tcm);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(815)

//____________________________________________________________________________
// _smoothingStep

template <typename TMatrix, typename TIter, typename TType> void _smoothingStep(TMatrix & matrix_w, TIter dataset_start, TType const & t, TType const & l);       	// "projects/library/seqan/find_motif/em_algorithm.h"(783)

//____________________________________________________________________________
// absFreqOfLettersInSeq

template <typename TValue, typename TSpec, typename TSeqIter> void absFreqOfLettersInSeq(FrequencyDistribution<TValue, TSpec> & fd, TSeqIter seq_start, TSeqIter seq_end);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(308)

//____________________________________________________________________________
// absFreqOfLettersInSetOfSeqs

template <typename TValue, typename TSpec, typename TIter> void absFreqOfLettersInSetOfSeqs(FrequencyDistribution<TValue, TSpec> & fd, TIter seq_start, TIter seq_end);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(338)

//____________________________________________________________________________
// addValue

template <typename TValue, typename TSpec, typename TType> void addValue(FrequencyDistribution<TValue, TSpec> & fd, TType const & val);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(362)

//____________________________________________________________________________
// backgroundFrequency

template <typename TValue, typename TSpec,typename TDatasetIter> void backgroundFrequency(FrequencyDistribution<TValue, TSpec> & fd, TDatasetIter dataset_start, TDatasetIter dataset_end);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(390)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSpec> inline typename Iterator< FrequencyDistribution<TValue, TSpec> >::Type begin(FrequencyDistribution<TValue, TSpec> & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(411)
template <typename TValue, typename TSpec> inline typename Iterator< FrequencyDistribution<TValue, TSpec> >::Type begin(FrequencyDistribution<TValue, TSpec> const & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(417)

//____________________________________________________________________________
// bestNeighbors

template <typename TIntSet, typename TType, typename TStrings> void bestNeighbors(TIntSet & neighbors, int & l_mer, TType const & j, TType const & l, TType const & d, TStrings & dataset);       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(493)

//____________________________________________________________________________
// binomialCoefficient

template <typename TType> TType binomialCoefficient(TType n, TType k);       	// "projects/library/seqan/find_motif/find_motif_base.h"(138)

//____________________________________________________________________________
// choosePositions

template <typename TAssociativeContainer, typename TType> void choosePositions(TAssociativeContainer & positions, TType const & l, TType const & k);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(914)

//____________________________________________________________________________
// clear

template <typename TValue, typename TSpec> void clear(FrequencyDistribution<TValue, TSpec> & fd);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(428)

//____________________________________________________________________________
// completeProfile

template <typename TProfile> void completeProfile(TProfile & profile, typename Value<TProfile>::Type & background_distribution);       	// "projects/library/seqan/find_motif/profile.h"(172)

//____________________________________________________________________________
// computeH

template <typename TType, typename TIntAr> TType computeH(TType const & t, TType const & l, TType const & d, bool const & is_exact, TIntAr & n_ar);       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(168)

//____________________________________________________________________________
// convertPatternToProfile

template <typename TProfile, typename TIterStr> void convertPatternToProfile(TProfile & profile, TIterStr str_begin, TIterStr str_end);       	// "projects/library/seqan/find_motif/profile.h"(62)

//____________________________________________________________________________
// convertResidueToFrequencyDist

template <typename TValue, typename TSpec> void convertResidueToFrequencyDist(FrequencyDistribution<TValue, TSpec> & fd, TValue const & residue);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(451)

//____________________________________________________________________________
// convertSetOfPatternsToProfile

template <typename TProfile, typename TStrings, typename TPseudocountMode> void convertSetOfPatternsToProfile(TProfile & profile, TStrings & l_mers, TPseudocountMode & pseudocount);       	// "projects/library/seqan/find_motif/profile.h"(97)

//____________________________________________________________________________
// createDVariants

template <typename TIntVect, typename TIterString, typename TType, typename TShape> void createDVariants(TIntVect & variants, TIterString l_mer_begin, TType const & l, TType const & d, bool is_exact, TShape & shape);       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(607)

//____________________________________________________________________________
// determineConsensusSeq

template <typename TString, typename TProfile> void determineConsensusSeq(TString & consensus_seq, TProfile & profile, typename Size<TString>::Type const & l);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(1123)

//____________________________________________________________________________
// display

template <typename TStrings> void display(TStrings & strings);       	// "projects/library/seqan/find_motif/profile.h"(203)

//____________________________________________________________________________
// displayResult

template <typename TValue> void displayResult(MotifFinder<TValue, Projection> & projection);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(1165)
template <typename TValue, typename TAlgorithm> void displayResult(MotifFinder<TValue, TAlgorithm> & finder);       	// "projects/library/seqan/find_motif/find_motif_base.h"(243)

//____________________________________________________________________________
// ePatternBranching

template <typename TStrings, typename TType> void ePatternBranching(TStrings & result_set, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, TType & h, OMOPS const & );       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(273)
template <typename TStrings, typename TType> void ePatternBranching(TStrings & result_set, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, TType & h, OOPS const & );       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(374)

//____________________________________________________________________________
// em

template <typename TProfile, typename TIter, typename TType> double em(TProfile & profile, TIter dataset_start, TType const & t, TType const & l, OOPS const & oops);       	// "projects/library/seqan/find_motif/em_algorithm.h"(70)
template <typename TProfile, typename TIter, typename TType> double em(TProfile & profile, TIter dataset_start, TType const & t, TType const & l, double & gamma, ZOOPS const & zoops);       	// "projects/library/seqan/find_motif/em_algorithm.h"(292)
template <typename TProfile, typename TIter, typename TType> double em(TProfile & profile, TIter dataset_start, TType const & t, TType const & l, double & lambda, TCM const & tcm);       	// "projects/library/seqan/find_motif/em_algorithm.h"(557)

//____________________________________________________________________________
// end

template <typename TValue, typename TSpec> inline typename Iterator< FrequencyDistribution<TValue, TSpec> >::Type end(FrequencyDistribution<TValue, TSpec> & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(476)
template <typename TValue, typename TSpec> inline typename Iterator< FrequencyDistribution<TValue, TSpec> const >::Type end(FrequencyDistribution<TValue, TSpec> const & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(482)

//____________________________________________________________________________
// factorial

template <typename TType> TType factorial(TType n);       	// "projects/library/seqan/find_motif/find_motif_base.h"(106)

//____________________________________________________________________________
// findMotif

template <typename TSeqType, typename TStrings, typename TModel> void findMotif(MotifFinder<TSeqType, Projection> & finder, TStrings & dataset, TModel seq_model);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(365)
template <typename TSeqType, typename TStrings, typename TModel> inline void findMotif(MotifFinder<TSeqType ,EPatternBranching> & epb2, TStrings & dataset, TModel seq_model);       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(225)
template <typename TSeqType, typename TStrings, typename TModel> inline void findMotif(MotifFinder<TSeqType ,PMSP> & finder, TStrings & dataset, TModel seq_model);       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(121)
template <typename TSeqType, typename TStrings, typename TModel> inline void findMotif(MotifFinder<TSeqType, PMS1> & finder, TStrings & dataset, TModel seq_model);       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(124)

//____________________________________________________________________________
// hammingDistance

template <typename TType, typename TStringIterator> TType hammingDistance(TStringIterator start1, TStringIterator end1, TStringIterator start2);       	// "projects/library/seqan/find_motif/find_motif_base.h"(177)

//____________________________________________________________________________
// hasAtLeastOneOccurrence

template <typename TStringIter, typename TType> bool hasAtLeastOneOccurrence(TStringIter l_mer_begin, TStringIter seq_begin, TStringIter seq_end, TType const & l, TType const & d, bool const & is_exact);       	// "projects/library/seqan/find_motif/find_motif_epatternbranching.h"(708)

//____________________________________________________________________________
// hasExactOneOccurrence

template <typename TStringIter, typename TType> bool hasExactOneOccurrence(TStringIter l_mer_begin, TStringIter seq_begin, TStringIter seq_end, TType const & l, TType const & d, bool const & is_exact);       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(732)

//____________________________________________________________________________
// inverseHash

template <typename TValue, typename TType> String<TValue> inverseHash(TType const & hash_value, typename Size<TValue>::Type const & alp_size, typename Size< String<TValue> >::Type const & seq_size);       	// "projects/library/seqan/find_motif/find_motif_base.h"(210)

//____________________________________________________________________________
// length

template <typename TValue, typename TSpec> inline typename Size< FrequencyDistribution<TValue, TSpec> >::Type length(FrequencyDistribution<TValue, TSpec> & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(493)
template <typename TValue, typename TSpec> inline typename Size< FrequencyDistribution<TValue, TSpec> >::Type length(FrequencyDistribution<TValue, TSpec> const & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(500)

//____________________________________________________________________________
// logarithmize

template <typename TValue, typename TSpec> void logarithmize(FrequencyDistribution<TValue, TSpec> & fd);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(518)

//____________________________________________________________________________
// normalize

template <typename TProfile, typename TValue> void normalize(TProfile & profile, Pseudocount<TValue, PMode> & mode);       	// "projects/library/seqan/find_motif/pseudocount_mode_p.h"(117)
template <typename TProfile, typename TValue> void normalize(TProfile & profile, Pseudocount<TValue, CMode> const & mode);       	// "projects/library/seqan/find_motif/pseudocount_mode_c.h"(115)
template <typename TValue, typename TSpec> void normalize(FrequencyDistribution<TValue, TSpec> & fd);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(542)
template <typename TProfile> void normalize(TProfile & profile);       	// "projects/library/seqan/find_motif/profile.h"(144)

//____________________________________________________________________________
// pms1

template <typename TStrings, typename TType> void pms1(TStrings & result_set, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, OOPS const & );       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(171)
template <typename TStrings, typename TType> void pms1(TStrings & result_set, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, OMOPS const & );       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(287)
template <typename TStrings, typename TType> void pms1(TStrings & result_set, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, ZOOPS const & model_type);       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(375)
template <typename TStrings, typename TType> void pms1(TStrings & result_set, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, TCM const & model_type);       	// "projects/library/seqan/find_motif/find_motif_pms1.h"(482)

//____________________________________________________________________________
// pmsp

template <typename TStrings, typename TType> void pmsp(TStrings & result, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, OOPS const & );       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(172)
template <typename TStrings, typename TType> void pmsp(TStrings & result, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, OMOPS const & );       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(293)
template <typename TStrings, typename TType> void pmsp(TStrings & result, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, ZOOPS const & model_type);       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(410)
template <typename TStrings, typename TType> void pmsp(TStrings & result, TStrings & dataset, TType const & l, TType const & d, bool const & is_exact, TCM const & model_type);       	// "projects/library/seqan/find_motif/find_motif_pmsp.h"(555)

//____________________________________________________________________________
// posOfMax

template <typename TValue, typename TSpec> typename Position< FrequencyDistribution<TValue, TSpec> >::Type posOfMax(FrequencyDistribution<TValue, TSpec> & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(567)

//____________________________________________________________________________
// projectLMer

template <typename TValue, typename TIter> inline std::set<int>::value_type projectLMer(std::set<int> & positions, TIter it);       	// "projects/library/seqan/find_motif/find_motif_projection.h"(938)

//____________________________________________________________________________
// sum

template <typename TValue, typename TSpec> TSpec sum(FrequencyDistribution<TValue, TSpec> & me);       	// "projects/library/seqan/find_motif/frequency_distribution.h"(599)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

