 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_CONSENSUS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_CONSENSUS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CtgStore

template <typename TAlphabet , typename TSpec > class CtgStore;       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(83)
template <typename TAlphabet, typename TSpec> class CtgStore;       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(89)

//____________________________________________________________________________
// FrgStore

template <typename TSpec > class FrgStore;       	// "projects/library/seqan/consensus/graph_consensus_frgstore.h"(33)
template <typename TSpec> class FrgStore;       	// "projects/library/seqan/consensus/graph_consensus_frgstore.h"(39)

//____________________________________________________________________________
// GappedRead

template <typename TSpec > class GappedRead;       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(34)
template <typename TSpec> class GappedRead;       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(40)

//____________________________________________________________________________
// LibStore

template <typename TSpec > class LibStore;       	// "projects/library/seqan/consensus/graph_consensus_libstore.h"(33)
template <typename TSpec> class LibStore;       	// "projects/library/seqan/consensus/graph_consensus_libstore.h"(39)

//____________________________________________________________________________
// Overlap_Library_

struct Overlap_Library_;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(67)

//____________________________________________________________________________
// ReadStore

template <typename TAlphabet , typename TSpec > class ReadStore;       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(33)
template <typename TAlphabet, typename TSpec> class ReadStore;       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(39)

//____________________________________________________________________________
// TagAmos_

struct TagAmos_;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(37)

//____________________________________________________________________________
// TagCeleraCgb_

struct TagCeleraCgb_;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(53)

//____________________________________________________________________________
// TagCeleraFrg_

struct TagCeleraFrg_;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(46)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Amos

typedef Tag<TagAmos_> const Amos;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(38)

//____________________________________________________________________________
// CeleraCgb

typedef Tag<TagCeleraCgb_> const CeleraCgb;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(54)

//____________________________________________________________________________
// CeleraFrg

typedef Tag<TagCeleraFrg_> const CeleraFrg;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(47)

//____________________________________________________________________________
// Overlap_Library

typedef Tag<Overlap_Library_> const Overlap_Library;       	// "projects/library/seqan/consensus/graph_consensus_base.h"(68)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __getAlignmentStatistics

template <typename TSize> inline void __getAlignmentStatistics(Nothing&, TSize, TSize, TSize, double, double);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(140)
template <typename TValue, typename TSpec, typename TSize> inline void __getAlignmentStatistics(String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, double matchLen, double quality);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(154)
template <typename TCargo, typename TSpec, typename TSize> inline void __getAlignmentStatistics(Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, double matchLen, double quality);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(171)

//____________________________________________________________________________
// consensusAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TValue, typename TBegEndRowPos, typename TCoverage, typename TGappedConsensus> inline void consensusAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, String<TValue>& mat, TBegEndRowPos& readBegEndRowPos, TCoverage& coverage, TGappedConsensus& gappedConsensus);       	// "projects/library/seqan/consensus/graph_consensus_base.h"(84)

//____________________________________________________________________________
// generatePrimaryLibrary

template <typename TStringSet, typename TCargo, typename TSpec, typename TPair, typename TPairSpec, typename TDistance, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, String<TPair, TPairSpec> const& pList, TDistance& dist, TScore const& score_type, Overlap_Library);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(188)
template <typename TStringSet, typename TCargo, typename TSpec, typename TDistance, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TDistance& dist, Score<TScoreValue, TScoreSpec> const& score_type, Overlap_Library);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(268)
template <typename TStringSet, typename TCargo, typename TSpec, typename TId, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, String<Pair<TId, TId> >& pList, Score<TScoreValue, TScoreSpec> const& score_type, Overlap_Library);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(284)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, Overlap_Library);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(297)

//____________________________________________________________________________
// getAlignmentStatistics

template <typename TFragment, typename TSpec1, typename TStringSet, typename TSize> inline void getAlignmentStatistics(String<TFragment, TSpec1>& matches, TStringSet& str, TSize& from, TSize& matchLength, TSize& overlapLength, TSize& alignLength);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(125)

//____________________________________________________________________________
// layoutReads

template <typename TString, typename TSpec, typename TRead, typename TSpec2, typename TBegEndPositions> inline void layoutReads(String<TString, TSpec>& names, StringSet<TRead, TSpec2>& strSet, TBegEndPositions& begEndPos);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(35)

//____________________________________________________________________________
// length

template <typename TAlphabet, typename TSpec> inline typename Size<ReadStore<TAlphabet, TSpec> >::Type length(ReadStore<TAlphabet, TSpec>& readSt);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(161)
template <typename TAlphabet, typename TSpec> inline typename Size<CtgStore<TAlphabet, TSpec> >::Type length(CtgStore<TAlphabet, TSpec>& ctgSt);       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(195)
template <typename TSpec> inline typename Size<FrgStore<TSpec> >::Type length(FrgStore<TSpec>& frgSt);       	// "projects/library/seqan/consensus/graph_consensus_frgstore.h"(132)
template <typename TSpec> inline typename Size<LibStore<TSpec> >::Type length(LibStore<TSpec>& libSt);       	// "projects/library/seqan/consensus/graph_consensus_libstore.h"(129)

//____________________________________________________________________________
// loadContig

template <typename TAlphabet, typename TSpec, typename TSize, typename TContig> inline void loadContig(CtgStore<TAlphabet, TSpec>& ctgSt, TSize index, TContig& seq);       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(156)

//____________________________________________________________________________
// loadExtId

template <typename TAlphabet, typename TSpec, typename TSize, typename TName> inline void loadExtId(ReadStore<TAlphabet, TSpec>& readSt, TSize index, TName& name);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(140)
template <typename TAlphabet, typename TSpec, typename TSize, typename TName> inline void loadExtId(CtgStore<TAlphabet, TSpec>& ctgSt, TSize index, TName& name);       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(185)
template <typename TSpec, typename TSize, typename TName> inline void loadExtId(FrgStore<TSpec>& frgSt, TSize index, TName& name);       	// "projects/library/seqan/consensus/graph_consensus_frgstore.h"(97)
template <typename TSpec, typename TSize, typename TName> inline void loadExtId(LibStore<TSpec>& libSt, TSize index, TName& name);       	// "projects/library/seqan/consensus/graph_consensus_libstore.h"(97)

//____________________________________________________________________________
// loadFrgId

template <typename TAlphabet, typename TSpec, typename TSize> inline typename Id<ReadStore<TAlphabet, TSpec> >::Type loadFrgId(ReadStore<TAlphabet, TSpec>& readSt, TSize index);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(151)

//____________________________________________________________________________
// loadLibraryId

template <typename TSpec, typename TSize> inline typename Id<FrgStore<TSpec> >::Type loadLibraryId(FrgStore<TSpec>& frgSt, TSize index);       	// "projects/library/seqan/consensus/graph_consensus_frgstore.h"(108)

//____________________________________________________________________________
// loadLibraryMean

template <typename TSpec, typename TSize> inline typename Id<LibStore<TSpec> >::Type loadLibraryMean(LibStore<TSpec>& libSt, TSize index);       	// "projects/library/seqan/consensus/graph_consensus_libstore.h"(108)

//____________________________________________________________________________
// loadLibraryStd

template <typename TSpec, typename TSize> inline typename Id<LibStore<TSpec> >::Type loadLibraryStd(LibStore<TSpec>& libSt, TSize index);       	// "projects/library/seqan/consensus/graph_consensus_libstore.h"(119)

//____________________________________________________________________________
// loadQuality

template <typename TAlphabet, typename TSpec, typename TSize, typename TRead> inline void loadQuality(ReadStore<TAlphabet, TSpec>& readSt, TSize index, TRead& seq);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(127)
template <typename TAlphabet, typename TSpec, typename TSize, typename TContig> inline void loadQuality(CtgStore<TAlphabet, TSpec>& ctgSt, TSize index, TContig& seq);       	// "projects/library/seqan/consensus/graph_consensus_ctgstore.h"(172)

//____________________________________________________________________________
// loadRdsId

template <typename TSpec, typename TSize, typename TId1, typename TId2> inline void loadRdsId(FrgStore<TSpec>& frgSt, TSize index, TId1& id1, TId2& id2);       	// "projects/library/seqan/consensus/graph_consensus_frgstore.h"(121)

//____________________________________________________________________________
// loadRead

template <typename TAlphabet, typename TSpec, typename TSize, typename TRead> inline void loadRead(ReadStore<TAlphabet, TSpec>& readSt, TSize index, TRead& seq);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(111)

//____________________________________________________________________________
// loadReadsClr

template <typename TAlphabet, typename TSpec, typename TAlph2, typename TSpec2, typename TSize, typename TStringSet, typename TLayoutPos> inline void loadReadsClr(ReadStore<TAlphabet, TSpec>& readSt, CtgStore<TAlph2, TSpec2>& ctgSt, TSize index, TStringSet& strSet, TLayoutPos& startEndPos);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(176)

//____________________________________________________________________________
// read

template <typename TFile, typename TAlphabet, typename TSpec, typename TFragmentStore, typename TLibraryStore, typename TContigStore> inline void read(TFile & file, ReadStore<TAlphabet, TSpec>& readSt, TFragmentStore& frgSt, TLibraryStore& libSt, TContigStore& ctgSt, Amos);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(209)

//____________________________________________________________________________
// realignLowQualityReads

template <typename TStringSet, typename TCargo, typename TSpec, typename TPairList, typename TBegEndRowPos, typename TNewLibraryGraph> inline unsigned int realignLowQualityReads(Graph<Alignment<TStringSet, TCargo, TSpec> > const& gIn, TPairList const& pList, TBegEndRowPos const& readBegEndRowPos, TNewLibraryGraph& gOut);       	// "projects/library/seqan/consensus/graph_consensus_base.h"(278)

//____________________________________________________________________________
// selectPairsForLibraryGeneration

template <typename TStringSet, typename TCargo, typename TSpec, typename TBegEndPositions, typename TPairList, typename TReadLength> inline void selectPairsForLibraryGeneration(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TBegEndPositions& begEndPos, TPairList& pList, TReadLength readLen);       	// "projects/library/seqan/consensus/graph_consensus_library.h"(82)

//____________________________________________________________________________
// write

template <typename TFile, typename TAlphabet, typename TSpec, typename TFragmentStore, typename TLibraryStore, typename TContigStore> inline void write(TFile& target, ReadStore<TAlphabet, TSpec>& readSt, TFragmentStore& frgSt, TLibraryStore& libSt, TContigStore& ctgSt, Amos);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(519)
template <typename TFile, typename TAlphabet, typename TSpec, typename TFragmentStore, typename TLibraryStore, typename TContigStore> inline void write(TFile& target, ReadStore<TAlphabet, TSpec>& readSt, TFragmentStore&, TLibraryStore&, TContigStore&, CeleraFrg);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(688)
template <typename TFile, typename TAlphabet, typename TSpec, typename TFragmentStore, typename TLibraryStore, typename TContigStore> inline void write(TFile& target, ReadStore<TAlphabet, TSpec>& readSt, TFragmentStore&, TLibraryStore&, TContigStore& ctgSt, CeleraCgb);       	// "projects/library/seqan/consensus/graph_consensus_readstore.h"(755)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

