 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BasicInfo

struct BasicInfo;       	// "projects/library/seqan/blast/blast_base.h"(16)

//____________________________________________________________________________
// BlastHit

template <typename TBlastHsp, typename TStoreSpec> class BlastHit;       	// "projects/library/seqan/blast/blast_hit.h"(9)

//____________________________________________________________________________
// BlastHsp

template <typename TBlastSpec , typename TInfoSpec > class BlastHsp;       	// "projects/library/seqan/blast/blast_hsp.h"(15)

//____________________________________________________________________________
// BlastReport

template <typename TBlastHsp , typename TStoreSpec > class BlastReport;       	// "projects/library/seqan/blast/blast_report.h"(12)

//____________________________________________________________________________
// FullInfo

struct FullInfo;       	// "projects/library/seqan/blast/blast_base.h"(13)

//____________________________________________________________________________
// Hit

template <typename T> struct Hit;       	// "projects/library/seqan/blast/blast_base.h"(75)

//____________________________________________________________________________
// HitIterator

struct HitIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(20)

//____________________________________________________________________________
// Hsp

template <typename T> struct Hsp;       	// "projects/library/seqan/blast/blast_base.h"(87)

//____________________________________________________________________________
// HspIterator

struct HspIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(23)

//____________________________________________________________________________
// NucleotideBlast

template <typename TSpec > class NucleotideBlast;       	// "projects/library/seqan/blast/blast_base.h"(135)

//____________________________________________________________________________
// ProteinBlast

template <typename TSpec > class ProteinBlast;       	// "projects/library/seqan/blast/blast_base.h"(142)

//____________________________________________________________________________
// SimpleBlastIterator

template <typename TSpec> struct SimpleBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(16)

//____________________________________________________________________________
// StoreReport

template <typename TInfoSpec > struct StoreReport;       	// "projects/library/seqan/blast/blast_base.h"(40)

//____________________________________________________________________________
// StreamBlastIterator

template <typename TSpec> struct StreamBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(31)

//____________________________________________________________________________
// StreamReport

template <typename TFile > struct StreamReport;       	// "projects/library/seqan/blast/blast_base.h"(57)

//____________________________________________________________________________
// TagBlastN_

struct TagBlastN_;       	// "projects/library/seqan/blast/blast_base.h"(127)

//____________________________________________________________________________
// TagBlastP_

struct TagBlastP_;       	// "projects/library/seqan/blast/blast_base.h"(129)

//____________________________________________________________________________
// TagBlastX_

struct TagBlastX_;       	// "projects/library/seqan/blast/blast_base.h"(130)

//____________________________________________________________________________
// TagBlast_

struct TagBlast_;       	// "projects/library/seqan/blast/blast_base.h"(93)

//____________________________________________________________________________
// TagBlat_

struct TagBlat_;       	// "projects/library/seqan/blast/blast_base.h"(99)

//____________________________________________________________________________
// TagKnownSource_

struct TagKnownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(825)

//____________________________________________________________________________
// TagMegaBlast_

struct TagMegaBlast_;       	// "projects/library/seqan/blast/blast_base.h"(128)

//____________________________________________________________________________
// TagRunBlastN_

struct TagRunBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(16)

//____________________________________________________________________________
// TagRunBlastP_

struct TagRunBlastP_;       	// "projects/library/seqan/blast/blast_run.h"(27)

//____________________________________________________________________________
// TagRunBlastX_

struct TagRunBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(30)

//____________________________________________________________________________
// TagRunBlat_

struct TagRunBlat_;       	// "projects/library/seqan/blast/blast_run.h"(22)

//____________________________________________________________________________
// TagRunMegaBlast_

struct TagRunMegaBlast_;       	// "projects/library/seqan/blast/blast_run.h"(19)

//____________________________________________________________________________
// TagRunTBlastN_

struct TagRunTBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(33)

//____________________________________________________________________________
// TagRunTBlastX_

struct TagRunTBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(36)

//____________________________________________________________________________
// TagTBlastN_

struct TagTBlastN_;       	// "projects/library/seqan/blast/blast_base.h"(131)

//____________________________________________________________________________
// TagTBlastX_

struct TagTBlastX_;       	// "projects/library/seqan/blast/blast_base.h"(132)

//____________________________________________________________________________
// TagUnknownSource_

struct TagUnknownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(822)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Blast

typedef Tag<TagBlast_> const Blast;       	// "projects/library/seqan/blast/blast_base.h"(94)

//____________________________________________________________________________
// BlastN

typedef NucleotideBlast<TagBlastN_> BlastN;       	// "projects/library/seqan/blast/blast_base.h"(148)

//____________________________________________________________________________
// BlastP

typedef ProteinBlast<TagBlastP_> BlastP;       	// "projects/library/seqan/blast/blast_base.h"(151)

//____________________________________________________________________________
// BlastX

typedef ProteinBlast<TagBlastX_> BlastX;       	// "projects/library/seqan/blast/blast_base.h"(152)

//____________________________________________________________________________
// Blat

typedef Tag<TagBlat_> const Blat;       	// "projects/library/seqan/blast/blast_base.h"(100)

//____________________________________________________________________________
// KnownSource

typedef Tag<TagKnownSource_> const KnownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(826)

//____________________________________________________________________________
// MegaBlast

typedef NucleotideBlast<TagMegaBlast_> MegaBlast;       	// "projects/library/seqan/blast/blast_base.h"(149)

//____________________________________________________________________________
// RunBlastN

typedef Tag<TagRunBlastN_> const RunBlastN;       	// "projects/library/seqan/blast/blast_run.h"(17)

//____________________________________________________________________________
// RunBlastP

typedef Tag<TagRunBlastP_> const RunBlastP;       	// "projects/library/seqan/blast/blast_run.h"(28)

//____________________________________________________________________________
// RunBlastX

typedef Tag<TagRunBlastX_> const RunBlastX;       	// "projects/library/seqan/blast/blast_run.h"(31)

//____________________________________________________________________________
// RunBlat

typedef Tag<TagRunBlat_> const RunBlat;       	// "projects/library/seqan/blast/blast_run.h"(23)

//____________________________________________________________________________
// RunMegaBlast

typedef Tag<TagRunMegaBlast_> const RunMegaBlast;       	// "projects/library/seqan/blast/blast_run.h"(20)

//____________________________________________________________________________
// RunTBlastN

typedef Tag<TagRunTBlastN_> const RunTBlastN;       	// "projects/library/seqan/blast/blast_run.h"(34)

//____________________________________________________________________________
// RunTBlastX

typedef Tag<TagRunTBlastX_> const RunTBlastX;       	// "projects/library/seqan/blast/blast_run.h"(37)

//____________________________________________________________________________
// TBlastN

typedef ProteinBlast<TagTBlastN_> TBlastN;       	// "projects/library/seqan/blast/blast_base.h"(153)

//____________________________________________________________________________
// TBlastX

typedef ProteinBlast<TagTBlastX_> TBlastX;       	// "projects/library/seqan/blast/blast_base.h"(154)

//____________________________________________________________________________
// UnknownSource

typedef Tag<TagUnknownSource_> const UnknownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(823)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _parseBlastHit

template <typename TFile, typename TChar, typename TBlastHit> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, TBlastHit & hit);       	// "projects/library/seqan/blast/blast_hit.h"(132)
template <typename TFile, typename TChar, typename TBlastSpec> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, BlastHit<TBlastSpec,StreamReport<TFile> > & hit);       	// "projects/library/seqan/blast/blast_stream_hit.h"(46)

//____________________________________________________________________________
// _parseBlastHsp

template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<NucleotideBlast<TSpec>,FullInfo > & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(152)
template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<ProteinBlast<TSpec>,FullInfo> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(443)
template <typename TFile, typename TChar, typename TBlastSpec, typename TInfoSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<TBlastSpec,TInfoSpec> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(724)

//____________________________________________________________________________
// _parse_lineUntil

template <typename TFile, typename TChar> inline bool _parse_lineUntil(TFile & file, TChar& c, TChar x);       	// "projects/library/seqan/blast/blast_parsing.h"(302)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_lineUntil(TFile & file, TChar& c, String<TChar> & word, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(328)

//____________________________________________________________________________
// _parse_readAlignmentString

template <typename TFile, typename TChar> inline String<char> _parse_readAlignmentString(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(68)

//____________________________________________________________________________
// _parse_readEValue

template <typename TFile, typename TChar> inline double _parse_readEValue(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(37)

//____________________________________________________________________________
// _parse_readFloat

template <typename TFile, typename TChar> inline float _parse_readFloat(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(87)

//____________________________________________________________________________
// _parse_readQueryAndDBName

template <typename TFile, typename TChar> typename Position<TFile>::Type _parse_readQueryAndDBName(TFile & file, TChar & c, String<char> & query_name, String<char> & db_name);       	// "projects/library/seqan/blast/blast_parsing.h"(387)

//____________________________________________________________________________
// _parse_readWord

template <typename TFile, typename TChar, typename TSize> inline String<char> _parse_readWord(TFile & file, TChar& c, TSize max_len);       	// "projects/library/seqan/blast/blast_parsing.h"(104)

//____________________________________________________________________________
// _parse_until

template <typename TFile, typename TChar> inline bool _parse_until(TFile & file, TChar& c, TChar x);       	// "projects/library/seqan/blast/blast_parsing.h"(258)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_until(TFile & file, TChar& c, String<TChar> & word, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(279)

//____________________________________________________________________________
// _parse_untilBeginLine

template <typename TFile, typename TChar> inline bool _parse_untilBeginLine(TFile & file, TChar& c, TChar x);       	// "projects/library/seqan/blast/blast_parsing.h"(148)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilBeginLine(TFile & file, TChar& c, String<TChar> & word, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(170)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilBeginLine(TFile & file, TChar& c, String<TChar> & word, TSize len, TSize num_lines);       	// "projects/library/seqan/blast/blast_parsing.h"(195)

//____________________________________________________________________________
// _parse_untilBeginLineOneOf

template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilBeginLineOneOf(TFile & file, TChar& c, String<TChar> & x, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(228)

//____________________________________________________________________________
// _readParameters

template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & file, TChar & c, BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(367)
template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & , TChar & , BlastReport<TBlastHsp, StoreReport<BasicInfo> >& );       	// "projects/library/seqan/blast/blast_report.h"(459)

//____________________________________________________________________________
// _runBlast

template <typename TString, typename TPath1, typename TPath, typename TParamString> void _runBlast(TPath1 blast_path, TPath db_path, TString db_name, TPath query_path, TString query_name, TPath out_path, TString outfile_name, Tag<TagRunBlastN_>, TParamString params);       	// "projects/library/seqan/blast/blast_run.h"(62)

//____________________________________________________________________________
// atBegin

template <typename TBlastReport, typename TFile> inline bool atBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(179)
template <typename TBlastHit, typename TFile> inline bool atBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(190)
template <typename TBlastHsp, typename TStoreSpec> inline bool atBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(162)
template <typename TBlastObject, typename TIteratorSpec> inline bool atBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(180)

//____________________________________________________________________________
// atEnd

template <typename TBlastReport, typename TFile> inline bool atEnd(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(364)
template <typename TBlastHit, typename TFile> inline bool atEnd(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(340)
template <typename TBlastHsp, typename TStoreSpec> inline bool atEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(183)
template <typename TBlastHsp, typename TSpec, typename TFile> inline bool atEnd(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1087)
template <typename TBlastReport> inline bool atEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(369)

//____________________________________________________________________________
// bitScore

template <typename TBlastSpec> inline float & bitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1459)

//____________________________________________________________________________
// clear

template <typename TBlastHsp, typename TSpec> inline void clear(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(72)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(175)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<BasicInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(347)
template <typename TSpec> inline void clear(BlastHsp<NucleotideBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(317)
template <typename TSpec> inline void clear(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(616)
template <typename TBlastSpec> inline void clear(BlastHsp<TBlastSpec, BasicInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(704)

//____________________________________________________________________________
// databaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & databaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1387)

//____________________________________________________________________________
// databaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1285)

//____________________________________________________________________________
// databaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1351)

//____________________________________________________________________________
// databaseFrame

template <typename TSpec> inline int & databaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1607)

//____________________________________________________________________________
// databaseName

template <typename TBlastHsp, typename TSpec> inline String<char> & databaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(740)

//____________________________________________________________________________
// databaseOrientationPlus

template <typename TBlastSpec> inline bool databaseOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1579)

//____________________________________________________________________________
// eValue

template <typename TBlastSpec, typename TInfoSpec> inline double & eValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1404)

//____________________________________________________________________________
// eValueCutoff

template <typename TBlastHsp> inline double & eValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(824)

//____________________________________________________________________________
// entropy

template <typename TBlastHsp> inline float & entropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1040)

//____________________________________________________________________________
// gapExtension

template <typename TBlastHsp> inline float & gapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(893)

//____________________________________________________________________________
// gapOpen

template <typename TBlastHsp> inline float & gapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(867)

//____________________________________________________________________________
// gappedEntropy

template <typename TBlastHsp> inline float & gappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1057)

//____________________________________________________________________________
// gappedKappa

template <typename TBlastHsp> inline float & gappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1013)

//____________________________________________________________________________
// gappedLambda

template <typename TBlastHsp> inline float & gappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(957)

//____________________________________________________________________________
// gapsAllowed

template <typename TBlastHsp> inline bool gapsAllowed(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(921)

//____________________________________________________________________________
// getAlignment

template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, UnknownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(835)
template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(944)
template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, KnownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(964)
template <typename TBlastHsp, typename TAlign, typename TId> inline unsigned int getAlignment(TBlastHsp & hsp, Graph<TAlign> & ali, TId id0, TId id1);       	// "projects/library/seqan/blast/blast_hsp.h"(1036)
template <typename TBlastHsp, typename TStringSet, typename TCargo, typename TSpec> inline unsigned int getAlignment(TBlastHsp & hsp, Graph<Alignment<TStringSet,TCargo,TSpec> > & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(1124)

//____________________________________________________________________________
// getBitScore

template <typename TBlastSpec> inline float getBitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1478)

//____________________________________________________________________________
// getDatabaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getDatabaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1395)

//____________________________________________________________________________
// getDatabaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1303)

//____________________________________________________________________________
// getDatabaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1359)

//____________________________________________________________________________
// getDatabaseFrame

template <typename TSpec> inline int getDatabaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1615)

//____________________________________________________________________________
// getDatabaseName

template <typename TBlastHsp, typename TSpec> inline String<char> getDatabaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(760)

//____________________________________________________________________________
// getEValue

template <typename TBlastSpec, typename TInfoSpec> inline double getEValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1422)

//____________________________________________________________________________
// getEValueCutoff

template <typename TBlastHsp> inline double getEValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(843)

//____________________________________________________________________________
// getEntropy

template <typename TBlastHsp> inline float getEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1048)

//____________________________________________________________________________
// getGapExtension

template <typename TBlastHsp> inline float getGapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(912)

//____________________________________________________________________________
// getGapOpen

template <typename TBlastHsp> inline float getGapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(885)

//____________________________________________________________________________
// getGappedEntropy

template <typename TBlastHsp> inline float getGappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1065)

//____________________________________________________________________________
// getGappedKappa

template <typename TBlastHsp> inline float getGappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1031)

//____________________________________________________________________________
// getGappedLambda

template <typename TBlastHsp> inline float getGappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(975)

//____________________________________________________________________________
// getKappa

template <typename TBlastHsp> inline float getKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1004)

//____________________________________________________________________________
// getLambda

template <typename TBlastHsp> inline float getLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(948)

//____________________________________________________________________________
// getLength

template <typename TBlastHsp, typename TStoreSpec> inline unsigned int getLength(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(109)

//____________________________________________________________________________
// getMatrixName

template <typename TBlastHsp> inline String<char> getMatrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(859)

//____________________________________________________________________________
// getName

template <typename TBlastHsp, typename TStoreSpec> inline String<char> getName(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(93)

//____________________________________________________________________________
// getNext

template <typename TBlastHsp, typename TSpec, typename TFile> inline void getNext(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1109)

//____________________________________________________________________________
// getNextHitFilePos

template <typename TBlastHsp, typename TFile> inline void getNextHitFilePos(TFile & file, Iter<BlastReport<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(386)

//____________________________________________________________________________
// getNextHspFilePos

template <typename TBlastHsp, typename TFile> inline void getNextHspFilePos(TFile & file, Iter<BlastHit<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(362)

//____________________________________________________________________________
// getNumGaps

template <typename TBlastSpec> inline unsigned int getNumGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1541)

//____________________________________________________________________________
// getPercentGaps

template <typename TBlastSpec> inline unsigned int getPercentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1513)

//____________________________________________________________________________
// getPercentIdentity

template <typename TBlastSpec> inline unsigned int getPercentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1497)

//____________________________________________________________________________
// getPercentPositives

template <typename TSpec> inline unsigned int getPercentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1631)

//____________________________________________________________________________
// getQueryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getQueryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1377)

//____________________________________________________________________________
// getQueryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1275)

//____________________________________________________________________________
// getQueryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1331)

//____________________________________________________________________________
// getQueryFrame

template <typename TSpec> inline int getQueryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1598)

//____________________________________________________________________________
// getQueryName

template <typename TBlastHsp, typename TSpec> inline String<char> getQueryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(720)

//____________________________________________________________________________
// getScore

template <typename TBlastSpec> inline float getScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1451)

//____________________________________________________________________________
// getValue

template <typename TBlastReport, typename TFile> inline typename GetValue<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type getValue(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(301)
template <typename TBlastHit, typename TFile> inline typename GetValue<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type getValue(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(271)
template <typename TBlastHsp, typename TStoreSpec> inline typename GetValue<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type getValue(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(113)
template <typename TBlastReport> inline typename GetValue<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type getValue(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(315)

//____________________________________________________________________________
// goBegin

template <typename TBlastReport, typename TFile> inline void goBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(201)
template <typename TBlastHit, typename TFile> inline void goBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(203)
template <typename TBlastHsp, typename TStoreSpec> inline void goBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(172)
template <typename TBlastObject, typename TIteratorSpec> inline void goBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(199)

//____________________________________________________________________________
// goEnd

template <typename TBlastHsp, typename TStoreSpec> inline void goEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(193)
template <typename TBlastReport> inline void goEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(386)

//____________________________________________________________________________
// goNext

template <typename TBlastReport, typename TFile> inline void goNext(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(228)
template <typename TBlastHit, typename TFile> inline void goNext(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(218)
template <typename TBlastHsp, typename TStoreSpec> inline void goNext(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(203)
template <typename TBlastObject, typename TIteratorSpec> inline void goNext(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(218)

//____________________________________________________________________________
// goPrevious

template <typename TBlastHsp, typename TStoreSpec> inline void goPrevious(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(226)
template <typename TBlastObject, typename TIteratorSpec> inline void goPrevious(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(249)

//____________________________________________________________________________
// hostHit

template <typename TBlastHit> inline typename Host<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type const& hostHit(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(328)

//____________________________________________________________________________
// hostReport

template <typename TBlastReport> inline typename Host<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(342)
template <typename TBlastReport> inline typename Host<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, SimpleBlastIterator<HitIterator> > & it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(351)

//____________________________________________________________________________
// kappa

template <typename TBlastHsp> inline float & kappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(985)

//____________________________________________________________________________
// lambda

template <typename TBlastHsp> inline float & lambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(930)

//____________________________________________________________________________
// length

template <typename TBlastHsp, typename TStoreSpec> inline unsigned int & length(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(101)
template <typename TBlast, typename TSpec> inline unsigned int length(BlastHsp<TBlast,TSpec >& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1645)

//____________________________________________________________________________
// matrixName

template <typename TBlastHsp> inline String<char> & matrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(851)

//____________________________________________________________________________
// name

template <typename TBlastHsp, typename TStoreSpec> inline String<char> & name(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(85)

//____________________________________________________________________________
// numGaps

template <typename TBlastSpec> inline unsigned int & numGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1521)

//____________________________________________________________________________
// numHits

template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHits(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(780)

//____________________________________________________________________________
// numHsps

template <typename TBlastHsp, typename TSpec> inline unsigned int numHsps(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(118)
template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHsps(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(799)

//____________________________________________________________________________
// operator!=

template <typename TBlastReport> inline bool operator!=(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(280)
template <typename TBlastHit> inline bool operator!=(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(259)
template <typename TBlastHsp, typename TStoreSpec> inline bool operator!=(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(270)
template <typename TBlastObject, typename TIteratorSpec> inline bool operator!=(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(293)

//____________________________________________________________________________
// operator*

template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type operator* (Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(134)
template <typename TBlastObject, typename TIteratorSpec> inline typename Reference<Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> > >::Type operator* (Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(162)

//____________________________________________________________________________
// operator++

template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator++(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(213)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator++(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(228)

//____________________________________________________________________________
// operator--

template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator--(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(236)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator--(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(259)

//____________________________________________________________________________
// operator==

template <typename TBlastReport> inline bool operator==(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(269)
template <typename TBlastHit> inline bool operator==(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(248)
template <typename TBlastHsp, typename TStoreSpec> inline bool operator==(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(259)
template <typename TBlastObject, typename TIteratorSpec> inline bool operator==(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(282)

//____________________________________________________________________________
// percentGaps

template <typename TBlastSpec> inline unsigned int & percentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1505)

//____________________________________________________________________________
// percentIdentity

template <typename TBlastSpec> inline unsigned int & percentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1487)

//____________________________________________________________________________
// percentPositives

template <typename TSpec> inline unsigned int & percentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1623)

//____________________________________________________________________________
// queryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & queryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1368)

//____________________________________________________________________________
// queryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1254)

//____________________________________________________________________________
// queryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1313)

//____________________________________________________________________________
// queryFrame

template <typename TSpec> inline int & queryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1590)

//____________________________________________________________________________
// queryName

template <typename TBlastHsp, typename TSpec> inline String<char> & queryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(700)

//____________________________________________________________________________
// queryOrientationPlus

template <typename TBlastSpec> inline bool queryOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1561)

//____________________________________________________________________________
// read

template <typename TBlastHsp, typename TFile> void read(TFile & file, BlastReport<TBlastHsp, StreamReport<TFile> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_stream_report.h"(72)
template <typename TFile, typename TBlastHsp, typename TInfoSpec> void read(TFile & file, BlastReport<TBlastHsp, StoreReport<TInfoSpec> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_report.h"(475)

//____________________________________________________________________________
// run

template <typename TBlast, typename TBlastReport, typename TString, typename TParamString> void run(Tag<TBlast> tag, TString blast_path, TString db_path, TString db_name, TString query_path, TString query_name, TBlastReport & blastObj, TParamString params );       	// "projects/library/seqan/blast/blast_run.h"(92)

//____________________________________________________________________________
// score

template <typename TBlastSpec> inline float & score(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1433)

//____________________________________________________________________________
// value

template <typename TBlastReport, typename TFile> inline typename Reference<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type value(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(329)
template <typename TBlastHit, typename TFile> inline typename Reference<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type value(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(294)
template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type value(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(124)
template <typename TBlastReport> inline typename Reference<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type value(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(332)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

