 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_ALIGN_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_ALIGN_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Align

template <typename TSource, typename TSpec > class Align;       	// "projects/library/seqan/align/align_base.h"(119)

//____________________________________________________________________________
// AlignColIterator

template <typename TSpec> struct AlignColIterator;       	// "projects/library/seqan/align/align_cols_base.h"(146)

//____________________________________________________________________________
// AlignCols

template <typename TAlign> struct AlignCols;       	// "projects/library/seqan/align/align_cols_base.h"(47)

//____________________________________________________________________________
// AlignTrace

template <typename TSize , typename TSpec > struct AlignTrace;       	// "projects/library/seqan/align/align_trace.h"(34)

//____________________________________________________________________________
// ArrayGaps

struct ArrayGaps;       	// "projects/library/seqan/align/gaps_array.h"(30)
struct ArrayGaps;       	// "projects/library/seqan/align/gaps_base.h"(31)

//____________________________________________________________________________
// Col

template <typename T> struct Col;       	// "projects/library/seqan/align/align_base.h"(57)

//____________________________________________________________________________
// Cols

template <typename T> struct Cols;       	// "projects/library/seqan/align/align_base.h"(39)

//____________________________________________________________________________
// GapAlphabet

template <typename T> struct GapAlphabet;       	// "projects/library/seqan/align/gaps_simple.h"(33)

//____________________________________________________________________________
// Gaps

template <typename TSource, typename TSpec > class Gaps;       	// "projects/library/seqan/align/gaps_base.h"(61)

//____________________________________________________________________________
// GapsIterator

template <typename TSpec> struct GapsIterator;       	// "projects/library/seqan/align/gaps_base.h"(35)

//____________________________________________________________________________
// GetSource

template <typename T> struct GetSource;       	// "projects/library/seqan/align/gaps_base.h"(132)

//____________________________________________________________________________
// LocalAlignmentFinder

template <typename TScoreValue > class LocalAlignmentFinder;       	// "projects/library/seqan/align/align_local_dynprog.h"(99)

//____________________________________________________________________________
// Matrix

template <typename TValue, typename TSpec > class Matrix;       	// "projects/library/seqan/align/matrix_base.h"(33)

//____________________________________________________________________________
// NDimensional

struct NDimensional;       	// "projects/library/seqan/align/matrix_base.h"(29)

//____________________________________________________________________________
// Navi

template <typename TContainer, typename TSpec> struct Navi;       	// "projects/library/seqan/align/align_trace.h"(230)

//____________________________________________________________________________
// Navigator

template <typename T> struct Navigator;       	// "projects/library/seqan/align/align_trace.h"(215)

//____________________________________________________________________________
// Row

template <typename T> struct Row;       	// "projects/library/seqan/align/align_base.h"(89)

//____________________________________________________________________________
// Rows

template <typename T> struct Rows;       	// "projects/library/seqan/align/align_base.h"(71)

//____________________________________________________________________________
// ScoreAndID

template <typename TValue, typename TID> class ScoreAndID;       	// "projects/library/seqan/align/align_local_dynprog.h"(34)

//____________________________________________________________________________
// SequenceGaps

struct SequenceGaps;       	// "projects/library/seqan/align/gaps_simple.h"(46)

//____________________________________________________________________________
// SumlistGaps

struct SumlistGaps;       	// "projects/library/seqan/align/gaps_sumlist.h"(30)

//____________________________________________________________________________
// _HirschbergSet

class _HirschbergSet;       	// "projects/library/seqan/align/hirschberg_set.h"(50)

//____________________________________________________________________________
// _SumList_of_Gaps

template <typename TGaps> struct _SumList_of_Gaps;       	// "projects/library/seqan/align/gaps_sumlist.h"(505)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _CoordinatesToPositions

template <typename TSize, typename TSpec, typename TCoordinates> inline void _CoordinatesToPositions(AlignTrace<TSize, TSpec> & me, TCoordinates const & coordinates_, TSize & position_, unsigned char & bit_position);       	// "projects/library/seqan/align/align_trace.h"(154)

//____________________________________________________________________________
// _PositionsToCoordinates

template <typename TSize, typename TSpec, typename TCoordinates> inline void _PositionsToCoordinates(AlignTrace<TSize, TSpec> & me, TCoordinates & coordinates_, TSize position_, unsigned char bit_position );       	// "projects/library/seqan/align/align_trace.h"(181)

//____________________________________________________________________________
// _dataArr

template <typename TSource> inline String<typename Size<Gaps<TSource, ArrayGaps> >::Type> & _dataArr(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(141)
template <typename TSource> inline String<typename Size<Gaps<TSource, ArrayGaps> >::Type> const & _dataArr(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(148)

//____________________________________________________________________________
// _dataSource

template <typename TSource> inline Holder<TSource> & _dataSource(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(158)
template <typename TSource> inline Holder<TSource> const & _dataSource(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(165)
template <typename TSource> inline Holder<TSource> & _dataSource(Gaps<TSource, SumlistGaps> & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(139)
template <typename TSource> inline Holder<TSource> const & _dataSource(Gaps<TSource, SumlistGaps> const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(146)

//____________________________________________________________________________
// _getBitsPerEntry

template <typename TSize, typename TSpec> inline unsigned int _getBitsPerEntry(AlignTrace<TSize, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(100)

//____________________________________________________________________________
// _goNext_arrayGapsIterator

template <typename T> inline void _goNext_arrayGapsIterator(T const & me);       	// "projects/library/seqan/align/gaps_array.h"(734)

//____________________________________________________________________________
// _goNext_sumlistGapsIterator

template <typename T> inline void _goNext_sumlistGapsIterator(T & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(651)

//____________________________________________________________________________
// _goPrevious_arrayGapsIterator

template <typename T> inline void _goPrevious_arrayGapsIterator(T const & me);       	// "projects/library/seqan/align/gaps_array.h"(767)

//____________________________________________________________________________
// _goPrevious_sumlistGapsIterator

template <typename T> inline void _goPrevious_sumlistGapsIterator(T & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(676)

//____________________________________________________________________________
// _gotoh

template <typename TScoreValue, typename TMatrixSpec, typename TString> TScoreValue _gotoh(Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(229)

//____________________________________________________________________________
// _gotoh_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TMatrixSpec> void _gotoh_trace(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(373)

//____________________________________________________________________________
// _initMembers

template <typename TSize, typename TSpec> inline void _initMembers(AlignTrace<TSize, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(109)

//____________________________________________________________________________
// _init_to_resize

template <typename TSource, typename TSize> inline void _init_to_resize(Gaps<TSource, ArrayGaps> & me, TSize _size);       	// "projects/library/seqan/align/gaps_array.h"(242)
template <typename TSource, typename TSize2> inline void _init_to_resize(Gaps<TSource, SumlistGaps> & me, TSize2 _size);       	// "projects/library/seqan/align/gaps_sumlist.h"(246)

//____________________________________________________________________________
// _iterator_gaps_array

template <typename TGaps, typename TPosition> inline typename Iterator<TGaps, Standard>::Type _iterator_gaps_array(TGaps & gaps, TPosition view_position);       	// "projects/library/seqan/align/gaps_array.h"(352)

//____________________________________________________________________________
// _needleman_wunsch

template <typename TScoreValue, typename TMatrixSpec, typename TString> TScoreValue _needleman_wunsch(Matrix<TScoreValue, TMatrixSpec> & matrix_, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(35)

//____________________________________________________________________________
// _needleman_wunsch_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> void _needleman_wunsch_trace(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(135)

//____________________________________________________________________________
// _setEndPosition

template <typename TSource, typename TPosition> inline void _setEndPosition(Gaps<TSource, ArrayGaps> & me, TPosition _pos);       	// "projects/library/seqan/align/gaps_array.h"(192)

//____________________________________________________________________________
// _setSourceBeginPosition

template <typename TSource, typename TSourcePosition> inline void _setSourceBeginPosition(Gaps<TSource, ArrayGaps> & me, TSourcePosition _pos);       	// "projects/library/seqan/align/gaps_array.h"(212)
template <typename TSource, typename TSourcePosition> inline void _setSourceBeginPosition(Gaps<TSource, SumlistGaps> & me, TSourcePosition _pos);       	// "projects/library/seqan/align/gaps_sumlist.h"(216)

//____________________________________________________________________________
// _setSourceEndPosition

template <typename TSource, typename TSourcePosition> inline void _setSourceEndPosition(Gaps<TSource, ArrayGaps> & me, TSourcePosition _pos);       	// "projects/library/seqan/align/gaps_array.h"(231)
template <typename TSource, typename TSourcePosition> inline void _setSourceEndPosition(Gaps<TSource, SumlistGaps> & me, TSourcePosition _pos);       	// "projects/library/seqan/align/gaps_sumlist.h"(235)

//____________________________________________________________________________
// _source_SequenceGaps

template <typename TSource> inline typename GetSource< Gaps<TSource, SequenceGaps> >::Type _source_SequenceGaps(Gaps<TSource, SequenceGaps> & me);       	// "projects/library/seqan/align/gaps_simple.h"(177)

//____________________________________________________________________________
// assignSource

template <typename TSource, typename TSource2, typename TPosition1, typename TPosition2> inline void assignSource(Gaps<TSource, SequenceGaps> & me, TSource2 const & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_simple.h"(246)
template <typename TSource, typename TSpec, typename TSource2, typename TPosition1, typename TPosition2> inline void assignSource(Gaps<TSource, TSpec> & me, TSource2 const & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_base.h"(938)
template <typename TSource, typename TSpec, typename TSource2> inline void assignSource(Gaps<TSource, TSpec> & me, TSource2 const & source_);       	// "projects/library/seqan/align/gaps_base.h"(952)

//____________________________________________________________________________
// assignValue

template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(334)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(343)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(352)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(361)
template <typename TGaps, typename TSpec, typename TValue> inline void assignValue(Iter<TGaps, GapsIterator<TSpec> > & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(181)
template <typename TGaps, typename TSpec, typename TValue> inline void assignValue(Iter<TGaps, GapsIterator<TSpec> > const & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(193)

//____________________________________________________________________________
// atBegin

template <typename TGaps> inline bool atBegin(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(722)
template <typename TGaps> inline bool atBegin(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(805)
template <typename TGaps> inline bool atBegin(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(705)

//____________________________________________________________________________
// atEnd

template <typename TGaps> inline bool atEnd(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(732)
template <typename TGaps> inline bool atEnd(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(815)
template <typename TGaps> inline bool atEnd(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(715)

//____________________________________________________________________________
// begin

template <typename TValue, typename TTag> inline typename Iterator<Matrix <TValue, NDimensional>, Tag<TTag> const>::Type begin(Matrix<TValue, NDimensional> & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(295)
template <typename TValue, typename TTag> inline typename Iterator<Matrix <TValue, NDimensional> const, Tag<TTag> const>::Type begin(Matrix<TValue, NDimensional> const & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(302)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type begin(AlignCols<TAlign> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(329)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type begin(AlignCols<TAlign> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(337)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec>, Tag<TTag> const>::Type begin(Gaps<TSource, TSpec> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(254)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec> const, Tag<TTag> const>::Type begin(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(262)

//____________________________________________________________________________
// beginPosition

template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type beginPosition(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(309)
template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type beginPosition(AlignCols<TAlign> & me);       	// "projects/library/seqan/align/align_cols_base.h"(316)
template <typename TSource> inline typename Position< Gaps<TSource, SequenceGaps> >::Type beginPosition(Gaps<TSource, SequenceGaps> & gaps);       	// "projects/library/seqan/align/gaps_simple.h"(289)
template <typename TSource> inline typename Position< Gaps<TSource, SequenceGaps> const>::Type beginPosition(Gaps<TSource, SequenceGaps> const & gaps);       	// "projects/library/seqan/align/gaps_simple.h"(296)
template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> >::Type beginPosition(Gaps<TSource, ArrayGaps> & gaps);       	// "projects/library/seqan/align/gaps_array.h"(436)
template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> const>::Type beginPosition(Gaps<TSource, ArrayGaps> const & gaps);       	// "projects/library/seqan/align/gaps_array.h"(443)
template <typename TSource> inline typename Position< Gaps<TSource, SumlistGaps> >::Type beginPosition(Gaps<TSource, SumlistGaps> & gaps);       	// "projects/library/seqan/align/gaps_sumlist.h"(156)
template <typename TSource> inline typename Position< Gaps<TSource, SumlistGaps> const>::Type beginPosition(Gaps<TSource, SumlistGaps> const & gaps);       	// "projects/library/seqan/align/gaps_sumlist.h"(167)

//____________________________________________________________________________
// beginPosition_AlignCols

template <typename TAlignCols> inline typename Position<TAlignCols>::Type beginPosition_AlignCols(TAlignCols const & me);       	// "projects/library/seqan/align/align_cols_base.h"(281)

//____________________________________________________________________________
// clear

template <typename TSource> inline void clear(Gaps<TSource, SequenceGaps> & me);       	// "projects/library/seqan/align/gaps_simple.h"(361)
template <typename TSource> inline void clear(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(265)
template <typename TSource> inline void clear(Gaps<TSource, SumlistGaps> & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(273)

//____________________________________________________________________________
// clearBit

template <typename TSize, typename TSpec, typename TSpec2> inline void clearBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(288)

//____________________________________________________________________________
// clearGaps

template <typename TSource> inline void clearGaps(Gaps<TSource, SequenceGaps> & me);       	// "projects/library/seqan/align/gaps_simple.h"(343)
template <typename TSource> inline void clearGaps(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(255)
template <typename TSource> inline void clearGaps(Gaps<TSource, SumlistGaps> & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(263)
template <typename TSource, typename TSpec, typename TPosition1, typename TPosition2> inline void clearGaps(Gaps<TSource, TSpec> & me, TPosition1 view_pos_begin, TPosition2 view_pos_end);       	// "projects/library/seqan/align/gaps_base.h"(547)
template <typename TSource, typename TSpec> inline void clearGaps(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(580)

//____________________________________________________________________________
// col

template <typename TSource, typename TSpec, typename TPosition> inline typename Col< Align<TSource, TSpec> >::Type col(Align<TSource, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(344)
template <typename TSource, typename TSpec, typename TPosition> inline typename Col< Align<TSource, TSpec> const>::Type col(Align<TSource, TSpec> const & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(352)

//____________________________________________________________________________
// cols

template <typename TSource, typename TSpec> inline typename Cols< Align<TSource, TSpec> >::Type cols(Align<TSource, TSpec> & me);       	// "projects/library/seqan/align/align_base.h"(312)
template <typename TSource, typename TSpec> inline typename Cols< Align<TSource, TSpec> const>::Type cols(Align<TSource, TSpec> const & me);       	// "projects/library/seqan/align/align_base.h"(319)

//____________________________________________________________________________
// container

template <typename TAlign, typename TSpec> inline typename Cols<TAlign>::Type container(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(122)
template <typename TAlign, typename TSpec> inline typename Cols<TAlign>::Type container(Iter<TAlign, AlignColIterator<TSpec> > const & me);       	// "projects/library/seqan/align/align_iterator_base.h"(129)
template <typename TGaps, typename TSpec> inline TGaps & container(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(232)
template <typename TGaps, typename TSpec> inline TGaps & container(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(240)
template <typename TContainer, typename TSpec> inline TContainer & container(Navi<TContainer, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(247)
template <typename TContainer, typename TSpec> inline TContainer const & container(Navi<TContainer, TSpec> const & me);       	// "projects/library/seqan/align/align_trace.h"(253)

//____________________________________________________________________________
// coordinate

template <typename TValue, typename TPosition> inline typename Size< Matrix <TValue, NDimensional> >::Type coordinate(Matrix<TValue, NDimensional> & me, TPosition position_, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(276)
template <typename TValue> inline typename Size< Matrix<TValue, NDimensional> >::Type coordinate(Iter< Matrix<TValue, NDimensional>, PositionIterator > & me, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(366)

//____________________________________________________________________________
// copyGaps

template <typename TSource, typename TSpec, typename TPosition1, typename TSourceGaps, typename TPosition2, typename TPosition3> inline void copyGaps(Gaps<TSource, TSpec> & target_gaps, TPosition1 target_view_pos_begin, TSourceGaps const & source_gaps, TPosition2 source_view_pos_begin, TPosition3 source_view_pos_end);       	// "projects/library/seqan/align/gaps_base.h"(597)

//____________________________________________________________________________
// countGaps

template <typename TGaps> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(642)
template <typename TGaps> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(702)
template <typename TGaps> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(634)
template <typename TSource, typename TSpec, typename TPosition> inline typename Size<Gaps<TSource, TSpec> >::Type countGaps(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(514)
template <typename TSource, typename TSpec, typename TPosition> inline typename Size<Gaps<TSource, TSpec> >::Type countGaps(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(522)

//____________________________________________________________________________
// createSource

template <typename TSource, typename TSpec> inline void createSource(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(795)

//____________________________________________________________________________
// dependentSource

template <typename TSource> inline bool dependentSource(Gaps<TSource, SequenceGaps> & );       	// "projects/library/seqan/align/gaps_simple.h"(272)
template <typename TSource> inline bool dependentSource(Gaps<TSource, SequenceGaps> const & );       	// "projects/library/seqan/align/gaps_simple.h"(279)
template <typename TSource, typename TSpec> inline bool dependentSource(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(714)
template <typename TSource, typename TSpec> inline bool dependentSource(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(721)

//____________________________________________________________________________
// detach

template <typename TSource, typename TSpec> inline void detach(Align<TSource, TSpec> & me);       	// "projects/library/seqan/align/align_base.h"(364)
template <typename TSource, typename TSpec> inline void detach(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(810)

//____________________________________________________________________________
// dimension

template <typename TValue> inline unsigned int dimension(Matrix<TValue, NDimensional> & me);       	// "projects/library/seqan/align/matrix_base.h"(172)
template <typename TSize, typename TSpec> inline unsigned int dimension(AlignTrace<TSize, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(60)

//____________________________________________________________________________
// emptySource

template <typename TSource, typename TSpec> inline bool emptySource(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(681)
template <typename TSource, typename TSpec> inline bool emptySource(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(689)

//____________________________________________________________________________
// end

template <typename TValue, typename TTag> inline typename Iterator<Matrix <TValue, NDimensional>, Tag<TTag> const >::Type end(Matrix<TValue, NDimensional> & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(312)
template <typename TValue, typename TTag> inline typename Iterator<Matrix <TValue, NDimensional> const, Tag<TTag> const >::Type end(Matrix<TValue, NDimensional> const & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(319)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type end(AlignCols<TAlign> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(391)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type end(AlignCols<TAlign> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(399)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec>, Tag<TTag> const>::Type end(Gaps<TSource, TSpec> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(275)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec> const, Tag<TTag> const>::Type end(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(283)

//____________________________________________________________________________
// endPosition

template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type endPosition(AlignCols<TAlign> & me);       	// "projects/library/seqan/align/align_cols_base.h"(371)
template <typename TAlign> inline typename Position<AlignCols<TAlign> const>::Type endPosition(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(378)
template <typename TSource> inline typename Position<Gaps<TSource, SequenceGaps> >::Type endPosition(Gaps<TSource, SequenceGaps> & me);       	// "projects/library/seqan/align/gaps_simple.h"(306)
template <typename TSource> inline typename Position<Gaps<TSource, SequenceGaps> >::Type endPosition(Gaps<TSource, SequenceGaps> const & me);       	// "projects/library/seqan/align/gaps_simple.h"(313)
template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type endPosition(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(175)
template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type endPosition(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(182)
template <typename TSource> inline typename Position<Gaps<TSource, SumlistGaps> >::Type endPosition(Gaps<TSource, SumlistGaps> & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(189)
template <typename TSource> inline typename Position<Gaps<TSource, SumlistGaps> >::Type endPosition(Gaps<TSource, SumlistGaps> const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(196)

//____________________________________________________________________________
// endPosition_AlignCols

template <typename TAlignCols> inline typename Position<TAlignCols>::Type endPosition_AlignCols(TAlignCols const & me);       	// "projects/library/seqan/align/align_cols_base.h"(349)

//____________________________________________________________________________
// getBit

template <typename TSize, typename TSpec, typename TSpec2> inline bool getBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(270)

//____________________________________________________________________________
// getValue

template <typename TAlign, typename TSpec, typename TPosition> inline typename GetValue<TAlign>::Type getValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(314)
template <typename TAlign, typename TSpec, typename TPosition> inline typename GetValue<TAlign>::Type getValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(322)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<SequenceGaps> > >::Type getValue(Iter<TGaps, GapsIterator<SequenceGaps> > & me);       	// "projects/library/seqan/align/gaps_simple.h"(578)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<SequenceGaps> > const>::Type getValue(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(591)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<ArrayGaps> > >::Type getValue(Iter<TGaps, GapsIterator<ArrayGaps> > & me);       	// "projects/library/seqan/align/gaps_array.h"(671)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<ArrayGaps> > const>::Type getValue(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(680)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<SumlistGaps> > >::Type getValue(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(576)
template <typename TGaps> inline typename GetValue< Iter<TGaps, GapsIterator<SumlistGaps> > const>::Type getValue(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(585)
template <typename TSource, typename TSpec, typename TPosition> inline typename GetValue<Gaps<TSource, TSpec> >::Type getValue(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(623)
template <typename TSource, typename TSpec, typename TPosition> inline typename GetValue<Gaps<TSource, TSpec> >::Type getValue(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(633)

//____________________________________________________________________________
// get_next_best_end_position

template <typename TScoreValue> typename LocalAlignmentFinder<TScoreValue>::TMatrixPosition get_next_best_end_position(LocalAlignmentFinder<TScoreValue> & sw , TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(596)

//____________________________________________________________________________
// globalAlignment

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const &, MyersBitVector);       	// "projects/library/seqan/align/align_myers.h"(156)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const &, MyersHirschberg);       	// "projects/library/seqan/align/align_myers.h"(358)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, Hirschberg);       	// "projects/library/seqan/align/align_hirschberg.h"(139)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(505)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, NeedlemanWunsch);       	// "projects/library/seqan/align/align_dynprog.h"(524)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, Gotoh);       	// "projects/library/seqan/align/align_dynprog.h"(543)

//____________________________________________________________________________
// goNext

template <typename TAlign, typename TSpec> inline void goNext(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(139)
template <typename TValue> inline void goNext(Iter< Matrix<TValue, NDimensional>, PositionIterator > & me, unsigned int dimension_ );       	// "projects/library/seqan/align/matrix_base.h"(343)
template <typename TSize, typename TSpec, typename TSpec2> inline void goNext(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me, unsigned int dimension_);       	// "projects/library/seqan/align/align_trace.h"(298)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<SequenceGaps> > & me);       	// "projects/library/seqan/align/gaps_simple.h"(665)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(678)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<ArrayGaps> > & me);       	// "projects/library/seqan/align/gaps_array.h"(752)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(758)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(661)
template <typename TGaps> inline void goNext(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(667)

//____________________________________________________________________________
// goPrevious

template <typename TAlign, typename TSpec> inline void goPrevious(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(182)
template <typename TValue> inline void goPrevious(Iter< Matrix<TValue, NDimensional>, PositionIterator > & me, unsigned int dimension_ );       	// "projects/library/seqan/align/matrix_base.h"(355)
template <typename TSize, typename TSpec, typename TSpec2> inline void goPrevious(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me, unsigned int dimension_);       	// "projects/library/seqan/align/align_trace.h"(338)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<SequenceGaps> > & me);       	// "projects/library/seqan/align/gaps_simple.h"(694)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(707)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<ArrayGaps> > & me);       	// "projects/library/seqan/align/gaps_array.h"(791)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(797)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<SumlistGaps> > & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(691)
template <typename TGaps> inline void goPrevious(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(697)

//____________________________________________________________________________
// host

template <typename TAlign, typename TSpec> inline TAlign & host(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(95)
template <typename TAlign, typename TSpec> inline TAlign & host(Iter<TAlign, AlignColIterator<TSpec> > const & me);       	// "projects/library/seqan/align/align_iterator_base.h"(102)
template <typename TAlign> inline typename Host<AlignCols<TAlign> >::Type & host(AlignCols<TAlign> & me);       	// "projects/library/seqan/align/align_cols_base.h"(216)
template <typename TAlign> inline typename Host<AlignCols<TAlign> const>::Type & host(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(224)

//____________________________________________________________________________
// id

template <typename TSource, typename TSpec> inline void const * id(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(233)
template <typename TSource, typename TSpec> inline void const * id(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(240)

//____________________________________________________________________________
// insertGap

template <typename TGaps, typename TSpec> inline void insertGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(138)
template <typename TSource, typename TSpec, typename TPosition> inline void insertGap(Gaps<TSource, TSpec> & me, TPosition _view_pos);       	// "projects/library/seqan/align/gaps_base.h"(383)

//____________________________________________________________________________
// insertGaps

template <typename TGaps, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<SequenceGaps> > const & me, TCount size);       	// "projects/library/seqan/align/gaps_simple.h"(743)
template <typename TGaps, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<ArrayGaps> > const & me, TCount size);       	// "projects/library/seqan/align/gaps_array.h"(826)
template <typename TGaps, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<SumlistGaps> > const & me, TCount size);       	// "projects/library/seqan/align/gaps_sumlist.h"(726)
template <typename TSource, typename TSpec, typename TPosition, typename TSize> inline void insertGaps(Gaps<TSource, TSpec> & me, TPosition _view_pos, TSize _size);       	// "projects/library/seqan/align/gaps_base.h"(406)

//____________________________________________________________________________
// isGap

template <typename TGaps> inline bool isGap(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(631)
template <typename TGaps> inline bool isGap(Iter<TGaps, GapsIterator<ArrayGaps> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(692)
template <typename TGaps> inline bool isGap(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(624)
template <typename TSource, typename TSpec, typename TPosition> inline bool isGap(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(478)
template <typename TSource, typename TSpec, typename TPosition> inline bool isGap(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(486)

//____________________________________________________________________________
// iter

template <typename TAlign, typename TPosition, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type iter(AlignCols<TAlign> & me, TPosition pos_, Tag<TTag> const);       	// "projects/library/seqan/align/align_cols_base.h"(239)
template <typename TAlign, typename TPosition, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type iter(AlignCols<TAlign> const & me, TPosition pos_, Tag<TTag> const);       	// "projects/library/seqan/align/align_cols_base.h"(248)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, SequenceGaps>, Tag<TTag> const>::Type iter(Gaps<TSource, SequenceGaps> & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_simple.h"(452)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, SequenceGaps> const, Tag<TTag> const>::Type iter(Gaps<TSource, SequenceGaps> const & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_simple.h"(463)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, ArrayGaps>, Tag<TTag> const>::Type iter(Gaps<TSource, ArrayGaps> & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_array.h"(417)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, ArrayGaps> const, Tag<TTag> const>::Type iter(Gaps<TSource, ArrayGaps> const & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_array.h"(426)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, SumlistGaps>, Tag<TTag> const>::Type iter(Gaps<TSource, SumlistGaps> & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_sumlist.h"(355)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, SumlistGaps> const, Tag<TTag> const>::Type iter(Gaps<TSource, SumlistGaps> const & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_sumlist.h"(366)

//____________________________________________________________________________
// length

template <typename TValue> inline typename Size<Matrix<TValue, NDimensional> >::Type length(Matrix<TValue, NDimensional> const & me, unsigned int dim_);       	// "projects/library/seqan/align/matrix_base.h"(197)
template <typename TValue> inline typename Size<Matrix <TValue, NDimensional> >::Type length(Matrix<TValue, NDimensional> const & me);       	// "projects/library/seqan/align/matrix_base.h"(204)
template <typename TAlign> inline typename Size<AlignCols<TAlign> >::Type length(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(409)
template <typename TSize, typename TSpec> inline TSize length(AlignTrace<TSize, TSpec> const & me, TSize _dim);       	// "projects/library/seqan/align/align_trace.h"(80)
template <typename TSource, typename TSpec> inline typename Size<Gaps<TSource, TSpec> >::Type length(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(295)

//____________________________________________________________________________
// localAlignment

template <typename TSource, typename TSpec, typename TScoreValue> inline TScoreValue localAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, SmithWaterman);       	// "projects/library/seqan/align/align_local_dynprog.h"(739)

//____________________________________________________________________________
// moveNextBit

template <typename TSize, typename TSpec, typename TSpec2> inline void moveNextBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(375)

//____________________________________________________________________________
// movePreviousBit

template <typename TSize, typename TSpec, typename TSpec2> inline void movePreviousBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(392)

//____________________________________________________________________________
// moveSource

template <typename TSource, typename TSource2, typename TPosition1, typename TPosition2> inline void moveSource(Gaps<TSource, SequenceGaps> & me, TSource2 const & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_simple.h"(262)
template <typename TSource, typename TSpec, typename TSource2, typename TPosition1, typename TPosition2> inline void moveSource(Gaps<TSource, TSpec> & me, TSource2 const & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_base.h"(993)
template <typename TSource, typename TSpec, typename TSource2> inline void moveSource(Gaps<TSource, TSpec> & me, TSource2 const & source_);       	// "projects/library/seqan/align/gaps_base.h"(1007)

//____________________________________________________________________________
// moveValue

template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(373)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(382)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(391)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(400)
template <typename TGaps, typename TSpec, typename TValue> inline void moveValue(Iter<TGaps, GapsIterator<TSpec> > & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(206)
template <typename TGaps, typename TSpec, typename TValue> inline void moveValue(Iter<TGaps, GapsIterator<TSpec> > const & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(217)

//____________________________________________________________________________
// nextPosition

template <typename TValue, typename TPosition> inline typename Position<Matrix <TValue, NDimensional> >::Type nextPosition(Matrix<TValue, NDimensional> & me, TPosition position_, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(256)

//____________________________________________________________________________
// operator!=

template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(261)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(269)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(277)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(285)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SequenceGaps> > & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > & _right);       	// "projects/library/seqan/align/gaps_simple.h"(839)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SequenceGaps> > const & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > & _right);       	// "projects/library/seqan/align/gaps_simple.h"(847)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SequenceGaps> > & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > const & _right);       	// "projects/library/seqan/align/gaps_simple.h"(855)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SequenceGaps> > const & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > const & _right);       	// "projects/library/seqan/align/gaps_simple.h"(863)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(972)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(980)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(988)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(996)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(843)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(851)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(859)
template <typename TGaps1, typename TGaps2> inline bool operator!= (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(867)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator!= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1102)
template <typename TLeftSource, typename TLeftSpec, typename TRight > inline bool operator!=(Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1111)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator!= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1120)

//____________________________________________________________________________
// operator++

template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > & operator++(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(160)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > operator++(Iter<TAlign, AlignColIterator<TSpec> > & me, int);       	// "projects/library/seqan/align/align_iterator_base.h"(170)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const & operator++(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(91)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const operator++(Iter<TGaps, GapsIterator<TSpec> > const & me, int);       	// "projects/library/seqan/align/gaps_iterator_base.h"(100)
template <typename TSize, typename TSpec, typename TSpec2> inline Navi< AlignTrace<TSize, TSpec>, TSpec2> const & operator++ (Navi< AlignTrace<TSize, TSpec>, TSpec2> & me);       	// "projects/library/seqan/align/align_trace.h"(326)

//____________________________________________________________________________
// operator--

template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > & operator--(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(203)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > operator--(Iter<TAlign, AlignColIterator<TSpec> > & me, int);       	// "projects/library/seqan/align/align_iterator_base.h"(213)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const & operator--(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(112)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const operator--(Iter<TGaps, GapsIterator<TSpec> > const & me, int);       	// "projects/library/seqan/align/gaps_iterator_base.h"(121)
template <typename TSize, typename TSpec, typename TSpec2> inline Navi< AlignTrace<TSize, TSpec>, TSpec2> const & operator-- (Navi< AlignTrace<TSize, TSpec>, TSpec2> & me);       	// "projects/library/seqan/align/align_trace.h"(366)

//____________________________________________________________________________
// operator<

template <typename TValue, typename TID> bool operator<(ScoreAndID<TValue,TID> & a, ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(75)
template <typename TValue, typename TID> bool operator<(const ScoreAndID<TValue,TID> & a, const ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(82)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator< (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1131)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator< (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1140)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator< (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1148)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSource, typename TSpec> inline TStream & operator<< (TStream & target, Align<TSource, TSpec> const & source);       	// "projects/library/seqan/align/align_base.h"(464)
template <typename TStream, typename TSource, typename TSpec> inline TStream & operator<< (TStream & target, Gaps<TSource, TSpec> const & source);       	// "projects/library/seqan/align/gaps_base.h"(1046)

//____________________________________________________________________________
// operator<=

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator<= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1160)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator<= (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1169)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator<= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1177)

//____________________________________________________________________________
// operator==

inline bool operator== (_HirschbergSet const & lhs, _HirschbergSet const & rhs);       	// "projects/library/seqan/align/hirschberg_set.h"(287)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(226)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(234)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(242)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(250)
template <typename TAlign> inline bool operator==(AlignCols<TAlign> const & left, AlignCols<TAlign> const & right);       	// "projects/library/seqan/align/align_cols_base.h"(420)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SequenceGaps> > & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > & _right);       	// "projects/library/seqan/align/gaps_simple.h"(805)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SequenceGaps> > const & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > & _right);       	// "projects/library/seqan/align/gaps_simple.h"(813)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SequenceGaps> > & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > const & _right);       	// "projects/library/seqan/align/gaps_simple.h"(821)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SequenceGaps> > const & _left, Iter<TGaps2, GapsIterator<SequenceGaps> > const & _right);       	// "projects/library/seqan/align/gaps_simple.h"(829)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(938)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(946)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(954)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<ArrayGaps> > const & _left, Iter<TGaps2, GapsIterator<ArrayGaps> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(962)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(809)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(817)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(825)
template <typename TGaps1, typename TGaps2> inline bool operator== (Iter<TGaps1, GapsIterator<SumlistGaps> > const & _left, Iter<TGaps2, GapsIterator<SumlistGaps> > const & _right);       	// "projects/library/seqan/align/gaps_sumlist.h"(833)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator== (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1072)
template <typename TLeftSource, typename TLeftSpec, typename TRight > inline bool operator== (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1081)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator== (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1090)

//____________________________________________________________________________
// operator>

template <typename TValue, typename TID> bool operator>(ScoreAndID<TValue,TID> & a, ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(59)
template <typename TValue, typename TID> bool operator>(const ScoreAndID<TValue,TID> & a, const ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(66)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator> (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1188)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator> (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1197)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator> (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1205)

//____________________________________________________________________________
// operator>=

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator>= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1216)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator>= (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1225)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator>= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1233)

//____________________________________________________________________________
// previousPosition

template <typename TValue, typename TPosition> inline typename Position<Matrix <TValue, NDimensional> >::Type previousPosition(Matrix<TValue, NDimensional> & me, TPosition position_, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(265)

//____________________________________________________________________________
// removeGap

template <typename TGaps, typename TSpec> inline void removeGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(149)
template <typename TSource, typename TSpec, typename TPosition> inline void removeGap(Gaps<TSource, TSpec> & me, TPosition _view_pos);       	// "projects/library/seqan/align/gaps_base.h"(428)

//____________________________________________________________________________
// removeGaps

template <typename TGaps, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<SequenceGaps> > const & me, TCount _size);       	// "projects/library/seqan/align/gaps_simple.h"(772)
template <typename TGaps, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<ArrayGaps> > const & me, TCount _size);       	// "projects/library/seqan/align/gaps_array.h"(883)
template <typename TGaps, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<SumlistGaps> > const & me, TCount _size);       	// "projects/library/seqan/align/gaps_sumlist.h"(764)
template <typename TSource, typename TSpec, typename TPosition, typename TSize> inline void removeGaps(Gaps<TSource, TSpec> & me, TPosition _view_pos, TSize _size);       	// "projects/library/seqan/align/gaps_base.h"(456)

//____________________________________________________________________________
// resize

template <typename TValue> inline void resize(Matrix<TValue, NDimensional> & me);       	// "projects/library/seqan/align/matrix_base.h"(227)

//____________________________________________________________________________
// row

template <typename TSource, typename TSpec, typename TPosition> inline typename Row< Align<TSource, TSpec> >::Type & row(Align<TSource, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(283)
template <typename TSource, typename TSpec, typename TPosition> inline typename Row< Align<TSource, TSpec> const>::Type & row(Align<TSource, TSpec> const & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(291)

//____________________________________________________________________________
// rows

template <typename TSource, typename TSpec> inline typename Rows< Align<TSource, TSpec> >::Type & rows(Align<TSource, TSpec> & me);       	// "projects/library/seqan/align/align_base.h"(250)
template <typename TSource, typename TSpec> inline typename Rows< Align<TSource, TSpec> const >::Type & rows(Align<TSource, TSpec> const & me);       	// "projects/library/seqan/align/align_base.h"(257)

//____________________________________________________________________________
// setBeginPosition

template <typename TSource, typename TPosition> inline void setBeginPosition(Gaps<TSource, SequenceGaps> & me, TPosition view_position);       	// "projects/library/seqan/align/gaps_simple.h"(478)
template <typename TSource, typename TPosition> inline void setBeginPosition(Gaps<TSource, ArrayGaps> & me, TPosition view_position);       	// "projects/library/seqan/align/gaps_array.h"(456)
template <typename TSource, typename TPosition> inline void setBeginPosition(Gaps<TSource, SumlistGaps> & me, TPosition view_position);       	// "projects/library/seqan/align/gaps_sumlist.h"(381)

//____________________________________________________________________________
// setBit

template <typename TSize, typename TSpec, typename TSpec2> inline void setBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(279)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename TSpec> inline void setContainer(Navi<TContainer, TSpec> & me, TContainer & container_);       	// "projects/library/seqan/align/align_trace.h"(260)

//____________________________________________________________________________
// setDimension

template <typename TValue> inline void setDimension(Matrix<TValue, NDimensional> & me, unsigned int dim_);       	// "projects/library/seqan/align/matrix_base.h"(182)
template <typename TSize, typename TSpec> inline unsigned int setDimension(AlignTrace<TSize, TSpec> & me, unsigned int _dim);       	// "projects/library/seqan/align/align_trace.h"(70)

//____________________________________________________________________________
// setHost

template <typename TAlign, typename TSpec> inline void setHost(Iter<TAlign, AlignColIterator<TSpec> > & me, TAlign & _host);       	// "projects/library/seqan/align/align_iterator_base.h"(112)

//____________________________________________________________________________
// setLength

template <typename TValue, typename TSize> inline void setLength(Matrix<TValue, NDimensional> & me, unsigned int dim_, TSize length_);       	// "projects/library/seqan/align/matrix_base.h"(215)
template <typename TSize, typename TSpec> inline void setLength(AlignTrace<TSize, TSpec> & me, unsigned int _dim, TSize _length);       	// "projects/library/seqan/align/align_trace.h"(91)

//____________________________________________________________________________
// setSource

template <typename TSource, typename TSpec, typename TPosition1, typename TPosition2> inline void setSource(Gaps<TSource, TSpec> & me, TSource & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_base.h"(753)
template <typename TSource, typename TSpec> inline void setSource(Gaps<TSource, TSpec> & me, TSource & source_);       	// "projects/library/seqan/align/gaps_base.h"(767)

//____________________________________________________________________________
// setSourceBeginPosition

template <typename TSource, typename TPosition> inline void setSourceBeginPosition(Gaps<TSource, SequenceGaps> & , TPosition );       	// "projects/library/seqan/align/gaps_simple.h"(492)
template <typename TSource, typename TPosition> inline void setSourceBeginPosition(Gaps<TSource, ArrayGaps> & me, TPosition source_position);       	// "projects/library/seqan/align/gaps_array.h"(473)
template <typename TSource, typename TPosition> inline typename Size< Gaps<TSource, SumlistGaps> >::Type setSourceBeginPosition(Gaps<TSource, SumlistGaps> & me, TPosition source_position);       	// "projects/library/seqan/align/gaps_sumlist.h"(399)

//____________________________________________________________________________
// setSourceEndPosition

template <typename TSource, typename TPosition> inline void setSourceEndPosition(Gaps<TSource, SequenceGaps> & , TPosition );       	// "projects/library/seqan/align/gaps_simple.h"(506)
template <typename TSource, typename TPosition> inline void setSourceEndPosition(Gaps<TSource, ArrayGaps> & me, TPosition source_position);       	// "projects/library/seqan/align/gaps_array.h"(540)
template <typename TSource, typename TPosition> inline void setSourceEndPosition(Gaps<TSource, SumlistGaps> & me, TPosition source_position);       	// "projects/library/seqan/align/gaps_sumlist.h"(457)

//____________________________________________________________________________
// setStrings

template <typename TSource, typename TSpec, typename TString, typename TSpec2> inline void setStrings(Align<TSource, TSpec> & me, StringSet<TString, TSpec2> & stringset);       	// "projects/library/seqan/align/align_base.h"(501)

//____________________________________________________________________________
// smithWaterman

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue smithWaterman(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue> & sw_finder , Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(658)

//____________________________________________________________________________
// smithWatermanGetNext

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue smithWatermanGetNext(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue> & sw_finder , Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(710)

//____________________________________________________________________________
// smith_waterman_declump

template <typename TScoreValue, typename TSource, typename TSpec> void smith_waterman_declump(LocalAlignmentFinder<TScoreValue> & sw , Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_local_dynprog.h"(286)

//____________________________________________________________________________
// smith_waterman_get_matrix

template <typename TScoreValue, typename TString> TScoreValue smith_waterman_get_matrix(LocalAlignmentFinder<TScoreValue> & sw, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(174)

//____________________________________________________________________________
// smith_waterman_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> typename Iterator<Matrix<TScoreValue, TSourceSpec>, Standard >::Type smith_waterman_trace(Align<TTargetSource, TTargetSpec> & target_, typename LocalAlignmentFinder<TScoreValue>::TBoolMatrix & fb_matrix, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const &);       	// "projects/library/seqan/align/align_local_dynprog.h"(489)

//____________________________________________________________________________
// source

template <typename TGaps, typename TSpec> inline typename Source<Iter<TGaps, GapsIterator<TSpec> > >::Type source(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(250)
template <typename TGaps, typename TSpec> inline typename Source<Iter<TGaps, GapsIterator<TSpec> > const>::Type source(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(257)
template <typename TSource> inline typename GetSource< Gaps<TSource, SequenceGaps> >::Type source(Gaps<TSource, SequenceGaps> & me);       	// "projects/library/seqan/align/gaps_simple.h"(209)
template <typename TSource> inline typename GetSource< Gaps<TSource, SequenceGaps> const >::Type source(Gaps<TSource, SequenceGaps> const & me);       	// "projects/library/seqan/align/gaps_simple.h"(216)
template <typename TSource, typename TSpec> inline TSource & source(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(832)
template <typename TSource, typename TSpec> inline TSource & source(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(839)

//____________________________________________________________________________
// sourceBegin

template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<TSource, Tag<TTag> const>::Type sourceBegin(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(319)
template <typename TSource, typename TSpec> inline typename Iterator<TSource, typename DefaultGetIteratorSpec<TSource>::Type>::Type sourceBegin(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(326)

//____________________________________________________________________________
// sourceBeginPosition

template <typename TSource> inline typename Position<TSource>::Type sourceBeginPosition(Gaps<TSource, SequenceGaps> const & me);       	// "projects/library/seqan/align/gaps_simple.h"(323)
template <typename TSource> inline typename Position<TSource>::Type sourceBeginPosition(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(202)
template <typename TSource> inline typename Position<TSource>::Type sourceBeginPosition(Gaps<TSource, SumlistGaps> const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(206)

//____________________________________________________________________________
// sourceEnd

template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<TSource, Tag<TTag> const>::Type sourceEnd(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(353)
template <typename TSource, typename TSpec> inline typename Iterator<TSource, typename DefaultGetIteratorSpec<TSource>::Type>::Type sourceEnd(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(360)

//____________________________________________________________________________
// sourceEndPosition

template <typename TSource> inline typename Position<TSource>::Type sourceEndPosition(Gaps<TSource, SequenceGaps> const & me);       	// "projects/library/seqan/align/gaps_simple.h"(333)
template <typename TSource> inline typename Position<TSource>::Type sourceEndPosition(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(222)
template <typename TSource> inline typename Position<TSource>::Type sourceEndPosition(Gaps<TSource, SumlistGaps> const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(226)

//____________________________________________________________________________
// sourceLength

template <typename TSource> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(589)
template <typename TSource, typename TSpec> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(894)
template <typename TSource, typename TSpec> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(901)

//____________________________________________________________________________
// sourcePosition

template <typename TGaps> inline typename Position<TGaps>::Type sourcePosition(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(621)
template <typename TGaps> inline typename Position<TGaps>::Type sourcePosition(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(607)

//____________________________________________________________________________
// sourceSegment

template <typename TSource> inline typename GetSource< Gaps<TSource, SequenceGaps> >::Type sourceSegment(Gaps<TSource, SequenceGaps> & me);       	// "projects/library/seqan/align/gaps_simple.h"(226)
template <typename TSource> inline typename GetSource< Gaps<TSource, SequenceGaps> const >::Type sourceSegment(Gaps<TSource, SequenceGaps> const & me);       	// "projects/library/seqan/align/gaps_simple.h"(233)
template <typename TSource, typename TSpec> inline typename Infix<TSource>::Type sourceSegment(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(863)
template <typename TSource, typename TSpec> inline typename Infix<TSource>::Type sourceSegment(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(871)

//____________________________________________________________________________
// toSourcePosition

template <typename TSource> inline typename Position<TSource>::Type toSourcePosition(Gaps<TSource, SequenceGaps> const & me, typename Position< Gaps<TSource, SequenceGaps> >::Type pos);       	// "projects/library/seqan/align/gaps_simple.h"(411)
template <typename TSource> inline typename Position<TSource>::Type toSourcePosition(Gaps<TSource, ArrayGaps> const & gaps, typename Position< Gaps<TSource, ArrayGaps> >::Type pos);       	// "projects/library/seqan/align/gaps_array.h"(316)
template <typename TSource> inline typename Position<TSource>::Type toSourcePosition(Gaps<TSource, SumlistGaps> const & gaps, typename Position< Gaps<TSource, SumlistGaps> >::Type pos);       	// "projects/library/seqan/align/gaps_sumlist.h"(313)

//____________________________________________________________________________
// toViewPosition

template <typename TSource> inline typename Position< Gaps<TSource, SequenceGaps> >::Type toViewPosition(Gaps<TSource, SequenceGaps> const & me, typename Position<TSource>::Type pos);       	// "projects/library/seqan/align/gaps_simple.h"(376)
template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> >::Type toViewPosition(Gaps<TSource, ArrayGaps> const & gaps, typename Position<TSource>::Type pos);       	// "projects/library/seqan/align/gaps_array.h"(279)
template <typename TSource> inline typename Position< Gaps<TSource, SumlistGaps> >::Type toViewPosition(Gaps<TSource, SumlistGaps> const & gaps, typename Position<TSource>::Type pos);       	// "projects/library/seqan/align/gaps_sumlist.h"(287)

//____________________________________________________________________________
// value

template <typename TAlign, typename TSpec, typename TPosition> inline typename Reference<TAlign>::Type value(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(296)
template <typename TAlign, typename TSpec, typename TPosition> inline typename Reference<TAlign>::Type value(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(304)
template <typename TGaps, typename TSpec> inline typename Reference< Iter<TGaps, GapsIterator<TSpec> > >::Type value(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(160)
template <typename TGaps, typename TSpec> inline typename Reference< Iter<TGaps, GapsIterator<TSpec> > const>::Type value(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(168)
template <typename TValue, typename TPosition> inline typename Reference<Matrix<TValue, NDimensional> >::Type value(Matrix<TValue, NDimensional> & me, TPosition position_);       	// "projects/library/seqan/align/matrix_base.h"(329)
template <typename TAlign, typename TPosition> inline typename Value< AlignCols<TAlign> >::Type value(AlignCols<TAlign> & me, TPosition _pos);       	// "projects/library/seqan/align/align_cols_base.h"(261)
template <typename TAlign, typename TPosition> inline typename Value< AlignCols<TAlign> const>::Type value(AlignCols<TAlign> const & me, TPosition _pos);       	// "projects/library/seqan/align/align_cols_base.h"(269)
template <typename TSource, typename TSpec, typename TPosition> inline typename Reference<Gaps<TSource, TSpec> >::Type value(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(648)
template <typename TSource, typename TSpec, typename TPosition> inline typename Reference<Gaps<TSource, TSpec> const>::Type value(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(657)

//____________________________________________________________________________
// viewPosition

template <typename TGaps> inline typename Position<TGaps>::Type viewPosition(Iter<TGaps, GapsIterator<SequenceGaps> > const & me);       	// "projects/library/seqan/align/gaps_simple.h"(607)
template <typename TGaps> inline typename Position<TGaps>::Type viewPosition(Iter<TGaps, GapsIterator<SumlistGaps> > const & me);       	// "projects/library/seqan/align/gaps_sumlist.h"(597)

//____________________________________________________________________________
// write

template <typename TFile, typename TSource, typename TSpec, typename TIDString> inline void write(TFile & target, Align<TSource, TSpec> const & source, TIDString const &, Raw);       	// "projects/library/seqan/align/align_base.h"(389)
template <typename TFile, typename TSource, typename TIDString, typename TSpec> inline void write(TFile & target, Gaps<TSource, TSpec> const & source, TIDString const &, Raw);       	// "projects/library/seqan/align/gaps_base.h"(1022)

//____________________________________________________________________________
// write_debug_matrix

template <typename TSource> void write_debug_matrix(TSource s1,TSource s2);       	// "projects/library/seqan/align/align_myers.h"(37)
template <typename TSource> void write_debug_matrix(TSource s1,TSource s2);       	// "projects/library/seqan/align/align_hirschberg.h"(15)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

