#include <iostream>
#include <seqan/index.h>

using namespace std;
using namespace seqan;

template <typename TSpec>
void testPizzaChili() {
    typedef Index<String<char>, PizzaChili<TSpec> > index_t;
    index_t index_pc;
    indexText(index_pc) = "This is the best test with a bast jest.";

    cout << indexText(index_pc) << endl;

    Finder<index_t> finder(index_pc);
    while (find(finder, "est"))
        cout << "Hit at position " << position(finder) << endl;

    typename Fibre<index_t, PizzaChili_Text>::Type text = indexText(index_pc);
    cout << "infix(text, 12, 21): " << infix(text, 12, 21) << endl;

    save(index_pc, "pizzachili");
    index_t index2;
    open(index2, "pizzachili");
    cout << indexText(index2) << endl;
}

int main() {
    cout << "Test the alphabet-friendly FM index:" << endl;
    testPizzaChili<PizzaChili_AF>();
    cout << endl << "Test the compressed compact suffix array index:" << endl;
    testPizzaChili<PizzaChili_CCSA>();
    return 0;
}
