#include <iostream>
#include <seqan/sequence.h>
#include <seqan/file.h>

int main()
{
	seqan::String<char> str = "admn";
	seqan::Iterator<seqan::String<char> >::Type it = begin(str);

	std::cout << *it;                //output: 'a'
	while (it != end(str))           //output: "admn"
	{
		std::cout << *it;
		++it;
	}
	std::cout << std::endl;
	seqan::Iterator<seqan::String<char>, seqan::Rooted >::Type it2 = begin(str);
	for (goBegin(it2); !atEnd(it2); goNext(it2)) 
	{
		++value(it2);
	}
	goEnd(it2);

	while (!atBegin(it2))              //output: "oneb"
	{
		goPrevious(it2);
		std::cout << getValue(it2);
	}
	std::cout << std::endl;
	assignValue(begin(str), 'X');

	std::cout << str << std::endl;        //output: "Xeno"
	

	return 0;
}
