#include <iostream>
#include <seqan/index.h>

using namespace std;
using namespace seqan;

int main ()
{
	String<char> myString = "How many wood would a woodchuck chuck.";

	typedef Index< String<char> > TMyIndex;
	TMyIndex myIndex(myString);

	typedef Iterator< TMyIndex, MaxRepeats >::Type TMaxRepeatIterator;
	TMaxRepeatIterator myRepeatIterator(myIndex, 3);

	while (!atEnd(myRepeatIterator)) 
	{
		Iterator<TMaxRepeatIterator>::Type myRepeatPair(myRepeatIterator);
		while (!atEnd(myRepeatPair)) {
			cout << *myRepeatPair << ", ";
			++myRepeatPair;
		}

		cout << repLength(myRepeatIterator) << "   ";

		cout << "\t\"" << representative(myRepeatIterator) << '\"' << endl;

		++myRepeatIterator;
	}

	return 0;
}
