#include <iostream>
#include <seqan/find.h>

using namespace seqan;
using namespace std;

int main() 
{
	String<char> haystk("AACTTAACCTAA");
	String<char> ndl("CCT");

	Finder<String<char> > fnd(haystk);
	Pattern<String<char>, MyersUkkonen> pat(ndl);
	setScoreLimit(pat, -1);
	while (find(fnd, pat))
	{
		cout << position(fnd) << ": " << getScore(pat) << "\n";
	}

	return 0;
}

