 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_PIPE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_PIPE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AbstractSource

template <typename TValue, typename TSize > struct AbstractSource;       	// "projects/library/seqan/pipe/pipe_base.h"(210)

//____________________________________________________________________________
// AdapterSpec

struct AdapterSpec;       	// "projects/library/seqan/pipe/pipe_base.h"(569)

//____________________________________________________________________________
// AdaptorCompare2Less

template <typename TCompare > struct AdaptorCompare2Less;       	// "projects/library/seqan/pipe/pool_sorter.h"(47)

//____________________________________________________________________________
// BufReadHandler

template <typename TInput > struct BufReadHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(560)

//____________________________________________________________________________
// BufWriteHandler

template <typename TOutput > struct BufWriteHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(563)

//____________________________________________________________________________
// BufferHandler

template <typename TObject, typename TSpec > struct BufferHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(553)

//____________________________________________________________________________
// Bundle2

template <typename TInput1, typename TInput2 > struct Bundle2;       	// "projects/library/seqan/pipe/pipe_base.h"(78)

//____________________________________________________________________________
// Bundle3

template <typename TInput1, typename TInput2, typename TInput3 > struct Bundle3;       	// "projects/library/seqan/pipe/pipe_base.h"(123)

//____________________________________________________________________________
// Bundle5

template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > struct Bundle5;       	// "projects/library/seqan/pipe/pipe_base.h"(179)

//____________________________________________________________________________
// Caster

template <typename TValue > struct Caster;       	// "projects/library/seqan/pipe/pipe_caster.h"(31)

//____________________________________________________________________________
// ContainerBuffer

template <typename TContainer > struct ContainerBuffer;       	// "projects/library/seqan/pipe/pipe_source.h"(93)

//____________________________________________________________________________
// Counter

struct Counter;       	// "projects/library/seqan/pipe/pipe_counter.h"(30)

//____________________________________________________________________________
// Echoer

template <unsigned echoRepeats, bool omitFirst > struct Echoer;       	// "projects/library/seqan/pipe/pipe_echoer.h"(55)

//____________________________________________________________________________
// EditEnvironment

template <typename TDistanceSpec, unsigned STEP_SIZE > struct EditEnvironment;       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(31)

//____________________________________________________________________________
// Filter

template <typename TFunctor > struct Filter;       	// "projects/library/seqan/pipe/pipe_filter.h"(47)

//____________________________________________________________________________
// Handler

template <typename TObject, typename TSpec > struct Handler;       	// "projects/library/seqan/pipe/pipe_base.h"(556)

//____________________________________________________________________________
// HandlerArgs

template <typename TPool > struct HandlerArgs;       	// "projects/library/seqan/pipe/pool_base.h"(603)

//____________________________________________________________________________
// IPipeIterator

template <typename TInput> struct IPipeIterator;       	// "projects/library/seqan/pipe/pipe_iterator.h"(36)

//____________________________________________________________________________
// IteratorBuffer

template <typename TIterator > struct IteratorBuffer;       	// "projects/library/seqan/pipe/pipe_source.h"(133)

//____________________________________________________________________________
// Joiner

struct Joiner;       	// "projects/library/seqan/pipe/pipe_joiner.h"(30)

//____________________________________________________________________________
// MapperAsyncWriter

struct MapperAsyncWriter;       	// "projects/library/seqan/pipe/pool_mapper.h"(387)

//____________________________________________________________________________
// MapperConfig

template <typename TMap, typename TFile > struct MapperConfig;       	// "projects/library/seqan/pipe/pool_mapper.h"(70)

//____________________________________________________________________________
// MapperConfigSize

template <typename TMap, typename TSize, typename TFile > struct MapperConfigSize;       	// "projects/library/seqan/pipe/pool_mapper.h"(47)

//____________________________________________________________________________
// MapperMemAdapter

struct MapperMemAdapter;       	// "projects/library/seqan/pipe/pool_mapper.h"(256)

//____________________________________________________________________________
// MapperSpec

template <typename TConfig > struct MapperSpec;       	// "projects/library/seqan/pipe/pool_mapper.h"(90)

//____________________________________________________________________________
// MapperSyncWriter

struct MapperSyncWriter;       	// "projects/library/seqan/pipe/pool_mapper.h"(297)

//____________________________________________________________________________
// MergeStreamComparer

template <typename TValue, typename Compare > struct MergeStreamComparer;       	// "projects/library/seqan/pipe/pool_sorter.h"(31)

//____________________________________________________________________________
// Multi

template <typename TSpec, typename TPair, typename TLimitsString> struct Multi;       	// "projects/library/seqan/pipe/pipe_base.h"(59)

//____________________________________________________________________________
// Namer

template <typename TCompare > struct Namer;       	// "projects/library/seqan/pipe/pipe_namer.h"(31)

//____________________________________________________________________________
// OPipeIterator

template <typename TOutput> struct OPipeIterator;       	// "projects/library/seqan/pipe/pipe_iterator.h"(122)

//____________________________________________________________________________
// Pipe

template <typename TInput, typename TSpec > struct Pipe;       	// "projects/library/seqan/pipe/pipe_base.h"(50)

//____________________________________________________________________________
// Pool

template <typename TValue, typename TSpec > struct Pool;       	// "projects/library/seqan/pipe/pool_base.h"(96)
template <typename TValue, typename TSpec > struct Pool;       	// "projects/library/seqan/pipe/pool_base.h"(614)

//____________________________________________________________________________
// PoolConfig

template <typename TFile > struct PoolConfig;       	// "projects/library/seqan/pipe/pool_base.h"(59)

//____________________________________________________________________________
// PoolConfigSize

template <typename TSize, typename TFile > struct PoolConfigSize;       	// "projects/library/seqan/pipe/pool_base.h"(41)

//____________________________________________________________________________
// PoolParameters

struct PoolParameters;       	// "projects/library/seqan/pipe/pool_base.h"(100)

//____________________________________________________________________________
// PoolSpec

template <typename TConfig > struct PoolSpec;       	// "projects/library/seqan/pipe/pool_base.h"(78)

//____________________________________________________________________________
// ReadHandler

template <typename TInput > struct ReadHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(635)

//____________________________________________________________________________
// Sampler

template <unsigned m, typename TCompression > struct Sampler;       	// "projects/library/seqan/pipe/pipe_sampler.h"(36)

//____________________________________________________________________________
// Shifter

template <int delta, bool omitBlank , bool _echoing > struct Shifter;       	// "projects/library/seqan/pipe/pipe_shifter.h"(33)

//____________________________________________________________________________
// SorterConfig

template <typename TCompare, typename TFile > struct SorterConfig;       	// "projects/library/seqan/pipe/pool_sorter.h"(98)

//____________________________________________________________________________
// SorterConfigSize

template <typename TCompare, typename TSize, typename TFile > struct SorterConfigSize;       	// "projects/library/seqan/pipe/pool_sorter.h"(75)

//____________________________________________________________________________
// SorterSpec

template <typename TConfig > struct SorterSpec;       	// "projects/library/seqan/pipe/pool_sorter.h"(119)

//____________________________________________________________________________
// Source

template <typename TSpec > struct Source;       	// "projects/library/seqan/pipe/pipe_source.h"(28)
template <typename T> struct Source;       	// "projects/library/seqan/pipe/pipe_base.h"(269)

//____________________________________________________________________________
// Tupler

template <unsigned tupleLen, bool omitLast , typename TCompression > struct Tupler;       	// "projects/library/seqan/pipe/pipe_tupler.h"(33)

//____________________________________________________________________________
// WriteHandler

template <typename TOutput > struct WriteHandler;       	// "projects/library/seqan/pipe/pipe_base.h"(641)

//____________________________________________________________________________
// _ControlBeginRead

struct _ControlBeginRead;       	// "projects/library/seqan/pipe/pipe_base.h"(408)

//____________________________________________________________________________
// _ControlClear

struct _ControlClear;       	// "projects/library/seqan/pipe/pipe_base.h"(407)

//____________________________________________________________________________
// _ControlEndRead

struct _ControlEndRead;       	// "projects/library/seqan/pipe/pipe_base.h"(409)

//____________________________________________________________________________
// _ControlEof

struct _ControlEof;       	// "projects/library/seqan/pipe/pipe_base.h"(405)

//____________________________________________________________________________
// _ControlEos

struct _ControlEos;       	// "projects/library/seqan/pipe/pipe_base.h"(406)

//____________________________________________________________________________
// _EchoerClearWorker

struct _EchoerClearWorker;       	// "projects/library/seqan/pipe/pipe_echoer.h"(39)

//____________________________________________________________________________
// _EchoerFillWorker

struct _EchoerFillWorker;       	// "projects/library/seqan/pipe/pipe_echoer.h"(32)

//____________________________________________________________________________
// _EchoerShiftWorker

struct _EchoerShiftWorker;       	// "projects/library/seqan/pipe/pipe_echoer.h"(46)

//____________________________________________________________________________
// _ExtStringSourceCachingSpec

struct _ExtStringSourceCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(268)

//____________________________________________________________________________
// _MemorySpec

struct _MemorySpec;       	// "projects/library/seqan/pipe/pool_base.h"(170)

//____________________________________________________________________________
// _MultiplexSpec

struct _MultiplexSpec;       	// "projects/library/seqan/pipe/pool_base.h"(443)

//____________________________________________________________________________
// _PairDecrementer

template <typename TPair, typename TLimits, unsigned m > struct _PairDecrementer;       	// "projects/library/seqan/pipe/pipe_base.h"(717)

//____________________________________________________________________________
// _PairIncrementer

template <typename TPair, typename TLimits> struct _PairIncrementer;       	// "projects/library/seqan/pipe/pipe_base.h"(653)

//____________________________________________________________________________
// _ReadFileSpec

struct _ReadFileSpec;       	// "projects/library/seqan/pipe/pool_base.h"(210)

//____________________________________________________________________________
// _ReadMapperSpec

struct _ReadMapperSpec;       	// "projects/library/seqan/pipe/pool_mapper.h"(101)

//____________________________________________________________________________
// _ReadSorterSpec

struct _ReadSorterSpec;       	// "projects/library/seqan/pipe/pool_sorter.h"(133)

//____________________________________________________________________________
// _ShiftLeftWorker

struct _ShiftLeftWorker;       	// "projects/library/seqan/pipe/pipe_tupler.h"(70)

//____________________________________________________________________________
// _SkewDC

template <int I, typename T > struct _SkewDC;       	// "projects/library/seqan/pipe/pipe_sampler.h"(31)

//____________________________________________________________________________
// _SourceCachingSpec

struct _SourceCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(209)

//____________________________________________________________________________
// _SourceNonCachingSpec

struct _SourceNonCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(170)

//____________________________________________________________________________
// _TuplerLastTuples

template <typename TTupler > struct _TuplerLastTuples;       	// "projects/library/seqan/pipe/pipe_tupler.h"(60)

//____________________________________________________________________________
// _WriteFileSpec

struct _WriteFileSpec;       	// "projects/library/seqan/pipe/pool_base.h"(328)

//____________________________________________________________________________
// filterI1

template <typename InType, typename Result > struct filterI1;       	// "projects/library/seqan/pipe/pipe_filter.h"(31)

//____________________________________________________________________________
// filterI2

template <typename InType, typename Result > struct filterI2;       	// "projects/library/seqan/pipe/pipe_filter.h"(36)

//____________________________________________________________________________
// filterI3

template <typename InType, typename Result > struct filterI3;       	// "projects/library/seqan/pipe/pipe_filter.h"(41)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ControlBeginRead

typedef Tag<_ControlBeginRead> ControlBeginRead;       	// "projects/library/seqan/pipe/pipe_base.h"(414)

//____________________________________________________________________________
// ControlClear

typedef Tag<_ControlClear> ControlClear;       	// "projects/library/seqan/pipe/pipe_base.h"(413)

//____________________________________________________________________________
// ControlEndRead

typedef Tag<_ControlEndRead> ControlEndRead;       	// "projects/library/seqan/pipe/pipe_base.h"(415)

//____________________________________________________________________________
// ControlEof

typedef Tag<_ControlEof> ControlEof;       	// "projects/library/seqan/pipe/pipe_base.h"(411)

//____________________________________________________________________________
// ControlEos

typedef Tag<_ControlEos> ControlEos;       	// "projects/library/seqan/pipe/pipe_base.h"(412)

//____________________________________________________________________________
// ExtStringSourceCachingSpec

typedef Tag<_ExtStringSourceCachingSpec> ExtStringSourceCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(269)

//____________________________________________________________________________
// MemorySpec

typedef Tag<_MemorySpec> MemorySpec;       	// "projects/library/seqan/pipe/pool_base.h"(171)

//____________________________________________________________________________
// MultiplexSpec

typedef Tag<_MultiplexSpec> MultiplexSpec;       	// "projects/library/seqan/pipe/pool_base.h"(444)

//____________________________________________________________________________
// ReadFileSpec

typedef Tag<_ReadFileSpec> ReadFileSpec;       	// "projects/library/seqan/pipe/pool_base.h"(211)

//____________________________________________________________________________
// ReadMapperSpec

typedef Tag<_ReadMapperSpec> ReadMapperSpec;       	// "projects/library/seqan/pipe/pool_mapper.h"(102)

//____________________________________________________________________________
// ReadSorterSpec

typedef Tag<_ReadSorterSpec> ReadSorterSpec;       	// "projects/library/seqan/pipe/pool_sorter.h"(134)

//____________________________________________________________________________
// SourceCachingSpec

typedef Tag<_SourceCachingSpec> SourceCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(210)

//____________________________________________________________________________
// SourceNonCachingSpec

typedef Tag<_SourceNonCachingSpec> SourceNonCachingSpec;       	// "projects/library/seqan/pipe/pipe_source.h"(171)

//____________________________________________________________________________
// WriteFileSpec

typedef Tag<_WriteFileSpec> WriteFileSpec;       	// "projects/library/seqan/pipe/pool_base.h"(329)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// append

template <typename TValue, typename TSpec, typename TSource > inline bool append(Pool<TValue, TSpec> &dest, TSource &src);       	// "projects/library/seqan/pipe/pool_base.h"(1159)
template <typename TValue, typename TSpec, typename TStringSpec > inline bool append(Pool<TValue, TSpec> &dest, String<TValue, TStringSpec> &src);       	// "projects/library/seqan/pipe/pool_base.h"(1175)

//____________________________________________________________________________
// assign

template <typename TValue, typename TSpec, typename TSource > inline bool assign(Pool<TValue, TSpec> &dest, TSource &src);       	// "projects/library/seqan/pipe/pool_base.h"(1191)
template <typename TValue1, typename TStringSpec, typename TValue2, typename TSpec > inline bool assign(String<TValue1, TStringSpec> &dest, Pool<TValue2, TSpec> &src);       	// "projects/library/seqan/pipe/pool_base.h"(1213)
template <typename TValue, typename TStringSpec, typename TInput, typename TSpec > inline bool assign(String<TValue, TStringSpec> &dest, Pipe<TInput, TSpec> &src);       	// "projects/library/seqan/pipe/pipe_base.h"(515)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSpec > OPipeIterator< Pool< TValue, TSpec > > begin(Pool< TValue, TSpec > &pool);       	// "projects/library/seqan/pipe/pool_base.h"(914)
template <typename TInput, typename TSpec > IPipeIterator< Pipe< TInput, TSpec > > begin(Pipe< TInput, TSpec > &pipe);       	// "projects/library/seqan/pipe/pipe_iterator.h"(222)
template <typename TInput, typename TSpec, typename TTag > inline typename Iterator< Pipe< TInput, Source<TSpec> >, Tag<TTag> const >::Type begin(Pipe< TInput, Source<TSpec> > &pipe, Tag<TTag> const);       	// "projects/library/seqan/pipe/pipe_source.h"(77)

//____________________________________________________________________________
// beginRead

template <typename TValue, typename TSpec > inline bool beginRead(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1142)
template <typename TInput, typename TSpec > inline bool beginRead(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(456)

//____________________________________________________________________________
// beginWrite

template <typename TValue, typename TSpec > inline bool beginWrite(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1111)

//____________________________________________________________________________
// bundle2

template <typename TInput1, typename TInput2 > inline Bundle2< TInput1, TInput2 > bundle2(TInput1 &_in1, TInput2 &_in2);       	// "projects/library/seqan/pipe/pipe_base.h"(98)

//____________________________________________________________________________
// bundle3

template <typename TInput1, typename TInput2, typename TInput3 > inline Bundle3< TInput1, TInput2, TInput3 > bundle3(TInput1 &_in1, TInput2 &_in2, TInput3 &_in3);       	// "projects/library/seqan/pipe/pipe_base.h"(146)

//____________________________________________________________________________
// bundle5

template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > inline Bundle5< TIn1, TIn2, TIn3, TIn4, TIn5 > bundle5(TIn1 &_in1, TIn2 &_in2, TIn3 &_in3, TIn4 &_in4, TIn5 &_in5);       	// "projects/library/seqan/pipe/pipe_base.h"(205)

//____________________________________________________________________________
// clear

template <typename TValue, typename TSpec > inline void clear(Pool<TValue, TSpec> &me);       	// "projects/library/seqan/pipe/pool_base.h"(979)
template <typename TInput, typename TSpec > inline bool clear(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(436)

//____________________________________________________________________________
// control

template <typename TInput > inline bool control(Pipe< TInput, Counter > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_counter.h"(81)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pool_base.h"(1072)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pool_base.h"(1077)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlClear const &);       	// "projects/library/seqan/pipe/pool_base.h"(1082)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlBeginRead const &);       	// "projects/library/seqan/pipe/pool_base.h"(1088)
template <typename TValue, typename TSpec > inline bool control(Pool< TValue, TSpec > &me, ControlEndRead const &);       	// "projects/library/seqan/pipe/pool_base.h"(1093)
template <typename TInput, typename TSpec, typename TCommand > inline bool control(Pipe< TInput, Source<TSpec> > &me, TCommand const &);       	// "projects/library/seqan/pipe/pipe_source.h"(360)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlBeginRead const &);       	// "projects/library/seqan/pipe/pipe_source.h"(365)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlEndRead const &);       	// "projects/library/seqan/pipe/pipe_source.h"(371)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_source.h"(377)
template <typename TInput, typename TSpec > inline bool control(Pipe< TInput, Source<TSpec> > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_source.h"(382)
template <typename TInput, typename TCompare > inline bool control(Pipe< TInput, Namer<TCompare> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_namer.h"(109)
template <typename TInput, unsigned m, typename TCompression > inline bool control(Pipe< TInput, Sampler<m, TCompression> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(261)
template <typename TInput, unsigned m, typename TCompression > inline bool control(Pipe< TInput, Sampler<m, TCompression> > &me, ControlEof const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(268)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline bool control(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(477)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline bool control(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > &me, ControlEof const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(484)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline bool control(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > &me, ControlEos const &command);       	// "projects/library/seqan/pipe/pipe_sampler.h"(489)
template <typename TInput, int delta, bool omitBlank > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, false > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_shifter.h"(112)
template <typename TInput, int delta, bool omitBlank > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, true > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_shifter.h"(122)
template <typename TInput, int delta, bool omitBlank, bool _echoing > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, _echoing > > &me, ControlEof const &command);       	// "projects/library/seqan/pipe/pipe_shifter.h"(139)
template <typename TInput, int delta, bool omitBlank, bool _echoing > inline bool control(Pipe< TInput, Shifter< delta, omitBlank, _echoing > > &me, ControlEos const &command);       	// "projects/library/seqan/pipe/pipe_shifter.h"(144)
template <typename TInput, unsigned echoRepeats, bool omitFirst > inline bool control(Pipe< TInput, Echoer< echoRepeats, omitFirst > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_echoer.h"(109)
template <typename TInput, unsigned echoRepeats > inline bool control(Pipe< TInput, Echoer< echoRepeats, true > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_echoer.h"(118)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<_HammingDistance>, STEP_SIZE > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(241)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<_LevenshteinDistance>, STEP_SIZE > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(256)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<_LevenshteinDistance>, STEP_SIZE > > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(285)
template <typename TInput, unsigned STEP_SIZE > inline bool control( Pipe< TInput, EditEnvironment< Tag<_LevenshteinDistance>, STEP_SIZE > > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(294)
template <typename TInput, typename TSpec, typename TCommand > inline bool control(Pipe<TInput, TSpec> &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(418)
template <typename TInput1, typename TInput2, typename TCommand > inline bool control(Bundle2<TInput1, TInput2> &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(482)
template <typename TInput1, typename TInput2, typename TInput3, typename TCommand > inline bool control(Bundle3<TInput1, TInput2, TInput3> &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(490)
template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5, typename TCommand > inline bool control(Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5 > &me, TCommand const &command);       	// "projects/library/seqan/pipe/pipe_base.h"(499)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline bool control( Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_tupler.h"(367)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline bool control( Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/pipe/pipe_tupler.h"(384)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline bool control( Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(397)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline bool control( Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > &me, ControlEof const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(412)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline bool control( Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(421)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline bool control( Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > &me, ControlEos const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(436)

//____________________________________________________________________________
// countSequences

template <typename TInput, typename TSpec > inline typename Size< Pipe<TInput, TSpec> >::Type countSequences(Pipe<TInput, TSpec> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(327)
template <typename TInput1, typename TInput2 > inline typename Size< Bundle2<TInput1, TInput2> >::Type countSequences(Bundle2<TInput1, TInput2> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(334)
template <typename TInput1, typename TInput2, typename TInput3 > inline typename Size< Bundle3<TInput1, TInput2, TInput3> >::Type countSequences(Bundle3<TInput1, TInput2, TInput3> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(341)
template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > inline typename Size< Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> >::Type countSequences(Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(348)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline unsigned countSequences(Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > const &);       	// "projects/library/seqan/pipe/pipe_tupler.h"(472)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline unsigned countSequences(Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > const &me);       	// "projects/library/seqan/pipe/pipe_tupler.h"(484)

//____________________________________________________________________________
// difference

template <typename TInput > inline typename Difference<TInput>::Type difference(IPipeIterator<TInput> first, IPipeIterator<TInput> last);       	// "projects/library/seqan/pipe/pipe_iterator.h"(235)
template <typename TOutput > inline typename Difference<TOutput>::Type difference(OPipeIterator<TOutput> first, OPipeIterator<TOutput> last);       	// "projects/library/seqan/pipe/pipe_iterator.h"(241)

//____________________________________________________________________________
// end

template <typename TValue, typename TSpec > OPipeIterator< Pool< TValue, TSpec > > end(Pool< TValue, TSpec > &pool);       	// "projects/library/seqan/pipe/pool_base.h"(920)
template <typename TInput, typename TSpec > IPipeIterator< Pipe< TInput, TSpec > > end(Pipe< TInput, TSpec > &pipe);       	// "projects/library/seqan/pipe/pipe_iterator.h"(228)
template <typename TInput, typename TSpec, typename TTag > inline typename Iterator< Pipe< TInput, Source<TSpec> >, Tag<TTag> const >::Type end(Pipe< TInput, Source<TSpec> > &pipe, Tag<TTag> const);       	// "projects/library/seqan/pipe/pipe_source.h"(83)

//____________________________________________________________________________
// endRead

template <typename TValue, typename TSpec > inline bool endRead(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1148)
template <typename TInput, typename TSpec > inline bool endRead(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(474)

//____________________________________________________________________________
// endWrite

template <typename TValue, typename TSpec > inline bool endWrite(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1129)

//____________________________________________________________________________
// eof

template <typename TValue, typename TSpec > inline bool eof(Pool< TValue, TSpec > &me);       	// "projects/library/seqan/pipe/pool_base.h"(1136)
template <typename TInput, typename TSpec > inline bool eof(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(424)

//____________________________________________________________________________
// eos

template <typename TInput, typename TSpec > inline bool eos(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(430)

//____________________________________________________________________________
// front

template <typename TValue, typename TSpec > inline typename Value< Pool<TValue, TSpec> >::Type const & front(Pool<TValue, TSpec> &me);       	// "projects/library/seqan/pipe/pool_base.h"(1012)
template <typename TInput, typename TSpec, typename TValue > inline Value< Pipe<TInput, TSpec> > const & front(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(367)

//____________________________________________________________________________
// length

template <typename TValue, typename TSpec > inline typename Size< Pool<TValue, TSpec> >::Type length(Pool<TValue, TSpec> const &me);       	// "projects/library/seqan/pipe/pool_base.h"(996)
template <typename TContainer > inline typename Size< ContainerBuffer<TContainer> >::Type length(ContainerBuffer<TContainer> const &me);       	// "projects/library/seqan/pipe/pipe_source.h"(121)
template <typename TIterator > inline typename Size< IteratorBuffer<TIterator> >::Type length(IteratorBuffer<TIterator> const &me);       	// "projects/library/seqan/pipe/pipe_source.h"(163)
template <typename TInput, typename TSpec > inline typename Size< Pipe< TInput, Source<TSpec> > >::Type length(Pipe< TInput, Source<TSpec> > const &me);       	// "projects/library/seqan/pipe/pipe_source.h"(388)
template <typename TInput, unsigned m, typename TCompression > inline typename Size< Pipe< TInput, Sampler<m, TCompression> > >::Type length(Pipe< TInput, Sampler<m, TCompression> > const &me);       	// "projects/library/seqan/pipe/pipe_sampler.h"(274)
template <typename TInput, unsigned m, typename TCompression, typename TPair, typename TLimitsString > inline typename Size< Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > >::Type length(Pipe< TInput, Multi<Sampler<m, TCompression>, TPair, TLimitsString> > const &me);       	// "projects/library/seqan/pipe/pipe_sampler.h"(496)
template <typename TInput, int delta, bool _echoing > inline Size< Pipe< TInput, Shifter< delta, true, _echoing > > > length(Pipe< TInput, Shifter< delta, true, _echoing > > const &me);       	// "projects/library/seqan/pipe/pipe_shifter.h"(134)
template <typename TInput, unsigned echoRepeats > inline Size< Pipe< TInput, Echoer< echoRepeats, true > > > length(Pipe< TInput, Echoer< echoRepeats, true > > const &me);       	// "projects/library/seqan/pipe/pipe_echoer.h"(128)
template <typename TInput, unsigned STEP_SIZE > inline typename Size< Pipe< TInput, Pipe< TInput, EditEnvironment< Tag<_HammingDistance>, STEP_SIZE > > > >::Type length(Pipe< TInput, EditEnvironment< Tag<_HammingDistance>, STEP_SIZE > > const &me);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(300)
template <typename TInput, unsigned STEP_SIZE > inline typename Size< Pipe< TInput, Pipe< TInput, EditEnvironment< Tag<_LevenshteinDistance>, STEP_SIZE > > > >::Type length(Pipe< TInput, EditEnvironment< Tag<_LevenshteinDistance>, STEP_SIZE > > const &me);       	// "projects/library/seqan/pipe/pipe_edit_environment.h"(315)
template <typename TInput, typename TSpec > inline typename Size< Pipe<TInput, TSpec> >::Type length(Pipe<TInput, TSpec> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(296)
template <typename TInput1, typename TInput2 > inline typename Size< Bundle2<TInput1, TInput2> >::Type length(Bundle2<TInput1, TInput2> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(303)
template <typename TInput1, typename TInput2, typename TInput3 > inline typename Size< Bundle3<TInput1, TInput2, TInput3> >::Type length(Bundle3<TInput1, TInput2, TInput3> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(310)
template <typename TIn1, typename TIn2, typename TIn3, typename TIn4, typename TIn5 > inline typename Size< Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> >::Type length(Bundle5<TIn1, TIn2, TIn3, TIn4, TIn5> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(317)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression > inline typename Size< Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > >::Type length(Pipe< TInput, Tupler< tupleLen, omitLast, TCompression > > const &me);       	// "projects/library/seqan/pipe/pipe_tupler.h"(443)
template <typename TInput, unsigned tupleLen, bool omitLast, typename TCompression, typename TPair, typename TLimitsString > inline typename Size< Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > >::Type length(Pipe< TInput, Multi<Tupler< tupleLen, omitLast, TCompression >, TPair, TLimitsString> > const &me);       	// "projects/library/seqan/pipe/pipe_tupler.h"(460)

//____________________________________________________________________________
// operator!=

template <typename TInput> bool operator!=(const IPipeIterator<TInput>& _Left, const IPipeIterator<TInput>& _Right);       	// "projects/library/seqan/pipe/pipe_iterator.h"(110)
template <typename TOutput> bool operator!=(const OPipeIterator<TOutput>& _Left, const OPipeIterator<TOutput>& _Right);       	// "projects/library/seqan/pipe/pipe_iterator.h"(189)

//____________________________________________________________________________
// operator<<

template <typename TValue, typename TSpec > ::std::ostream& operator<<(::std::ostream &out, Pool<TValue, TSpec> &p);       	// "projects/library/seqan/pipe/pool_base.h"(1045)
template <typename TValue, typename TSpec, typename TSource > inline bool operator<<(Pool<TValue, TSpec> &dest, TSource &src);       	// "projects/library/seqan/pipe/pool_base.h"(1200)
template <typename TValue1, typename TStringSpec, typename TValue2, typename TSpec > inline bool operator<<(String<TValue1, TStringSpec> &dest, Pool<TValue2, TSpec> &src);       	// "projects/library/seqan/pipe/pool_base.h"(1233)
template <typename TValue, typename TStringSpec, typename TInput, typename TSpec > inline bool operator<<(String<TValue, TStringSpec> &dest, Pipe<TInput, TSpec> &src);       	// "projects/library/seqan/pipe/pipe_base.h"(534)
template <typename TInput, typename TSpec > std::ostream& operator<<(std::ostream &out, Pipe<TInput, TSpec> &p);       	// "projects/library/seqan/pipe/pipe_base.h"(541)

//____________________________________________________________________________
// operator==

template <typename TInput> bool operator==(const IPipeIterator<TInput>& _Left, const IPipeIterator<TInput>& _Right);       	// "projects/library/seqan/pipe/pipe_iterator.h"(104)
template <typename TOutput> bool operator==(const OPipeIterator<TOutput>& _Left, const OPipeIterator<TOutput>& _Right);       	// "projects/library/seqan/pipe/pipe_iterator.h"(183)

//____________________________________________________________________________
// pop

template <typename TValue, typename TSpec > inline void pop(Pool<TValue, TSpec> &me);       	// "projects/library/seqan/pipe/pool_base.h"(1019)
template <typename TValue, typename TSpec > inline void pop(Pool<TValue, TSpec> &me, TValue &_Ref);       	// "projects/library/seqan/pipe/pool_base.h"(1024)
template <typename TInput, typename TSpec, typename TValue > inline void pop(Pipe<TInput, TSpec> &me, TValue &_Ref);       	// "projects/library/seqan/pipe/pipe_base.h"(387)
template <typename TInput, typename TSpec > inline void pop(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(394)

//____________________________________________________________________________
// processBuffer

template <typename TBuffer, typename THandler > inline TBuffer& processBuffer(TBuffer &h, THandler &);       	// "projects/library/seqan/pipe/pool_base.h"(163)
template <typename TValue, typename TConfig > inline PageFrame< TValue, typename TConfig::File, Dynamic<> > & processBuffer( PageFrame< TValue, typename TConfig::File, Dynamic<> > &buf, BufferHandler< Pool< TValue, SorterSpec<TConfig> >, WriteFileSpec > &me);       	// "projects/library/seqan/pipe/pool_sorter.h"(373)
template <typename TValue, typename TConfig > inline SimpleBuffer<TValue> & processBuffer( SimpleBuffer< TValue > &buf, BufferHandler< Pool< TValue, SorterSpec<TConfig> >, MemorySpec > &me);       	// "projects/library/seqan/pipe/pool_sorter.h"(386)
template <typename TValue, typename TConfig > inline SimpleBuffer< TValue > & processBuffer( PageFrame< TValue, typename TConfig::File, Dynamic<> > &buf, BufferHandler< Pool< TValue, MapperSpec<TConfig> >, ReadFileSpec > &me);       	// "projects/library/seqan/pipe/pool_mapper.h"(141)

//____________________________________________________________________________
// push

template <typename TValue, typename TSpec > inline void push(Pool<TValue, TSpec> &me, TValue const &_Val);       	// "projects/library/seqan/pipe/pool_base.h"(1040)

//____________________________________________________________________________
// resize

template <typename TValue, typename TSpec, typename TSize > inline TSize resize(Pool<TValue, TSpec> &me, TSize new_length);       	// "projects/library/seqan/pipe/pool_base.h"(1004)

//____________________________________________________________________________
// setHost

template <typename TPair, typename TLimits> void setHost(_PairIncrementer<TPair, TLimits> &me, TLimits const &limits);       	// "projects/library/seqan/pipe/pipe_base.h"(684)
template <typename TPair, typename TLimits, unsigned m, typename TLimits2> void setHost(_PairDecrementer<TPair, TLimits, m> &me, TLimits2 const &limits);       	// "projects/library/seqan/pipe/pipe_base.h"(756)
template <typename TPair, typename TLimits, typename TLimits2> void setHost(_PairDecrementer<TPair, TLimits, 0> &me, TLimits2 const &limits);       	// "projects/library/seqan/pipe/pipe_base.h"(806)

//____________________________________________________________________________
// size

template <typename TValue, typename TSpec > inline typename Size< Pool<TValue, TSpec> >::Type size(Pool<TValue, TSpec> const &me);       	// "projects/library/seqan/pipe/pool_base.h"(987)

//____________________________________________________________________________
// source

template <typename TInput, typename TSpec > inline TInput const & source(Pipe<TInput, TSpec> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(279)
template <typename TInput, typename TSpec > inline TInput & source(Pipe<TInput, TSpec> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(286)

//____________________________________________________________________________
// value

template <typename TPair, typename TLimits> TPair const & value(_PairIncrementer<TPair, TLimits> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(700)
template <typename TPair, typename TLimits> TPair & value(_PairIncrementer<TPair, TLimits> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(705)
template <typename TPair, typename TLimits, unsigned m> TPair const & value(_PairDecrementer<TPair, TLimits, m> const &me);       	// "projects/library/seqan/pipe/pipe_base.h"(821)
template <typename TPair, typename TLimits, unsigned m> TPair & value(_PairDecrementer<TPair, TLimits, m> &me);       	// "projects/library/seqan/pipe/pipe_base.h"(826)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

