 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_MISC_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MISC_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Key

template <typename TElement> struct Key;       	// "projects/library/seqan/misc/misc_base.h"(40)

//____________________________________________________________________________
// Map

template <typename TKey> struct Map;       	// "projects/library/seqan/misc/misc_map.h"(100)

//____________________________________________________________________________
// Object

template <typename TElement> struct Object;       	// "projects/library/seqan/misc/misc_base.h"(50)

//____________________________________________________________________________
// PriorityHeap

struct PriorityHeap;       	// "projects/library/seqan/misc/priority_type_base.h"(31)

//____________________________________________________________________________
// PriorityType

template <typename TValue , typename TLess , typename TSpec > class PriorityType;       	// "projects/library/seqan/misc/priority_type_base.h"(49)

//____________________________________________________________________________
// SequenceMap

template <typename TString, typename TLess > struct SequenceMap;       	// "projects/library/seqan/misc/misc_map.h"(58)

//____________________________________________________________________________
// Set

template <typename TKey> struct Set;       	// "projects/library/seqan/misc/misc_set.h"(547)

//____________________________________________________________________________
// VectorSet

template <typename TElement, typename TSpec> class VectorSet;       	// "projects/library/seqan/misc/misc_set.h"(44)
template <typename TElement , typename TSpec > class VectorSet;       	// "projects/library/seqan/misc/misc_set.h"(92)

//____________________________________________________________________________
// _MersenneBuffer

template <typename T > struct _MersenneBuffer;       	// "projects/library/seqan/misc/misc_random.h"(56)

//____________________________________________________________________________
// _SetLess

template <typename TElement> struct _SetLess;       	// "projects/library/seqan/misc/misc_set.h"(367)

//____________________________________________________________________________
// _SetObjVector

template <typename TSet> struct _SetObjVector;       	// "projects/library/seqan/misc/misc_set.h"(72)

//____________________________________________________________________________
// _SetSetVector

template <typename TSet> struct _SetSetVector;       	// "projects/library/seqan/misc/misc_set.h"(57)

//____________________________________________________________________________
// _VectorSetIterator

struct _VectorSetIterator;       	// "projects/library/seqan/misc/misc_set.h"(162)

//____________________________________________________________________________
// _VectorSetKeySize

template <typename TElement> struct _VectorSetKeySize;       	// "projects/library/seqan/misc/misc_set.h"(51)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// VectorSetIterator

typedef Tag<_VectorSetIterator> VectorSetIterator;       	// "projects/library/seqan/misc/misc_set.h"(163)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _adjustHeapTowardLeaves

template <typename TValue, typename TLess, typename TSize> inline void _adjustHeapTowardLeaves( PriorityType<TValue, TLess, PriorityHeap> & me, TValue element, TSize h, TSize i );       	// "projects/library/seqan/misc/priority_type_heap.h"(271)

//____________________________________________________________________________
// _adjustHeapTowardRoot

template <typename TValue, typename TLess, typename TSize> inline void _adjustHeapTowardRoot( PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element, TSize h );       	// "projects/library/seqan/misc/priority_type_heap.h"(220)

//____________________________________________________________________________
// _copyHeapElement

template <typename TValue, typename TLess, typename TSize> inline void _copyHeapElement (PriorityType<TValue, TLess, PriorityHeap> & me, TSize i, TSize & h);       	// "projects/library/seqan/misc/priority_type_heap.h"(143)
template <typename TValue, typename TLess, typename TSize> inline void _copyHeapElement (PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element, TSize h);       	// "projects/library/seqan/misc/priority_type_heap.h"(153)

//____________________________________________________________________________
// adjustTop

template <typename TValue, typename TLess> inline void adjustTop (PriorityType<TValue, TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(170)

//____________________________________________________________________________
// atEnd

template <typename TSet> inline bool atEnd(Iter<TSet, VectorSetIterator> const &a);       	// "projects/library/seqan/misc/misc_set.h"(323)

//____________________________________________________________________________
// begin

template <typename TElement, typename TSpec> inline typename Iterator< VectorSet<TElement, TSpec> >::Type begin(VectorSet<TElement, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(282)
template <typename TElement, typename TSpec> inline typename Iterator< VectorSet<TElement, TSpec> const>::Type begin(VectorSet<TElement, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(288)
template <typename TObject> typename Iterator< ::std::set<TObject> >::Type begin(::std::set<TObject> &set);       	// "projects/library/seqan/misc/misc_set.h"(469)
template <typename TObject> typename Iterator< ::std::set<TObject> const >::Type begin(::std::set<TObject> const &set);       	// "projects/library/seqan/misc/misc_set.h"(473)

//____________________________________________________________________________
// clear

template <typename TValue, typename TLess> inline void clear (PriorityType<TValue,TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(82)
template <typename TValue, typename TSpec> finline void clear(VectorSet<TValue, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(216)
template <typename TKey> inline void clear(::std::set<TKey> &set);       	// "projects/library/seqan/misc/misc_set.h"(395)
template <typename TString, typename TLess> inline void clear(SequenceMap<TString, TLess> &map);       	// "projects/library/seqan/misc/misc_map.h"(128)

//____________________________________________________________________________
// empty

template <typename TValue, typename TLess> inline bool empty(PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(91)

//____________________________________________________________________________
// end

template <typename TElement, typename TSpec> inline typename Iterator< VectorSet<TElement, TSpec> >::Type end(VectorSet<TElement, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(295)
template <typename TElement, typename TSpec> inline typename Iterator< VectorSet<TElement, TSpec> const>::Type end(VectorSet<TElement, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(301)
template <typename TObject> typename Iterator< ::std::set<TObject> >::Type end(::std::set<TObject> &set);       	// "projects/library/seqan/misc/misc_set.h"(477)
template <typename TObject> typename Iterator< ::std::set<TObject> const >::Type end(::std::set<TObject> const &set);       	// "projects/library/seqan/misc/misc_set.h"(481)

//____________________________________________________________________________
// eof

template <typename TSet> inline bool eof(Iter<TSet, VectorSetIterator> const &a);       	// "projects/library/seqan/misc/misc_set.h"(318)

//____________________________________________________________________________
// erase

template <typename TKey, typename TValue, typename TSpec> finline void erase(TKey const &key, VectorSet<TValue, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(246)
template <typename TKey, typename TSetKey> inline void erase(TKey const &key, ::std::set<TSetKey> &set);       	// "projects/library/seqan/misc/misc_set.h"(407)
template <typename TKey, typename TSetKey, typename TSetObject, typename TPairSpec> inline void erase(TKey const &key, ::std::set< Pair<TSetKey, TSetObject, TPairSpec> > &set);       	// "projects/library/seqan/misc/misc_set.h"(412)
template <typename TKey, typename TString> inline void erase(TKey const &key, SequenceMap<TString> &map);       	// "projects/library/seqan/misc/misc_map.h"(181)

//____________________________________________________________________________
// find

template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< VectorSet<TKey2, TSpec> >::Type find(TKey const &key, VectorSet<TKey2, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(261)
template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< VectorSet<TKey2, TSpec> const>::Type find(TKey const &key, VectorSet<TKey2, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(271)
template <typename TKey, typename TSetKey> inline typename Iterator< ::std::set<TSetKey> >::Type find(TKey const &key, ::std::set<TSetKey> &set);       	// "projects/library/seqan/misc/misc_set.h"(435)
template <typename TKey, typename TSetKey> inline typename Iterator< ::std::set<TSetKey> const>::Type find(TKey const &key, ::std::set<TSetKey> const &set);       	// "projects/library/seqan/misc/misc_set.h"(440)
template <typename TKey, typename TSetKey, typename TSetObject, typename TPairSpec> inline typename Iterator< ::std::set<Pair<TSetKey, TSetObject, TPairSpec> > >::Type find(TKey const &key, ::std::set<Pair<TSetKey, TSetObject> > &set);       	// "projects/library/seqan/misc/misc_set.h"(445)
template <typename TKey, typename TSetKey, typename TSetObject> inline typename Iterator< ::std::set<Pair<TSetKey, TSetObject> > const>::Type find(TKey const &key, ::std::set<Pair<TSetKey, TSetObject> > const &set);       	// "projects/library/seqan/misc/misc_set.h"(450)
template <typename TKey, typename TString, typename TLess> inline typename Iterator< SequenceMap<TString, TLess> >::Type find(TKey const &key, SequenceMap<TString, TLess> &map);       	// "projects/library/seqan/misc/misc_map.h"(134)

//____________________________________________________________________________
// geomRand

template <typename T> inline T geomRand();       	// "projects/library/seqan/misc/misc_random.h"(159)

//____________________________________________________________________________
// in

template <typename TKey, typename TValue, typename TSpec> finline bool in(TKey const &key, VectorSet<TValue, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(255)
template <typename TKey, typename TSetKey> inline bool in(TKey const &key, ::std::set<TSetKey> const &set);       	// "projects/library/seqan/misc/misc_set.h"(418)
template <typename TKey, typename TSetKey, typename TSetObject, typename TPairSpec> inline bool in(TKey const &key, ::std::set<Pair<TSetKey, TSetObject, TPairSpec> > const &set);       	// "projects/library/seqan/misc/misc_set.h"(423)

//____________________________________________________________________________
// insert

template <typename TElement, typename TSetKey, typename TSpec> finline void insert(TElement const &element, VectorSet<TSetKey, TSpec> &set);       	// "projects/library/seqan/misc/misc_set.h"(223)
template <typename TElement, typename TSetKey, typename TSetObject, typename TPairSpec, typename TSpec> finline void insert(TElement const &element, VectorSet< Pair<TSetKey, TSetObject, TPairSpec>, TSpec > &set);       	// "projects/library/seqan/misc/misc_set.h"(236)
template <typename TElement, typename TSetKey> inline void insert(TElement const &element, ::std::set<TSetKey> &set);       	// "projects/library/seqan/misc/misc_set.h"(401)
template <typename TPair, typename TString, typename TLess> inline void insert(TPair &pair, SequenceMap<TString> &map);       	// "projects/library/seqan/misc/misc_map.h"(161)

//____________________________________________________________________________
// keyOf

template <typename TElement> inline TElement & keyOf(TElement &element);       	// "projects/library/seqan/misc/misc_base.h"(66)
template <typename TElement> inline TElement const & keyOf(TElement const &element);       	// "projects/library/seqan/misc/misc_base.h"(71)
template <typename TKey, typename TObject, typename TSpec> inline TKey & keyOf(Pair<TKey, TObject, TSpec> &element);       	// "projects/library/seqan/misc/misc_base.h"(77)
template <typename TKey, typename TObject, typename TSpec> inline TKey const & keyOf(Pair<TKey, TObject, TSpec> const &element);       	// "projects/library/seqan/misc/misc_base.h"(82)
template <typename TSet> inline typename Key<TSet>::Type keyOf(Iter<TSet, VectorSetIterator> &it);       	// "projects/library/seqan/misc/misc_set.h"(331)
template <typename TSet> inline typename Key<TSet>::Type keyOf(Iter<TSet, VectorSetIterator> const &it);       	// "projects/library/seqan/misc/misc_set.h"(336)
template <typename TElement> inline typename Key< ::std::set<TElement> >::Type & keyOf(typename ::std::set<TElement>::iterator &it);       	// "projects/library/seqan/misc/misc_set.h"(489)
template <typename TElement> inline typename Key< ::std::set<TElement> >::Type & keyOf(typename ::std::set<TElement>::iterator const &it);       	// "projects/library/seqan/misc/misc_set.h"(494)
template <typename TElement> inline typename Key< ::std::set<TElement> >::Type const & keyOf(typename ::std::set<TElement>::const_iterator &it);       	// "projects/library/seqan/misc/misc_set.h"(499)
template <typename TElement> inline typename Key< ::std::set<TElement> >::Type const & keyOf(typename ::std::set<TElement>::const_iterator const &it);       	// "projects/library/seqan/misc/misc_set.h"(504)
template <typename TPair> inline typename TPair::T1 & keyOf(TPair &pair);       	// "projects/library/seqan/misc/misc_map.h"(37)
template <typename TPair> inline typename TPair::T1 const & keyOf(TPair const &pair);       	// "projects/library/seqan/misc/misc_map.h"(41)

//____________________________________________________________________________
// length

template <typename TValue, typename TLess> inline typename Size<PriorityType<TValue, TLess, PriorityHeap> >::Type length( PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(101)
template <typename TObject, typename TSpec> inline typename Size< VectorSet<TObject, TSpec> >::Type length(VectorSet<TObject, TSpec> const &set);       	// "projects/library/seqan/misc/misc_set.h"(153)
template <typename TKey> inline typename Size< ::std::set<TKey> >::Type length(::std::set<TKey> const &set);       	// "projects/library/seqan/misc/misc_set.h"(429)
template <typename TString> inline typename Size< SequenceMap<TString> >::Type length(SequenceMap<TString> const &set);       	// "projects/library/seqan/misc/misc_map.h"(71)

//____________________________________________________________________________
// mtRand

inline unsigned long mtRand();       	// "projects/library/seqan/misc/misc_random.h"(116)

//____________________________________________________________________________
// mtRandInit

inline void mtRandInit(bool _doSRand );       	// "projects/library/seqan/misc/misc_random.h"(87)
inline void mtRandInit();       	// "projects/library/seqan/misc/misc_random.h"(107)

//____________________________________________________________________________
// objectOf

template <typename TKey, typename TObject, typename TSpec> inline TObject & objectOf(Pair<TKey, TObject, TSpec> &element);       	// "projects/library/seqan/misc/misc_base.h"(92)
template <typename TKey, typename TObject, typename TSpec> inline TObject const & objectOf(Pair<TKey, TObject, TSpec> const &element);       	// "projects/library/seqan/misc/misc_base.h"(97)
template <typename TSet> inline typename Object<TSet>::Type & objectOf(Iter<TSet, VectorSetIterator> &it);       	// "projects/library/seqan/misc/misc_set.h"(342)
template <typename TSet> inline typename Object<TSet>::Type & objectOf(Iter<TSet, VectorSetIterator> const &it);       	// "projects/library/seqan/misc/misc_set.h"(347)
template <typename TElement> inline typename Object< ::std::set<TElement> >::Type & objectOf(typename ::std::set<TElement>::iterator &it);       	// "projects/library/seqan/misc/misc_set.h"(510)
template <typename TElement> inline typename Object< ::std::set<TElement> >::Type & objectOf(typename ::std::set<TElement>::iterator const &it);       	// "projects/library/seqan/misc/misc_set.h"(515)
template <typename TElement> inline typename Object< ::std::set<TElement> >::Type const & objectOf(typename ::std::set<TElement>::const_iterator &it);       	// "projects/library/seqan/misc/misc_set.h"(520)
template <typename TElement> inline typename Object< ::std::set<TElement> >::Type const & objectOf(typename ::std::set<TElement>::const_iterator const &it);       	// "projects/library/seqan/misc/misc_set.h"(525)
template <typename TPair> inline typename TPair::T2 & objectOf(TPair &pair);       	// "projects/library/seqan/misc/misc_map.h"(45)
template <typename TPair> inline typename TPair::T2 const & objectOf(TPair const &pair);       	// "projects/library/seqan/misc/misc_map.h"(49)

//____________________________________________________________________________
// operator!=

template <typename TSet> inline bool operator!=(Iter<TSet, VectorSetIterator> const &a, Iter<TSet, VectorSetIterator> const &b);       	// "projects/library/seqan/misc/misc_set.h"(313)

//____________________________________________________________________________
// operator==

template <typename TSet> inline bool operator==(Iter<TSet, VectorSetIterator> const &a, Iter<TSet, VectorSetIterator> const &b);       	// "projects/library/seqan/misc/misc_set.h"(308)

//____________________________________________________________________________
// pop

template <typename TValue, typename TLess> inline void pop (PriorityType<TValue, TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(249)

//____________________________________________________________________________
// push

template <typename TValue, typename TLess> inline void push (PriorityType<TValue, TLess, PriorityHeap> & me, TValue const & element);       	// "projects/library/seqan/misc/priority_type_heap.h"(198)

//____________________________________________________________________________
// top

template <typename TValue, typename TLess> inline TValue & top(PriorityType<TValue, TLess, PriorityHeap> & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(126)
template <typename TValue, typename TLess> inline TValue const & top(PriorityType<TValue, TLess, PriorityHeap> const & me);       	// "projects/library/seqan/misc/priority_type_heap.h"(134)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

