 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_INDEX_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_INDEX_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Align

template <typename TSource, typename TSpec> class Align;       	// "projects/library/seqan/index/index_esa_base.h"(189)

//____________________________________________________________________________
// ArrayGaps

struct ArrayGaps;       	// "projects/library/seqan/index/index_esa_base.h"(186)

//____________________________________________________________________________
// BTree

template <unsigned BlockSize > struct BTree;       	// "projects/library/seqan/index/index_esa_find.h"(70)

//____________________________________________________________________________
// BWT

struct BWT;       	// "projects/library/seqan/index/index_base.h"(46)
struct BWT;       	// "projects/library/seqan/index/index_bwt.h"(30)

//____________________________________________________________________________
// BottomUp

template <typename TSpec > struct BottomUp;       	// "projects/library/seqan/index/index_esa_base.h"(125)

//____________________________________________________________________________
// ChildTab

struct ChildTab;       	// "projects/library/seqan/index/index_childtab.h"(30)
struct ChildTab;       	// "projects/library/seqan/index/index_base.h"(45)

//____________________________________________________________________________
// CompareSkewDCStream

template <typename TValue> struct CompareSkewDCStream;       	// "projects/library/seqan/index/pipe_merger7.h"(95)

//____________________________________________________________________________
// DefaultIndexCreator

template <typename TIndex, typename TFibre > struct DefaultIndexCreator;       	// "projects/library/seqan/index/index_base.h"(177)

//____________________________________________________________________________
// DefaultIndexSpec

template <typename TObject > struct DefaultIndexSpec;       	// "projects/library/seqan/index/index_base.h"(63)

//____________________________________________________________________________
// DefaultIndexStringSpec

template <typename TIndex > struct DefaultIndexStringSpec;       	// "projects/library/seqan/index/index_base.h"(78)

//____________________________________________________________________________
// EmptyEdges

struct EmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(102)

//____________________________________________________________________________
// Extender3

struct Extender3;       	// "projects/library/seqan/index/pump_extender3.h"(30)

//____________________________________________________________________________
// Extender7

template <typename TCompression > struct Extender7;       	// "projects/library/seqan/index/pump_extender7.h"(33)

//____________________________________________________________________________
// Extender7Multi

template <typename TPair, typename TCompression > struct Extender7Multi;       	// "projects/library/seqan/index/pump_extender7.h"(228)

//____________________________________________________________________________
// Fibre

template <typename TIndex, typename TSpec > struct Fibre;       	// "projects/library/seqan/index/index_base.h"(141)

//____________________________________________________________________________
// FibreLess

struct FibreLess;       	// "projects/library/seqan/index/index_base.h"(158)

//____________________________________________________________________________
// FibreRecord

struct FibreRecord;       	// "projects/library/seqan/index/index_base.h"(150)

//____________________________________________________________________________
// FixedGappedShape

template <typename TSpec> struct FixedGappedShape;       	// "projects/library/seqan/index/shape_base.h"(32)

//____________________________________________________________________________
// FixedShape

template <unsigned q> struct FixedShape;       	// "projects/library/seqan/index/shape_base.h"(28)

//____________________________________________________________________________
// FunctorGlobalize

template <typename InType, typename TLimitsString, typename Result > struct FunctorGlobalize;       	// "projects/library/seqan/index/index_base.h"(376)

//____________________________________________________________________________
// GetVSTreeIteratorTraits

template <typename TIterator> struct GetVSTreeIteratorTraits;       	// "projects/library/seqan/index/index_esa_base.h"(148)

//____________________________________________________________________________
// HardwiredShape

template <int P00 , int P01 , int P02 , int P03 , int P04 , int P05 , int P06 , int P07 , int P08 , int P09 , int P10 , int P11 , int P12 , int P13 , int P14 , int P15 , int P16 , int P17 , int P18 , int P19 > struct HardwiredShape;       	// "projects/library/seqan/index/shape_gapped.h"(50)

//____________________________________________________________________________
// HideEmptyEdges

struct HideEmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(101)

//____________________________________________________________________________
// Index

template <typename TObject, typename TSpec > class Index;       	// "projects/library/seqan/index/index_base.h"(114)

//____________________________________________________________________________
// Index_ESA

template <typename TSpec > struct Index_ESA;       	// "projects/library/seqan/index/index_base.h"(49)

//____________________________________________________________________________
// Index_QGram

template <typename TShapeSpec > struct Index_QGram;       	// "projects/library/seqan/index/index_qgram.h"(92)

//____________________________________________________________________________
// Kasai

struct Kasai;       	// "projects/library/seqan/index/index_base.h"(41)
struct Kasai;       	// "projects/library/seqan/index/index_lcp.h"(30)

//____________________________________________________________________________
// KasaiOriginal

struct KasaiOriginal;       	// "projects/library/seqan/index/index_base.h"(42)
struct KasaiOriginal;       	// "projects/library/seqan/index/index_lcp.h"(31)

//____________________________________________________________________________
// LarssonSadakane

struct LarssonSadakane;       	// "projects/library/seqan/index/index_sa_lss.h"(336)
struct LarssonSadakane;       	// "projects/library/seqan/index/index_base.h"(35)

//____________________________________________________________________________
// LcpConfig

struct LcpConfig;       	// "projects/library/seqan/index/pump_lcp_core.h"(31)

//____________________________________________________________________________
// LeftCompleteTree

struct LeftCompleteTree;       	// "projects/library/seqan/index/index_esa_find.h"(67)

//____________________________________________________________________________
// MUMs

struct MUMs;       	// "projects/library/seqan/index/index_esa_base.h"(129)

//____________________________________________________________________________
// ManberMyers

struct ManberMyers;       	// "projects/library/seqan/index/index_sa_mm.h"(27)
struct ManberMyers;       	// "projects/library/seqan/index/index_base.h"(36)

//____________________________________________________________________________
// MaxRepeat

template <typename TSTree> struct MaxRepeat;       	// "projects/library/seqan/index/index_esa_algs.h"(602)

//____________________________________________________________________________
// MaxRepeatOccurrences

struct MaxRepeatOccurrences;       	// "projects/library/seqan/index/index_esa_base.h"(132)

//____________________________________________________________________________
// Merger3

struct Merger3;       	// "projects/library/seqan/index/pipe_merger3.h"(30)

//____________________________________________________________________________
// Merger7

struct Merger7;       	// "projects/library/seqan/index/pipe_merger7.h"(178)

//____________________________________________________________________________
// Merger7Multi

template <typename TLimitsString> struct Merger7Multi;       	// "projects/library/seqan/index/pipe_merger7.h"(187)

//____________________________________________________________________________
// MultiMEM

template <typename TSTree> struct MultiMEM;       	// "projects/library/seqan/index/index_esa_algs_multi.h"(385)

//____________________________________________________________________________
// MultiMEMOccurences

struct MultiMEMOccurences;       	// "projects/library/seqan/index/index_esa_base.h"(134)

//____________________________________________________________________________
// ParentLinks

template <typename TSpec > struct ParentLinks;       	// "projects/library/seqan/index/index_esa_base.h"(121)

//____________________________________________________________________________
// Postorder

struct Postorder;       	// "projects/library/seqan/index/index_esa_base.h"(96)

//____________________________________________________________________________
// PostorderEmptyEdges

struct PostorderEmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(98)

//____________________________________________________________________________
// Preorder

struct Preorder;       	// "projects/library/seqan/index/index_esa_base.h"(95)

//____________________________________________________________________________
// PreorderEmptyEdges

struct PreorderEmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(97)

//____________________________________________________________________________
// QGram_Alg

struct QGram_Alg;       	// "projects/library/seqan/index/index_base.h"(38)

//____________________________________________________________________________
// SAQSort

struct SAQSort;       	// "projects/library/seqan/index/index_base.h"(37)
struct SAQSort;       	// "projects/library/seqan/index/index_sa_qsort.h"(27)

//____________________________________________________________________________
// SAValue

template <typename TObject> struct SAValue;       	// "projects/library/seqan/index/index_base.h"(278)

//____________________________________________________________________________
// SearchTreeIterator

template <typename TString, typename TSpec > class SearchTreeIterator;       	// "projects/library/seqan/index/index_esa_find.h"(73)

//____________________________________________________________________________
// Shape

template <typename TValue , typename TSpec > class Shape;       	// "projects/library/seqan/index/shape_base.h"(54)

//____________________________________________________________________________
// Skew3

struct Skew3;       	// "projects/library/seqan/index/index_base.h"(33)
struct Skew3;       	// "projects/library/seqan/index/index_skew3.h"(30)

//____________________________________________________________________________
// Skew7

struct Skew7;       	// "projects/library/seqan/index/index_base.h"(34)
struct Skew7;       	// "projects/library/seqan/index/index_skew7.h"(30)

//____________________________________________________________________________
// SkewDCStream

template <typename TValue> struct SkewDCStream;       	// "projects/library/seqan/index/pipe_merger7.h"(71)

//____________________________________________________________________________
// SortedList

struct SortedList;       	// "projects/library/seqan/index/index_esa_find.h"(66)

//____________________________________________________________________________
// SuperMaxRepeats

struct SuperMaxRepeats;       	// "projects/library/seqan/index/index_esa_base.h"(127)

//____________________________________________________________________________
// SuperMaxRepeatsFast

struct SuperMaxRepeatsFast;       	// "projects/library/seqan/index/index_esa_base.h"(128)

//____________________________________________________________________________
// TopDown

template <typename TSpec > struct TopDown;       	// "projects/library/seqan/index/index_esa_base.h"(117)

//____________________________________________________________________________
// VSTree

template <typename TSpec > struct VSTree;       	// "projects/library/seqan/index/index_esa_base.h"(113)

//____________________________________________________________________________
// VSTreeIteratorTraits

template <typename TDFSOrder , typename THideEmptyEdges > struct VSTreeIteratorTraits;       	// "projects/library/seqan/index/index_esa_base.h"(32)

//____________________________________________________________________________
// VertexESA

template <typename TSize> struct VertexESA;       	// "projects/library/seqan/index/index_esa_base.h"(153)

//____________________________________________________________________________
// _Context_LSS

template <typename TValue> struct _Context_LSS;       	// "projects/library/seqan/index/index_sa_lss.h"(40)

//____________________________________________________________________________
// _Fibre_BWT

struct _Fibre_BWT;       	// "projects/library/seqan/index/index_base.h"(245)

//____________________________________________________________________________
// _Fibre_ChildTab

struct _Fibre_ChildTab;       	// "projects/library/seqan/index/index_base.h"(244)

//____________________________________________________________________________
// _Fibre_Counts

struct _Fibre_Counts;       	// "projects/library/seqan/index/index_qgram.h"(64)

//____________________________________________________________________________
// _Fibre_CountsDir

struct _Fibre_CountsDir;       	// "projects/library/seqan/index/index_qgram.h"(65)

//____________________________________________________________________________
// _Fibre_Dir

struct _Fibre_Dir;       	// "projects/library/seqan/index/index_qgram.h"(61)

//____________________________________________________________________________
// _Fibre_LCP

struct _Fibre_LCP;       	// "projects/library/seqan/index/index_base.h"(242)

//____________________________________________________________________________
// _Fibre_LCPE

struct _Fibre_LCPE;       	// "projects/library/seqan/index/index_base.h"(243)

//____________________________________________________________________________
// _Fibre_RawSA

struct _Fibre_RawSA;       	// "projects/library/seqan/index/index_base.h"(240)

//____________________________________________________________________________
// _Fibre_RawText

struct _Fibre_RawText;       	// "projects/library/seqan/index/index_base.h"(238)

//____________________________________________________________________________
// _Fibre_SA

struct _Fibre_SA;       	// "projects/library/seqan/index/index_base.h"(239)

//____________________________________________________________________________
// _Fibre_SADir

struct _Fibre_SADir;       	// "projects/library/seqan/index/index_qgram.h"(62)

//____________________________________________________________________________
// _Fibre_SAE

struct _Fibre_SAE;       	// "projects/library/seqan/index/index_base.h"(241)

//____________________________________________________________________________
// _Fibre_Shape

struct _Fibre_Shape;       	// "projects/library/seqan/index/index_qgram.h"(63)

//____________________________________________________________________________
// _Fibre_Text

struct _Fibre_Text;       	// "projects/library/seqan/index/index_base.h"(237)

//____________________________________________________________________________
// _Finder_LCPE

struct _Finder_LCPE;       	// "projects/library/seqan/index/index_esa_find.h"(49)

//____________________________________________________________________________
// _Finder_MLR

struct _Finder_MLR;       	// "projects/library/seqan/index/index_esa_find.h"(48)

//____________________________________________________________________________
// _Finder_QGramLookup

struct _Finder_QGramLookup;       	// "projects/library/seqan/index/index_qgram_find.h"(30)

//____________________________________________________________________________
// _FractionCompound

template <typename TValue, typename TSize> struct _FractionCompound;       	// "projects/library/seqan/index/index_esa_algs.h"(250)

//____________________________________________________________________________
// _FractionHeader

template <typename TSize> struct _FractionHeader;       	// "projects/library/seqan/index/index_esa_algs.h"(239)

//____________________________________________________________________________
// _FractionMultiCompound

template <typename TValue, typename TSize> struct _FractionMultiCompound;       	// "projects/library/seqan/index/index_esa_algs_multi.h"(132)

//____________________________________________________________________________
// _HistoryStackEntry

template <typename TVSTreeIter > struct _HistoryStackEntry;       	// "projects/library/seqan/index/index_esa_stree.h"(122)

//____________________________________________________________________________
// _MaxRepeats

template <typename TSpec > struct _MaxRepeats;       	// "projects/library/seqan/index/index_esa_base.h"(106)

//____________________________________________________________________________
// _MultiMEMs

struct _MultiMEMs;       	// "projects/library/seqan/index/index_esa_base.h"(107)

//____________________________________________________________________________
// _Postorder

struct _Postorder;       	// "projects/library/seqan/index/index_esa_base.h"(29)

//____________________________________________________________________________
// _Preorder

struct _Preorder;       	// "projects/library/seqan/index/index_esa_base.h"(28)

//____________________________________________________________________________
// _QGramLess

template <typename TSAValue, typename TText > struct _QGramLess;       	// "projects/library/seqan/index/index_qgram.h"(336)

//____________________________________________________________________________
// _QGramLessNoCheck

template <typename TSAValue, typename TText > struct _QGramLessNoCheck;       	// "projects/library/seqan/index/index_qgram.h"(495)

//____________________________________________________________________________
// _QGramLessNoCheckOffset

template <typename TSAValue, typename TText > struct _QGramLessNoCheckOffset;       	// "projects/library/seqan/index/index_qgram.h"(577)

//____________________________________________________________________________
// _QGramLessOffset

template <typename TSAValue, typename TText > struct _QGramLessOffset;       	// "projects/library/seqan/index/index_qgram.h"(431)

//____________________________________________________________________________
// _SAValueLess

template <typename TOccValue> struct _SAValueLess;       	// "projects/library/seqan/index/index_shims.h"(433)

//____________________________________________________________________________
// _SkewNIndx

template <int I, typename T > struct _SkewNIndx;       	// "projects/library/seqan/index/pipe_merger7.h"(34)

//____________________________________________________________________________
// _SkewShift

template <int I, typename T > struct _SkewShift;       	// "projects/library/seqan/index/pipe_merger7.h"(31)

//____________________________________________________________________________
// _SuffixLess

template <typename TSAValue, typename TText > struct _SuffixLess;       	// "projects/library/seqan/index/index_sa_qsort.h"(33)

//____________________________________________________________________________
// _SuffixLessOffset

template <typename TSAValue, typename TText > struct _SuffixLessOffset;       	// "projects/library/seqan/index/index_sa_qsort.h"(71)

//____________________________________________________________________________
// _qgram_comp

template <typename InType, typename Result > struct _qgram_comp;       	// "projects/library/seqan/index/index_qgram.h"(1128)

//____________________________________________________________________________
// _qgram_hash

template <typename TValue, typename TResult > struct _qgram_hash;       	// "projects/library/seqan/index/index_qgram.h"(1163)

//____________________________________________________________________________
// filter_globalizer

template <typename InType, typename TLimitsString, typename Result > struct filter_globalizer;       	// "projects/library/seqan/index/index_bwt.h"(130)

//____________________________________________________________________________
// map_inverse

template <typename InType, typename Result > struct map_inverse;       	// "projects/library/seqan/index/index_lcp.h"(45)

//____________________________________________________________________________
// map_inverse_multi

template <typename InType, typename TLimitsString, typename Result > struct map_inverse_multi;       	// "projects/library/seqan/index/index_lcp.h"(148)

//____________________________________________________________________________
// skew3_extend_comp

template <typename InType, typename Result > struct skew3_extend_comp;       	// "projects/library/seqan/index/index_skew3.h"(107)

//____________________________________________________________________________
// skew3_ncomp

template <typename InType, typename Result > struct skew3_ncomp;       	// "projects/library/seqan/index/index_skew3.h"(49)

//____________________________________________________________________________
// skew3_nmap_extended

template <typename InType, typename Result > struct skew3_nmap_extended;       	// "projects/library/seqan/index/index_skew3.h"(101)

//____________________________________________________________________________
// skew3_nmap_linear

template <typename InType, typename Result > struct skew3_nmap_linear;       	// "projects/library/seqan/index/index_skew3.h"(72)

//____________________________________________________________________________
// skew3_nmap_sliced

template <typename InType, typename Result > struct skew3_nmap_sliced;       	// "projects/library/seqan/index/index_skew3.h"(80)

//____________________________________________________________________________
// skew3_unslicer_func

template <typename InType, typename Result > struct skew3_unslicer_func;       	// "projects/library/seqan/index/index_skew3.h"(89)

//____________________________________________________________________________
// skew7_extend_comp

template <typename InType, const int EXT_LENGTH, typename Result > struct skew7_extend_comp;       	// "projects/library/seqan/index/index_skew7.h"(137)

//____________________________________________________________________________
// skew7_global_sliced_multi

template <typename InType, typename TLimitsString, typename TResultSize , typename Result > struct skew7_global_sliced_multi;       	// "projects/library/seqan/index/index_skew7_multi.h"(109)

//____________________________________________________________________________
// skew7_ncomp

template <typename InType, typename Result > struct skew7_ncomp;       	// "projects/library/seqan/index/index_skew7.h"(49)

//____________________________________________________________________________
// skew7_ncomp_multi

template <typename InType, typename Result > struct skew7_ncomp_multi;       	// "projects/library/seqan/index/index_skew7_multi.h"(42)

//____________________________________________________________________________
// skew7_nmap_extended

template <typename InType, typename Result > struct skew7_nmap_extended;       	// "projects/library/seqan/index/index_skew7.h"(131)

//____________________________________________________________________________
// skew7_nmap_linear

template <typename InType, typename Result > struct skew7_nmap_linear;       	// "projects/library/seqan/index/index_skew7.h"(91)

//____________________________________________________________________________
// skew7_nmap_sliced

template <typename InType, typename Result > struct skew7_nmap_sliced;       	// "projects/library/seqan/index/index_skew7.h"(99)

//____________________________________________________________________________
// skew7_unslicer_func

template <typename InType, typename Result > struct skew7_unslicer_func;       	// "projects/library/seqan/index/index_skew7.h"(115)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ESA_BWT

typedef Tag<_Fibre_BWT> const ESA_BWT;       	// "projects/library/seqan/index/index_esa_base.h"(240)

//____________________________________________________________________________
// ESA_ChildTab

typedef Tag<_Fibre_ChildTab> const ESA_ChildTab;       	// "projects/library/seqan/index/index_esa_base.h"(239)

//____________________________________________________________________________
// ESA_FIND_LCPE

typedef Tag<_Finder_LCPE> const ESA_FIND_LCPE;       	// "projects/library/seqan/index/index_esa_find.h"(52)

//____________________________________________________________________________
// ESA_FIND_MLR

typedef Tag<_Finder_MLR> const ESA_FIND_MLR;       	// "projects/library/seqan/index/index_esa_find.h"(51)

//____________________________________________________________________________
// ESA_LCP

typedef Tag<_Fibre_LCP> const ESA_LCP;       	// "projects/library/seqan/index/index_esa_base.h"(237)

//____________________________________________________________________________
// ESA_LCPE

typedef Tag<_Fibre_LCPE> const ESA_LCPE;       	// "projects/library/seqan/index/index_esa_base.h"(238)

//____________________________________________________________________________
// ESA_RawSA

typedef Tag<_Fibre_RawSA> const ESA_RawSA;       	// "projects/library/seqan/index/index_esa_base.h"(235)

//____________________________________________________________________________
// ESA_RawText

typedef Tag<_Fibre_RawText> const ESA_RawText;       	// "projects/library/seqan/index/index_esa_base.h"(233)

//____________________________________________________________________________
// ESA_SA

typedef Tag<_Fibre_SA> const ESA_SA;       	// "projects/library/seqan/index/index_esa_base.h"(234)

//____________________________________________________________________________
// ESA_SAE

typedef Tag<_Fibre_SAE> const ESA_SAE;       	// "projects/library/seqan/index/index_esa_base.h"(236)

//____________________________________________________________________________
// ESA_Text

typedef Tag<_Fibre_Text> const ESA_Text;       	// "projects/library/seqan/index/index_esa_base.h"(232)

//____________________________________________________________________________
// GappedShape

typedef FixedGappedShape<Default> GappedShape;       	// "projects/library/seqan/index/shape_base.h"(33)

//____________________________________________________________________________
// MaxRepeats

typedef _MaxRepeats<void> MaxRepeats;       	// "projects/library/seqan/index/index_esa_base.h"(131)

//____________________________________________________________________________
// MultiMEMs

typedef _MaxRepeats<_MultiMEMs> MultiMEMs;       	// "projects/library/seqan/index/index_esa_base.h"(133)

//____________________________________________________________________________
// QGram_Counts

typedef Tag<_Fibre_Counts> const QGram_Counts;       	// "projects/library/seqan/index/index_qgram.h"(74)

//____________________________________________________________________________
// QGram_CountsDir

typedef Tag<_Fibre_CountsDir> const QGram_CountsDir;       	// "projects/library/seqan/index/index_qgram.h"(75)

//____________________________________________________________________________
// QGram_Dir

typedef Tag<_Fibre_Dir> const QGram_Dir;       	// "projects/library/seqan/index/index_qgram.h"(71)

//____________________________________________________________________________
// QGram_FIND_Lookup

typedef Tag<_Finder_QGramLookup> const QGram_FIND_Lookup;       	// "projects/library/seqan/index/index_qgram_find.h"(38)

//____________________________________________________________________________
// QGram_RawSA

typedef Tag<_Fibre_RawSA> const QGram_RawSA;       	// "projects/library/seqan/index/index_qgram.h"(70)

//____________________________________________________________________________
// QGram_RawText

typedef Tag<_Fibre_RawText> const QGram_RawText;       	// "projects/library/seqan/index/index_qgram.h"(68)

//____________________________________________________________________________
// QGram_SA

typedef Tag<_Fibre_SA> const QGram_SA;       	// "projects/library/seqan/index/index_qgram.h"(69)

//____________________________________________________________________________
// QGram_SADir

typedef Tag<_Fibre_SADir> const QGram_SADir;       	// "projects/library/seqan/index/index_qgram.h"(72)

//____________________________________________________________________________
// QGram_Shape

typedef Tag<_Fibre_Shape> const QGram_Shape;       	// "projects/library/seqan/index/index_qgram.h"(73)

//____________________________________________________________________________
// QGram_Text

typedef Tag<_Fibre_Text> const QGram_Text;       	// "projects/library/seqan/index/index_qgram.h"(67)

//____________________________________________________________________________
// SimpleShape

typedef FixedShape<0> SimpleShape;       	// "projects/library/seqan/index/shape_base.h"(29)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __cp_

template <typename Dest, typename Ofs, typename Src> static finline Src const __cp_(Dest &dst, Ofs const ofs, Src const src);       	// "projects/library/seqan/index/pump_extender7.h"(67)

//____________________________________________________________________________
// _createBWTableWrapper

template <typename TBWT, typename TText, typename TSA, typename _TTextRandom > inline void _createBWTableWrapper(TBWT &bwt, TText const &s, TSA const &sa, _TTextRandom const);       	// "projects/library/seqan/index/index_shims.h"(411)
template <typename TBWT, typename TText, typename TSA > inline void _createBWTableWrapper(TBWT &bwt, TText const &s, TSA const &sa, True const);       	// "projects/library/seqan/index/index_shims.h"(418)

//____________________________________________________________________________
// _dataHost

template <typename TText, typename TSpec> inline Holder<TText> & _dataHost(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(454)
template <typename TText, typename TSpec> inline Holder<TText> const & _dataHost(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(458)

//____________________________________________________________________________
// _dfsClear

template <typename TIndex, class TSpec > inline void _dfsClear(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1231)

//____________________________________________________________________________
// _dfsLCP

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type & _dfsLCP(Iter< TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1647)
template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type _dfsLCP(Iter< TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1653)

//____________________________________________________________________________
// _dfsOnLeaf

template <typename TIndex, typename TSpec > inline void _dfsOnLeaf(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(271)
template <typename TSTree, typename TSpec > inline void _dfsOnLeaf(Iter<TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(496)
template <typename TSTree > inline void _dfsOnLeaf(Iter<TSTree, VSTree< BottomUp<MultiMEMs> > > &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(338)

//____________________________________________________________________________
// _dfsOnPop

template <typename TIndex, typename TSpec, typename TSize > inline void _dfsOnPop(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, TSize const);       	// "projects/library/seqan/index/index_esa_stree.h"(259)

//____________________________________________________________________________
// _dfsOnPush

template <typename TIndex, typename TSpec, typename TElement > inline void _dfsOnPush(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, TElement const &e);       	// "projects/library/seqan/index/index_esa_stree.h"(266)
template <typename TSTree, typename TElement, typename TSpec > inline void _dfsOnPush(Iter<TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it, TElement const &e);       	// "projects/library/seqan/index/index_esa_algs.h"(482)

//____________________________________________________________________________
// _dfsRange

template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> & _dfsRange(Iter< TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1634)
template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> const & _dfsRange(Iter< TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1641)

//____________________________________________________________________________
// _dfsReversedOrder

template <typename TIndex, typename TSpec > inline bool _dfsReversedOrder(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(253)

//____________________________________________________________________________
// _dump

template <typename TText, typename TSpec> inline void _dump(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_stree.h"(235)

//____________________________________________________________________________
// _dumpHistoryStack

template <typename TIndex, typename TSpec > inline void _dumpHistoryStack(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(226)

//____________________________________________________________________________
// _equalRangeLCPE

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1362)
template <typename TText, typename TSA, typename TLCP, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeLCPE( TText &text, TSA &sa, TLCP &lcp, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1514)

//____________________________________________________________________________
// _equalRangeSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(632)

//____________________________________________________________________________
// _findFirstIndex

template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, QGram_FIND_Lookup const);       	// "projects/library/seqan/index/index_qgram_find.h"(57)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, ESA_FIND_MLR const);       	// "projects/library/seqan/index/index_esa_find.h"(1742)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, ESA_FIND_LCPE const);       	// "projects/library/seqan/index/index_esa_find.h"(1754)

//____________________________________________________________________________
// _fractionMerge

template <typename TSTree, typename TSpec, typename TValue, typename TSize > inline void _fractionMerge( Iter<TSTree, VSTree< BottomUp<TSpec> > > &it, _FractionCompound<TValue, TSize> &parent, _FractionCompound<TValue, TSize> &child);       	// "projects/library/seqan/index/index_esa_algs.h"(451)
template <typename TSTree, typename TSpec, typename TValue, typename TSize > inline void _fractionMerge( Iter<TSTree, VSTree< BottomUp<TSpec> > > &it, _FractionMultiCompound<TValue, TSize> &parent, _FractionMultiCompound<TValue, TSize> &child);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(317)

//____________________________________________________________________________
// _fullDir2Length

template <typename TIndex> inline int _fullDir2Length(TIndex const &index);       	// "projects/library/seqan/index/index_qgram.h"(319)

//____________________________________________________________________________
// _fullDirLength

template <typename TIndex> inline int _fullDirLength(TIndex const &index);       	// "projects/library/seqan/index/index_qgram.h"(311)

//____________________________________________________________________________
// _getDown

template <typename TSize, typename TIndex > inline TSize _getDown(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1623)

//____________________________________________________________________________
// _getNextl

template <typename TSize, typename TIndex > inline TSize _getNextl(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1608)

//____________________________________________________________________________
// _getNodeByChar

template <typename TIndex, class TSpec, typename TValue > inline bool _getNodeByChar( Iter< TIndex, VSTree<TSpec> > const &it, TValue c, typename VertexDescriptor<TIndex>::Type &childDesc);       	// "projects/library/seqan/index/index_esa_stree.h"(734)

//____________________________________________________________________________
// _getUp

template <typename TSize, typename TIndex > inline TSize _getUp(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1614)

//____________________________________________________________________________
// _goDown

template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder > inline bool _goDown( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, False> const);       	// "projects/library/seqan/index/index_esa_stree.h"(906)
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder > inline bool _goDown( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, True> const);       	// "projects/library/seqan/index/index_esa_stree.h"(927)
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder > inline bool _goDown( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<TDFSOrder, True> const);       	// "projects/library/seqan/index/index_esa_stree.h"(964)

//____________________________________________________________________________
// _goDownChar

template <typename TIndex, class TSpec, typename TValue > inline bool _goDownChar(Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "projects/library/seqan/index/index_esa_stree.h"(1005)

//____________________________________________________________________________
// _goDownString

template <typename TIndex, typename TSpec, typename TString, typename TSize > inline bool _goDownString( Iter< TIndex, VSTree< TopDown<TSpec> > > &node, TString const &pattern, TSize &lcp);       	// "projects/library/seqan/index/index_esa_stree.h"(1023)

//____________________________________________________________________________
// _goRight

template <typename TText, class TIndexSpec, class TSpec, typename TTraits > inline bool _goRight( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, TTraits const);       	// "projects/library/seqan/index/index_esa_stree.h"(1166)

//____________________________________________________________________________
// _goUp

template <typename TIndex, class TSpec > inline bool _goUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1121)

//____________________________________________________________________________
// _hashFixedShape

template <typename THValue, typename TValue, typename TIter> inline THValue _hashFixedShape(THValue hash, TIter &, TValue const, FixedShape<1> const);       	// "projects/library/seqan/index/shape_base.h"(290)
template <typename THValue, typename TValue, typename TIter, unsigned q> inline THValue _hashFixedShape(THValue hash, TIter &it, TValue const, FixedShape<q> const);       	// "projects/library/seqan/index/shape_base.h"(296)

//____________________________________________________________________________
// _hashHardwiredShape

template <typename THValue, typename TValue, typename TIter> inline THValue _hashHardwiredShape(THValue hash, TIter &, TValue const, HardwiredShape< 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 > const);       	// "projects/library/seqan/index/shape_gapped.h"(448)
template <int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename THValue, typename TValue, typename TIter > inline THValue _hashHardwiredShape(THValue hash, TIter &it, TValue const, HardwiredShape< 1 ,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > const);       	// "projects/library/seqan/index/shape_gapped.h"(465)
template <int P00, int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename THValue, typename TValue, typename TIter > inline THValue _hashHardwiredShape(THValue hash, TIter &it, TValue const, HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > const);       	// "projects/library/seqan/index/shape_gapped.h"(488)

//____________________________________________________________________________
// _hashTuple2FixedShape

template <typename THValue, typename TValue, typename TTValue, unsigned SIZE, typename TCompressed> inline THValue _hashTuple2FixedShape( THValue const, Tuple<TTValue, SIZE, TCompressed> const &tuple, TValue const, FixedShape<1> const);       	// "projects/library/seqan/index/shape_base.h"(353)
template <typename THValue, typename TValue, typename TTValue, unsigned SIZE, typename TCompressed, unsigned q> inline THValue _hashTuple2FixedShape( THValue const, Tuple<TTValue, SIZE, TCompressed> const &tuple, TValue const, FixedShape<q> const);       	// "projects/library/seqan/index/shape_base.h"(364)

//____________________________________________________________________________
// _haveMaximalRepeats

template <typename TValue, typename TSize> int _haveMaximalRepeats( _FractionCompound<TValue, TSize> const &a, _FractionCompound<TValue, TSize> const &b);       	// "projects/library/seqan/index/index_esa_algs.h"(268)
template <typename TValue, typename TSize> int _haveMaximalRepeats( _FractionCompound<TValue, TSize> const &a, _FractionCompound<TValue, TSize> const &b, TValue &equalKey);       	// "projects/library/seqan/index/index_esa_algs.h"(289)

//____________________________________________________________________________
// _historyClear

template <typename TIndex, class TSpec > inline void _historyClear(Iter< TIndex, VSTree<TSpec> > &);       	// "projects/library/seqan/index/index_esa_stree.h"(877)
template <typename TIndex, class TSpec > inline void _historyClear(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(881)

//____________________________________________________________________________
// _historyPush

template <typename TText, class TIndexSpec, class TSpec > inline void _historyPush(Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(887)
template <typename TText, class TIndexSpec, class TSpec > inline void _historyPush(Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(892)

//____________________________________________________________________________
// _indexRequireBottomUpIteration

template <typename TText, typename TSpec > void _indexRequireBottomUpIteration(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_base.h"(298)

//____________________________________________________________________________
// _indexRequireTopDownIteration

template <typename TText, typename TSpec > void _indexRequireTopDownIteration(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_base.h"(290)

//____________________________________________________________________________
// _isLeaf

template <typename TSize > inline bool _isLeaf(VertexESA<TSize> const &vDesc);       	// "projects/library/seqan/index/index_esa_stree.h"(1575)

//____________________________________________________________________________
// _isNextl

template <typename TSize, typename TIndex > inline bool _isNextl(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1592)

//____________________________________________________________________________
// _isRoot

template <typename TSize > inline bool _isRoot(VertexESA<TSize> const &value);       	// "projects/library/seqan/index/index_esa_stree.h"(1329)

//____________________________________________________________________________
// _isSizeInval

template <typename TValue> inline bool _isSizeInval(TValue const &v);       	// "projects/library/seqan/index/index_base.h"(784)

//____________________________________________________________________________
// _isUp

template <typename TSize, typename TIndex > inline bool _isUp(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1600)

//____________________________________________________________________________
// _leqSkew3

template <typename T, typename ST> inline bool _leqSkew3(T a1, ST a2,  T b1, ST b2);       	// "projects/library/seqan/index/index_skew3.h"(313)
template <typename T, typename ST> inline bool _leqSkew3(T a1, T a2, ST a3,  T b1, T b2, ST b3);       	// "projects/library/seqan/index/index_skew3.h"(319)

//____________________________________________________________________________
// _leqSkew7

template <typename T, typename ST> inline bool _leqSkew7(const T * a1, ST a2,  const T * b1, ST b2,  ST n);       	// "projects/library/seqan/index/index_skew7.h"(414)
template <typename T, typename ST> inline bool _leqSkew7(const T * a,  const T * b,  ST n);       	// "projects/library/seqan/index/index_skew7.h"(425)
template <typename T, typename ST, typename TString> inline bool _leqSkew7(unsigned a, unsigned b,  const T* spos[], const ST tpos[], const bool islast[], const TString &s124, const int adjust[7][7]);       	// "projects/library/seqan/index/index_skew7.h"(436)

//____________________________________________________________________________
// _lowerBoundLCPE

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery, typename TDiff_ > inline typename Iterator<TSA, Standard>::Type _lowerBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query, TDiff_ lcpLower, TDiff_ lcpUpper);       	// "projects/library/seqan/index/index_esa_find.h"(992)
template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > &treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1169)

//____________________________________________________________________________
// _lowerBoundSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(524)

//____________________________________________________________________________
// _refineQGramIndex

template <typename TSA, typename TDir, typename TText, typename TSize1, typename TSize2 > void _refineQGramIndex( TSA &sa, TDir &dir, TText const &text, TSize1 oldQ, TSize2 newQ);       	// "projects/library/seqan/index/index_qgram.h"(870)

//____________________________________________________________________________
// _setSizeInval

template <typename TValue> inline void _setSizeInval(TValue &v);       	// "projects/library/seqan/index/index_base.h"(779)

//____________________________________________________________________________
// _sortBucketQuickSort

template <typename TSA, typename TText, typename TSize> void _sortBucketQuickSort( TSA &sa, TText &text, TSize lcp);       	// "projects/library/seqan/index/index_sa_qsort.h"(87)

//____________________________________________________________________________
// _treeLevels

template <typename TSize > inline unsigned _treeLevels(TSize lcpSize);       	// "projects/library/seqan/index/index_lcp_tree.h"(146)

//____________________________________________________________________________
// _upperBoundLCPE

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery, typename TDiff_ > inline typename Iterator<TSA, Standard>::Type _upperBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query, TDiff_ lcpLower, TDiff_ lcpUpper);       	// "projects/library/seqan/index/index_esa_find.h"(1192)
template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > &treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1342)

//____________________________________________________________________________
// _upperBoundSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(578)

//____________________________________________________________________________
// alignment

template <typename TString, typename TSSetSpec, typename TIndexSpec, class TSpec > inline Align<TString, ArrayGaps> alignment(Iter< Index< StringSet<TString, TSSetSpec>, TIndexSpec >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(587)
template <typename TString, typename TConcSpec, typename TIndexSpec, class TSpec > inline Align<TString, ArrayGaps> alignment(Iter< Index< StringSet<TString, Owner<ConcatDirect<TConcSpec> > >, TIndexSpec >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(633)

//____________________________________________________________________________
// atBegin

template <typename TText, typename TSpec, typename TSpecFinder > inline bool atBegin(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(179)

//____________________________________________________________________________
// atEnd

template <typename TText, typename TSpec, typename TSpecFinder > inline bool atEnd(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(187)
template <typename TIndex, class TSpec > inline bool atEnd(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1295)
template <typename TIndex, class TSpec > inline bool atEnd(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1301)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MaxRepeatOccurrences> const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(824)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(829)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MultiMEMOccurences> const &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(644)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MultiMEMOccurences> &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(649)

//____________________________________________________________________________
// begin

template <typename TText, typename TIndexSpec, class TSpec > inline typename Iterator<Index<TText, TIndexSpec>, TSpec >::Type begin(Index<TText, TIndexSpec> &index, TSpec const);       	// "projects/library/seqan/index/index_esa_stree.h"(775)
template <typename TSTree, class TSpec > inline typename Iterator< Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > >::Type begin(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(579)

//____________________________________________________________________________
// bwtAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_BWT> const >::Type>::Type bwtAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(767)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_BWT> const >::Type>::Type bwtAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(771)

//____________________________________________________________________________
// childAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_ChildTab> const >::Type>::Type childAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(746)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_ChildTab> const >::Type>::Type childAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(750)

//____________________________________________________________________________
// childrenAreLeaves

template <typename TIndex, class TSpec > inline bool childrenAreLeaves(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1559)

//____________________________________________________________________________
// childtab_process

template <typename TLCPInput, typename TDest > inline void childtab_process(TLCPInput &lcpIn, TDest &dest);       	// "projects/library/seqan/index/index_childtab.h"(44)

//____________________________________________________________________________
// clear

template <typename TText, typename TSpec> inline void clear(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_base.h"(307)
template <typename TText, typename TSpec, typename TSpecFinder > inline void clear(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(166)
template <typename TIndex, class TSpec > inline void clear(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1225)

//____________________________________________________________________________
// container

template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type container(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(99)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type container(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(107)
template <typename TIndex, class TSpec > inline TIndex const & container(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(487)
template <typename TIndex, class TSpec > inline TIndex & container(Iter< TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(492)

//____________________________________________________________________________
// control

template <typename TInput > inline bool control(Pipe< TInput, LarssonSadakane > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/index_sa_lss.h"(413)
template <typename TInput > inline bool control(Pipe< TInput, Merger3 > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/pipe_merger3.h"(134)
template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/pipe_merger7.h"(475)
template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlEof const &);       	// "projects/library/seqan/index/pipe_merger7.h"(483)
template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlEos const &);       	// "projects/library/seqan/index/pipe_merger7.h"(488)
template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/pipe_merger7.h"(506)
template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlEof const &);       	// "projects/library/seqan/index/pipe_merger7.h"(513)
template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlEos const &);       	// "projects/library/seqan/index/pipe_merger7.h"(518)

//____________________________________________________________________________
// countChildren

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type countChildren(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(710)

//____________________________________________________________________________
// countOccurrences

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type countOccurrences(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(544)

//____________________________________________________________________________
// countSequences

template <typename TText, typename TSpec> inline typename Size<TText>::Type countSequences(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(599)

//____________________________________________________________________________
// createBWTable

template <typename TBWT, typename TText, typename TSA > inline void createBWTable(TBWT &bwt, TText const &s, TSA const &sa);       	// "projects/library/seqan/index/index_shims.h"(424)

//____________________________________________________________________________
// createBWTableExt

template <typename TBWT, typename TText, typename TSA > void createBWTableExt( TBWT &bwt, TText const &s, TSA const &SA);       	// "projects/library/seqan/index/index_shims.h"(382)

//____________________________________________________________________________
// createBWTableInt

template <typename TBWT, typename TText, typename TSA > void createBWTableInt( TBWT &bwt, TText const &s, TSA const &SA);       	// "projects/library/seqan/index/index_bwt.h"(247)
template <typename TBWT, typename TString, typename TSpec, typename TSA > void createBWTableInt( TBWT &bwt, StringSet<TString, TSpec> const &s, TSA const &SA);       	// "projects/library/seqan/index/index_bwt.h"(275)

//____________________________________________________________________________
// createChildTable

template <typename TLCPTable, typename TValue, typename TConfig > inline void createChildTable( String<TValue, External<TConfig> > &childtab, TLCPTable &lcp);       	// "projects/library/seqan/index/index_childtab.h"(197)
template <typename TLCPInput, typename TDest > inline void createChildTable(TDest &dest, TLCPInput const &lcpIn);       	// "projects/library/seqan/index/index_childtab.h"(209)

//____________________________________________________________________________
// createChildTableExt

template <typename TLCPTable, typename TChildTable > void createChildTableExt( TChildTable &childtab, TLCPTable &lcp);       	// "projects/library/seqan/index/index_childtab.h"(171)

//____________________________________________________________________________
// createCountsArray

template <typename TCounts, typename TDir, typename TString, typename TSpec, typename TShape > void createCountsArray( TCounts &counts, TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(1039)

//____________________________________________________________________________
// createLCPBinTree

template <class LCPFwdIt, class FlatOutIt > inline FlatOutIt createLCPBinTree( LCPFwdIt _First, LCPFwdIt _Last, FlatOutIt _Dest);       	// "projects/library/seqan/index/index_lcp_tree.h"(33)
template <typename TLCPE, typename TLCP > inline void createLCPBinTree(TLCPE &lcp_enhanced, TLCP &lcp);       	// "projects/library/seqan/index/index_lcp_tree.h"(139)
template <typename TValue, typename TConfig, typename TLCP > inline void createLCPBinTree(String<TValue, External<TConfig> > &lcp_enhanced, TLCP &lcp);       	// "projects/library/seqan/index/index_lcp_tree.h"(155)

//____________________________________________________________________________
// createLCPETable

template <typename TValue, typename TSpec, typename TText, typename TSA, typename TAlgSpec > void createLCPETable( String< TValue, TSpec > &LCPE, TText const &s, TSA const &SA, TAlgSpec const alg);       	// "projects/library/seqan/index/index_shims.h"(325)
template <typename TValue, typename TConfig, typename TText, typename TSA, typename TAlgSpec > void createLCPETable( String< TValue, External<TConfig> > &LCPE, TText const &s, TSA const &SA, TAlgSpec const alg);       	// "projects/library/seqan/index/index_shims.h"(349)
template <typename TValue, typename TSpec, typename TText, typename TSA> inline void createLCPETable( String< TValue, TSpec > &LCPE, TText &s, TSA &SA);       	// "projects/library/seqan/index/index_shims.h"(362)

//____________________________________________________________________________
// createLCPETableExt

template <typename TValue, typename TSpec, typename TObject, typename TSA, typename TAlgSpec > void createLCPETableExt( String< TValue, TSpec > &LCPE, TObject const &text, TSA const &suffixArray, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(293)

//____________________________________________________________________________
// createLCPTable

template <typename TLCPTable, typename TValue, typename TConfig, typename TSA > void createLCPTable( TLCPTable &LCP, String< TValue, External<TConfig> > const &s, TSA const &SA, Kasai const);       	// "projects/library/seqan/index/index_shims.h"(250)
template <typename TLCPTable, typename TValue, typename TConfig, typename TSSetSpec, typename TSA > void createLCPTable( TLCPTable &LCP, StringSet< String<TValue, External<TConfig> >, TSSetSpec > const &s, TSA const &SA, Kasai const);       	// "projects/library/seqan/index/index_shims.h"(265)
template <typename TLCPTable, typename TText, typename TSA > void createLCPTable( TLCPTable &LCP, TText const &s, TSA const &SA, KasaiOriginal const);       	// "projects/library/seqan/index/index_lcp.h"(253)
template <typename TLCPTable, typename TText, typename TSA > void createLCPTable( TLCPTable &LCP, TText const &s, TSA const &SA, Kasai const);       	// "projects/library/seqan/index/index_lcp.h"(315)
template <typename TLCPTable, typename TString, typename TSpec, typename TSA > void createLCPTable( TLCPTable &LCP, StringSet<TString, TSpec> const &sset, TSA const &SA, Kasai const);       	// "projects/library/seqan/index/index_lcp.h"(398)

//____________________________________________________________________________
// createLCPTableExt

template <typename TLCPTable, typename TObject, typename TSA, typename TAlgSpec > void createLCPTableExt( TLCPTable &LCP, TObject const &text, TSA const &suffixArray, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(174)
template <typename TLCPTable, typename TString, typename TSpec, typename TSA, typename TAlgSpec > void createLCPTableExt( TLCPTable &LCP, StringSet<TString, TSpec> const &stringSet, TSA const &suffixArray, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(204)

//____________________________________________________________________________
// createQGramIndex

template <typename TSA, typename TDir, typename TText, typename TShape > void createQGramIndex( TSA &sa, TDir &dir, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(645)
template <typename TSA, typename TDir, typename TString, typename TSpec, typename TShape > void createQGramIndex( TSA &sa, TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(703)

//____________________________________________________________________________
// createQGramIndexDirOnly

template <typename TDir, typename TText, typename TShape > void createQGramIndexDirOnly( TDir &dir, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(926)
template <typename TDir, typename TString, typename TSpec, typename TShape > void createQGramIndexDirOnly( TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(972)

//____________________________________________________________________________
// createQGramIndexExt

template <typename TSA, typename TDir, typename TText, typename TShape > void createQGramIndexExt( TSA &suffixArray, TDir &dir, TText &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(1188)
template <typename TSA, typename TDir, typename TString, typename TSpec, typename TShape, typename TLimitsString > void createQGramIndexExt( TSA &suffixArray, TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape, TLimitsString &limits);       	// "projects/library/seqan/index/index_qgram.h"(1275)

//____________________________________________________________________________
// createQGramIndexSAOnly

template <typename TSA, typename TText, typename TShape > void createQGramIndexSAOnly( TSA &sa, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(788)
template <typename TSA, typename TString, typename TSpec, typename TShape > void createQGramIndexSAOnly( TSA &sa, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(823)

//____________________________________________________________________________
// createSABTree

template <class SAFwdIt, class FlatOutIt > inline FlatOutIt createSABTree( SAFwdIt _First, SAFwdIt _Last, FlatOutIt _Dest, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(33)
template <typename TSAB, typename TSA > inline void createSABTree(TSAB &sa_btree, TSA &sa, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(96)
template <typename TValue, typename TConfig, typename TSA > inline void createSABTree(String<TValue, External<TConfig> > &sa_btree, TSA &sa, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(110)

//____________________________________________________________________________
// createSuffixArray

template <typename TSA, typename TText, typename TAlgSpec > inline void createSuffixArray( TSA &SA, TText const &s, TAlgSpec const &alg);       	// "projects/library/seqan/index/index_shims.h"(119)
template <typename TSA, typename TValue, typename TConfig, typename TAlgSpec > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > const &s, TAlgSpec const alg);       	// "projects/library/seqan/index/index_shims.h"(136)
template <typename TSA, typename TValue, typename TSpec, typename TSSetSpec, typename TAlgSpec > inline void createSuffixArray( TSA &SA, StringSet< String<TValue, TSpec>, TSSetSpec > const &s, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(151)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, LarssonSadakane const &, unsigned K);       	// "projects/library/seqan/index/index_sa_lss.h"(352)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, ManberMyers const &, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_sa_mm.h"(42)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, SAQSort const &);       	// "projects/library/seqan/index/index_sa_qsort.h"(102)
template <typename TSA, typename TValue, typename TConfig > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > &s, Skew3 const &spec, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew3.h"(299)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Skew3 const &, unsigned K, unsigned maxdepth, unsigned depth);       	// "projects/library/seqan/index/index_skew3.h"(342)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, Skew3 const &alg, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew3.h"(494)
template <typename TSA, typename TValue, typename TConfig > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > &s, Skew7 const &spec, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew7.h"(399)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Skew7 const &, unsigned K, unsigned maxdepth, unsigned depth);       	// "projects/library/seqan/index/index_skew7.h"(472)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, Skew7 const &alg, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew7.h"(792)

//____________________________________________________________________________
// createSuffixArrayExt

template <typename TSA, typename TObject, typename TAlgSpec > void createSuffixArrayExt( TSA &suffixArray, TObject const &text, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(40)
template <typename TSA, typename TString, typename TSpec, typename TAlgSpec > void createSuffixArrayExt( TSA &suffixArray, StringSet<TString, TSpec> const &stringSet, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(73)

//____________________________________________________________________________
// createSuffixArrayPart

template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, ManberMyers const &alg, TSize maxLCP, unsigned K );       	// "projects/library/seqan/index/index_sa_mm.h"(167)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew3 const &_dummy, TSize maxLCP, unsigned K );       	// "projects/library/seqan/index/index_skew3.h"(508)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew7 const &_dummy, TSize maxLCP, unsigned K );       	// "projects/library/seqan/index/index_skew7.h"(806)

//____________________________________________________________________________
// dirAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_Dir> >::Type>::Type dirAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_qgram.h"(254)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_Dir> >::Type>::Type dirAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_qgram.h"(258)

//____________________________________________________________________________
// empty

template <typename TText, typename TSpec, typename TSpecFinder > inline bool empty(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(158)
template <typename TIndex, class TSpec > inline bool empty(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1280)
template <typename TIndex, class TSpec > inline bool empty(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1286)

//____________________________________________________________________________
// end

template <typename TText, typename TIndexSpec, class TSpec > inline typename Iterator<Index<TText, TIndexSpec>, TSpec >::Type end(Index<TText, TIndexSpec> &index, TSpec const);       	// "projects/library/seqan/index/index_esa_stree.h"(815)
template <typename TSTree, class TSpec > inline typename Iterator< Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > >::Type end(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(589)

//____________________________________________________________________________
// eof

template <typename TIndex, class TSpec > inline bool eof(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1268)
template <typename TIndex, class TSpec > inline bool eof(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1274)

//____________________________________________________________________________
// equalRangeLCPE

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1586)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1688)

//____________________________________________________________________________
// equalRangeLCPEIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > equalRangeLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1637)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > equalRangeLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1707)

//____________________________________________________________________________
// equalRangeSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(853)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(870)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(950)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(967)

//____________________________________________________________________________
// equalRangeSAIterator

template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(727)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(773)

//____________________________________________________________________________
// find

template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline bool find( Finder<Index<TText, TSpec>, TSpecFinder> &finder, TPattern const &pattern);       	// "projects/library/seqan/index/index_find.h"(248)
template <typename TText, typename TSpec, typename TSpecFinder > inline bool find(Finder<Index<TText, TSpec>, TSpecFinder> &finder);       	// "projects/library/seqan/index/index_find.h"(259)

//____________________________________________________________________________
// getFibre

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Dir> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_Dir> const);       	// "projects/library/seqan/index/index_qgram.h"(177)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Dir> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_Dir> const);       	// "projects/library/seqan/index/index_qgram.h"(182)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Counts> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_Counts> const);       	// "projects/library/seqan/index/index_qgram.h"(188)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Counts> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_Counts> const);       	// "projects/library/seqan/index/index_qgram.h"(193)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_CountsDir> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_CountsDir> const);       	// "projects/library/seqan/index/index_qgram.h"(199)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_CountsDir> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_CountsDir> const);       	// "projects/library/seqan/index/index_qgram.h"(204)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Shape> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_Shape> const);       	// "projects/library/seqan/index/index_qgram.h"(210)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Shape> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_Shape> const);       	// "projects/library/seqan/index/index_qgram.h"(215)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Text> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_Text> const);       	// "projects/library/seqan/index/index_base.h"(466)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Text> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_Text> const);       	// "projects/library/seqan/index/index_base.h"(471)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_RawText> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_RawText> const);       	// "projects/library/seqan/index/index_base.h"(479)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_RawText> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_RawText> const);       	// "projects/library/seqan/index/index_base.h"(484)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_SA> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_SA> const);       	// "projects/library/seqan/index/index_base.h"(492)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_SA> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_SA> const);       	// "projects/library/seqan/index/index_base.h"(497)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_SA> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_RawSA> const);       	// "projects/library/seqan/index/index_base.h"(505)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename Fibre<Index<StringSet<TString, TSSetSpec>, TSpec>, Tag<_Fibre_RawSA> const >::Type getFibre(Index<StringSet<TString, TSSetSpec>, TSpec> &index, Tag<_Fibre_RawSA> const);       	// "projects/library/seqan/index/index_base.h"(518)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_LCP> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_LCP> const);       	// "projects/library/seqan/index/index_base.h"(538)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_LCP> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_LCP> const);       	// "projects/library/seqan/index/index_base.h"(543)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_LCPE> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_LCPE> const);       	// "projects/library/seqan/index/index_base.h"(551)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_LCPE> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_LCPE> const);       	// "projects/library/seqan/index/index_base.h"(556)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_ChildTab> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_ChildTab> const);       	// "projects/library/seqan/index/index_base.h"(564)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_ChildTab> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_ChildTab> const);       	// "projects/library/seqan/index/index_base.h"(569)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_BWT> const >::Type & getFibre(Index<TText, TSpec> &index, Tag<_Fibre_BWT> const);       	// "projects/library/seqan/index/index_base.h"(577)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_BWT> const >::Type & getFibre(Index<TText, TSpec> const &index, Tag<_Fibre_BWT> const);       	// "projects/library/seqan/index/index_base.h"(582)

//____________________________________________________________________________
// getFrequency

template <typename TIndex, class TSpec, typename TSet > inline int getFrequency(Iter<TIndex, VSTree<TSpec> > const &it, TSet &set);       	// "projects/library/seqan/index/index_esa_stree.h"(1513)
template <typename TIndex, class TSpec > inline int getFrequency(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1539)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TObject, typename TSpec, typename TDistMatrix > inline void getKmerSimilarityMatrix( Index< TObject, Index_QGram<TSpec> > &index, TDistMatrix &distMat);       	// "projects/library/seqan/index/index_qgram.h"(1427)
template <typename TObject, typename TSpec, typename TDistMatrix, typename TSeqNoString > inline void getKmerSimilarityMatrix( Index< TObject, Index_QGram<TSpec> > &index, TDistMatrix &distMat, TSeqNoString const &seqNo);       	// "projects/library/seqan/index/index_qgram.h"(1521)

//____________________________________________________________________________
// getOccurrence

template <typename TIndex, class TSpec > inline typename SAValue<TIndex>::Type getOccurrence(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(525)

//____________________________________________________________________________
// getOccurrences

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, ESA_SA>::Type const >::Type getOccurrences(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(565)

//____________________________________________________________________________
// getOccurrencesBWT

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, ESA_BWT>::Type const >::Type getOccurrencesBWT(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(667)

//____________________________________________________________________________
// goBegin

template <typename TText, typename TSpec, typename TSpecFinder > inline void goBegin(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(197)
template <typename TText, typename TIndexSpec, class TSpec > inline void goBegin(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(785)
template <typename TText, typename TIndexSpec, class TSpec > inline void goBegin(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(793)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goBegin(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(810)

//____________________________________________________________________________
// goDown

template <typename TIndex, class TSpec > inline bool goDown(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(994)
template <typename TIndex, typename TSpecIter, typename TValue > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpecIter> > > &it, TValue const &c);       	// "projects/library/seqan/index/index_esa_stree.h"(1062)
template <typename TIndex, typename TSpecIter, typename TValue, typename TSpec > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpecIter> > > &it, String<TValue, TSpec> const &pattern);       	// "projects/library/seqan/index/index_esa_stree.h"(1071)
template <typename TIndex, typename TSpecIter, typename THost, typename TSpec > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpecIter> > > &it, Segment<THost, TSpec> const &pattern);       	// "projects/library/seqan/index/index_esa_stree.h"(1081)
template <typename TIndex, typename TSpecIter, typename TValue, typename TSpec, typename TSize > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpecIter> > > &it, String<TValue, TSpec> const &pattern, TSize lcp);       	// "projects/library/seqan/index/index_esa_stree.h"(1093)
template <typename TIndex, typename TSpecIter, typename THost, typename TSpec, typename TSize > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpecIter> > > &it, Segment<THost, TSpec> const &pattern, TSize lcp);       	// "projects/library/seqan/index/index_esa_stree.h"(1103)

//____________________________________________________________________________
// goEnd

template <typename TText, typename TSpec, typename TSpecFinder > inline void goEnd(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(205)
template <typename TText, typename TIndexSpec, class TSpec > inline void goEnd(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(826)
template <typename TText, typename TIndexSpec, class TSpec > inline void goEnd(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(833)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goEnd(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(819)

//____________________________________________________________________________
// goNext

template <typename TIndex, typename TSpec > inline void goNext(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(844)
template <typename TIndex, typename TSpec, typename TTraits > inline void goNext(Iter<TIndex, VSTree<TSpec> > &it, TTraits const traits);       	// "projects/library/seqan/index/index_esa_stree.h"(849)
template <typename TSTree > inline void goNext(Iter< TSTree, VSTree< BottomUp<SuperMaxRepeats> > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(96)
template <typename TText, typename TSpec > inline void goNext(Iter< Index<TText, Index_ESA<TSpec> >, VSTree< BottomUp<SuperMaxRepeatsFast> > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(187)
template <typename TSTree, typename TSpec > inline void goNext(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(533)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goNext(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(793)
template <typename TSTree > inline void goNext(Iter< TSTree, VSTree< BottomUp<MUMs> > > &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(100)
template <typename TRepeat > inline Iter<TRepeat, MultiMEMOccurences> & goNext(Iter<TRepeat, MultiMEMOccurences> &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(630)

//____________________________________________________________________________
// goNextImpl

template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, VSTreeIteratorTraits<_Postorder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(281)
template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<_Preorder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1243)
template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<_Postorder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1254)

//____________________________________________________________________________
// goRight

template <typename TIndex, class TSpec > inline bool goRight(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1189)

//____________________________________________________________________________
// goUp

template <typename TIndex, class TSpec > inline bool goUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1134)

//____________________________________________________________________________
// hash

template <typename TValue, typename TIter> inline typename Value< Shape<TValue, GappedShape> >::Type hash(Shape<TValue, GappedShape> &me, TIter it);       	// "projects/library/seqan/index/shape_gapped.h"(368)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, FixedGappedShape<TSpec> > >::Type hash(Shape<TValue, FixedGappedShape<TSpec> > &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_gapped.h"(385)
template <int P00, int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename TValue, typename TIter > inline typename Value< Shape<TValue, FixedGappedShape< HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > > > >::Type hash(Shape<TValue, FixedGappedShape< HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > > > &me, TIter it);       	// "projects/library/seqan/index/shape_gapped.h"(517)
template <typename TValue, typename TIter> typename Value< Shape<TValue, SimpleShape> >::Type hash(Shape<TValue, SimpleShape> &me, TIter it);       	// "projects/library/seqan/index/shape_base.h"(271)
template <typename TValue, unsigned q, typename TIter> inline typename Value< Shape<TValue, FixedShape<q> > >::Type hash(Shape<TValue, FixedShape<q> > &me, TIter it);       	// "projects/library/seqan/index/shape_base.h"(307)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(320)
template <typename TValue, typename TTValue, unsigned SIZE, unsigned q> typename Value< Shape<TValue, FixedShape<q> > >::Type hash( Shape<TValue, FixedShape<q> > &me, Tuple<TTValue, SIZE, Compressed> const &tuple);       	// "projects/library/seqan/index/shape_base.h"(379)
template <typename TValue, typename TTValue, unsigned SIZE, typename TCompressed, unsigned q> typename Value< Shape<TValue, FixedShape<q> > >::Type hash( Shape<TValue, FixedShape<q> > &me, Tuple<TTValue, SIZE, TCompressed> const &tuple);       	// "projects/library/seqan/index/shape_base.h"(400)

//____________________________________________________________________________
// hash2

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(490)

//____________________________________________________________________________
// hash2Next

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2Next(Shape<TValue, TSpec> &me, TIter &it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(568)

//____________________________________________________________________________
// hash2Upper

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2Upper(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(519)

//____________________________________________________________________________
// hashNext

template <typename TValue, typename TSpec, typename TIter> inline typename Value< Shape<TValue, FixedGappedShape<TSpec> > >::Type hashNext(Shape<TValue, FixedGappedShape<TSpec> > &me, TIter it);       	// "projects/library/seqan/index/shape_gapped.h"(536)
template <typename TValue, typename TSpec, typename TIter> inline typename Value< Shape<TValue, TSpec> >::Type hashNext(Shape<TValue, TSpec> &me, TIter &it);       	// "projects/library/seqan/index/shape_base.h"(463)

//____________________________________________________________________________
// hashUpper

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, FixedGappedShape<TSpec> > >::Type hashUpper(Shape<TValue, FixedGappedShape<TSpec> > &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_gapped.h"(413)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hashUpper(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(422)

//____________________________________________________________________________
// host

template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type host(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(83)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type host(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(91)

//____________________________________________________________________________
// hostIterator

template <typename TText, typename TSpec, typename TSpecFinder > inline typename Iterator< typename Fibre<Index<TText, TSpec>, Tag<_Fibre_SA> const >::Type, Standard>::Type & hostIterator(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(139)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Iterator< typename Fibre<Index<TText, TSpec>, Tag<_Fibre_SA> const >::Type, Standard>::Type const & hostIterator(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(147)

//____________________________________________________________________________
// indexBWT

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_BWT> const >::Type & indexBWT(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(922)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_BWT> const >::Type & indexBWT(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(924)

//____________________________________________________________________________
// indexChildTab

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_ChildTab> const >::Type & indexChildTab(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(938)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_ChildTab> const >::Type & indexChildTab(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(940)

//____________________________________________________________________________
// indexCounts

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Counts> const >::Type & indexCounts(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(278)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Counts> const >::Type & indexCounts(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(283)

//____________________________________________________________________________
// indexCountsDir

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_CountsDir> const >::Type & indexCountsDir(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(289)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_CountsDir> const >::Type & indexCountsDir(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(294)

//____________________________________________________________________________
// indexCreate

template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, Tag<_Fibre_SA> const, TSpecAlg const alg);       	// "projects/library/seqan/index/index_shims.h"(481)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, Tag<_Fibre_LCP> const, TSpecAlg const alg);       	// "projects/library/seqan/index/index_shims.h"(488)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, Tag<_Fibre_LCPE> const, TSpecAlg const alg);       	// "projects/library/seqan/index/index_shims.h"(495)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, TSpec> &index, Tag<_Fibre_BWT> const, BWT const);       	// "projects/library/seqan/index/index_shims.h"(503)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, TSpec> &index, Tag<_Fibre_ChildTab> const, ChildTab const);       	// "projects/library/seqan/index/index_shims.h"(510)
template <typename TText, typename TSpec, typename TFibre> inline bool indexCreate(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "projects/library/seqan/index/index_shims.h"(517)
template <typename TText, typename TShapeSpec> inline bool indexCreate(Index<TText, Index_QGram<TShapeSpec> > &index, Tag<_Fibre_SADir> const, Default const);       	// "projects/library/seqan/index/index_qgram.h"(1357)
template <typename TText, typename TShapeSpec> inline bool indexCreate(Index<TText, Index_QGram<TShapeSpec> > &index, Tag<_Fibre_SA> const, Default const alg);       	// "projects/library/seqan/index/index_qgram.h"(1382)
template <typename TText, typename TShapeSpec> inline bool indexCreate(Index<TText, Index_QGram<TShapeSpec> > &index, Tag<_Fibre_Counts> const, Default const);       	// "projects/library/seqan/index/index_qgram.h"(1401)

//____________________________________________________________________________
// indexDir

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Dir> const >::Type & indexDir(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(232)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Dir> const >::Type & indexDir(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(237)

//____________________________________________________________________________
// indexLCP

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_LCP> const >::Type & indexLCP(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(890)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_LCP> const >::Type & indexLCP(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(892)

//____________________________________________________________________________
// indexLCPE

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_LCPE> const >::Type & indexLCPE(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(906)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_LCPE> const >::Type & indexLCPE(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(908)

//____________________________________________________________________________
// indexRawSA

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_RawSA> const >::Type indexRawSA(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(874)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_RawSA> const >::Type indexRawSA(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(876)

//____________________________________________________________________________
// indexRawText

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_RawText> const >::Type & indexRawText(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(842)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_RawText> const >::Type & indexRawText(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(844)

//____________________________________________________________________________
// indexRequire

template <typename TText, typename TSpec, typename TFibre> inline bool indexRequire(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "projects/library/seqan/index/index_shims.h"(556)

//____________________________________________________________________________
// indexSA

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_SA> const >::Type & indexSA(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(858)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_SA> const >::Type & indexSA(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(860)

//____________________________________________________________________________
// indexShape

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Shape> const >::Type & indexShape(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(300)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Shape> const >::Type & indexShape(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(305)

//____________________________________________________________________________
// indexSolveDependencies

template <typename TText, typename TSpec, typename TFibre> inline bool indexSolveDependencies(Index<TText, TSpec> &, Tag<TFibre> const);       	// "projects/library/seqan/index/index_shims.h"(567)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Tag<_Fibre_LCP> const);       	// "projects/library/seqan/index/index_shims.h"(572)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Tag<_Fibre_LCPE> const);       	// "projects/library/seqan/index/index_shims.h"(577)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Tag<_Fibre_ChildTab> const);       	// "projects/library/seqan/index/index_shims.h"(582)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Tag<_Fibre_BWT> const);       	// "projects/library/seqan/index/index_shims.h"(587)

//____________________________________________________________________________
// indexSupplied

template <typename TText, typename TSpec, typename TFibre> inline bool indexSupplied(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "projects/library/seqan/index/index_shims.h"(536)
template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, TSpec> &index, Tag<_Fibre_SADir> const);       	// "projects/library/seqan/index/index_qgram.h"(1376)

//____________________________________________________________________________
// indexText

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Tag<_Fibre_Text> const >::Type & indexText(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(800)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Tag<_Fibre_Text> const >::Type & indexText(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(802)

//____________________________________________________________________________
// isLeaf

template <typename TIndex, class TSpec > inline bool isLeaf(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1582)

//____________________________________________________________________________
// isLeftMaximal

template <typename TIndex, class TSpec > inline bool isLeftMaximal(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1369)

//____________________________________________________________________________
// isPartiallyLeftExtensible

template <typename TIndex, class TSpec, typename TSet > inline bool isPartiallyLeftExtensible(Iter<TIndex, VSTree<TSpec> > const &it, TSet &charSet);       	// "projects/library/seqan/index/index_esa_stree.h"(1417)
template <typename TIndex, class TSpec > inline bool isPartiallyLeftExtensible(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1451)

//____________________________________________________________________________
// isRightTerminal

template <typename TIndex, class TSpec > inline bool isRightTerminal(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1346)

//____________________________________________________________________________
// isRoot

template <typename TIndex, class TSpec > inline bool isRoot(Iter<TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1317)
template <typename TIndex, class TSpec > inline bool isRoot(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1323)

//____________________________________________________________________________
// isUnique

template <typename TIndex, class TSpec, typename TSet > inline bool isUnique(Iter<TIndex, VSTree<TSpec> > const &it, TSet &set);       	// "projects/library/seqan/index/index_esa_stree.h"(1469)
template <typename TIndex, class TSpec > inline bool isUnique(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1492)

//____________________________________________________________________________
// lca

template <typename TIndex, class TSpec1, class TSpec2 > inline bool lca( Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &a, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec2> > > > &b, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &_lca);       	// "projects/library/seqan/index/index_esa_stree.h"(400)

//____________________________________________________________________________
// lcp

template <typename TIndex, class TSpec1, class TSpec2 > inline typename Size<TIndex>::Type lcp( Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &a, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec2> > > > &b);       	// "projects/library/seqan/index/index_esa_stree.h"(451)

//____________________________________________________________________________
// lcpAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_LCP> const >::Type>::Type lcpAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(704)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_LCP> const >::Type>::Type lcpAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(708)

//____________________________________________________________________________
// lcp_process

template <typename TTextInput, typename TInvertedSAInput, typename TDest > static void lcp_process(TTextInput &textIn, TInvertedSAInput &invertedSAIn, TDest &dest, LcpConfig conf);       	// "projects/library/seqan/index/pump_lcp_core.h"(56)
template <typename TTextInput, typename TInvertedSAInput, typename TDest > static inline void lcp_process(TTextInput &textIn, TInvertedSAInput &invertedSAIn, TDest &dest);       	// "projects/library/seqan/index/pump_lcp_core.h"(196)

//____________________________________________________________________________
// lcp_process_multi

template <typename TTextInput, typename TLimitsString, typename TInvertedSAInput, typename TDest > static void lcp_process_multi( TTextInput &textIn, TLimitsString const &limits, TInvertedSAInput &invertedSAIn, TDest &dest, LcpConfig conf);       	// "projects/library/seqan/index/pump_lcp_core.h"(208)
template <typename TTextInput, typename TLimitsString, typename TInvertedSAInput, typename TDest > static void lcp_process_multi( TTextInput &textIn, TLimitsString const &limits, TInvertedSAInput &invertedSAIn, TDest &dest);       	// "projects/library/seqan/index/pump_lcp_core.h"(367)

//____________________________________________________________________________
// lcpeAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_LCPE> const >::Type>::Type lcpeAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(725)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_LCPE> const >::Type>::Type lcpeAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(729)

//____________________________________________________________________________
// length

template <typename TInput > inline typename Size< Pipe< TInput, LarssonSadakane > >::Type length(Pipe< TInput, LarssonSadakane > const &me);       	// "projects/library/seqan/index/index_sa_lss.h"(421)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, TSpec> >::Type length(Shape<TValue, TSpec> const &me);       	// "projects/library/seqan/index/shape_base.h"(215)
template <typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type length(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(591)
template <typename TSTree, typename TSpec > inline typename Size<TSTree>::Type length(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(570)
template <typename TSTree> inline typename Size< MaxRepeat<TSTree> >::Type length(MaxRepeat<TSTree> const &repeat);       	// "projects/library/seqan/index/index_esa_algs.h"(619)
template <typename TSTree> inline typename Size< MultiMEM<TSTree> >::Type length(MultiMEM<TSTree> const &repeat);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(402)
template <typename TInput > inline typename Size< Pipe< TInput, Merger3 > >::Type length(Pipe< TInput, Merger3 > const &me);       	// "projects/library/seqan/index/pipe_merger3.h"(145)
template <typename TInput > inline typename Size< Pipe< TInput, Merger7 > >::Type length(Pipe< TInput, Merger7 > const &me);       	// "projects/library/seqan/index/pipe_merger7.h"(494)
template <typename TInput, typename TLimitsString > inline typename Size< Pipe< TInput, Merger7Multi<TLimitsString> > >::Type length(Pipe< TInput, Merger7Multi<TLimitsString> > const &me);       	// "projects/library/seqan/index/pipe_merger7.h"(524)

//____________________________________________________________________________
// lowerBoundLCPE

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type lowerBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1554)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type lowerBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1656)

//____________________________________________________________________________
// lowerBoundLCPEIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Iterator<TSA, Standard>::Type lowerBoundLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1605)

//____________________________________________________________________________
// lowerBoundSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(793)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(807)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(890)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(904)

//____________________________________________________________________________
// lowerBoundSAIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(699)
template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(745)

//____________________________________________________________________________
// nodeUp

template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type nodeUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1142)

//____________________________________________________________________________
// open

template <typename TObject, typename TSpec > inline bool open( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_esa_base.h"(324)
template <typename TObject, typename TSpec > inline bool open( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_esa_base.h"(340)
template <typename TValue, typename TSpec > inline bool open(String<TValue, TSpec> &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(596)
template <typename TValue, typename TSpec > inline bool open(String<TValue, TSpec> &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(603)
template <typename THost, typename TSpec > inline bool open(Segment<THost, TSpec> &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(608)
template <typename THost, typename TSpec > inline bool open(Segment<THost, TSpec> &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(615)
template <typename TValue, typename TSpec, typename TSSSpec > inline bool open(StringSet<String<TValue, TSpec>, TSSSpec> &multi, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(620)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool open(StringSet<String<TValue, TSpec>, TSSSpec> &multi, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(633)
template <typename TObject, typename TSpec > inline bool open( Index< TObject, Index_QGram<TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_qgram.h"(1638)
template <typename TObject, typename TSpec > inline bool open( Index< TObject, Index_QGram<TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_qgram.h"(1652)

//____________________________________________________________________________
// operator!=

template <typename TRepeat > inline bool operator!= ( Iter<TRepeat, MaxRepeatOccurrences> const &itA, Iter<TRepeat, MaxRepeatOccurrences> const &itB);       	// "projects/library/seqan/index/index_esa_algs.h"(851)

//____________________________________________________________________________
// operator<<

template <typename TInput, typename _TLCPInput > inline bool operator<<(Pipe< TInput, ChildTab > &me, _TLCPInput const &in);       	// "projects/library/seqan/index/index_childtab.h"(162)
template <typename TInput, typename TObject, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Skew7, TPair, TLimitsString> > &me, TObject &textIn);       	// "projects/library/seqan/index/index_skew7_multi.h"(404)
template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput > inline bool operator<<(Pipe< TInput, Kasai > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_lcp.h"(131)
template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Kasai, TPair, TLimitsString> > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_lcp.h"(234)
template <typename TInput, typename TObject > inline bool operator<<(Pipe< TInput, Skew3 > &me, TObject &textIn);       	// "projects/library/seqan/index/index_skew3.h"(285)
template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput > inline bool operator<<(Pipe< TInput, BWT > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_bwt.h"(113)
template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<BWT, TPair, TLimitsString> > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_bwt.h"(229)
template <typename TValue> std::ostream& operator<<(std::ostream &out, const SkewDCStream<TValue> &s);       	// "projects/library/seqan/index/pipe_merger7.h"(77)
template <typename TInput, typename TObject > inline bool operator<<(Pipe< TInput, Skew7 > &me, TObject &textIn);       	// "projects/library/seqan/index/index_skew7.h"(385)

//____________________________________________________________________________
// operator==

template <typename TRepeat > inline bool operator== ( Iter<TRepeat, MaxRepeatOccurrences> const &itA, Iter<TRepeat, MaxRepeatOccurrences> const &itB);       	// "projects/library/seqan/index/index_esa_algs.h"(840)

//____________________________________________________________________________
// orderOccurrences

template <typename TValue, typename TSpec> inline void orderOccurrences(String<TValue, TSpec> &occString);       	// "projects/library/seqan/index/index_shims.h"(458)

//____________________________________________________________________________
// parentEdgeLabel

template <typename TText, class TIndexSpec, class TSpec > inline typename Infix< typename Fibre<Index<TText, Index_ESA<TIndexSpec> >, ESA_RawText>::Type const >::Type parentEdgeLabel(Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1207)

//____________________________________________________________________________
// position

template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type position(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(225)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type position(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(234)

//____________________________________________________________________________
// radixExtend

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixExtend( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "projects/library/seqan/index/radix.h"(102)

//____________________________________________________________________________
// radixExtendClip

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixExtendClip( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "projects/library/seqan/index/radix.h"(132)

//____________________________________________________________________________
// radixPass

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixPass( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "projects/library/seqan/index/radix.h"(39)
template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText, typename TShift > void radixPass( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K, TShift shift);       	// "projects/library/seqan/index/radix.h"(69)

//____________________________________________________________________________
// rawsaAt

template <typename TPos, typename TIndex> inline typename Value<typename Fibre<TIndex const, Tag<_Fibre_RawSA> const >::Type>::Type rawsaAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(686)

//____________________________________________________________________________
// rawtextAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_RawText> const >::Type>::Type rawtextAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(656)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_RawText> const >::Type>::Type rawtextAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(660)

//____________________________________________________________________________
// repLength

template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type repLength(Iter< TIndex, VSTree<BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(351)
template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type repLength(TIndex const &index, VertexESA<TSize> const &vDesc);       	// "projects/library/seqan/index/index_esa_stree.h"(363)
template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type repLength(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(377)
template <typename TSTree, typename TSpec > inline typename Size<TSTree>::Type repLength(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(562)

//____________________________________________________________________________
// representative

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, ESA_RawText>::Type const >::Type representative(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(688)

//____________________________________________________________________________
// resize

template <typename TValue, typename TSize> inline typename Size< Shape<TValue, SimpleShape> >::Type resize(Shape<TValue, SimpleShape> & me, TSize new_length);       	// "projects/library/seqan/index/shape_base.h"(246)

//____________________________________________________________________________
// saAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_SA> const >::Type>::Type saAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(677)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Tag<_Fibre_SA> const >::Type>::Type saAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(681)

//____________________________________________________________________________
// save

template <typename TObject, typename TSpec > inline bool save( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_esa_base.h"(353)
template <typename TObject, typename TSpec > inline bool save( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_esa_base.h"(369)
template <typename TValue, typename TSpec > inline bool save(String<TValue, TSpec> const &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(642)
template <typename TValue, typename TSpec > inline bool save(String<TValue, TSpec> &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(650)
template <typename THost, typename TSpec > inline bool save(Segment<THost, TSpec> const &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(655)
template <typename THost, typename TSpec > inline bool save(Segment<THost, TSpec> const &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(663)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool save(StringSet<String<TValue, TSpec>, TSSSpec> const &multi, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(668)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool save(StringSet<String<TValue, TSpec>, TSSSpec> const &multi, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(683)
template <typename TObject, typename TSpec > inline bool save( Index< TObject, Index_QGram<TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_qgram.h"(1665)
template <typename TObject, typename TSpec > inline bool save( Index< TObject, Index_QGram<TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_qgram.h"(1679)

//____________________________________________________________________________
// sequenceLength

template <typename TSeqNo, typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type sequenceLength(TSeqNo seqNo, Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(607)

//____________________________________________________________________________
// setContainer

template <typename TText, typename TSpec, typename TSpecFinder > inline void setContainer( Finder< Index<TText, TSpec>, TSpecFinder > & me, typename _Parameter<Index<TText, TSpec> >::Type container_);       	// "projects/library/seqan/index/index_find.h"(129)

//____________________________________________________________________________
// setHost

template <typename TText, typename TSpec, typename TSpecFinder > inline void setHost( Finder< Index<TText, TSpec>, TSpecFinder > & me, typename _Parameter<Index<TText, TSpec> >::Type container_);       	// "projects/library/seqan/index/index_find.h"(119)

//____________________________________________________________________________
// sizeofLCPE

template <typename TSize > inline TSize sizeofLCPE(TSize n);       	// "projects/library/seqan/index/index_lcp_tree.h"(105)
template <class LCPFwdIt, typename TSize > inline void sizeofLCPE(LCPFwdIt _First, LCPFwdIt _Last, TSize &_Size);       	// "projects/library/seqan/index/index_lcp_tree.h"(124)

//____________________________________________________________________________
// sizeofLCPH

template <typename TSize > inline TSize sizeofLCPH(TSize n);       	// "projects/library/seqan/index/index_lcp_tree.h"(116)
template <class LCPFwdIt, typename TSize > inline void sizeofLCPH(LCPFwdIt _First, LCPFwdIt _Last, TSize &_Size);       	// "projects/library/seqan/index/index_lcp_tree.h"(132)

//____________________________________________________________________________
// sizeofSAB

template <typename TSize > inline TSize sizeofSAB(TSize n, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(79)
template <class SAFwdIt, typename TSize > inline void sizeofSAB(SAFwdIt _First, SAFwdIt _Last, TSize &_Size, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(90)

//____________________________________________________________________________
// skew3_extend

template <typename TTextInput, typename TNameInput, typename TOut0, typename TOut12 > static bool skew3_extend(TTextInput &textIn, TNameInput &nameIn, TOut0 &out0, TOut12 &out12);       	// "projects/library/seqan/index/pump_extender3.h"(54)

//____________________________________________________________________________
// skew7_extend

template <typename TTextInput, typename TNameInput, typename TOut0, typename TOut3, typename TOut5, typename TOut6, typename TOut124 > static bool skew7_extend(TTextInput &textIn, TNameInput &nameIn, TOut0 &out0, TOut3 &out3, TOut5 &out5, TOut6 &out6, TOut124 &out124);       	// "projects/library/seqan/index/pump_extender7.h"(75)

//____________________________________________________________________________
// skew7_extend_multi

template <typename TTextInput, typename TLimitsString, typename TNameInput, typename TOut0, typename TOut3, typename TOut5, typename TOut6, typename TOut124 > static bool skew7_extend_multi( TTextInput &textIn, TLimitsString const &limits, TNameInput &nameIn1, TNameInput &nameIn2, TNameInput &nameIn4, TOut0 &out0, TOut3 &out3, TOut5 &out5, TOut6 &out6, TOut124 &out124);       	// "projects/library/seqan/index/pump_extender7.h"(265)

//____________________________________________________________________________
// skew7_separate_slices

template <typename TInput, typename TFunctor, typename TOut1, typename TOut2, typename TOut4 > static void skew7_separate_slices( TInput &in, TFunctor const &funcSlice, TOut1 &out1, TOut2 &out2, TOut4 &out4);       	// "projects/library/seqan/index/pump_separator7.h"(35)

//____________________________________________________________________________
// stringSetLimits

template <typename TText, typename TSpec> inline typename StringSetLimits<TText const>::Type stringSetLimits(Index<TText, TSpec> &);       	// "projects/library/seqan/index/index_base.h"(808)
template <typename TText, typename TSpec> inline typename StringSetLimits<TText const>::Type stringSetLimits(Index<TText, TSpec> const &);       	// "projects/library/seqan/index/index_base.h"(814)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSSetSpec> const >::Type & stringSetLimits(Index<StringSet<TString, TSSetSpec>, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(820)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSSetSpec> const >::Type & stringSetLimits(Index<StringSet<TString, TSSetSpec>, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(826)

//____________________________________________________________________________
// stringToShape

template <typename TValue, typename TSpec, typename TShapeString> inline void stringToShape( Shape<TValue, FixedGappedShape<TSpec> > &me, TShapeString const &bitmap);       	// "projects/library/seqan/index/shape_gapped.h"(561)

//____________________________________________________________________________
// suffixLength

template <typename TPos, typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type suffixLength(TPos pos, Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(615)

//____________________________________________________________________________
// textAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Tag<_Fibre_RawText> const >::Type>::Type textAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(625)
template <typename TPos, typename TString, typename TSSetSpec, typename TSpec> inline typename Reference<typename Fibre< Index< StringSet<TString, TSSetSpec>, TSpec>, Tag<_Fibre_RawText> const >::Type>::Type textAt(TPos i, Index< StringSet<TString, TSSetSpec>, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(630)
template <typename TPos, typename TString, typename TSpec> inline typename Reference<typename Fibre< Index< StringSet<TString, Owner<Default> >, TSpec>, Tag<_Fibre_RawText> const >::Type>::Type textAt(TPos i, Index< StringSet<TString, Owner<Default> >, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(635)

//____________________________________________________________________________
// treeLevelsSAB

template <typename TSize > inline unsigned treeLevelsSAB(TSize saSize, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(103)

//____________________________________________________________________________
// upperBoundLCPE

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type upperBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1570)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type upperBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1672)

//____________________________________________________________________________
// upperBoundLCPEIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Iterator<TSA, Standard>::Type upperBoundLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1621)

//____________________________________________________________________________
// upperBoundSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(823)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(837)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(920)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(934)

//____________________________________________________________________________
// upperBoundSAIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type upperBoundSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(713)
template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type upperBoundSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(759)

//____________________________________________________________________________
// value

template <typename TValue, typename TSpec> inline typename Value< Shape<TValue, TSpec> >::Type value(Shape<TValue, TSpec> &me);       	// "projects/library/seqan/index/shape_base.h"(205)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type & value(Iter< TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(501)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type const & value(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(507)
template <typename TSTree, typename TSpec > inline typename VertexDescriptor<TSTree>::Type value(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(551)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MaxRepeatOccurrences> >::Type & value(Iter<TRepeat, MaxRepeatOccurrences> const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(780)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MaxRepeatOccurrences> >::Type & value(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(786)

//____________________________________________________________________________
// weight

template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, FixedGappedShape<TSpec> > >::Type weight(Shape<TValue, FixedGappedShape<TSpec> > const & me);       	// "projects/library/seqan/index/shape_gapped.h"(358)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, TSpec> >::Type weight(Shape<TValue, TSpec> const &me);       	// "projects/library/seqan/index/shape_base.h"(235)

//____________________________________________________________________________
// write

template <typename TFile, typename TText, typename TESASpec> void write(TFile & file, Index<TText, Index_ESA<TESASpec> > & stree, DotDrawing);       	// "projects/library/seqan/index/index_esa_drawing.h"(31)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

