 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator_

struct AdjacencyIterator_;       	// "projects/library/seqan/graph/graph_base.h"(263)

//____________________________________________________________________________
// AlignConfig

template <bool TTop , bool TLeft , bool TRight , bool TBottom , typename TSpec > class AlignConfig;       	// "projects/library/seqan/graph/graph_align_config.h"(53)

//____________________________________________________________________________
// Alignment

template <typename TStringSet, typename TCargo , typename TSpec > struct Alignment;       	// "projects/library/seqan/graph/graph_interface.h"(45)

//____________________________________________________________________________
// Alphabet

template <typename T> struct Alphabet;       	// "projects/library/seqan/graph/graph_base.h"(92)

//____________________________________________________________________________
// Annotation

template <typename TSequence, typename TValue, typename TSpec > class Annotation;       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(31)

//____________________________________________________________________________
// AtacMatches_

struct AtacMatches_;       	// "projects/library/seqan/graph/graph_base.h"(216)

//____________________________________________________________________________
// Automaton

template <typename TAlphabet , typename TCargo , typename TSpec > struct Automaton;       	// "projects/library/seqan/graph/graph_interface.h"(41)

//____________________________________________________________________________
// AutomatonEdgeArray

template <typename TEdge, typename TAlphabet> class AutomatonEdgeArray;       	// "projects/library/seqan/graph/graph_impl_automaton.h"(34)

//____________________________________________________________________________
// BfsIterator_

struct BfsIterator_;       	// "projects/library/seqan/graph/graph_base.h"(271)

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "projects/library/seqan/graph/graph_base.h"(63)

//____________________________________________________________________________
// CgVizFormat_

struct CgVizFormat_;       	// "projects/library/seqan/graph/graph_base.h"(186)

//____________________________________________________________________________
// DfsPreorder_

struct DfsPreorder_;       	// "projects/library/seqan/graph/graph_base.h"(279)

//____________________________________________________________________________
// Directed

template <typename TCargo , typename TSpec > struct Directed;       	// "projects/library/seqan/graph/graph_interface.h"(29)

//____________________________________________________________________________
// EdgeDescriptor

template <typename T> struct EdgeDescriptor;       	// "projects/library/seqan/graph/graph_base.h"(45)

//____________________________________________________________________________
// EdgeIdHandler

template <typename T> struct EdgeIdHandler;       	// "projects/library/seqan/graph/graph_base.h"(109)

//____________________________________________________________________________
// EdgeIterator_

struct EdgeIterator_;       	// "projects/library/seqan/graph/graph_base.h"(247)

//____________________________________________________________________________
// EdgeStump

template <typename TCargo , bool TList , bool TSource , bool TId , typename TSpec > class EdgeStump;       	// "projects/library/seqan/graph/graph_base.h"(289)

//____________________________________________________________________________
// EdgeType

template <typename T> struct EdgeType;       	// "projects/library/seqan/graph/graph_base.h"(78)

//____________________________________________________________________________
// ExactFragment

struct ExactFragment;       	// "projects/library/seqan/graph/graph_algorithm_refine_fragment.h"(30)

//____________________________________________________________________________
// FakeScore

struct FakeScore;       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(730)

//____________________________________________________________________________
// FastaFormat_

struct FastaFormat_;       	// "projects/library/seqan/graph/graph_base.h"(166)

//____________________________________________________________________________
// FastaReadFormat_

struct FastaReadFormat_;       	// "projects/library/seqan/graph/graph_base.h"(176)

//____________________________________________________________________________
// Fragment

template <typename TId , typename TPos , typename TSize , typename TSpec > class Fragment;       	// "projects/library/seqan/graph/graph_impl_fragment.h"(30)
template <typename TId, typename TPos, typename TSize, typename TSpec> class Fragment;       	// "projects/library/seqan/graph/graph_impl_fragment.h"(35)

//____________________________________________________________________________
// FragmentInfo

template <typename TId , typename TSize > class FragmentInfo;       	// "projects/library/seqan/graph/graph_impl_align.h"(35)

//____________________________________________________________________________
// GlobalPairwise_Library_

struct GlobalPairwise_Library_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(98)

//____________________________________________________________________________
// Graph

template <typename TSpec > class Graph;       	// "projects/library/seqan/graph/graph_interface.h"(63)

//____________________________________________________________________________
// GraphIterator

template <typename TSpec> struct GraphIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(34)

//____________________________________________________________________________
// HiddenMarkovModel

template <typename TAlphabet, typename TProb , typename TSpec > class HiddenMarkovModel;       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(32)
template <typename TAlphabet, typename TProb, typename TSpec> class HiddenMarkovModel;       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(39)

//____________________________________________________________________________
// IdManager

template <typename TIdType , typename TSpec > class IdManager;       	// "projects/library/seqan/graph/graph_base.h"(317)
template <typename TIdType, typename TSpec> class IdManager;       	// "projects/library/seqan/graph/graph_idmanager.h"(46)

//____________________________________________________________________________
// InternalAdjacencyIterator

template <typename TSpec > struct InternalAdjacencyIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(50)

//____________________________________________________________________________
// InternalBfsIterator

template <typename TSpec > struct InternalBfsIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(54)

//____________________________________________________________________________
// InternalDfsIterator

template <typename TSpec > struct InternalDfsIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(58)

//____________________________________________________________________________
// InternalEdgeIterator

template <typename TSpec > struct InternalEdgeIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(42)

//____________________________________________________________________________
// InternalMap

template <typename TContainer, unsigned int const MemberId > struct InternalMap;       	// "projects/library/seqan/graph/graph_property.h"(237)

//____________________________________________________________________________
// InternalOutEdgeIterator

template <typename TSpec > struct InternalOutEdgeIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(46)

//____________________________________________________________________________
// InternalPointerMap

template <typename TPropmap, TPropmap const Instance> struct InternalPointerMap;       	// "projects/library/seqan/graph/graph_property.h"(498)

//____________________________________________________________________________
// InternalVertexIterator

template <typename TSpec > struct InternalVertexIterator;       	// "projects/library/seqan/graph/graph_iterator.h"(38)

//____________________________________________________________________________
// IntervalAndCargo

template <typename TValue , typename TCargo > class IntervalAndCargo;       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(42)

//____________________________________________________________________________
// IntervalTree

template <typename TValue , typename TCargo > class IntervalTree;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(43)

//____________________________________________________________________________
// IntervalTreeNode

template <typename TInterval, typename TSpec > class IntervalTreeNode;       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(285)

//____________________________________________________________________________
// KmerDistance_

struct KmerDistance_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(83)

//____________________________________________________________________________
// Kmer_Library_

struct Kmer_Library_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(124)

//____________________________________________________________________________
// LibraryDistance_

struct LibraryDistance_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(75)

//____________________________________________________________________________
// ListType

template <typename T> struct ListType;       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(462)

//____________________________________________________________________________
// LocalPairwise_Library_

struct LocalPairwise_Library_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(107)

//____________________________________________________________________________
// MUMPairwise_Library_

struct MUMPairwise_Library_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(133)

//____________________________________________________________________________
// MsfFormat_

struct MsfFormat_;       	// "projects/library/seqan/graph/graph_base.h"(156)

//____________________________________________________________________________
// NewickFormat_

struct NewickFormat_;       	// "projects/library/seqan/graph/graph_base.h"(206)

//____________________________________________________________________________
// OutEdgeIterator_

struct OutEdgeIterator_;       	// "projects/library/seqan/graph/graph_base.h"(255)

//____________________________________________________________________________
// Overlap_Library_

struct Overlap_Library_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(116)

//____________________________________________________________________________
// PointAndCargo

template <typename TValue , typename TCargo > class PointAndCargo;       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(154)

//____________________________________________________________________________
// PseudoFragment

template <typename TGraph, typename TSpec > class PseudoFragment;       	// "projects/library/seqan/graph/graph_align_chaining.h"(43)

//____________________________________________________________________________
// ScoreAlignmentGraph

template <typename TGraphType> struct ScoreAlignmentGraph;       	// "projects/library/seqan/graph/graph_align_base.h"(287)

//____________________________________________________________________________
// ScoreNussinov

struct ScoreNussinov;       	// "projects/library/seqan/graph/graph_fold_nussinov.h"(34)

//____________________________________________________________________________
// StoreIntervals

struct StoreIntervals;       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(281)

//____________________________________________________________________________
// StorePointsOnly

struct StorePointsOnly;       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(280)

//____________________________________________________________________________
// TCoffeeLib_

struct TCoffeeLib_;       	// "projects/library/seqan/graph/graph_base.h"(196)

//____________________________________________________________________________
// TagComputeCenter_

struct TagComputeCenter_;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(176)

//____________________________________________________________________________
// TagExactRefinement_

struct TagExactRefinement_;       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(30)

//____________________________________________________________________________
// TagInexactRefinement_

struct TagInexactRefinement_;       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(28)

//____________________________________________________________________________
// TagMidCenter_

struct TagMidCenter_;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(181)

//____________________________________________________________________________
// TagRandomCenter_

struct TagRandomCenter_;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(186)

//____________________________________________________________________________
// Tree

template <typename TCargo , typename TSpec > struct Tree;       	// "projects/library/seqan/graph/graph_interface.h"(37)

//____________________________________________________________________________
// TreeTag_

struct TreeTag_;       	// "projects/library/seqan/graph/graph_base.h"(136)

//____________________________________________________________________________
// Undirected

template <typename TCargo , typename TSpec > struct Undirected;       	// "projects/library/seqan/graph/graph_interface.h"(33)

//____________________________________________________________________________
// UpgmaAvg_

struct UpgmaAvg_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(63)

//____________________________________________________________________________
// UpgmaMax_

struct UpgmaMax_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(53)

//____________________________________________________________________________
// UpgmaMin_

struct UpgmaMin_;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(43)

//____________________________________________________________________________
// VertexIdHandler

template <typename T> struct VertexIdHandler;       	// "projects/library/seqan/graph/graph_base.h"(122)
template <typename T> struct VertexIdHandler;       	// "projects/library/seqan/graph/graph_base.h"(338)

//____________________________________________________________________________
// VertexIterator_

struct VertexIterator_;       	// "projects/library/seqan/graph/graph_base.h"(239)

//____________________________________________________________________________
// Weight

template <typename T> struct Weight;       	// "projects/library/seqan/graph/graph_align_chaining.h"(32)

//____________________________________________________________________________
// WithoutEdgeId_

struct WithoutEdgeId_;       	// "projects/library/seqan/graph/graph_base.h"(131)

//____________________________________________________________________________
// WordGraph

template <typename TSpec > struct WordGraph;       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(28)

//____________________________________________________________________________
// _AAGroupsDayhoff

struct _AAGroupsDayhoff;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(117)

//____________________________________________________________________________
// _AAGroupsLiA10

struct _AAGroupsLiA10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(849)

//____________________________________________________________________________
// _AAGroupsLiB10

struct _AAGroupsLiB10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(746)

//____________________________________________________________________________
// _AAGroupsMurphy

struct _AAGroupsMurphy;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(433)

//____________________________________________________________________________
// _AAGroupsSeB10

struct _AAGroupsSeB10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1059)

//____________________________________________________________________________
// _AAGroupsSeB14

struct _AAGroupsSeB14;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1163)

//____________________________________________________________________________
// _AAGroupsSeB6

struct _AAGroupsSeB6;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(223)

//____________________________________________________________________________
// _AAGroupsSeB8

struct _AAGroupsSeB8;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(328)

//____________________________________________________________________________
// _AAGroupsSeV10

struct _AAGroupsSeV10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(953)

//____________________________________________________________________________
// _AAGroupsSolisD10

struct _AAGroupsSolisD10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(642)

//____________________________________________________________________________
// _AAGroupsSolisG10

struct _AAGroupsSolisG10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(537)

//____________________________________________________________________________
// _Rna5

struct _Rna5;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(52)

//____________________________________________________________________________
// _TagChaining

struct _TagChaining;       	// "projects/library/seqan/graph/graph_align_chaining.h"(37)

//____________________________________________________________________________
// _TraceBack

struct _TraceBack;       	// "projects/library/seqan/graph/graph_align_base.h"(73)

//____________________________________________________________________________
// _TraceBackGotoh

struct _TraceBackGotoh;       	// "projects/library/seqan/graph/graph_align_base.h"(143)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsDayhoff

template <typename T > struct _Translate_Table_AA_2_AAGroupsDayhoff;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(71)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsLiA10

template <typename T > struct _Translate_Table_AA_2_AAGroupsLiA10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(804)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsLiB10

template <typename T > struct _Translate_Table_AA_2_AAGroupsLiB10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(701)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsMurphy

template <typename T > struct _Translate_Table_AA_2_AAGroupsMurphy;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(388)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1014)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB14

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB14;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1118)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB6

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB6;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(178)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeB8

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeB8;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(283)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSeV10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSeV10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(908)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSolisD10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSolisD10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(597)

//____________________________________________________________________________
// _Translate_Table_AA_2_AAGroupsSolisG10

template <typename T > struct _Translate_Table_AA_2_AAGroupsSolisG10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(492)

//____________________________________________________________________________
// _Translate_Table_Byte_2_TraceBack

template <typename T > struct _Translate_Table_Byte_2_TraceBack;       	// "projects/library/seqan/graph/graph_align_base.h"(36)

//____________________________________________________________________________
// _Translate_Table_Byte_2_TraceBackGotoh

template <typename T > struct _Translate_Table_Byte_2_TraceBackGotoh;       	// "projects/library/seqan/graph/graph_align_base.h"(101)

//____________________________________________________________________________
// _Translate_Table_Rna5_2_Ascii

template <typename T > struct _Translate_Table_Rna5_2_Ascii;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(33)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AAGroupsDayhoff

typedef SimpleType<unsigned char, _AAGroupsDayhoff> AAGroupsDayhoff;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(118)

//____________________________________________________________________________
// AAGroupsLiA10

typedef SimpleType<unsigned char, _AAGroupsLiA10> AAGroupsLiA10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(850)

//____________________________________________________________________________
// AAGroupsLiB10

typedef SimpleType<unsigned char, _AAGroupsLiB10> AAGroupsLiB10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(747)

//____________________________________________________________________________
// AAGroupsMurphy

typedef SimpleType<unsigned char, _AAGroupsMurphy> AAGroupsMurphy;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(434)

//____________________________________________________________________________
// AAGroupsSeB10

typedef SimpleType<unsigned char, _AAGroupsSeB10> AAGroupsSeB10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1060)

//____________________________________________________________________________
// AAGroupsSeB14

typedef SimpleType<unsigned char, _AAGroupsSeB14> AAGroupsSeB14;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1164)

//____________________________________________________________________________
// AAGroupsSeB6

typedef SimpleType<unsigned char, _AAGroupsSeB6> AAGroupsSeB6;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(224)

//____________________________________________________________________________
// AAGroupsSeB8

typedef SimpleType<unsigned char, _AAGroupsSeB8> AAGroupsSeB8;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(329)

//____________________________________________________________________________
// AAGroupsSeV10

typedef SimpleType<unsigned char, _AAGroupsSeV10> AAGroupsSeV10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(954)

//____________________________________________________________________________
// AAGroupsSolisD10

typedef SimpleType<unsigned char, _AAGroupsSolisD10> AAGroupsSolisD10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(643)

//____________________________________________________________________________
// AAGroupsSolisG10

typedef SimpleType<unsigned char, _AAGroupsSolisG10> AAGroupsSolisG10;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(538)

//____________________________________________________________________________
// AdjacencyIterator

typedef Tag<AdjacencyIterator_> const AdjacencyIterator;       	// "projects/library/seqan/graph/graph_base.h"(264)

//____________________________________________________________________________
// AtacMatches

typedef Tag<AtacMatches_> const AtacMatches;       	// "projects/library/seqan/graph/graph_base.h"(217)

//____________________________________________________________________________
// BfsIterator

typedef Tag<BfsIterator_> const BfsIterator;       	// "projects/library/seqan/graph/graph_base.h"(272)

//____________________________________________________________________________
// CgVizFormat

typedef Tag<CgVizFormat_> const CgVizFormat;       	// "projects/library/seqan/graph/graph_base.h"(187)

//____________________________________________________________________________
// Chaining

typedef Tag<_TagChaining> const Chaining;       	// "projects/library/seqan/graph/graph_align_chaining.h"(38)

//____________________________________________________________________________
// ComputeCenter

typedef Tag<TagComputeCenter_> const ComputeCenter;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(177)

//____________________________________________________________________________
// DfsPreorder

typedef Tag<DfsPreorder_> const DfsPreorder;       	// "projects/library/seqan/graph/graph_base.h"(280)

//____________________________________________________________________________
// EdgeIterator

typedef Tag<EdgeIterator_> const EdgeIterator;       	// "projects/library/seqan/graph/graph_base.h"(248)

//____________________________________________________________________________
// ExactRefinement

typedef Tag<TagExactRefinement_> const ExactRefinement;       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(31)

//____________________________________________________________________________
// FastaFormat

typedef Tag<FastaFormat_> const FastaFormat;       	// "projects/library/seqan/graph/graph_base.h"(167)

//____________________________________________________________________________
// FastaReadFormat

typedef Tag<FastaReadFormat_> const FastaReadFormat;       	// "projects/library/seqan/graph/graph_base.h"(177)

//____________________________________________________________________________
// GlobalPairwise_Library

typedef Tag<GlobalPairwise_Library_> const GlobalPairwise_Library;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(99)

//____________________________________________________________________________
// InexactRefinement

typedef Tag<TagInexactRefinement_> const InexactRefinement;       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(29)

//____________________________________________________________________________
// KmerDistance

typedef Tag<KmerDistance_> const KmerDistance;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(84)

//____________________________________________________________________________
// Kmer_Library

typedef Tag<Kmer_Library_> const Kmer_Library;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(125)

//____________________________________________________________________________
// LibraryDistance

typedef Tag<LibraryDistance_> const LibraryDistance;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(76)

//____________________________________________________________________________
// LocalPairwise_Library

typedef Tag<LocalPairwise_Library_> const LocalPairwise_Library;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(108)

//____________________________________________________________________________
// MUMPairwise_Library

typedef Tag<MUMPairwise_Library_> const MUMPairwise_Library;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(134)

//____________________________________________________________________________
// MidCenter

typedef Tag<TagMidCenter_> const MidCenter;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(182)

//____________________________________________________________________________
// MsfFormat

typedef Tag<MsfFormat_> const MsfFormat;       	// "projects/library/seqan/graph/graph_base.h"(157)

//____________________________________________________________________________
// NewickFormat

typedef Tag<NewickFormat_> const NewickFormat;       	// "projects/library/seqan/graph/graph_base.h"(207)

//____________________________________________________________________________
// OutEdgeIterator

typedef Tag<OutEdgeIterator_> const OutEdgeIterator;       	// "projects/library/seqan/graph/graph_base.h"(256)

//____________________________________________________________________________
// Overlap_Library

typedef Tag<Overlap_Library_> const Overlap_Library;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(117)

//____________________________________________________________________________
// RandomCenter

typedef Tag<TagRandomCenter_> const RandomCenter;       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(187)

//____________________________________________________________________________
// Rna5

typedef SimpleType<unsigned char, _Rna5> Rna5;       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(53)

//____________________________________________________________________________
// TCoffeeLib

typedef Tag<TCoffeeLib_> const TCoffeeLib;       	// "projects/library/seqan/graph/graph_base.h"(197)

//____________________________________________________________________________
// TraceBack

typedef SimpleType<unsigned char, _TraceBack> TraceBack;       	// "projects/library/seqan/graph/graph_align_base.h"(74)

//____________________________________________________________________________
// TraceBackGotoh

typedef SimpleType<unsigned char, _TraceBackGotoh> TraceBackGotoh;       	// "projects/library/seqan/graph/graph_align_base.h"(144)

//____________________________________________________________________________
// TreeTag

typedef Tag<TreeTag_> const TreeTag;       	// "projects/library/seqan/graph/graph_base.h"(137)

//____________________________________________________________________________
// UpgmaAvg

typedef Tag<UpgmaAvg_> const UpgmaAvg;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(64)

//____________________________________________________________________________
// UpgmaMax

typedef Tag<UpgmaMax_> const UpgmaMax;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(54)

//____________________________________________________________________________
// UpgmaMin

typedef Tag<UpgmaMin_> const UpgmaMin;       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(44)

//____________________________________________________________________________
// VertexIterator

typedef Tag<VertexIterator_> const VertexIterator;       	// "projects/library/seqan/graph/graph_base.h"(240)

//____________________________________________________________________________
// WithoutEdgeId

typedef Tag<WithoutEdgeId_> const WithoutEdgeId;       	// "projects/library/seqan/graph/graph_base.h"(132)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __getAlignmentStatistics

template <typename TFragmentMatches, typename TStringSet, typename TValue, typename TSpec, typename TSize> inline void __getAlignmentStatistics(TFragmentMatches& matches, TStringSet& pairSet, String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, TSize from);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(156)
template <typename TFragmentMatches, typename TStringSet, typename TCargo, typename TSpec, typename TSize> inline void __getAlignmentStatistics(TFragmentMatches& matches, TStringSet& pairSet, Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize nseq, TSize from);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(184)
template <typename TFragmentMatches, typename TStringSet, typename TSize> inline void __getAlignmentStatistics(TFragmentMatches&, TStringSet&, Nothing&, TSize, TSize, TSize, TSize);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(212)
template <typename TSize> inline void __getAlignmentStatistics(Nothing&, TSize, TSize, TSize, double, double);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(290)
template <typename TValue, typename TSpec, typename TSize> inline void __getAlignmentStatistics(String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, double matchLen, double quality);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(304)
template <typename TCargo, typename TSpec, typename TSize> inline void __getAlignmentStatistics(Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, double matchLen, double quality);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(321)

//____________________________________________________________________________
// __heaviestCommonSubsequence

template <typename TKey, typename TValue, typename TPositions, typename TSize, typename TVertexDescriptor, typename TString> inline void __heaviestCommonSubsequence(std::map<TKey, TValue>&, TPositions const&, TSize const, TSize const, TVertexDescriptor const, TString const&, TString const&, Nothing&);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(345)
template <typename TKey, typename TValue, typename TPositions, typename TSize, typename TVertexDescriptor, typename TString, typename TOutString> inline void __heaviestCommonSubsequence(std::map<TKey, TValue>& posToSlotMap, TPositions const& positions, TSize const m, TSize const n, TVertexDescriptor const nilVertex, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(361)

//____________________________________________________________________________
// __resizeWithRespectToDistance

template <typename TValue, typename TSpec, typename TSize> inline void __resizeWithRespectToDistance(String<TValue, TSpec>& dist, TSize nseq);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(118)
template <typename TCargo, typename TSpec, typename TSize> inline void __resizeWithRespectToDistance(Graph<Undirected<TCargo, TSpec> >& dist, TSize nseq);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(130)
template <typename TSize> inline void __resizeWithRespectToDistance(Nothing&, TSize);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(141)

//____________________________________________________________________________
// __writeCargo

template <typename TFile, typename TStringSet, typename TSpec, typename TEdge> inline void __writeCargo(TFile & file, Graph<Alignment<TStringSet, void, TSpec> > const&, TEdge const&);       	// "projects/library/seqan/graph/graph_impl_align.h"(789)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TEdge> inline void __writeCargo(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, TEdge const& edge);       	// "projects/library/seqan/graph/graph_impl_align.h"(799)

//____________________________________________________________________________
// _addAnnotationCuts

template <typename TValue, typename TAliString, typename TGraph, typename TPropertyMap, typename TStringSet, typename TMap, typename TTagSpec> inline void _addAnnotationCuts(String<std::set<TValue> > &, TAliString &, String<TGraph> &, String<TPropertyMap> &, TStringSet &, TMap &, bool, TValue, Tag<TTagSpec>);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(130)
template <typename TValue, typename TAliString, typename TGraph, typename TPropertyMap, typename TStringSet, typename TMap, typename TAnnoString, typename TTagSpec> inline void _addAnnotationCuts(String<std::set<TValue> > & all_nodes, TAliString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, TStringSet & seq, TMap & seq_map, TAnnoString & annotation, TValue min_fragment_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(150)

//____________________________________________________________________________
// _addNewEdgesFoundByTriplet

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexString, typename TCargoString> inline void _addNewEdgesFoundByTriplet(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(470)

//____________________________________________________________________________
// _addNodeAnnotation

template <typename TPropertyMap, typename TStringSet, typename TMap, typename TAnnoString, typename TAliGraph,typename TTagSpec> inline void _addNodeAnnotation(TStringSet &, TMap &, TAnnoString & annotation, TPropertyMap & pm, TAliGraph & ali_g, Tag<TTagSpec>);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(197)

//____________________________________________________________________________
// _addStringToTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeyword, typename TPos> inline void _addStringToTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeyword const& str, TPos const& keywordIndex);       	// "projects/library/seqan/graph/graph_impl_trie.h"(72)

//____________________________________________________________________________
// _alignImportSequences

template <typename TPath, typename TFilePrefix, typename TFileSuffix, typename TNames, typename TStringSet> inline unsigned int _alignImportSequences(TPath const& in_path, TFilePrefix const& file_prefix, TFileSuffix const& file_suffix, TStringSet& origStrSet, TNames& names);       	// "projects/library/seqan/graph/graph_align_tcoffee_msa.h"(110)

//____________________________________________________________________________
// _alignStringsAccordingToGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSequenceIn, typename TSequence> inline TCargo _alignStringsAccordingToGraph(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSequenceIn const& seq1, TSequenceIn const& seq2, TSequence& alignSeq, Chaining);       	// "projects/library/seqan/graph/graph_align_chaining.h"(265)

//____________________________________________________________________________
// _alignTiming

template <typename TText> inline void _alignTiming(std::clock_t& startTime, TText const& text);       	// "projects/library/seqan/graph/graph_align_tcoffee_msa.h"(149)

//____________________________________________________________________________
// _align_gotoh

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _align_gotoh(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, typename Value<TTrace>::Type& initialDir, TAlignConfig const);       	// "projects/library/seqan/graph/graph_align_gotoh.h"(172)

//____________________________________________________________________________
// _align_gotoh_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair, typename TVal> inline void _align_gotoh_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex, TVal const initialDir);       	// "projects/library/seqan/graph/graph_align_gotoh.h"(40)

//____________________________________________________________________________
// _align_hirschberg

template <typename TTrace, typename TStringSet, typename TScoreValue, typename TSpec> TScoreValue _align_hirschberg(TTrace& trace, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, Hirschberg);       	// "projects/library/seqan/graph/graph_align_hirschberg.h"(132)

//____________________________________________________________________________
// _align_hirschberg_trace

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTrace> void _align_hirschberg_trace(TAlign& align, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTrace& trace);       	// "projects/library/seqan/graph/graph_align_hirschberg.h"(41)

//____________________________________________________________________________
// _align_myers_bit_vector

template <typename TString> unsigned int _align_myers_bit_vector(TString const & str1, TString const & str2);       	// "projects/library/seqan/graph/graph_align_myers.h"(38)

//____________________________________________________________________________
// _align_needleman_wunsch

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _align_needleman_wunsch(TTrace & trace, TStringSet const & str, TScore const & sc, TValPair & overallMaxValue, TIndexPair & overallMaxIndex, TAlignConfig const);       	// "projects/library/seqan/graph/graph_align_needleman_wunsch.h"(119)

//____________________________________________________________________________
// _align_needleman_wunsch_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair> void _align_needleman_wunsch_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex);       	// "projects/library/seqan/graph/graph_align_needleman_wunsch.h"(41)

//____________________________________________________________________________
// _align_nussinov

template <typename TScoreValue, typename TSpec, typename TString, typename TScore, typename TLoopSize> TScoreValue _align_nussinov(String<TScoreValue, TSpec>& mat, TString const& str, TScore const& sc, TLoopSize const& lSize);       	// "projects/library/seqan/graph/graph_fold_nussinov.h"(131)

//____________________________________________________________________________
// _align_nussinov_trace

template <typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TString, typename TScore, typename TPos> void _align_nussinov_trace(Graph<Undirected<TCargo, TSpec> >& g, String<TScoreValue, TSpec2> const& mat, TString const& str, TScore const& sc, TPos const i, TPos const j);       	// "projects/library/seqan/graph/graph_fold_nussinov.h"(98)

//____________________________________________________________________________
// _align_smith_waterman

template <typename TTrace, typename TStringSet, typename TScore, typename TSize, typename TForbidden> inline typename Value<TScore>::Type _align_smith_waterman(TTrace& trace, TStringSet const& str, TScore const & sc, typename Value<TTrace>::Type& initialDir, TSize& best_row, TSize& best_col, TForbidden& forbidden);       	// "projects/library/seqan/graph/graph_align_smith_waterman.h"(164)

//____________________________________________________________________________
// _align_smith_waterman_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TVal, typename TSize, typename TForbidden> inline void _align_smith_waterman_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TVal const initialDir, TSize best_row, TSize best_col, TForbidden& forbidden);       	// "projects/library/seqan/graph/graph_align_smith_waterman.h"(42)

//____________________________________________________________________________
// _align_trace_print

template <typename TFile, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(TFile& file, TStringSet const& str, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph/graph_align_base.h"(179)
template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet2, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TStringSet2 const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph/graph_align_base.h"(232)
template <typename TFragment, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(String<TFragment, Block<> >& matches, TStringSet const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const seqLen, TTraceValue const tv);       	// "projects/library/seqan/graph/graph_align_base.h"(258)
template <typename TVertexDescriptor, typename TSpec, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(String<String<TVertexDescriptor, TSpec> >& nodeString, TStringSet const& str, TId const, TPos const pos1, TId const, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph/graph_align_base.h"(398)

//____________________________________________________________________________
// _appendIntervalTreeNodeLists

template <typename TInterval> void _appendIntervalTreeNodeLists(IntervalTreeNode<TInterval,StoreIntervals> & knot,TInterval & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(412)
template <typename TInterval> void _appendIntervalTreeNodeLists(IntervalTreeNode<TInterval,StorePointsOnly> & knot,TInterval & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(439)

//____________________________________________________________________________
// _assignId

template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es, TId2 const id);       	// "projects/library/seqan/graph/graph_edgestump.h"(939)
template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TSpec>*, TId2 const);       	// "projects/library/seqan/graph/graph_edgestump.h"(950)
template <typename TCargo, bool TList, bool TSource, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TreeTag>*, TId2 const);       	// "projects/library/seqan/graph/graph_edgestump.h"(960)

//____________________________________________________________________________
// _assignNewCargos

template <typename TStringSet, typename TCargo, typename TSpec, typename TCargoMap> inline void _assignNewCargos(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TCargoMap& newCargoMap);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(451)

//____________________________________________________________________________
// _buildIntervalsForAllSequences

template <typename TInterval, typename TStringSet, typename TAlignmentString, typename TSeqMap> void _buildIntervalsForAllSequences(TAlignmentString & alis, String<String<TInterval> > & intervals, TStringSet & seqs, TSeqMap & seq_map);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(367)
template <typename TInterval, typename TStringSet, typename TAlignmentString, typename TSeqMap> void _buildIntervalsForAllSequences(TAlignmentString & alis, String<String<TInterval> > & intervals, TStringSet & seqs, TSeqMap & seq_map);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(112)

//____________________________________________________________________________
// _buildLeafString

template <typename TStringSet, typename TCargo, typename TSpec, typename TPosition, typename TSequence> inline void _buildLeafString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TPosition const pos, TSequence& alignSeq);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(38)

//____________________________________________________________________________
// _build_residual_graph

template <typename TSpec, typename TCapMap, typename TFlowMap, typename TResidualGraph> void _build_residual_graph(Graph<TSpec> const& g, TCapMap const& capacity, TFlowMap const& flow, TResidualGraph& rG);       	// "projects/library/seqan/graph/graph_algorithm.h"(1153)

//____________________________________________________________________________
// _calcIntervalTreeNodeCenterLeft

template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterLeft(TIntervals & intervals, TValue &, TValue &, Tag<TagRandomCenter_> const);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(489)
template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterLeft(TIntervals &, TValue & last_center, TValue & center, Tag<TagMidCenter_> const);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(512)

//____________________________________________________________________________
// _calcIntervalTreeNodeCenterRight

template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterRight(TIntervals & intervals, TValue &, TValue &, Tag<TagRandomCenter_> const);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(501)
template <typename TIntervals, typename TValue> TValue _calcIntervalTreeNodeCenterRight(TIntervals &, TValue & last_center, TValue & center, Tag<TagMidCenter_> const);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(523)

//____________________________________________________________________________
// _calcIntervalTreeRootCenter

template <typename TIntervals> typename Value<typename Value<TIntervals>::Type>::Type _calcIntervalTreeRootCenter(TIntervals & intervals);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(534)

//____________________________________________________________________________
// _copyGraph

template <typename TStringSet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest, bool);       	// "projects/library/seqan/graph/graph_impl_align.h"(183)
template <typename TStringSet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_align.h"(198)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph/graph_impl_directed.h"(140)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_directed.h"(184)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest, bool);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(139)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(186)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph/graph_impl_tree.h"(175)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_tree.h"(217)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest, bool transpose);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(161)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(204)

//____________________________________________________________________________
// _createAlignmentGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TOutGraph> inline void _createAlignmentGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TOutGraph& gOut);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(73)

//____________________________________________________________________________
// _createEdgeAttributes

template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Directed<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(223)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Undirected<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(234)
template <typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(245)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(256)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(278)
template <typename TStringSet, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Alignment<TStringSet, void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(299)
template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(310)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(333)

//____________________________________________________________________________
// _createEmptyEdgeAttributes

template <typename TSpec, typename TEdgeAttributes> inline void _createEmptyEdgeAttributes(Graph<TSpec> const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(204)

//____________________________________________________________________________
// _createIntervalTree

template <typename TGraph, typename TPropertyMap, typename TIntervalPointer, typename TValue> void _createIntervalTree(TGraph & g, TPropertyMap & pm, String<TIntervalPointer*> & intervals, typename VertexDescriptor<TGraph>::Type & knot, TValue, TValue center, typename VertexDescriptor<TGraph>::Type len, Tag<TagComputeCenter_> const tag);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(325)
template <typename TGraph, typename TPropertyMap, typename TSpec, typename TInterval, typename TValue> void _createIntervalTree(TGraph & g, TPropertyMap & pm, String<TInterval*> & intervals, typename VertexDescriptor<TGraph>::Type & knot, TValue last_center, TValue center, typename VertexDescriptor<TGraph>::Type len, Tag<TSpec> const tag);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(417)

//____________________________________________________________________________
// _createNodeAttributes

template <typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(122)
template <typename TSpec, typename TNodeAttributes, typename TNameMap> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap, TNameMap const& nameMap);       	// "projects/library/seqan/graph/graph_drawing.h"(149)
template <typename TStringSet, typename TCargo, typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNodeAttributes& nodeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(174)

//____________________________________________________________________________
// _createTrieNodeAttributes

template <typename TAlphabet, typename TCargo, typename TSpec, typename TNodeMap> inline void _createTrieNodeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, String<String<unsigned int> > pos, TNodeMap& nodeMap);       	// "projects/library/seqan/graph/graph_drawing.h"(85)

//____________________________________________________________________________
// _createVertices

template <typename TSpec, typename TVertexDescriptor> inline void _createVertices(Graph<TSpec>& g, TVertexDescriptor const maxId);       	// "projects/library/seqan/graph/graph_interface.h"(451)

//____________________________________________________________________________
// _debugMatches

template <typename TStringSet, typename TMatches> void _debugMatches(TStringSet& str, TMatches& matches);       	// "projects/library/seqan/graph/graph_align_tcoffee_msa.h"(168)

//____________________________________________________________________________
// _debugRefinedMatches

template <typename TGraph> void _debugRefinedMatches(TGraph& g);       	// "projects/library/seqan/graph/graph_align_tcoffee_msa.h"(205)

//____________________________________________________________________________
// _dfs_visit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap, typename TVal> void _dfs_visit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish, TVal& time);       	// "projects/library/seqan/graph/graph_algorithm.h"(153)

//____________________________________________________________________________
// _extend_shortest_paths

template <typename TMatrix, typename TPredecessor, typename TInfDist> void _extend_shortest_paths(TMatrix& local, TMatrix& w, TPredecessor& predecessor, TInfDist const infDist);       	// "projects/library/seqan/graph/graph_algorithm.h"(951)

//____________________________________________________________________________
// _getClosestRefinedNeighbor

template <typename TAliGraph, typename TVertexDescriptor,typename TValue> TValue _getClosestRefinedNeighbor(TAliGraph & ali_g, TVertexDescriptor & vd, TValue seq, TValue pos);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(74)

//____________________________________________________________________________
// _getCutBeginPos

template <typename TAliGraph,typename TValue> void _getCutBeginPos(TAliGraph & ali_g, typename VertexDescriptor<TAliGraph>::Type & act_knot, TValue seq, TValue act_pos, TValue & cut_act_pos);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(113)

//____________________________________________________________________________
// _getCutEndPos

template <typename TAliGraph,typename TValue> void _getCutEndPos(TAliGraph & ali_g, typename VertexDescriptor<TAliGraph>::Type & end_knot, TValue seq, TValue end_pos, TValue & cut_end_pos);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(91)

//____________________________________________________________________________
// _getEdgeIdManager

template <typename TStringSet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(169)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(125)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(125)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(134)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(142)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(146)

//____________________________________________________________________________
// _getId

template <typename TId> inline TId _getId(TId const id);       	// "projects/library/seqan/graph/graph_interface.h"(440)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> const>::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(969)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(979)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> const>::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(989)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(1000)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(1011)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(1022)

//____________________________________________________________________________
// _getNonOverlappingTupelString

template <typename TString, typename TTupelString, typename TKTup, typename TAlphabet> inline void _getNonOverlappingTupelString(TString const& str, TTupelString& tupelString, TKTup const ktup, TAlphabet);       	// "projects/library/seqan/graph/graph_align_tcoffee_kmer.h"(81)

//____________________________________________________________________________
// _getOtherSequenceAndProject

template <typename TAlignment,typename TValue, typename TMap> void _getOtherSequenceAndProject(Graph<TAlignment> & segment, TMap &, TValue seq_i_id, TValue pos_i, TValue & seq_j_id, TValue & pos_j);       	// "projects/library/seqan/graph/graph_algorithm_refine_aligngraph.h"(41)
template <typename TSource,typename TSpec,typename TStringSet,typename TValue,typename TMap> bool _getOtherSequenceAndProject(Align<TSource,TSpec> & segment, TStringSet & seqs, TMap & seq_map, TValue seq_i, TValue node_i, TValue & seq_j, TValue & node_j);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(41)
template <typename TAlignment,typename TStringSet,typename TValue, typename TMap> bool _getOtherSequenceAndProject(Graph<TAlignment> & segment, TStringSet & seqs, TMap & seq_map, TValue seq_i, TValue pos_i, TValue & seq_j, TValue & pos_j);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(105)
template <typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec,typename TValue, typename TMap> bool _getOtherSequenceAndProject(Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, TStringSet & seqs, TMap &, TValue seq_i, TValue pos_i, TValue & seq_j, TValue & pos_j);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(154)
template <typename TSource,typename TSpec,typename TValue,typename TMap> void _getOtherSequenceAndProject(Align<TSource,TSpec> & segment, TMap & seq_map, TValue seq_i_id, TValue node_i, TValue & seq_j_id, TValue & node_j);       	// "projects/library/seqan/graph/graph_algorithm_refine_align.h"(41)
template <typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec,typename TValue, typename TMap> void _getOtherSequenceAndProject(Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, TMap &, TValue seq_i_id, TValue pos_i, TValue & seq_j_id, TValue & pos_j);       	// "projects/library/seqan/graph/graph_algorithm_refine_fragment.h"(44)

//____________________________________________________________________________
// _getSeqBeginAndEnd

template <typename TValue,typename TAlign,typename TId> void _getSeqBeginAndEnd(Graph<TAlign> & segment, std::map<const void * ,int> &, TId & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/graph/graph_algorithm_refine_aligngraph.h"(60)
template <typename TAliSource,typename TAliSpec, typename TValue> void _getSeqBeginAndEnd(Align<TAliSource,TAliSpec> & segment, std::map<const void * ,int> & seq_map, TValue & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/graph/graph_algorithm_refine_align.h"(79)
template <typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec, typename TValue> void _getSeqBeginAndEnd(Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, std::map<const void * ,int> &, TValue & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/graph/graph_algorithm_refine_fragment.h"(66)

//____________________________________________________________________________
// _getSeqMapId

template <typename TSource,typename TSpec, typename TValue, typename TSeqMap> int _getSeqMapId(TSeqMap & seq_map, Align<TSource,TSpec> & segment, TValue seq_i);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(66)
template <typename TAlignment, typename TValue,typename TVertexDescriptor, typename TSeqMap> int _getSeqMapId(TSeqMap & seq_map, TAlignment & segment, TVertexDescriptor seq_i);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(182)

//____________________________________________________________________________
// _getTupelString

template <typename TString, typename TTupelString, typename TKTup, typename TAlphabet> inline void _getTupelString(TString const& str, TTupelString& tupelString, TKTup const ktup, TAlphabet);       	// "projects/library/seqan/graph/graph_align_tcoffee_kmer.h"(39)

//____________________________________________________________________________
// _getVertexIdManager

template <typename TStringSet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(158)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(114)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(114)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getVertexIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(118)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getVertexIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(126)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(135)

//____________________________________________________________________________
// _getVertexString

template <typename TStringSet, typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(147)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Directed<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(103)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Undirected<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(103)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Tree<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(107)
template <typename TAlphabet, typename TCargo, typename TSpec> inline String<AutomatonEdgeArray<typename EdgeType<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type, TAlphabet> >& _getVertexString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(124)

//____________________________________________________________________________
// _get_minimum_aug

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor> inline unsigned int _get_minimum_aug(Graph<TSpec> const& rG, TPredecessorMap& predecessor, TVertexDescriptor const source, TVertexDescriptor sink);       	// "projects/library/seqan/graph/graph_algorithm.h"(1193)

//____________________________________________________________________________
// _globalAlignment

template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "projects/library/seqan/graph/graph_align_needleman_wunsch.h"(309)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "projects/library/seqan/graph/graph_align_needleman_wunsch.h"(337)
template <typename TStringSet, typename TScoreValue> TScoreValue _globalAlignment(TStringSet const& str, Score<TScoreValue, Simple> const&, MyersBitVector);       	// "projects/library/seqan/graph/graph_align_myers.h"(191)
template <typename TAlign, typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "projects/library/seqan/graph/graph_align_hirschberg.h"(495)
template <typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "projects/library/seqan/graph/graph_align_hirschberg.h"(518)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "projects/library/seqan/graph/graph_align_gotoh.h"(345)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "projects/library/seqan/graph/graph_align_gotoh.h"(372)

//____________________________________________________________________________
// _goNextInternal

template <typename TGraph, typename TSpec> inline void _goNextInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(270)

//____________________________________________________________________________
// _goPreviousInternal

template <typename TGraph, typename TSpec> inline void _goPreviousInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(358)

//____________________________________________________________________________
// _greater_compI2_ITree

template <typename TPair> bool _greater_compI2_ITree(TPair const& p1, TPair const& p2);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(267)

//____________________________________________________________________________
// _initFirstColumn

template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, false, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "projects/library/seqan/graph/graph_align_config.h"(163)
template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, true, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "projects/library/seqan/graph/graph_align_config.h"(175)

//____________________________________________________________________________
// _initFirstRow

template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<false, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "projects/library/seqan/graph/graph_align_config.h"(187)
template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<true, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "projects/library/seqan/graph/graph_align_config.h"(199)

//____________________________________________________________________________
// _initialize_all_pairs

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void _initialize_all_pairs(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& matrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph/graph_algorithm.h"(902)

//____________________________________________________________________________
// _initialize_single_source

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> inline void _initialize_single_source(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph/graph_algorithm.h"(607)

//____________________________________________________________________________
// _less_compI1_ITree

template <typename TPair> bool _less_compI1_ITree(TPair const& p1, TPair const& p2);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(261)

//____________________________________________________________________________
// _localAlignment

template <typename TAlign, typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet const& str, TScore const& sc, SmithWaterman);       	// "projects/library/seqan/graph/graph_align_smith_waterman.h"(326)
template <typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TStringSet const& str, TScore const& sc, SmithWaterman);       	// "projects/library/seqan/graph/graph_align_smith_waterman.h"(355)
template <typename TAlign, typename TStringSet, typename TForbidden, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet& str, TForbidden& forbidden, TScore const& sc, SmithWatermanClump);       	// "projects/library/seqan/graph/graph_align_smith_waterman_clump.h"(41)
template <typename TAlign, typename TStringSet, typename TScore, typename TLimitCount> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet& str, TScore const& sc, TLimitCount limit_count, SmithWatermanClump);       	// "projects/library/seqan/graph/graph_align_smith_waterman_clump.h"(83)
template <typename TAlign, typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet& str, TScore const& sc, SmithWatermanClump);       	// "projects/library/seqan/graph/graph_align_smith_waterman_clump.h"(157)

//____________________________________________________________________________
// _makeAlignmentGraphFromRefinedSegments

template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, bool);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(324)
template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TAnnoString,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, TAnnoString & annotation);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(356)

//____________________________________________________________________________
// _makeAlignmentGraphFromRefinedSegmentsSimple

template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TIntervalTreeGraph,typename TPropertyMap, typename TAliGraph,typename TSeqMap> void _makeAlignmentGraphFromRefinedSegmentsSimple(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, String<TIntervalTreeGraph> &, String<TPropertyMap> &, TAliGraph & ali_g);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(827)

//____________________________________________________________________________
// _makePointerInterval

template <typename TIntervals, typename TIntervalPointers> void _makePointerInterval(TIntervals & intervals,TIntervalPointers & interval_pointers);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(193)

//____________________________________________________________________________
// _makeRefinedGraphEdges

template <typename TAlignmentString,typename TPropertyMap,typename TStringSet,typename TSeqMap, typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & pm, TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagInexactRefinement_> const);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(140)
template <typename TAlignmentString,typename TStringSet,typename TSeqMap, typename TPropertyMap,typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & pm, TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(247)

//____________________________________________________________________________
// _makeRefinedGraphNodes

template <typename TStringSet,typename TValue,typename TAliGraph> void _makeRefinedGraphNodes(String<std::set<TValue> > & all_nodes, TStringSet & seqs, TAliGraph & ali_g);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(202)

//____________________________________________________________________________
// _markRootVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "projects/library/seqan/graph/graph_drawing.h"(34)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Directed<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "projects/library/seqan/graph/graph_drawing.h"(48)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Undirected<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "projects/library/seqan/graph/graph_drawing.h"(59)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "projects/library/seqan/graph/graph_drawing.h"(71)

//____________________________________________________________________________
// _nextInSortedSequence

template <typename TSortedSequence, typename TIterator> inline typename TSortedSequence::const_iterator _nextInSortedSequence(TSortedSequence const& list, TIterator const& prev);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(64)

//____________________________________________________________________________
// _parse_isAlphanumericChar

template <typename TChar> inline bool _parse_isAlphanumericChar(TChar const c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(97)

//____________________________________________________________________________
// _parse_isDigit

template <typename TChar> inline bool _parse_isDigit(TChar const c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(66)

//____________________________________________________________________________
// _parse_isLetter

template <typename TChar> inline bool _parse_isLetter(TChar const c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(77)

//____________________________________________________________________________
// _parse_readDouble

template <typename TFile, typename TChar> inline double _parse_readDouble(TFile & file, TChar& c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(122)

//____________________________________________________________________________
// _parse_readIdentifier

template <typename TFile, typename TChar> inline String<char> _parse_readIdentifier(TFile & file, TChar& c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(138)

//____________________________________________________________________________
// _parse_readNumber

template <typename TFile, typename TChar> inline int _parse_readNumber(TFile & file, TChar& c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(106)

//____________________________________________________________________________
// _parse_readSequenceData

template <typename TFile, typename TChar, typename TString> inline void _parse_readSequenceData(TFile & file, TChar & c, TString& str);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(819)

//____________________________________________________________________________
// _parse_readWord

template <typename TFile, typename TChar> inline String<char> _parse_readWord(TFile & file, TChar& c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(154)

//____________________________________________________________________________
// _parse_skipLine

template <typename TFile, typename TChar> inline void _parse_skipLine(TFile& file, TChar& c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(39)

//____________________________________________________________________________
// _parse_skipWhitespace

template <typename TFile, typename TChar> inline void _parse_skipWhitespace(TFile& file, TChar& c);       	// "projects/library/seqan/graph/graph_utility_parsing.h"(53)

//____________________________________________________________________________
// _performTripletExtension

template <typename TStringSet, typename TCargo, typename TSpec, typename TCargoMap, typename TVertexString, typename TCargoString> inline void _performTripletExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TCargoMap& newCargoMap, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(284)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet, typename TCargoMap, typename TVertexString, typename TCargoString> inline void _performTripletExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1, TCargoMap& newCargoMap, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(342)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet, typename TCargoMap, typename TVertexString, typename TCargoString> inline void _performTripletExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1, TSet const& set2, TCargoMap& newCargoMap, TVertexString& edges_vertices, TCargoString& edges_cargo);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(396)

//____________________________________________________________________________
// _previousInSortedSequence

template <typename TSortedSequence, typename TKey> inline typename TSortedSequence::const_iterator _previousInSortedSequence(TSortedSequence const& list, TKey const key);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(35)

//____________________________________________________________________________
// _print_all_pairs_shortest_path

template <typename TSpec, typename TPredecessor, typename TVertexDescriptor> inline void _print_all_pairs_shortest_path(Graph<TSpec> const& g, TPredecessor& predecessor, TVertexDescriptor const i, TVertexDescriptor const j);       	// "projects/library/seqan/graph/graph_algorithm.h"(880)

//____________________________________________________________________________
// _print_path

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor, typename TNameMap> inline void _print_path(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor const source, TVertexDescriptor const v, TNameMap const& nameMap);       	// "projects/library/seqan/graph/graph_algorithm.h"(568)
template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor1, typename TVertexDescriptor2> inline void _print_path(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor1 const source, TVertexDescriptor2 const v);       	// "projects/library/seqan/graph/graph_algorithm.h"(587)

//____________________________________________________________________________
// _processLastColumn

template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _processLastColumn(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TColumn const& column);       	// "projects/library/seqan/graph/graph_align_config.h"(244)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _processLastColumn(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TColumn const& column);       	// "projects/library/seqan/graph/graph_align_config.h"(258)

//____________________________________________________________________________
// _processLastRow

template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _processLastRow(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue1&, TIndex1&, TValue2 const, TIndex2 const);       	// "projects/library/seqan/graph/graph_align_config.h"(213)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _processLastRow(AlignConfig<TTop, TLeft, TRight, true, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const index);       	// "projects/library/seqan/graph/graph_align_config.h"(227)

//____________________________________________________________________________
// _readLibrary

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _readLibrary(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(838)

//____________________________________________________________________________
// _rebuildParentMap

template <typename TCargo, typename TSpec> inline void _rebuildParentMap(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(151)

//____________________________________________________________________________
// _recursiveProgressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence> inline void _recursiveProgressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(117)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence, typename TTag> inline void _recursiveProgressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq, Tag<TTag>);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(279)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence> inline TCargo _recursiveProgressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq, Chaining tag);       	// "projects/library/seqan/graph/graph_align_chaining.h"(282)

//____________________________________________________________________________
// _refine

template <typename TValue, typename TAlignmentString, typename TStringSet, typename TGraph, typename TPropertyMap,typename TSeqMap> void _refine(TValue node_i, TValue seq_i, TStringSet & seqs, TSeqMap & seq_map, TAlignmentString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, String<std::set<TValue> > & all_nodes);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(226)
template <typename TValue, typename TAlignmentString, typename TStringSet,typename TGraph, typename TPropertyMap,typename TSeqMap> void _refine(TValue node_i, TValue seq_i, TStringSet & seqs, TSeqMap & seq_map, TAlignmentString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, String<std::set<TValue> > & all_nodes, TValue min_len);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(312)
template <typename TValue, typename TAlignmentString, typename TStringSet,typename TGraph, typename TPropertyMap,typename TSeqMap, typename TTagSpec> void _refine(TValue node_i, TValue seq_i_id, TStringSet & seqs, TSeqMap & seq_map, TAlignmentString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, String<std::set<TValue> > & all_nodes, TValue min_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(66)

//____________________________________________________________________________
// _relax

template <typename TSpec, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap, typename TVertexDescriptor, typename TEdgeDescriptor> inline void _relax(Graph<TSpec> const& g, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance, TVertexDescriptor const u, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_algorithm.h"(633)

//____________________________________________________________________________
// _retrieveMaxOfAlignment

template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue> inline typename TValue::first_type _retrieveMaxOfAlignment(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue& maxValue);       	// "projects/library/seqan/graph/graph_align_config.h"(278)
template <bool TTop, bool TLeft, typename TSpec, typename TValue> inline typename TValue::first_type _retrieveMaxOfAlignment(AlignConfig<TTop, TLeft, false, true, TSpec> const, TValue& maxValue);       	// "projects/library/seqan/graph/graph_align_config.h"(289)
template <bool TTop, bool TLeft, typename TSpec, typename TValue> inline typename TValue::first_type _retrieveMaxOfAlignment(AlignConfig<TTop, TLeft, true, true, TSpec> const, TValue& maxValue);       	// "projects/library/seqan/graph/graph_align_config.h"(300)

//____________________________________________________________________________
// _setIntervalTreeNode

template <typename TValue, typename TInterval> void _setIntervalTreeNode(IntervalTreeNode<TInterval,StoreIntervals> & knot,TValue center,TInterval & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(400)
template <typename TValue, typename TInterval> void _setIntervalTreeNode(IntervalTreeNode<TInterval,StorePointsOnly> & knot,TValue center,TInterval & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(425)

//____________________________________________________________________________
// _setLeftPosition

template <typename TGraph, typename TSize, typename TPosition > inline void _setLeftPosition( PseudoFragment<TGraph,Default> & me, TSize dim, TPosition val );       	// "projects/library/seqan/graph/graph_align_chaining.h"(213)

//____________________________________________________________________________
// _setRightPosition

template <typename TGraph, typename TSize, typename TPosition > inline void _setRightPosition( PseudoFragment<TGraph,Default> & me, TSize dim, TPosition val );       	// "projects/library/seqan/graph/graph_align_chaining.h"(224)

//____________________________________________________________________________
// _upgmaTreeMerge

template <typename TMatrix, typename TActive, typename TSize> inline typename Value<TMatrix>::Type _upgmaTreeMerge(TMatrix const& mat, TActive const& active, TSize index_i, TSize index_j, TSize i, TSize nseq, UpgmaAvg);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(235)
template <typename TMatrix, typename TActive, typename TSize> inline typename Value<TMatrix>::Type _upgmaTreeMerge(TMatrix const& mat, TActive const&, TSize index_i, TSize index_j, TSize i, TSize nseq, UpgmaMin);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(259)
template <typename TMatrix, typename TActive, typename TSize> inline typename Value<TMatrix>::Type _upgmaTreeMerge(TMatrix const& mat, TActive const&, TSize index_i, TSize index_j, TSize i, TSize nseq, UpgmaMax);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(285)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMax);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(308)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMin);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(336)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const& active, TEdgeDescriptor best, UpgmaAvg);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(372)

//____________________________________________________________________________
// _writeEdgeType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(501)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(512)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(523)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(534)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(545)

//____________________________________________________________________________
// _writeGraphFooter

template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(364)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(374)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(384)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(425)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(436)

//____________________________________________________________________________
// _writeGraphType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(446)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(457)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(468)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(479)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(490)

//____________________________________________________________________________
// addChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor parent);       	// "projects/library/seqan/graph/graph_impl_tree.h"(884)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TCargo const cargo);       	// "projects/library/seqan/graph/graph_impl_tree.h"(899)

//____________________________________________________________________________
// addEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph/graph_impl_align.h"(439)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/graph/graph_impl_align.h"(452)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(102)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TChars> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TChars const* chars);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(129)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(143)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph/graph_impl_directed.h"(550)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo const cargo);       	// "projects/library/seqan/graph/graph_impl_directed.h"(581)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor source, TVertexDescriptor target);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(397)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(442)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph/graph_impl_tree.h"(454)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child, TCargo const cargo);       	// "projects/library/seqan/graph/graph_impl_tree.h"(484)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(405)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(428)

//____________________________________________________________________________
// addEdges

template <typename TSpec, typename TEdgeArray, typename TSize> inline void addEdges(Graph<TSpec>& dest, TEdgeArray const edges, TSize const size);       	// "projects/library/seqan/graph/graph_interface.h"(483)

//____________________________________________________________________________
// addInterval

template <typename TGraph, typename TPropertyMap, typename TInterval> void addInterval(TGraph & g, TPropertyMap & pm, TInterval interval);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(563)
template <typename TValue, typename TCargo, typename TInterval> void addInterval(IntervalTree<TValue,TCargo> & itree, TInterval interval);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(648)
template <typename TValue, typename TCargo> void addInterval(IntervalTree<TValue,TCargo> & itree, TValue begin, TValue end, TCargo cargo);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(659)
template <typename TValue, typename TCargo> void addInterval(IntervalTree<TValue,TCargo> & itree, TValue begin, TValue end);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(674)

//____________________________________________________________________________
// addLetterToOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TPropertyMap, typename TChar> inline void addLetterToOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TPropertyMap& supplyState, TChar const c);       	// "projects/library/seqan/graph/graph_impl_oracle.h"(68)

//____________________________________________________________________________
// addVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TId, typename TPos, typename TLength> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TId id, TPos begin, TLength len);       	// "projects/library/seqan/graph/graph_impl_align.h"(348)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addVertex(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(477)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addVertex(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(362)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addVertex(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(400)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(366)

//____________________________________________________________________________
// all_pairs_shortest_path

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void all_pairs_shortest_path(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph/graph_algorithm.h"(1008)

//____________________________________________________________________________
// assign

inline void assign(TraceBack & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_align_base.h"(84)
inline void assign(TraceBackGotoh & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_align_base.h"(154)
inline void assign(AAGroupsDayhoff & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(129)
inline void assign(AAGroupsDayhoff & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(139)
inline void assign(AAGroupsDayhoff & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(149)
inline void assign(AAGroupsDayhoff & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(159)
inline void assign(AAGroupsSeB6 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(235)
inline void assign(AAGroupsSeB6 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(245)
inline void assign(AAGroupsSeB6 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(255)
inline void assign(AAGroupsSeB6 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(265)
inline void assign(AAGroupsSeB8 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(340)
inline void assign(AAGroupsSeB8 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(350)
inline void assign(AAGroupsSeB8 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(360)
inline void assign(AAGroupsSeB8 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(370)
inline void assign(AAGroupsMurphy & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(445)
inline void assign(AAGroupsMurphy & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(455)
inline void assign(AAGroupsMurphy & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(465)
inline void assign(AAGroupsMurphy & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(475)
inline void assign(AAGroupsSolisG10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(549)
inline void assign(AAGroupsSolisG10 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(559)
inline void assign(AAGroupsSolisG10 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(569)
inline void assign(AAGroupsSolisG10 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(579)
inline void assign(AAGroupsSolisD10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(654)
inline void assign(AAGroupsSolisD10 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(664)
inline void assign(AAGroupsSolisD10 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(674)
inline void assign(AAGroupsSolisD10 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(684)
inline void assign(AAGroupsLiB10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(758)
inline void assign(AAGroupsLiB10 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(768)
inline void assign(AAGroupsLiB10 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(778)
inline void assign(AAGroupsLiB10 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(788)
inline void assign(AAGroupsLiA10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(861)
inline void assign(AAGroupsLiA10 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(871)
inline void assign(AAGroupsLiA10 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(881)
inline void assign(AAGroupsLiA10 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(891)
inline void assign(AAGroupsSeV10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(965)
inline void assign(AAGroupsSeV10 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(975)
inline void assign(AAGroupsSeV10 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(985)
inline void assign(AAGroupsSeV10 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(995)
inline void assign(AAGroupsSeB10 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1071)
inline void assign(AAGroupsSeB10 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1081)
inline void assign(AAGroupsSeB10 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1091)
inline void assign(AAGroupsSeB10 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1101)
inline void assign(AAGroupsSeB14 & target, AminoAcid const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1175)
inline void assign(AAGroupsSeB14 & target, Byte const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1185)
inline void assign(AAGroupsSeB14 & target, Ascii const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1195)
inline void assign(AAGroupsSeB14 & target, Unicode const c_source);       	// "projects/library/seqan/graph/graph_utility_alphabets.h"(1205)

//____________________________________________________________________________
// assignCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TCargo2 const& t);       	// "projects/library/seqan/graph/graph_edgestump.h"(450)
template <bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<void, TList, TSource, TId, TSpec>*, TCargo2 const&);       	// "projects/library/seqan/graph/graph_edgestump.h"(461)

//____________________________________________________________________________
// assignNextS

template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, true, TId, TSpec>* es, EdgeStump<TCargo, true, true, TId, TSpec>* es2);       	// "projects/library/seqan/graph/graph_edgestump.h"(820)
template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, false, TId, TSpec>*, EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(832)

//____________________________________________________________________________
// assignNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline void assignNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es, EdgeStump<TCargo, true, TSource, TId, TSpec>* es2);       	// "projects/library/seqan/graph/graph_edgestump.h"(730)

//____________________________________________________________________________
// assignProperty

template <typename TPropertyMap, typename TDescriptor, typename TValue> inline void assignProperty(TPropertyMap& pm, TDescriptor const d, TValue const val);       	// "projects/library/seqan/graph/graph_property.h"(136)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph/graph_property.h"(320)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph/graph_property.h"(332)
template <typename T, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<T, 0>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph/graph_property.h"(344)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline void assignProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph/graph_property.h"(553)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline void assignProperty(TValue TClass:: * ptr_to_member, TEdgeDescriptor const e, TValue const val);       	// "projects/library/seqan/graph/graph_property.h"(669)

//____________________________________________________________________________
// assignRoot

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_tree.h"(734)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(731)

//____________________________________________________________________________
// assignSource

template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es, TVertexDescriptor const s);       	// "projects/library/seqan/graph/graph_edgestump.h"(577)
template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, false, TId, TSpec>*, TVertexDescriptor const);       	// "projects/library/seqan/graph/graph_edgestump.h"(588)

//____________________________________________________________________________
// assignStringSet

template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet2> inline void assignStringSet(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TStringSet2& sStr);       	// "projects/library/seqan/graph/graph_impl_align.h"(1029)

//____________________________________________________________________________
// assignTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TVertexDescriptor const t);       	// "projects/library/seqan/graph/graph_edgestump.h"(486)

//____________________________________________________________________________
// atBegin

template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(225)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(196)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(199)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(315)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(206)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(613)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(623)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(634)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(644)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(654)

//____________________________________________________________________________
// atEnd

template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(249)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(213)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(216)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(390)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(226)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(714)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(724)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(734)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(744)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(754)

//____________________________________________________________________________
// bellman_ford_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> bool bellman_ford_algorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph/graph_algorithm.h"(738)

//____________________________________________________________________________
// breadth_first_search

template <typename TSpec, typename TVertexDescriptor, typename TPredecessorMap, typename TDistanceMap> void breadth_first_search(Graph<TSpec> const& g, TVertexDescriptor const source, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph/graph_algorithm.h"(92)

//____________________________________________________________________________
// cargo

template <typename TValue, typename TCargo> TCargo & cargo(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(122)
template <typename TValue, typename TCargo> TCargo & cargo(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(230)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(391)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(401)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(412)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(423)

//____________________________________________________________________________
// chainSubsequence

template <typename TStringSet, typename TCargo, typename TSpec, typename TString> inline TCargo chainSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TString& align);       	// "projects/library/seqan/graph/graph_align_chaining.h"(497)

//____________________________________________________________________________
// childVertex

template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type childVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_tree.h"(990)

//____________________________________________________________________________
// clear

template <typename TStringSet, typename TCargo, typename TSpec> inline void clear(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(300)
template <typename TCargo, typename TSpec> inline void clear(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(355)
template <typename TCargo, typename TSpec> inline void clear(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(307)
template <typename TCargo, typename TSpec> inline void clear(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(332)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(295)

//____________________________________________________________________________
// clearEdges

template <typename TStringSet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(265)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(303)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(251)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(297)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(271)

//____________________________________________________________________________
// clearVertices

template <typename TStringSet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(275)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(334)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Undirected<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(295)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(319)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(283)

//____________________________________________________________________________
// collectLeaves

template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TSet> inline void collectLeaves(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const root, TSet& set1);       	// "projects/library/seqan/graph/graph_impl_tree.h"(1049)

//____________________________________________________________________________
// combineGraphs

template <typename TStringSet, typename TCargo, typename TSpec, typename TLibraries> inline void combineGraphs(Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, bool onlyTopology, TLibraries& libs);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(149)
template <typename TStringSet, typename TCargo, typename TSpec, typename TLibraries> inline void combineGraphs(Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TLibraries& libs);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(261)

//____________________________________________________________________________
// consensusAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TValue, typename TCoverage, typename TGappedConsensus, typename TConsensus, typename TPolymorphMap, typename TSize> inline void consensusAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, String<TValue>& mat, TCoverage& coverage, TGappedConsensus& gappedConsensus, TConsensus& ungappedConsensus, TPolymorphMap& polyMap, TSize& maxCoverage);       	// "projects/library/seqan/graph/graph_align_consensus_base.h"(42)

//____________________________________________________________________________
// convertAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TComponentMap, typename TOrderMap, typename TComponentLength> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TComponentMap& component, TOrderMap& order, TComponentLength& compLength);       	// "projects/library/seqan/graph/graph_impl_align.h"(1367)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph/graph_impl_align.h"(1465)

//____________________________________________________________________________
// createIntervalTree

template <typename TGraph, typename TPropertyMap, typename TIntervals, typename TSpec> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, Tag<TSpec> const tag);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(218)
template <typename TGraph, typename TPropertyMap, typename TIntervals> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(254)
template <typename TGraph, typename TPropertyMap, typename TIntervals, typename TSpec> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, typename Value<typename Value<TIntervals>::Type>::Type center, Tag<TSpec> const tag);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(268)
template <typename TGraph, typename TPropertyMap, typename TIntervals> void createIntervalTree(TGraph & g, TPropertyMap & pm, TIntervals & intervals, typename Value<typename Value<TIntervals>::Type>::Type center);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(306)

//____________________________________________________________________________
// createOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "projects/library/seqan/graph/graph_impl_oracle.h"(114)

//____________________________________________________________________________
// createOracleOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracleOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "projects/library/seqan/graph/graph_impl_oracle.h"(148)

//____________________________________________________________________________
// createRoot

template <typename TCargo, typename TSpec> inline void createRoot(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(749)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void createRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(701)

//____________________________________________________________________________
// createTreesForAllSequences

template <typename TGraph, typename TPropertyMap, typename TAlignmentString, typename TSpec, typename TSequence, typename TSetSpec, typename TValue, typename TSeqMap> void createTreesForAllSequences(String<TGraph> & gs, String<TPropertyMap> & pms, TAlignmentString & alis, StringSet<TSequence,TSetSpec> & seqs, TSeqMap & seq_map, TValue numSequences, Tag<TSpec> const tag);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(413)
template <typename TGraph, typename TPropertyMap, typename TAlignmentString, typename TSequence, typename TSetSpec, typename TValue, typename TSeqMap> void createTreesForAllSequences(String<TGraph> & gs, String<TPropertyMap> & pms, TAlignmentString & alis, StringSet<TSequence,TSetSpec> & seqs, TSeqMap & seq_map, TValue numSequences);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(153)

//____________________________________________________________________________
// createTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph/graph_impl_trie.h"(127)

//____________________________________________________________________________
// createTrieOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrieOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "projects/library/seqan/graph/graph_impl_trie.h"(167)

//____________________________________________________________________________
// cutIsOk

template <typename TValue> inline bool cutIsOk(String<std::set<TValue> > & all_nodes, TValue seq_i, TValue pos_i, typename std::set<TValue>::iterator iter, TValue min_len);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(275)
template <typename TValue> inline bool cutIsOk(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue pos_i, typename std::set<TValue>::iterator iter, TValue min_len, Tag<TagInexactRefinement_> const);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(41)
template <typename TValue> inline bool cutIsOk(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue, typename std::set<TValue>::iterator iter, TValue, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(42)

//____________________________________________________________________________
// dag_shortest_path

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dag_shortest_path(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph/graph_algorithm.h"(675)

//____________________________________________________________________________
// degree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type degree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_align.h"(335)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type degree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_directed.h"(455)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type degree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(353)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type degree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_tree.h"(390)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(356)

//____________________________________________________________________________
// depth_first_search

template <typename TSpec, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap> void depth_first_search(Graph<TSpec> const& g, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish);       	// "projects/library/seqan/graph/graph_algorithm.h"(201)

//____________________________________________________________________________
// dijkstra

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dijkstra(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph/graph_algorithm.h"(808)

//____________________________________________________________________________
// dimension

template <typename TGraph > inline size_t dimension( PseudoFragment<TGraph,Default> & me );       	// "projects/library/seqan/graph/graph_align_chaining.h"(129)
template <typename TGraph > inline size_t dimension( const PseudoFragment<TGraph,Default> & me );       	// "projects/library/seqan/graph/graph_align_chaining.h"(136)

//____________________________________________________________________________
// empty

template <typename TStringSet, typename TCargo, typename TSpec> inline bool empty(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(255)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(281)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(241)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(287)
template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(261)

//____________________________________________________________________________
// findEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type findEdge(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph/graph_impl_align.h"(541)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type findEdge(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph/graph_impl_directed.h"(880)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type findEdge(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(649)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type findEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/graph/graph_impl_tree.h"(657)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v, TLabel const c);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(617)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TLabel const c);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(635)

//____________________________________________________________________________
// findIntervals

template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervals(TGraph & g, TPropertyMap & pm, TValue query, String<TCargo> & result);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(704)
template <typename TValue,typename TCargo> void findIntervals(IntervalTree<TValue,TCargo> & it, TValue query, String<TCargo> & result);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(775)

//____________________________________________________________________________
// findIntervalsExcludeTouching

template <typename TGraph, typename TPropertyMap, typename TValue,typename TCargo> void findIntervalsExcludeTouching(TGraph & g, TPropertyMap & pm, TValue query, String<TCargo> & result);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(789)
template <typename TValue,typename TCargo> void findIntervalsExcludeTouching(IntervalTree<TValue,TCargo> & it, TValue query, String<TCargo> & result);       	// "projects/library/seqan/graph/graph_impl_interval_tree.h"(865)

//____________________________________________________________________________
// findVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId, typename TPos> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type findVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId id, TPos pos);       	// "projects/library/seqan/graph/graph_impl_align.h"(1203)

//____________________________________________________________________________
// floyd_warshall

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void floyd_warshall(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph/graph_algorithm.h"(1057)

//____________________________________________________________________________
// ford_fulkerson

template <typename TSpec, typename TVertexDescriptor, typename TCapMap, typename TFlowMap> typename Value<TFlowMap>::Type ford_fulkerson(Graph<TSpec> const& g, TVertexDescriptor const source, TVertexDescriptor const sink, TCapMap const& capacity, TFlowMap& flow);       	// "projects/library/seqan/graph/graph_algorithm.h"(1250)

//____________________________________________________________________________
// forwardAlgorithm

template <typename TAlphabet, typename TProb, typename TSpec, typename TSequence> inline TProb forwardAlgorithm(HiddenMarkovModel<TAlphabet, TProb, TSpec> const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(192)

//____________________________________________________________________________
// fragmentBegin

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& fragmentBegin(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(1158)
template <typename TSequence,typename TValue,typename TSpec> typename Position<TSequence>::Type& fragmentBegin(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(90)
template <typename TId, typename TPos, typename TSize, typename TSpec, typename TVal> inline typename Position<Fragment<TId, TPos, TSize, TSpec> >::Type& fragmentBegin(Fragment<TId, TPos, TSize, TSpec> const& f, TVal const seqId);       	// "projects/library/seqan/graph/graph_impl_fragment.h"(113)

//____________________________________________________________________________
// fragmentLength

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& fragmentLength(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(1180)
template <typename TSequence,typename TValue,typename TSpec> typename Size<TSequence>::Type& fragmentLength(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(98)
template <typename TId, typename TPos, typename TSize, typename TSpec, typename TVal> inline typename Size<Fragment<TId, TPos, TSize, TSpec> >::Type& fragmentLength(Fragment<TId, TPos, TSize, TSpec> const& f, TVal const);       	// "projects/library/seqan/graph/graph_impl_fragment.h"(128)
template <typename TId, typename TPos, typename TSize, typename TSpec> inline typename Size<Fragment<TId, TPos, TSize, TSpec> >::Type& fragmentLength(Fragment<TId, TPos, TSize, TSpec> const& f);       	// "projects/library/seqan/graph/graph_impl_fragment.h"(138)

//____________________________________________________________________________
// generatePrimaryLibrary

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, LocalPairwise_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(40)
template <typename TStringSet, typename TCargo, typename TSpec, typename TDistance, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TDistance& dist, TScore const& score_type, GlobalPairwise_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(224)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TScoreSpec> const& score_type, GlobalPairwise_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(273)
template <typename TStringSet, typename TCargo, typename TSpec, typename TPair, typename TPairSpec, typename TDistance, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, String<TPair, TPairSpec> const& pList, TDistance& dist, TScore const& score_type, Overlap_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(338)
template <typename TStringSet, typename TCargo, typename TSpec, typename TPair, typename TPairSpec, typename TScore> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, String<TPair, TPairSpec> const& pList, TScore const& score_type, Overlap_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(414)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TSize> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TScore const& score_type, TSize ktup, bool overlapping, Kmer_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(430)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TScoreSpec, typename TSize> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TScoreSpec> const& score_type, TSize ktup, Kmer_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(545)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TScoreSpec> inline void generatePrimaryLibrary(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TScoreSpec> const& score_type, Kmer_Library);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(557)

//____________________________________________________________________________
// generateSequence

template <typename TAlphabet, typename TProb, typename TSpec, typename TSize, typename TSequence> inline void generateSequence(HiddenMarkovModel<TAlphabet, TProb, TSpec> const& hmm, TSize const& len, TSequence& seq);       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(131)

//____________________________________________________________________________
// getAdjacencyMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph/graph_impl_align.h"(530)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Directed<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph/graph_impl_directed.h"(825)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Undirected<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(611)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Tree<TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph/graph_impl_tree.h"(625)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(580)

//____________________________________________________________________________
// getAlignmentStatistics

template <typename TFragmentMatches, typename TStringSet, typename TPos, typename TSize1, typename TAlphabet> inline void getAlignmentStatistics(TFragmentMatches const& matches, TStringSet& str, TPos const from, TPos const to, TSize1& matchLength, TSize1& overlapLength, TSize1& alignLength, TAlphabet);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(164)
template <typename TFragmentMatches, typename TStringSet, typename TPos, typename TSize> inline void getAlignmentStatistics(TFragmentMatches& matches, TStringSet& str, TPos from, TPos to, TSize& matchLength, TSize& overlapLength, TSize& alignLength);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(217)
template <typename TFragmentMatches, typename TStringSet, typename TSize> inline void getAlignmentStatistics(TFragmentMatches& matches, TStringSet& str, TSize& matchLength, TSize& overlapLength, TSize& alignLength);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(231)

//____________________________________________________________________________
// getAnnoScore

template <typename TAliGraph,typename TScore, typename TPropertyMap> typename Value<TScore>::Type getAnnoScore(TAliGraph &, TPropertyMap & pm, typename VertexDescriptor<TAliGraph>::Type vd1, typename VertexDescriptor<TAliGraph>::Type vd2, TScore &);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(249)
template <typename TAliGraph,typename TScore> typename Value<TScore>::Type getAnnoScore(TAliGraph &, bool, typename VertexDescriptor<TAliGraph>::Type, typename VertexDescriptor<TAliGraph>::Type, TScore &);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(281)

//____________________________________________________________________________
// getCargo

template <typename TValue, typename TCargo> TCargo getCargo(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(130)
template <typename TValue, typename TCargo> TCargo getCargo(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(238)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(335)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(345)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(355)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(366)

//____________________________________________________________________________
// getDistanceMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, LibraryDistance);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(39)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize, typename TAlphabet> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, TAlphabet, KmerDistance);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(99)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, KmerDistance);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(129)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, KmerDistance);       	// "projects/library/seqan/graph/graph_align_tcoffee_distance.h"(141)

//____________________________________________________________________________
// getFirstCoveredPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type getFirstCoveredPosition(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSeqId const id);       	// "projects/library/seqan/graph/graph_impl_align.h"(1289)

//____________________________________________________________________________
// getIdLowerBound

template <typename TIdType, typename TSpec> inline typename Size<IdManager<TIdType, TSpec> >::Type getIdLowerBound(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(250)
template <typename TSpec> inline typename Size<IdManager<void, TSpec> >::Type getIdLowerBound(IdManager<void, TSpec> const&);       	// "projects/library/seqan/graph/graph_idmanager.h"(429)

//____________________________________________________________________________
// getIdUpperBound

template <typename TIdType, typename TSpec> inline typename Size<IdManager<TIdType, TSpec> >::Type getIdUpperBound(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(229)
template <typename TSpec> inline typename Size<IdManager<void, TSpec> >::Type getIdUpperBound(IdManager<void, TSpec> const& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(417)

//____________________________________________________________________________
// getInfinity

template <typename T> inline T const getInfinity();       	// "projects/library/seqan/graph/graph_interface.h"(339)
template <> inline double const getInfinity();       	// "projects/library/seqan/graph/graph_interface.h"(349)

//____________________________________________________________________________
// getInfinityDistance

template <typename TWeightMap> inline typename Value<TWeightMap>::Type getInfinityDistance(TWeightMap const&);       	// "projects/library/seqan/graph/graph_interface.h"(420)
inline unsigned int getInfinityDistance();       	// "projects/library/seqan/graph/graph_interface.h"(429)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TString, typename TSpec, typename THitMatrix, typename TSize, typename TAlphabet> inline void getKmerSimilarityMatrix(StringSet<TString, TSpec> const& strSet, THitMatrix& mat, TSize ktup, TAlphabet);       	// "projects/library/seqan/graph/graph_align_tcoffee_kmer.h"(117)

//____________________________________________________________________________
// getLastCoveredPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type getLastCoveredPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId id);       	// "projects/library/seqan/graph/graph_impl_align.h"(1332)

//____________________________________________________________________________
// getLeftBoundary

template <typename TValue, typename TCargo> TValue getLeftBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(106)
template <typename TValue, typename TCargo> TValue getLeftBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(214)

//____________________________________________________________________________
// getNextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* getNextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(908)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* getNextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(918)

//____________________________________________________________________________
// getNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(784)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(795)

//____________________________________________________________________________
// getNil

template <typename T> inline T const getNil(T *);       	// "projects/library/seqan/graph/graph_interface.h"(367)
template <typename T> inline T const getNil();       	// "projects/library/seqan/graph/graph_interface.h"(376)

//____________________________________________________________________________
// getNilPredecessor

template <typename TSpec> inline typename VertexDescriptor<Graph<TSpec> >::Type getNilPredecessor(Graph<TSpec> const&);       	// "projects/library/seqan/graph/graph_interface.h"(400)

//____________________________________________________________________________
// getProjectedPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId, typename TPosition, typename TSeqId2, typename TPosition2> inline void getProjectedPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId const id1, TPosition const pos1, TSeqId2& id2, TPosition2& pos2);       	// "projects/library/seqan/graph/graph_impl_align.h"(1234)
template <typename TId, typename TPos, typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TId, TPos, TSize, TSpec> const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "projects/library/seqan/graph/graph_impl_fragment.h"(152)

//____________________________________________________________________________
// getProperty

template <typename TPropertyMap, typename TDescriptor> inline typename GetValue<TPropertyMap const>::Type getProperty(TPropertyMap const& pm, TDescriptor const d);       	// "projects/library/seqan/graph/graph_property.h"(207)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> const>::Type getProperty(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(421)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type getProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(432)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> const>::Type getProperty(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(443)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type getProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(454)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> const>::Type getProperty(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(465)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type getProperty(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(476)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> const>::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_property.h"(586)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_property.h"(598)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue getProperty(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_property.h"(692)

//____________________________________________________________________________
// getRightBoundary

template <typename TValue, typename TCargo> TValue getRightBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(114)
template <typename TValue, typename TCargo> TValue getRightBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(222)

//____________________________________________________________________________
// getRoot

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type getRoot(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(772)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(783)

//____________________________________________________________________________
// getScore

template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TAlignment,typename TValue> TScoreValue getScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet & seqs, Graph<TAlignment> & segment, TValue pos_i, TValue pos_j, TValue len, TValue len_j);       	// "projects/library/seqan/graph/graph_algorithm_refine_aligngraph.h"(176)
template <typename TScore,typename TStringSet,typename TAliSource,typename TAliSpec,typename TValue> typename Value<TScore>::Type getScore(TScore & score_type, TStringSet & seqs, Align<TAliSource,TAliSpec> & segment, bool i_am_first, TValue pos_i, TValue pos_j, TValue len);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(484)
template <typename TScore,typename TStringSet, typename TAliSource,typename TAliSpec,typename TValue> typename Value<TScore>::Type getScore(TScore & score_type, TStringSet & seqs, Align<TAliSource,TAliSpec> & segment, bool i_am_first, TValue pos_i, TValue pos_j, TValue len1, TValue len2);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(533)
template <typename TScore,typename TStringSet,typename TAlignment,typename TValue> typename Value<TScore>::Type getScore(TScore & score_type, TStringSet & seqs, Graph<TAlignment> & segment, bool i_am_first, TValue pos_i, TValue pos_j, TValue len);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(589)
template <typename TScore,typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec,typename TValue> typename Value<TScore>::Type getScore(TScore & score_type, TStringSet & seqs, Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, bool i_am_first, TValue pos_i, TValue pos_j, TValue len1, TValue len2);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(627)
template <typename TScoreValue, typename TSpec, typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec> TScoreValue getScore(Score<TScoreValue, TSpec> & score_type, TStringSet & seqs, Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, bool i_am_first, TFragPos pos_i, TFragPos pos_j, TFragSize len1, TFragSize len2);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(670)
template <typename TScoreValue, typename TSpec, typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec> TScoreValue getScore(Score<TScoreValue, TSpec> & score_type, TStringSet & seqs, Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, bool, TFragPos pos_i, TFragPos pos_j, TFragSize len);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(705)
template <typename TScoreValue,typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec> TScoreValue getScore(Score<TScoreValue,FakeScore> &, TStringSet &, Fragment<TFragId,TFragPos,TFragSize,TFragSpec> &, bool, TFragPos, TFragPos, TFragSize);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(801)
template <typename TScoreValue,typename TStringSet,typename TAlign,typename TValue, typename TSize> TScoreValue getScore(TScoreValue &, TStringSet &, TAlign &, TValue, TValue, TSize, TSize);       	// "projects/library/seqan/graph/graph_algorithm_refine_scoring.h"(42)
template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TAliSource,typename TAliSpec,typename TValue> TScoreValue getScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet &, Align<TAliSource,TAliSpec> & segment, TValue pos_i, TValue pos_j, TValue len, TValue);       	// "projects/library/seqan/graph/graph_algorithm_refine_align.h"(103)
template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize, typename TFragSpec> TScoreValue getScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet & seqs, Fragment<TFragId,TFragPos,TFragSize,TFragSpec> & segment, TFragPos pos_i, TFragPos pos_j, TFragSize len, TFragSize);       	// "projects/library/seqan/graph/graph_algorithm_refine_fragment.h"(155)
template <typename TScoreValue,typename TStringSet,typename TFragId,typename TFragPos,typename TFragSize> TScoreValue getScore(Score<TScoreValue, Simple> & score_type, TStringSet &, Fragment<TFragId,TFragPos,TFragSize,ExactFragment> &, TFragPos, TFragPos, TFragSize len, TFragSize);       	// "projects/library/seqan/graph/graph_algorithm_refine_fragment.h"(186)

//____________________________________________________________________________
// getSeqBeginAndEnd

template <typename TAliSource,typename TAliSpec, typename TValue> void getSeqBeginAndEnd(Align<TAliSource,TAliSpec> & segment, std::map<const void * ,int> & seq_map, TValue & seq_i, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(84)
template <typename TValue,typename TAlign> void getSeqBeginAndEnd(TAlign & segment, std::map<const void * ,int> &, TValue & seq_i, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(199)

//____________________________________________________________________________
// getSource

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(670)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(680)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(690)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(701)

//____________________________________________________________________________
// getStringSet

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Host<Graph<Alignment<TStringSet, TCargo, TSpec> > const>::Type& getStringSet(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(1059)

//____________________________________________________________________________
// getSuccessor

template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const& chars);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(211)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const* chars);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(232)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TChar> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getSuccessor(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor vertex, TChar const c);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(847)

//____________________________________________________________________________
// getTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(540)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(550)

//____________________________________________________________________________
// getValue

template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(185)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(164)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(166)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(203)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(166)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(488)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(498)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(508)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(518)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(528)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(64)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(78)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(90)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(103)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(115)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(129)
template <typename TStringSet> inline unsigned int globalAlignment(TStringSet const& str, MyersBitVector);       	// "projects/library/seqan/graph/graph_align_interface.h"(141)

//____________________________________________________________________________
// goBegin

template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(236)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(205)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(208)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(352)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(216)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(664)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(674)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(684)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(694)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(704)

//____________________________________________________________________________
// goEnd

template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(259)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(221)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(224)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(426)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(236)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(764)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(774)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(785)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(795)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(805)

//____________________________________________________________________________
// goNext

template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(293)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(303)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(319)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(229)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(232)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(464)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(246)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(815)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(825)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(835)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(848)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(861)

//____________________________________________________________________________
// goPrevious

template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(384)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(394)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(522)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(279)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(902)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(916)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(930)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(953)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(976)

//____________________________________________________________________________
// heaviestCommonSubsequence

template <typename TStringSet, typename TCargo, typename TSpec, typename TString, typename TOutString> inline TCargo heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(462)
template <typename TStringSet, typename TCargo, typename TSpec, typename TString> inline TCargo heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(577)

//____________________________________________________________________________
// heaviestIncreasingSubsequence

template <typename TString, typename TWeightMap, typename TPositions> inline typename Value<TWeightMap>::Type heaviestIncreasingSubsequence(TString const& str, TWeightMap const& weights, TPositions& pos);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(248)

//____________________________________________________________________________
// highestScoreFirstAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TOutGraph> inline void highestScoreFirstAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TOutGraph& gOut);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(362)

//____________________________________________________________________________
// hostGraph

template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(215)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(188)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(191)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(277)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(196)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(603)

//____________________________________________________________________________
// idCount

template <typename TIdType, typename TSpec> inline typename Size<IdManager<TIdType, TSpec> >::Type idCount(IdManager<TIdType, TSpec> const& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(275)
template <typename TSpec> inline typename Size<IdManager<void, TSpec> >::Type idCount(IdManager<void, TSpec> const& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(440)

//____________________________________________________________________________
// idInUse

template <typename TIdType, typename TSpec, typename TId> inline bool idInUse(IdManager<TIdType, TSpec> const& idm, TId const id);       	// "projects/library/seqan/graph/graph_idmanager.h"(298)
template <typename TSpec, typename TId> inline bool idInUse(IdManager<void, TSpec> const&, TId const);       	// "projects/library/seqan/graph/graph_idmanager.h"(452)

//____________________________________________________________________________
// inDegree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type inDegree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_align.h"(324)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type inDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_directed.h"(416)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type inDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(341)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type inDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_tree.h"(365)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(327)

//____________________________________________________________________________
// initializeModel

template <typename TAlphabet, typename TProb, typename TSpec, typename TSize, typename TTransitionProb, typename TEmissionProb, typename TInitialProb> inline void initializeModel(HiddenMarkovModel<TAlphabet, TProb, TSpec>& hmm, TSize const nStates, TSize const alphSize, TTransitionProb const& trans, TEmissionProb const& emis, TInitialProb const& init);       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(91)

//____________________________________________________________________________
// isLeaf

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isLeaf(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph/graph_impl_tree.h"(806)

//____________________________________________________________________________
// isRoot

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph/graph_impl_tree.h"(783)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(811)

//____________________________________________________________________________
// iterativeProgressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TScore, typename TOutGraph> inline typename Value<TScore>::Type iterativeProgressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TScore const& score_type, TOutGraph& gOut, Chaining tag);       	// "projects/library/seqan/graph/graph_align_chaining.h"(328)

//____________________________________________________________________________
// kruskals_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TEdges> void kruskals_algorithm(Graph<TSpec> const& g, TVertexDescriptor const, TWeightMap const& weight, TEdges& edges);       	// "projects/library/seqan/graph/graph_algorithm.h"(484)

//____________________________________________________________________________
// label

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(1103)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(477)
template <typename TSequence,typename TValue,typename TSpec> TValue label(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(106)
template <typename TId, typename TPos, typename TSize, typename TSpec, typename TStringSet, typename TVal> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Fragment<TId, TPos, TSize, TSpec> const& f, TStringSet& str, TVal const seqId);       	// "projects/library/seqan/graph/graph_impl_fragment.h"(81)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1160)

//____________________________________________________________________________
// leftBoundary

template <typename TValue, typename TCargo> TValue & leftBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(90)
template <typename TValue, typename TCargo> TValue & leftBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(198)

//____________________________________________________________________________
// leftPosition

template <typename TGraph, typename TSize > inline int leftPosition( PseudoFragment<TGraph,Default> & me, TSize dim );       	// "projects/library/seqan/graph/graph_align_chaining.h"(144)
template <typename TGraph, typename TSize > inline int leftPosition( const PseudoFragment<TGraph,Default> & me, TSize dim );       	// "projects/library/seqan/graph/graph_align_chaining.h"(156)

//____________________________________________________________________________
// localAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(175)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(186)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue localAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "projects/library/seqan/graph/graph_align_interface.h"(198)

//____________________________________________________________________________
// longestCommonSubsequence

template <typename TString1, typename TString2, typename TFinalPos> inline void longestCommonSubsequence(TString1 const& str1, TString2 const& str2, TFinalPos& pos);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(174)

//____________________________________________________________________________
// longestIncreasingSubsequence

template <typename TString, typename TPositions> inline void longestIncreasingSubsequence(TString const& str, TPositions& pos);       	// "projects/library/seqan/graph/graph_algorithm_lis_his.h"(92)

//____________________________________________________________________________
// matchRefinement

template <typename TAlignmentString, typename TOutGraph, typename TSequence, typename TSetSpec, typename TScore> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TScore & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(947)
template <typename TAlignmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(1059)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(250)
template <typename TAlignmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/graph/graph_algorithm_refine_inexact.h"(271)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TAnnoString,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(303)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TAnnoString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(323)
template <typename TAlignmentString, typename TOutGraph, typename TAnnoString, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(345)
template <typename TAlignmentString,typename TAnnoString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(368)
template <typename TAlignmentString, typename TAnnotation, typename TOutGraph, typename TSequence, typename TSetSpec, typename TScore,typename TTagSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TScore & score_type, TOutGraph & ali_graph, unsigned int min_fragment_len, TAnnotation & annotation, Tag<TTagSpec> const tag);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(399)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(511)
template <typename TAlignmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph);       	// "projects/library/seqan/graph/graph_algorithm_refine_exact.h"(539)

//____________________________________________________________________________
// nextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(855)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(865)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(874)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(885)

//____________________________________________________________________________
// nextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(752)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(762)

//____________________________________________________________________________
// numChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numChildren(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_tree.h"(854)

//____________________________________________________________________________
// numEdges

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type numEdges(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(235)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numEdges(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(244)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numEdges(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(221)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(255)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(241)

//____________________________________________________________________________
// numTreeEdges

template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numTreeEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(830)

//____________________________________________________________________________
// numVertices

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type numVertices(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(245)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numVertices(Graph<Directed<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(265)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numVertices(Graph<Undirected<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(231)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numVertices(Graph<Tree<TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(277)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(251)

//____________________________________________________________________________
// obtainId

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type obtainId(IdManager<TIdType, TSpec>& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(141)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type obtainId(IdManager<void, TSpec>& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(385)

//____________________________________________________________________________
// operator!=

template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(446)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(280)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(283)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(568)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(324)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1078)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1090)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1102)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1114)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1126)

//____________________________________________________________________________
// operator*

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(205)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(180)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(183)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(252)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(186)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(593)

//____________________________________________________________________________
// operator++

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(335)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(346)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(249)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(258)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(252)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(261)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(475)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(486)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(256)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(267)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(879)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(890)

//____________________________________________________________________________
// operator--

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(410)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(421)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(533)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(544)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(289)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(300)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(994)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1005)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TAlphabet, typename TProb, typename TSpec> inline TStream & operator<<(TStream & target, HiddenMarkovModel<TAlphabet, TProb, TSpec> const& source);       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(289)
template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & target, Graph<TSpec> const& source);       	// "projects/library/seqan/graph/graph_interface.h"(505)

//____________________________________________________________________________
// operator==

template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(434)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(269)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(272)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(557)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(313)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1018)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1030)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1042)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1054)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1066)

//____________________________________________________________________________
// outDegree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type outDegree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_align.h"(313)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type outDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_directed.h"(380)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type outDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(318)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type outDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_tree.h"(343)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(306)

//____________________________________________________________________________
// parentVertex

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const edge);       	// "projects/library/seqan/graph/graph_impl_tree.h"(1014)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const v);       	// "projects/library/seqan/graph/graph_impl_tree.h"(1025)

//____________________________________________________________________________
// parseString

template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type parseString(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor const vertex, TIterator beginIt, TIterator endIt);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(245)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TIterator beginIt, TIterator endIt);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(884)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const& chars);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(905)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const* chars);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(917)

//____________________________________________________________________________
// path_growing_algorithm

template <typename TSpec, typename TWeightMap, typename TEdgeMap> typename Value<TWeightMap>::Type path_growing_algorithm(Graph<TSpec>& g, TWeightMap const& weightMap, TEdgeMap& edgeMap1);       	// "projects/library/seqan/graph/graph_algorithm.h"(1324)

//____________________________________________________________________________
// prims_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap> void prims_algorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor);       	// "projects/library/seqan/graph/graph_algorithm.h"(406)

//____________________________________________________________________________
// progressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(159)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph, typename TSize> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut, TSize seqPerGroup);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(184)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph, typename TTag> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut, Tag<TTag>);       	// "projects/library/seqan/graph/graph_align_tcoffee_progressive.h"(340)

//____________________________________________________________________________
// property

template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap>::Type property(TPropertyMap& pm, TDescriptor const d);       	// "projects/library/seqan/graph/graph_property.h"(166)
template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap const>::Type property(TPropertyMap const& pm, TDescriptor const d);       	// "projects/library/seqan/graph/graph_property.h"(177)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type& property(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(355)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> const>::Type& property(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(366)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type& property(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(377)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> const>::Type& property(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(388)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type& property(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(399)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> const>::Type& property(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "projects/library/seqan/graph/graph_property.h"(410)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type& property(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_property.h"(564)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> const>::Type& property(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_property.h"(575)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue& property(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "projects/library/seqan/graph/graph_property.h"(681)

//____________________________________________________________________________
// read

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> void read(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TCoffeeLib);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(928)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, TCoffeeLib);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(977)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void read(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, NewickFormat);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(1143)
template <typename TFile, typename TFragment, typename TSpec, typename TSize> void read(TFile & file, String<TFragment, TSpec>& matches, TSize const minMatchSize, AtacMatches);       	// "projects/library/seqan/graph/graph_utility_match_parsing.h"(35)

//____________________________________________________________________________
// releaseAll

template <typename TIdType, typename TSpec> inline void releaseAll(IdManager<TIdType, TSpec>& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(207)
template <typename TSpec> inline void releaseAll(IdManager<void, TSpec>& idm);       	// "projects/library/seqan/graph/graph_idmanager.h"(407)

//____________________________________________________________________________
// releaseId

template <typename TIdType, typename TSpec, typename TId> inline void releaseId(IdManager<TIdType, TSpec>& idm, TId const id);       	// "projects/library/seqan/graph/graph_idmanager.h"(175)
template <typename TSpec, typename TId> inline void releaseId(IdManager<void, TSpec>& idm, TId const);       	// "projects/library/seqan/graph/graph_idmanager.h"(397)

//____________________________________________________________________________
// removeAllChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeAllChildren(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent);       	// "projects/library/seqan/graph/graph_impl_tree.h"(957)

//____________________________________________________________________________
// removeChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph/graph_impl_tree.h"(930)

//____________________________________________________________________________
// removeEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph/graph_impl_align.h"(464)
template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_align.h"(475)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(157)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph/graph_impl_directed.h"(619)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_directed.h"(655)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(460)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(548)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "projects/library/seqan/graph/graph_impl_tree.h"(500)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_tree.h"(536)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(450)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(467)

//____________________________________________________________________________
// removeInEdges

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(497)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_directed.h"(710)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(577)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_tree.h"(565)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(507)

//____________________________________________________________________________
// removeOutEdges

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(486)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_directed.h"(679)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(559)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_tree.h"(547)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(483)

//____________________________________________________________________________
// removeVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TVD> inline void removeVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVD const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(416)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_directed.h"(510)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(382)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_tree.h"(429)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(388)

//____________________________________________________________________________
// resizeEdgeMap

template <typename TSpec, typename TPropertyMap> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "projects/library/seqan/graph/graph_property.h"(102)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec> const&, InternalMap<TContainer, MemberId>&);       	// "projects/library/seqan/graph/graph_property.h"(301)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec>&, InternalMap<TContainer, MemberId>&);       	// "projects/library/seqan/graph/graph_property.h"(310)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec>&, InternalPointerMap<TPropmap, Instance>&);       	// "projects/library/seqan/graph/graph_property.h"(533)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec> const&, InternalPointerMap<TPropmap, Instance>&);       	// "projects/library/seqan/graph/graph_property.h"(543)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec> const&, TValue TClass:: *);       	// "projects/library/seqan/graph/graph_property.h"(649)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec>&, TValue TClass:: *);       	// "projects/library/seqan/graph/graph_property.h"(658)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "projects/library/seqan/graph/graph_property.h"(729)

//____________________________________________________________________________
// resizeVertexMap

template <typename TSpec, typename TPropertyMap> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "projects/library/seqan/graph/graph_property.h"(73)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "projects/library/seqan/graph/graph_property.h"(711)

//____________________________________________________________________________
// rightBoundary

template <typename TValue, typename TCargo> TValue & rightBoundary(IntervalAndCargo<TValue,TCargo> & interval);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(98)
template <typename TValue, typename TCargo> TValue & rightBoundary(PointAndCargo<TValue,TCargo> & point);       	// "projects/library/seqan/graph/graph_impl_interval_types.h"(206)

//____________________________________________________________________________
// rightPosition

template <typename TGraph, typename TSize > inline int rightPosition( PseudoFragment<TGraph,Default> & me, TSize dim );       	// "projects/library/seqan/graph/graph_align_chaining.h"(167)
template <typename TGraph, typename TSize > inline int rightPosition( const PseudoFragment<TGraph,Default> & me, TSize dim );       	// "projects/library/seqan/graph/graph_align_chaining.h"(178)

//____________________________________________________________________________
// rnaFolding

template <typename TCargo, typename TSpec, typename TString, typename TScore, typename TLoopSize> unsigned int rnaFolding(Graph<Undirected<TCargo, TSpec> >& g, TString const& str, TScore const& sc, TLoopSize const& lSize, Nussinov);       	// "projects/library/seqan/graph/graph_fold_nussinov.h"(179)
template <typename TCargo, typename TSpec, typename TScore, typename TString> unsigned int rnaFolding(Graph<Undirected<TCargo, TSpec> >& g, TString const& str, TScore const& sc, Nussinov);       	// "projects/library/seqan/graph/graph_fold_nussinov.h"(202)

//____________________________________________________________________________
// root

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type& root(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(762)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& root(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(757)

//____________________________________________________________________________
// score

template <typename TValue, typename T> inline TValue score(Score<TValue,FakeScore> & me, T const & left, T const & right);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(780)
template <typename TValue, typename TGraphType, typename T> inline TValue score(Score<TValue, ScoreAlignmentGraph<TGraphType> > & me, T const & left, T const & right);       	// "projects/library/seqan/graph/graph_align_base.h"(354)
template <typename TValue, typename T> inline unsigned int score(Score<TValue, ScoreNussinov> const& me, T const & left, T const & right);       	// "projects/library/seqan/graph/graph_fold_nussinov.h"(74)

//____________________________________________________________________________
// scoreGapExtend

template <typename TValue> inline TValue scoreGapExtend(Score<TValue,FakeScore> & me);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(750)
template <typename TValue> inline TValue const scoreGapExtend(Score<TValue,FakeScore> const & me);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(758)
template <typename TValue, typename TGraphType> inline TValue scoreGapExtend(Score<TValue, ScoreAlignmentGraph<TGraphType> > &);       	// "projects/library/seqan/graph/graph_align_base.h"(324)
template <typename TValue, typename TGraphType> inline TValue const scoreGapExtend(Score<TValue, ScoreAlignmentGraph<TGraphType> > const &);       	// "projects/library/seqan/graph/graph_align_base.h"(332)

//____________________________________________________________________________
// scoreGapOpen

template <typename TValue> inline TValue scoreGapOpen(Score<TValue,FakeScore> & me);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(765)
template <typename TValue> inline TValue const scoreGapOpen(Score<TValue,FakeScore> const & me);       	// "projects/library/seqan/graph/graph_algorithm_refine.h"(771)
template <typename TValue, typename TGraphType> inline TValue scoreGapOpen(Score<TValue, ScoreAlignmentGraph<TGraphType> > &);       	// "projects/library/seqan/graph/graph_align_base.h"(339)
template <typename TValue, typename TGraphType> inline TValue const scoreGapOpen(Score<TValue, ScoreAlignmentGraph<TGraphType> > const &);       	// "projects/library/seqan/graph/graph_align_base.h"(345)

//____________________________________________________________________________
// selectPairsForLibraryGeneration

template <typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TPairList, typename TReadLength> inline void selectPairsForLibraryGeneration(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TNames& names, TPairList& pList, TReadLength readLen);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(771)

//____________________________________________________________________________
// sequenceId

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Id<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& sequenceId(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/graph/graph_impl_align.h"(1135)
template <typename TSequence,typename TValue,typename TSpec> typename Id<TSequence>::Type& sequenceId(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/graph/graph_algorithm_refine_annotation.h"(82)
template <typename TId, typename TPos, typename TSize, typename TSpec, typename TVal> inline TId sequenceId(Fragment<TId, TPos, TSize, TSpec> const& f, TVal const seqId);       	// "projects/library/seqan/graph/graph_impl_fragment.h"(98)

//____________________________________________________________________________
// setWeight

template <typename TGraph, typename TWeight > inline typename Weight< PseudoFragment< TGraph,Default > >::Type setWeight(PseudoFragment<TGraph,Default> & me, TWeight weight );       	// "projects/library/seqan/graph/graph_align_chaining.h"(204)

//____________________________________________________________________________
// slowNjTree

template <typename TStringSpec, typename TCargo, typename TSpec> inline void slowNjTree(String<double, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(37)

//____________________________________________________________________________
// source

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type& source(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(612)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(622)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "projects/library/seqan/graph/graph_edgestump.h"(633)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "projects/library/seqan/graph/graph_edgestump.h"(645)

//____________________________________________________________________________
// sourceVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type sourceVertex(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_align.h"(519)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(457)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type sourceVertex(Graph<Directed<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_directed.h"(792)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type sourceVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(599)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type sourceVertex(Graph<Tree<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_tree.h"(604)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(549)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1137)

//____________________________________________________________________________
// stringSet

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Host<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& stringSet(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/graph/graph_impl_align.h"(1081)

//____________________________________________________________________________
// strongly_connected_components

template <typename TSpec, typename TComponents> void strongly_connected_components(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph/graph_algorithm.h"(309)

//____________________________________________________________________________
// subtreeMerging

template <typename TCargo, typename TSpec, typename TGuideTree> inline void subtreeMerging(Graph<Undirected<TCargo, TSpec> >& pairGraph, TGuideTree& guideTree);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(628)

//____________________________________________________________________________
// sumOfPairsScore

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(586)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TScore> inline typename Value<TScore>::Type sumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString const& alignSeq, TScore const& score_type);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(634)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TScore> inline typename Value<TScore>::Type sumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString const& alignSeq, TScore const& score_type, Chaining);       	// "projects/library/seqan/graph/graph_align_chaining.h"(675)

//____________________________________________________________________________
// tCoffeeProteinAlignment

template <typename TString, typename TAlignmentGraph> inline void tCoffeeProteinAlignment(StringSet<TString, Dependent<> > const& strSet, TAlignmentGraph& gOut);       	// "projects/library/seqan/graph/graph_align_tcoffee_msa.h"(37)

//____________________________________________________________________________
// target

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& target(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(508)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type target(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "projects/library/seqan/graph/graph_edgestump.h"(518)

//____________________________________________________________________________
// targetVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type targetVertex(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_align.h"(508)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type targetVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(467)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type targetVertex(Graph<Directed<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_directed.h"(759)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type targetVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(588)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type targetVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_tree.h"(593)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(537)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Directed<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1169)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Tree<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1179)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Undirected<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1189)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1203)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(1218)

//____________________________________________________________________________
// topological_sort

template <typename TSpec, typename TVertexDescriptor> void topological_sort(Graph<TSpec> const& g, String<TVertexDescriptor>& topSort);       	// "projects/library/seqan/graph/graph_algorithm.h"(257)

//____________________________________________________________________________
// transitive_closure

template <typename TSpec, typename TMatrix> void transitive_closure(Graph<TSpec> const& g, TMatrix& closure);       	// "projects/library/seqan/graph/graph_algorithm.h"(1107)

//____________________________________________________________________________
// transpose

template <typename TStringSet, typename TCargo, typename TSpec> inline void transpose(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_align.h"(214)
template <typename TStringSet, typename TCargo, typename TSpec> inline void transpose(Graph<Alignment<TStringSet, TCargo, TSpec> >&);       	// "projects/library/seqan/graph/graph_impl_align.h"(225)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_directed.h"(211)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_directed.h"(221)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(200)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const&);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(212)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_tree.h"(232)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_tree.h"(243)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(219)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(229)

//____________________________________________________________________________
// tripletLibraryExtension

template <typename TStringSet, typename TCargo, typename TSpec> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(498)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(524)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSet> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSet const& set1, TSet const& set2);       	// "projects/library/seqan/graph/graph_align_tcoffee_base.h"(552)

//____________________________________________________________________________
// upgmaTree

template <typename TStringValue, typename TStringSpec, typename TCargo, typename TSpec, typename TTag> inline void upgmaTree(String<TStringValue, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g, TTag);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(411)
template <typename TValue, typename TSpec1, typename TCargo, typename TSpec2, typename TTag> inline void upgmaTree(Graph<Undirected<TValue, TSpec1> >& pairGraph, Graph<Tree<TCargo, TSpec2> >& g, TTag);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(517)
template <typename TDistance, typename TCargo, typename TSpec> inline void upgmaTree(TDistance& dist, Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph/graph_align_tcoffee_guidetree.h"(610)

//____________________________________________________________________________
// value

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_edge.h"(195)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_bfs.h"(172)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_dfs.h"(174)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_vertex.h"(242)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_adjacency.h"(176)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(540)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(550)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(561)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(571)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/graph/graph_iterator_outedge.h"(581)

//____________________________________________________________________________
// weight

template <typename TGraph > inline double weight( PseudoFragment<TGraph,Default> & me );       	// "projects/library/seqan/graph/graph_align_chaining.h"(188)
template <typename TGraph > inline double weight( const PseudoFragment<TGraph,Default> & me );       	// "projects/library/seqan/graph/graph_align_chaining.h"(195)

//____________________________________________________________________________
// write

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TCoffeeLib);       	// "projects/library/seqan/graph/graph_align_tcoffee_library.h"(1085)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_impl_align.h"(554)
template <typename TFile, typename TSpec, typename TNames> inline void write(TFile & file, Graph<TSpec> const& g, TNames const& names, FastaFormat);       	// "projects/library/seqan/graph/graph_impl_align.h"(686)
template <typename TFile, typename TSpec, typename TNames> inline void write(TFile & file, Graph<TSpec> const& g, TNames const& names, MsfFormat);       	// "projects/library/seqan/graph/graph_impl_align.h"(724)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> inline void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames const& names, CgVizFormat);       	// "projects/library/seqan/graph/graph_impl_align.h"(812)
template <typename TFile, typename TValue, typename TSpec, typename TGappedConsensus, typename TConsensus, typename TPolymorphismMap, typename TSize> inline void write(TFile & file, String<TValue, TSpec> const& mat, TGappedConsensus const& gappedConsensus, TConsensus& ungappedConsensus, TPolymorphismMap& polyMap, TSize maxCoverage, FastaReadFormat);       	// "projects/library/seqan/graph/graph_impl_align.h"(935)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_impl_wordgraph.h"(174)
template <typename TFile, typename TAlphabet, typename TProb, typename TSpec, typename TIDString> inline void write(TFile &, HiddenMarkovModel<TAlphabet, TProb, TSpec> const& hmm, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_algorithm_hmm.h"(238)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Directed<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_impl_directed.h"(904)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Undirected<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_impl_undirected.h"(680)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Tree<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_impl_tree.h"(689)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/graph/graph_impl_automaton.h"(652)
template <typename TFile, typename TSpec, typename TNodeAttributes, typename TEdgeAttributes> void write(TFile & file, Graph<TSpec> const& g, TNodeAttributes const& nodeMap, TEdgeAttributes const& edgeMap, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(563)
template <typename TFile, typename TSpec> inline void write(TFile & file, Graph<TSpec> const& g, DotDrawing);       	// "projects/library/seqan/graph/graph_drawing.h"(621)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

