 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_CHAINING_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_CHAINING_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Complete

struct Complete;       	// "projects/library/seqan/chaining/skip_list_type.h"(135)

//____________________________________________________________________________
// Deferred

struct Deferred;       	// "projects/library/seqan/chaining/skip_list_type.h"(137)

//____________________________________________________________________________
// Key

template <typename T > struct Key;       	// "projects/library/seqan/chaining/skip_list_type.h"(41)

//____________________________________________________________________________
// Pair

template <typename _T1, typename _T2, typename Compressed > struct Pair;       	// "projects/library/seqan/chaining/skip_list_type.h"(47)

//____________________________________________________________________________
// SkipBaseElement

template <typename TObject, typename TModus , typename TSpec , typename TStructuring > struct SkipBaseElement;       	// "projects/library/seqan/chaining/skip_list_type.h"(148)

//____________________________________________________________________________
// SkipElement

template <typename TObject, typename TModus , typename TSpec , typename TStructuring > struct SkipElement;       	// "projects/library/seqan/chaining/skip_list_type.h"(145)

//____________________________________________________________________________
// SkipList

template <typename TObject, typename TModus , typename TSpec , typename TStructuring > struct SkipList;       	// "projects/library/seqan/chaining/skip_list_type.h"(151)

//____________________________________________________________________________
// SkipListDynamic

struct SkipListDynamic;       	// "projects/library/seqan/chaining/skip_list_type.h"(131)

//____________________________________________________________________________
// SkipListStatic

struct SkipListStatic;       	// "projects/library/seqan/chaining/skip_list_type.h"(133)

//____________________________________________________________________________
// _Chain_Generic_Entry

template <typename TPos, typename TWeight> struct _Chain_Generic_Entry;       	// "projects/library/seqan/chaining/chain_generic.h"(31)

//____________________________________________________________________________
// _Chain_Generic_SortFragsPredFunctional

template <typename TSource> struct _Chain_Generic_SortFragsPredFunctional;       	// "projects/library/seqan/chaining/chain_generic.h"(41)

//____________________________________________________________________________
// _Empty

struct _Empty;       	// "projects/library/seqan/chaining/skip_list_type.h"(118)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// ChainSoP

struct ChainSoP;       	// "projects/library/seqan/chaining/score_chain.h"(33)

//____________________________________________________________________________
// ClassPool

template <typename TClass, typename TType, typename TParentAllocator > struct ClassPool;       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(62)

//____________________________________________________________________________
// Complete

struct Complete;       	// "projects/library/seqan/chaining/rt_base.h"(47)

//____________________________________________________________________________
// Deferred

struct Deferred;       	// "projects/library/seqan/chaining/rt_base.h"(50)

//____________________________________________________________________________
// Fragment

template <typename TBorder, typename TSpec > struct Fragment;       	// "projects/library/seqan/chaining/fragment.h"(178)
template <typename TBorder, typename TSpec > struct Fragment;       	// "projects/library/seqan/chaining/chain_base.h"(44)

//____________________________________________________________________________
// G_0_Cost

struct G_0_Cost;       	// "projects/library/seqan/chaining/chain_base.h"(72)

//____________________________________________________________________________
// G_1_Cost

struct G_1_Cost;       	// "projects/library/seqan/chaining/chain_base.h"(76)

//____________________________________________________________________________
// G_Inf_Cost

struct G_Inf_Cost;       	// "projects/library/seqan/chaining/chain_base.h"(80)

//____________________________________________________________________________
// G_SoP_Cost

struct G_SoP_Cost;       	// "projects/library/seqan/chaining/chain_base.h"(84)

//____________________________________________________________________________
// Limited

struct Limited;       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(42)

//____________________________________________________________________________
// Manhattan

struct Manhattan;       	// "projects/library/seqan/chaining/score_chain.h"(29)

//____________________________________________________________________________
// MaxTree

template <typename TSpec > struct MaxTree;       	// "projects/library/seqan/chaining/rmt_base.h"(60)

//____________________________________________________________________________
// RT

template <typename TSpec > struct RT;       	// "projects/library/seqan/chaining/rt_base.h"(40)

//____________________________________________________________________________
// RangeTree

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > class RangeTree;       	// "projects/library/seqan/chaining/rmt_base.h"(63)
template <typename TObject, typename TModus, typename TSpec , typename TStructuring > class RangeTree;       	// "projects/library/seqan/chaining/rt_base.h"(57)

//____________________________________________________________________________
// SemiDeferred

struct SemiDeferred;       	// "projects/library/seqan/chaining/rt_base.h"(44)

//____________________________________________________________________________
// SkipBaseElement

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipBaseElement;       	// "projects/library/seqan/chaining/skip_base_element.h"(801)

//____________________________________________________________________________
// SkipElement

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipElement;       	// "projects/library/seqan/chaining/skip_element.h"(54)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipElement;       	// "projects/library/seqan/chaining/skip_element.h"(352)

//____________________________________________________________________________
// SkipList

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipList;       	// "projects/library/seqan/chaining/rt_base.h"(54)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct SkipList;       	// "projects/library/seqan/chaining/skip_list_impl.h"(411)

//____________________________________________________________________________
// Unlimited

struct Unlimited;       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(39)

//____________________________________________________________________________
// Weight

template <typename T > struct Weight;       	// "projects/library/seqan/chaining/rmt_base.h"(89)

//____________________________________________________________________________
// Zero

struct Zero;       	// "projects/library/seqan/chaining/score_chain.h"(31)

//____________________________________________________________________________
// _ChainPoint

template <typename TFragType, typename TSpec > struct _ChainPoint;       	// "projects/library/seqan/chaining/chain_point.h"(178)
template <typename T, typename TSpec > struct _ChainPoint;       	// "projects/library/seqan/chaining/chain_base.h"(48)

//____________________________________________________________________________
// _ChainSorter

template <typename T > struct _ChainSorter;       	// "projects/library/seqan/chaining/tree_chain_utils.h"(289)

//____________________________________________________________________________
// _ChainSpecType

template <typename Spec > struct _ChainSpecType;       	// "projects/library/seqan/chaining/chain_base.h"(89)

//____________________________________________________________________________
// _DeferredStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct _DeferredStruct;       	// "projects/library/seqan/chaining/skip_base_element.h"(98)

//____________________________________________________________________________
// _DynamicStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct _DynamicStruct;       	// "projects/library/seqan/chaining/skip_base_element.h"(70)

//____________________________________________________________________________
// _GenericChaining

struct _GenericChaining;       	// "projects/library/seqan/chaining/chain_base.h"(64)

//____________________________________________________________________________
// _MetaFragment

template <typename TFragType > struct _MetaFragment;       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(147)
template <typename T > struct _MetaFragment;       	// "projects/library/seqan/chaining/chain_base.h"(56)

//____________________________________________________________________________
// _RTreeAllocators

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct _RTreeAllocators;       	// "projects/library/seqan/chaining/rt_base.h"(81)

//____________________________________________________________________________
// _RangeCargo

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct _RangeCargo;       	// "projects/library/seqan/chaining/rt_skip_element.h"(35)

//____________________________________________________________________________
// _RangeMaxCargo

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct _RangeMaxCargo;       	// "projects/library/seqan/chaining/rmt_skip_element.h"(31)

//____________________________________________________________________________
// _RangetreeChaining

struct _RangetreeChaining;       	// "projects/library/seqan/chaining/chain_base.h"(67)

//____________________________________________________________________________
// _SearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > struct _SearchPath;       	// "projects/library/seqan/chaining/skip_list_base.h"(78)

//____________________________________________________________________________
// _WrapperPoint

template <typename TFragType > struct _WrapperPoint;       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(141)
template <typename T > struct _WrapperPoint;       	// "projects/library/seqan/chaining/chain_base.h"(52)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// GenericChaining

typedef Tag<_GenericChaining> const GenericChaining;       	// "projects/library/seqan/chaining/chain_base.h"(65)

//____________________________________________________________________________
// RangetreeChaining

typedef Tag<_RangetreeChaining> const RangetreeChaining;       	// "projects/library/seqan/chaining/chain_base.h"(68)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _chain_generic_Backtrace

template <typename TSource, typename TFrags, typename TIterator, typename TDest, typename TFragment> inline void _chain_generic_Backtrace(TSource & source, TFrags & frags, TIterator & it_best, TDest & dest, TFragment & bottom);       	// "projects/library/seqan/chaining/chain_generic.h"(163)

//____________________________________________________________________________
// _chain_generic_chainable

template <typename TFrag> inline bool _chain_generic_chainable(TFrag & f1, TFrag & f2);       	// "projects/library/seqan/chaining/chain_generic.h"(107)

//____________________________________________________________________________
// _chain_generic_findBest

template <typename TSource, typename TFrags, typename TIterator, typename TScoring> inline void _chain_generic_findBest(TSource & source, TFrags & frags, TIterator & it_act, TScoring scoring);       	// "projects/library/seqan/chaining/chain_generic.h"(131)

//____________________________________________________________________________
// _chain_generic_initFrags

template <typename TSource, typename TFrags, typename TScoring> inline void _chain_generic_initFrags(TSource & source, TFrags & frags, TScoring scoring);       	// "projects/library/seqan/chaining/chain_generic.h"(77)

//____________________________________________________________________________
// _initCargo

template <typename TTag, typename TCargo > inline void _initCargo( TTag * , TCargo & );       	// "projects/library/seqan/chaining/skip_list_type.h"(371)

//____________________________________________________________________________
// chain

template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type chain(TSource & source, TDest & dest, TScoring const & scoring, GenericChaining);       	// "projects/library/seqan/chaining/chain_generic.h"(195)

//____________________________________________________________________________
// getValue

template <typename TKey, typename TVal > TVal getValue( Pair<TKey, TVal> & p );       	// "projects/library/seqan/chaining/skip_list_type.h"(60)

//____________________________________________________________________________
// key

template <typename TKey, typename TVal > inline TKey key( Pair<TKey, TVal> & p );       	// "projects/library/seqan/chaining/skip_list_type.h"(54)
template <typename TKey, typename TVal > inline TKey key( std::pair< TKey, TVal > & p );       	// "projects/library/seqan/chaining/skip_list_type.h"(85)

//____________________________________________________________________________
// setKey

template <typename TKey2, typename TVal > void setKey( Pair<TKey2, TVal> & p, TKey2 theKey);       	// "projects/library/seqan/chaining/skip_list_type.h"(66)
template <typename TKey, typename TVal > void setKey( std::pair<TKey, TVal> & p, TKey theKey );       	// "projects/library/seqan/chaining/skip_list_type.h"(91)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _activate

template <typename TObject, typename TSpec, typename TStructuring, typename TSize > void _activate( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TObject * obj, TSize dim );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(150)

//____________________________________________________________________________
// _activateHigherLayer

template <typename TObject, typename TSpec, typename TStructuring, typename TSize > void _activateHigherLayer( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TObject * obj, TSize dim );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(120)

//____________________________________________________________________________
// _activatePriority

template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _activatePriority( _MetaFragment< FragType > &, _ChainPoint< FragType, SpecType > &, G_0_Cost, TScore const &, TSize );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(215)
template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _activatePriority( _MetaFragment< FragType > & last_meta, _ChainPoint< FragType, SpecType > & point, G_1_Cost, TScore const & score_, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(227)

//____________________________________________________________________________
// _activateScoreBuild

template <typename TObject, typename TSpec, typename TStructuring > inline void _activateScoreBuild( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * base, SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > ** search_path );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(63)

//____________________________________________________________________________
// _add

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename THeight > inline void _add( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, THeight height, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path );       	// "projects/library/seqan/chaining/skip_list_base.h"(826)

//____________________________________________________________________________
// _add_max

template <typename TObject, typename TSpec, typename TStructuring, typename THeight > inline void _add_max( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * base, THeight height, SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > ** );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(299)

//____________________________________________________________________________
// _begin_default

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > , Standard >::Type _begin_default( SkipList< TObject, TModus, TSpec, TStructuring > & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(132)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > , Standard >::Type _begin_default( SkipList< TObject, TModus, TSpec, TStructuring > const & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(141)

//____________________________________________________________________________
// _bottomSearch

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet > void _bottomSearch( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(130)
template <typename TObject, typename TModus, typename TSpec, typename TResultSet > void _bottomSearch( SkipList< TObject, TModus, RT< TSpec >, Deferred > * list, TObject * left_border, TObject * right_border, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_def_algos.h"(98)

//____________________________________________________________________________
// _buildAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _buildAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TSize dim );       	// "projects/library/seqan/chaining/rt_skip_element.h"(95)

//____________________________________________________________________________
// _buildAssocStruct_left

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _buildAssocStruct_left( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * left, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * right, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(332)

//____________________________________________________________________________
// _buildAssocStruct_right

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _buildAssocStruct_right( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * left, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * right, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(347)

//____________________________________________________________________________
// _buildMaxTowers

template <typename TObject, typename TSpec, typename TStructuring > void _buildMaxTowers( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(246)

//____________________________________________________________________________
// _buildTowers

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > void _buildTowers( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(474)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > void _buildTowers( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(55)

//____________________________________________________________________________
// _build_chain_environment

template <typename FragType, typename TSource, typename TMetas, typename TWPoints, typename TCPoints, typename TSpec > inline void _build_chain_environment( TSource & source, TMetas & metas, TWPoints & wPoints, TCPoints & cPoints, FragType & startingFrag, FragType & endFrag, TSpec );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(379)
template <typename FragType, typename TSource, typename TMetas, typename TWPoints, typename TPoints, typename TPerm, typename TSpec > inline void _build_chain_environment( TSource & source, TMetas & metas, TWPoints & wPoints, TPoints & tPoints, FragType & startingFrag, FragType & endFrag, TPerm & perm, typename Size< FragType >::Type fac, TSpec &);       	// "projects/library/seqan/chaining/tree_chain_utils.h"(446)

//____________________________________________________________________________
// _build_chain_trees

template <typename TTrees, typename TTPoints, typename TSize > void _build_chain_trees( TTrees & trees, TTPoints & tPoints, TSize dim, TSize facValue );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(526)

//____________________________________________________________________________
// _calcPivot

template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _calcPivot( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & base );       	// "projects/library/seqan/chaining/skip_list_base.h"(243)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * _calcPivot( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > & base );       	// "projects/library/seqan/chaining/skip_list_base.h"(261)

//____________________________________________________________________________
// _chainTransformCoords

template <typename FragType, typename SpecType, typename TPerm > inline void _chainTransformCoords( _ChainPoint< FragType, SpecType > & point_src, _ChainPoint< FragType, SpecType > & point_dst, TPerm & perm );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(123)

//____________________________________________________________________________
// _chainTransformCoordsSearch

template <typename FragType, typename SpecType, typename TPerm > inline void _chainTransformCoordsSearch( _ChainPoint< FragType, SpecType > & point_src, _ChainPoint< FragType, SpecType > & point_dst, TPerm & perm );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(141)

//____________________________________________________________________________
// _chain_trace

template <typename TDest, typename TMetas > typename Weight< typename Value< TDest >::Type >::Type _chain_trace( TDest & dest, TMetas & metas );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(325)

//____________________________________________________________________________
// _checkAssocThresh

template <typename TObject, typename TSpec, typename TStructuring > inline bool _checkAssocThresh( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * first, SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * second );       	// "projects/library/seqan/chaining/rmt_base.h"(191)
template <typename TObject, typename TSpec, typename TStructuring > inline bool _checkAssocThresh( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * first, SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * second );       	// "projects/library/seqan/chaining/rt_base.h"(126)

//____________________________________________________________________________
// _checkBaseElementsLeft

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize, typename TKey, typename TResultSet > inline SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * _checkBaseElementsLeft( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base, TObject * left_border, TObject * right_border, TSize dim, TKey left_theKey, TKey right_theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(120)

//____________________________________________________________________________
// _checkBaseElementsLeftBottom

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey, typename TResultSet > inline SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * _checkBaseElementsLeftBottom( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base, TObject * left_border, TObject * right_border, TKey left_theKey, TKey right_theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(153)

//____________________________________________________________________________
// _checkBaseElementsRight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize, typename TKey, typename TResultSet > inline void _checkBaseElementsRight( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base, TObject * left_border, TObject * right_border, TSize dim, TKey right_theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(185)

//____________________________________________________________________________
// _clearSearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _clearSearchPath( _SearchPath< TObject, TModus, TSpec, TStructuring > & sp, TSize size );       	// "projects/library/seqan/chaining/skip_list_base.h"(115)

//____________________________________________________________________________
// _collectAssocStructs

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize, typename TKey, typename TResultSet > inline SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * _collectAssocStructs( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * tower_buffer, TObject * left_border, TObject * right_border, TSize dim, TKey search_theKey, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(92)

//____________________________________________________________________________
// _completeBuild

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _completeBuild( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(507)
template <typename TObject, typename TModus, typename TSpec > inline void _completeBuild( SkipList< TObject, TModus, TSpec, Deferred > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(517)
template <typename TObject, typename TSpec > inline void _completeBuild( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, Deferred > & list, typename Size< TObject >::Type dim );       	// "projects/library/seqan/chaining/rmt_def_algos.h"(39)
template <typename TObject, typename TSpec, typename TStructuring > inline void _completeBuild( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list, typename Size< TObject >::Type dim );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(49)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _completeBuild( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, TSize dim );       	// "projects/library/seqan/chaining/rt_common_algos.h"(39)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _completeBuild( SkipList< TObject, TModus, RT< TSpec >, Deferred > & list, TSize dim );       	// "projects/library/seqan/chaining/rt_common_algos.h"(49)

//____________________________________________________________________________
// _compute_chain

template <typename TSource, typename TDest, typename TScoreValue, typename TScoreType, typename TStructuring, typename TCostModell, typename TSpec > TScoreValue _compute_chain( TSource & source, TDest & dest, TCostModell cost, Score< TScoreValue, TScoreType > const & score_, TStructuring, TSpec spec );       	// "projects/library/seqan/chaining/tree_chain.h"(38)
template <typename TSource, typename TDest, typename TScoreValue, typename TScoreType, typename TStructuring, typename TSpec > TScoreValue _compute_chain( TSource & source, TDest & dest, G_SoP_Cost, Score< TScoreValue, TScoreType > const & score_, TStructuring, TSpec spec );       	// "projects/library/seqan/chaining/tree_chain_sop.h"(38)

//____________________________________________________________________________
// _connect

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TSize > inline void _connect( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, TSize height, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(804)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connect( SkipList< TObject, TModus, RT< TSpec >, Deferred > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, Deferred > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, Deferred > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(256)

//____________________________________________________________________________
// _connect_actualize

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TSize > inline void _connect_actualize( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, TSize height, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(781)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connect_actualize( SkipList< TObject, TModus, RT< TSpec >, Deferred > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, Deferred > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, Deferred > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(232)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connect_actualize( SkipList< TObject, TModus, RT< TSpec >, SemiDeferred > & , SkipBaseElement< TObject, TModus, RT< TSpec >, SemiDeferred > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, SemiDeferred > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(278)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connect_actualize( SkipList< TObject, TModus, RT< TSpec >, Complete > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, Complete > * base, TSize height, SkipElement< TObject, TModus, RT< TSpec >, Complete > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(303)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _connect_actualize( SkipList< TObject, TModus, RT< MaxTree< TSpec > >, Complete > & list, SkipBaseElement< TObject, TModus, RT< MaxTree< TSpec > >, Complete > * base, TSize height, SkipElement< TObject, TModus, RT< MaxTree< TSpec > >, Complete > ** search_path, TSize dim );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(91)

//____________________________________________________________________________
// _connect_actualize_max

template <typename TObject, typename TSpec, typename TStructuring, typename TSize, typename TKey > void _connect_actualize_max( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * base, TSize height, TKey searchKey, SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > ** search_path, TObject * max_obj );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(217)

//____________________________________________________________________________
// _costG1

template <typename FragType, typename TScore, typename TSize > typename Weight< FragType >::Type _costG1( _MetaFragment< FragType > & upper, _MetaFragment< FragType > & lower, TScore const & score, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(239)

//____________________________________________________________________________
// _costGSoP

template <typename FragType, typename TItPerm, typename TScoreValue, typename TScoreType, typename TSize > typename Weight< FragType >::Type _costGSoP( _MetaFragment< FragType > & upper, _MetaFragment< FragType > & lower, Score< TScoreValue, TScoreType > const & score, TItPerm permBeg, TItPerm, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(259)

//____________________________________________________________________________
// _create

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TContainer, typename TSize > void _create( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me, TContainer & data, RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & Tree, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(110)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > void _create( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * first, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * last, RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & Tree, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(135)

//____________________________________________________________________________
// _createAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _createAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TSize dim );       	// "projects/library/seqan/chaining/rt_skip_element.h"(171)

//____________________________________________________________________________
// _deleteAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _deleteAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(124)

//____________________________________________________________________________
// _deleteBase

template <typename TObject, typename TSpec, typename TStructuring > void _deleteBase( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& base );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(340)

//____________________________________________________________________________
// _deleteSearchFrom

template <typename TObject, typename TSpec, typename TStructuring, typename TParam > SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _deleteSearchFrom( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, typename Key< SkipList< TObject, SkipListDynamic, TSpec, TStructuring > >::Type theKey, SkipElement< TObject, SkipListDynamic, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(255)

//____________________________________________________________________________
// _deleteTower

template <typename TObject, typename TSpec, typename TStructuring > void _deleteTower( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, SkipElement< TObject, SkipListDynamic, TSpec, TStructuring > ** search_path, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * base, typename Size< SkipList< TObject, SkipListDynamic, TSpec, TStructuring > >::Type height );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(316)

//____________________________________________________________________________
// _delete_chain_trees

template <typename TTrees, typename TSize > void _delete_chain_trees( TTrees & trees, TSize facValue );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(543)

//____________________________________________________________________________
// _end_default

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring >, Standard>::Type _end_default( SkipList< TObject, TModus, TSpec, TStructuring > & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(171)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > const, Standard>::Type _end_default( SkipList< TObject, TModus, TSpec, TStructuring > const & me, Standard);       	// "projects/library/seqan/chaining/skip_list_impl.h"(179)

//____________________________________________________________________________
// _findTowerTop

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet, typename TSize, typename TKey > inline SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * _findTowerTop( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * base_buffer, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TSize dim, TKey theKey, TResultSet & results );       	// "projects/library/seqan/chaining/rt_common_algos.h"(69)

//____________________________________________________________________________
// _fingerSearch

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet, typename TSize > void _fingerSearch( SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TSize dim, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(102)
template <typename TObject, typename TModus, typename TSpec, typename TResultSet, typename TSize > void _fingerSearch( SkipList< TObject, TModus, RT< TSpec >, Deferred > * list, TObject * left_border, TObject * right_border, TSize dim, TResultSet & results );       	// "projects/library/seqan/chaining/rt_sl_def_algos.h"(54)

//____________________________________________________________________________
// _geomRand

template <typename T > inline T _geomRand( );       	// "projects/library/seqan/chaining/geom_distribution.h"(44)

//____________________________________________________________________________
// _getAssoc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, TSpec, TStructuring > * _getAssoc( _RangeMaxCargo< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(46)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, TSpec, TStructuring > * _getAssoc( _RangeCargo< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(48)

//____________________________________________________________________________
// _getAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, RT< TSpec >, TStructuring > * _getAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(75)

//____________________________________________________________________________
// _getBaseAlloc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< SimpleAlloc<> > & _getBaseAlloc( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(201)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipBaseElement< TObject, TModus, TSpec, TStructuring >, Unlimited, SimpleAllocator> > & _getBaseAlloc( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(324)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< SimpleAlloc<> > & _getBaseAlloc( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(88)

//____________________________________________________________________________
// _getBaseStore

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getBaseStore( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(366)

//____________________________________________________________________________
// _getCount

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getCount( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(754)

//____________________________________________________________________________
// _getCurrentLayer

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getCurrentLayer( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(385)

//____________________________________________________________________________
// _getDown

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getDown( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(117)

//____________________________________________________________________________
// _getElementAlloc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipElement< TObject, TModus, RT< TSpec >, TStructuring >, Limited, SimpleAllocator > > & _getElementAlloc( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(185)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipElement< TObject, TModus, TSpec, TStructuring >, Limited, SimpleAllocator > > & _getElementAlloc( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(314)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipElement< TObject, TModus, RT< TSpec >, TStructuring >, Limited, SimpleAllocator > > & _getElementAlloc( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(71)

//____________________________________________________________________________
// _getFrag

template <typename TFragType, typename TSpec > inline TFragType & _getFrag( _ChainPoint< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(101)
template <typename TFragType, typename TSpec > inline TFragType & _getFrag( const _ChainPoint< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(109)
template <typename TFragType > inline TFragType & _getFrag( _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(92)
template <typename TFragType > inline TFragType & _getFrag( const _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(99)
template <typename TFragType > inline TFragType & _getFrag( _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(67)
template <typename TFragType > inline TFragType & _getFrag( const _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(77)

//____________________________________________________________________________
// _getHeight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getHeight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(678)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline typename Size< SkipElement< TObject, TModus, TSpec, TStructuring > >::Type _getHeight( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(225)

//____________________________________________________________________________
// _getInitialState

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _getInitialState( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(146)

//____________________________________________________________________________
// _getLBorderObj

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline TObject * _getLBorderObj( RangeTree< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(211)

//____________________________________________________________________________
// _getLeft

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getLeft( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(514)
template <typename TObject, typename TModus, typename TSpec > inline SkipBaseElement< TObject, TModus, TSpec, Deferred > * _getLeft( SkipBaseElement< TObject, TModus, TSpec, Deferred > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(522)

//____________________________________________________________________________
// _getLeftSideStore

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getLeftSideStore( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(356)

//____________________________________________________________________________
// _getList

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipList< TObject, TModus, RT< TSpec >, TStructuring > * _getList( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(229)

//____________________________________________________________________________
// _getListAlloc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipList< TObject, TModus, RT< TSpec >, TStructuring >, Unlimited, SimpleAllocator > > & _getListAlloc( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(193)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline Allocator< ClassPool< SkipList< TObject, TModus, RT< TSpec >, TStructuring >, Unlimited, SimpleAllocator > > & _getListAlloc( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(80)

//____________________________________________________________________________
// _getMaxObject

template <typename TObject, typename TSpec, typename TStructuring > inline TObject * _getMaxObject( _RangeMaxCargo< TObject, SkipListStatic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(64)
template <typename TObject,typename TSpec, typename TStructuring > inline TObject * _getMaxObject( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(79)

//____________________________________________________________________________
// _getMaximalSLTowerHeight

template <typename TNumber > inline TNumber _getMaximalSLTowerHeight( TNumber elements );       	// "projects/library/seqan/chaining/skip_list_base.h"(178)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _getMaximalSLTowerHeight( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_base.h"(187)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, RT< TSpec >, TStructuring > >::Type _getMaximalSLTowerHeight( RangeTree< TObject, TModus, RT< TSpec >, TStructuring > & rt );       	// "projects/library/seqan/chaining/rt_base.h"(317)

//____________________________________________________________________________
// _getNext

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getNext( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(648)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getNext( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(181)

//____________________________________________________________________________
// _getNextBlock

template <typename TClass, typename TSpec, typename TParentAlloc > inline TClass * _getNextBlock( Allocator< ClassPool< TClass, TSpec, TParentAlloc > > & me, TClass & block );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(89)

//____________________________________________________________________________
// _getPerm

template <typename TData, typename TItPerm, typename TSize > inline void _getPerm( TData * values, TItPerm perm, TSize length );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(78)

//____________________________________________________________________________
// _getPermDifference

template <typename TData, typename TSize, typename FragType > void _getPermDifference( TData * values, TSize dim, FragType & upper, FragType & lower );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(106)

//____________________________________________________________________________
// _getPred

template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * _getPred( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(444)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _getPred( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(452)
template <typename TFragType > inline _MetaFragment< TFragType > & _getPred( _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(107)
template <typename TFragType > inline _MetaFragment< TFragType > & _getPred( const _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(114)

//____________________________________________________________________________
// _getRBorderObj

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline TObject * _getRBorderObj( RangeTree< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_base.h"(220)

//____________________________________________________________________________
// _getRight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getRight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(570)
template <typename TObject, typename TSpec > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * _getRight( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(579)
template <typename TObject, typename TSpec > inline SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > * _getRight( SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(587)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getRight(SkipElement< TObject, TModus, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_element.h"(91)

//____________________________________________________________________________
// _getRightBorder

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getRightBorder( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(346)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipElement< TObject, SkipListStatic, RT< TSpec >, TStructuring > * _getRightBorder( SkipList< TObject, SkipListStatic, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_sl_base.h"(50)

//____________________________________________________________________________
// _getRoot

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > * _getRoot( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(305)

//____________________________________________________________________________
// _getSearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > ** _getSearchPath( _SearchPath< TObject, TModus, TSpec, TStructuring > & sp );       	// "projects/library/seqan/chaining/skip_list_base.h"(106)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > ** _getSearchPath( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(375)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline SkipElement< TObject, TModus, RT< TSpec >, TStructuring > ** _getSearchPath( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & me, TParam dim );       	// "projects/library/seqan/chaining/rt_sl_def_algos.h"(33)

//____________________________________________________________________________
// _getSucc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _getSucc( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(367)
template <typename TObject, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * _getSucc( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(375)

//____________________________________________________________________________
// _getUp

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipElement< TObject, TModus, TSpec, TStructuring > & _getUp( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(346)

//____________________________________________________________________________
// _hasAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _hasAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(143)

//____________________________________________________________________________
// _hasBigAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _hasBigAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(159)

//____________________________________________________________________________
// _hasSmallAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline bool _hasSmallAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(151)

//____________________________________________________________________________
// _incKey

template <typename TFragType, typename TSpec, typename TSize > inline void _incKey( _ChainPoint< TFragType, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/chain_point.h"(92)

//____________________________________________________________________________
// _initBases

template <typename TObject, typename TSpec, typename TStructuring, typename TIter, typename TSize > inline void _initBases( SkipList< TObject, SkipListStatic, TSpec, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > * firstBase, SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > *& lastBase, TIter & firstData, TIter & lastData, TSize numEntries );       	// "projects/library/seqan/chaining/skip_list_base.h"(906)
template <typename TObject, typename TSpec, typename TStructuring, typename TIter, typename TSize > inline void _initBases( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * firstBase, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& lastBase, TIter & firstData, TIter & lastData, TSize numEntries );       	// "projects/library/seqan/chaining/skip_list_base.h"(936)
template <typename TObject, typename TSpec, typename TStructuring, typename TIter, typename TSize > inline void _initBases( SkipList< TObject, SkipListStatic, RT< TSpec >, TStructuring > & list, SkipBaseElement< TObject, SkipListStatic, RT< TSpec >, TStructuring > * firstBase, SkipBaseElement< TObject, SkipListStatic, RT< TSpec >, TStructuring > *& lastBase, TIter & firstData, TIter & lastData, TSize numEntries, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_base.h"(160)

//____________________________________________________________________________
// _initPerm

template <typename TPerm, typename TSize > inline void _initPerm( TPerm & perm, TSize length );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(50)

//____________________________________________________________________________
// _initSL

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _initSL( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * first_base, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * last_base, TSize numEntries );       	// "projects/library/seqan/chaining/skip_list_base.h"(969)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _initSL( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * first_base, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * , TSize numEntries, TSize );       	// "projects/library/seqan/chaining/rt_sl_base.h"(188)

//____________________________________________________________________________
// _init_starting_frag

template <typename FragType, typename TSize > inline void _init_starting_frag( FragType & frag, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(354)

//____________________________________________________________________________
// _insertBack

template <typename TObject, typename TSpec, typename TStructuring, typename TParam > void _insertBack( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(156)

//____________________________________________________________________________
// _insertInPlace

template <typename TObject, typename TSpec, typename TStructuring, typename TParam > void _insertInPlace( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(180)

//____________________________________________________________________________
// _isBegin

template <typename TFragType > inline bool _isBegin( _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(120)
template <typename TFragType > inline bool _isBegin( const _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(127)

//____________________________________________________________________________
// _isEnd

template <typename TFragType > inline bool _isEnd( _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(106)
template <typename TFragType > inline bool _isEnd( const _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(113)

//____________________________________________________________________________
// _maxPriority

template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _maxPriority( _MetaFragment< FragType > & , _MetaFragment< FragType > & current_meta, _ChainPoint< FragType, SpecType > & point, G_0_Cost, TScore const &, TSize );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(176)
template <typename FragType, typename SpecType, typename TScore, typename TSize > inline typename Weight< FragType >::Type _maxPriority( _MetaFragment< FragType > &, _MetaFragment< FragType > & current_meta, _ChainPoint< FragType, SpecType > & point, G_1_Cost, TScore const & score_, TSize dim );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(190)

//____________________________________________________________________________
// _meta

template <typename TFragType, typename TSpec > inline _MetaFragment< TFragType > & _meta( _ChainPoint< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(118)
template <typename TFragType, typename TSpec > inline _MetaFragment< TFragType > & _meta( const _ChainPoint< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(125)
template <typename TFragType > inline _MetaFragment< TFragType > & _meta( _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(87)

//____________________________________________________________________________
// _noInitialState

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _noInitialState( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_base.h"(154)

//____________________________________________________________________________
// _performDestructorAction

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _performDestructorAction( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(288)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _performDestructorAction( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_skip_element.h"(223)

//____________________________________________________________________________
// _performRMQ

template <typename TObject, typename TSpec, typename TBorder, typename TSize, typename TKey > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, Deferred > * list, TBorder & borderObj, TSize dim, TKey searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_def_algos.h"(65)
template <typename TObject, typename TSpec, typename TStructuring, typename TBorder, typename TSize, typename TKey > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TBorder & borderObj, TSize dim, TKey searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(123)
template <typename TObject, typename TSpec, typename TBorder, typename TSize, typename TKey > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, Complete > * list, TBorder & borderObj, TSize dim, TKey searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(168)
template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > void _performRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TBorder & , typename Key< TObject >::Type searchKey, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(210)

//____________________________________________________________________________
// _performSmallRMQ

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > inline void _performSmallRMQ( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * elem, typename Size< TObject >::Type dim, TBorder & border, TObject *& max_object );       	// "projects/library/seqan/chaining/rmt_compl_algos.h"(255)

//____________________________________________________________________________
// _processRMQ

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > inline void _processRMQ( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, typename Size< TObject >::Type dim, TBorder & borderObj, TObject *& maxObject );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(73)

//____________________________________________________________________________
// _pushBack

template <typename TTarget, typename TSource > inline void _pushBack( TTarget & target, TSource const & source );       	// "projects/library/seqan/chaining/rt_base.h"(134)

//____________________________________________________________________________
// _renewConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _renewConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(430)
template <typename TObject, typename TSpec, typename TSize > inline void _renewConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & elem, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(443)

//____________________________________________________________________________
// _renewDynConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _renewDynConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(391)
template <typename TObject, typename TModus, typename TSpec, typename TSize > inline void _renewDynConnects( SkipBaseElement< TObject, TModus, TSpec, Deferred > & elem, SkipBaseElement< TObject, TModus, TSpec, Deferred > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(400)
template <typename TObject, typename TSpec, typename TSize > inline void _renewDynConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & elem, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & pivot, TSize elem_count, TSize i_count );       	// "projects/library/seqan/chaining/skip_list_base.h"(413)

//____________________________________________________________________________
// _renewLeftTower

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > void _renewLeftTower( SkipList< TObject, TModus, TSpec, TStructuring > & list );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(58)

//____________________________________________________________________________
// _renewSearchPath

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _renewSearchPath( SkipList< TObject, TModus, TSpec, TStructuring > & list, TSize old_size, TSize new_size );       	// "projects/library/seqan/chaining/skip_list_base.h"(128)

//____________________________________________________________________________
// _resetPerm

template <typename TPerm > inline void _resetPerm( TPerm & perm );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(61)

//____________________________________________________________________________
// _scanAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultsSet, typename TSize > inline void _scanAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list, TObject * left_border, TObject * right_border, TSize dim, TResultsSet & results );       	// "projects/library/seqan/chaining/rt_skip_element.h"(192)

//____________________________________________________________________________
// _searchFrom

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TKey > SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _searchFrom( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipElement< TObject, TModus, TSpec, TStructuring > * layer_element, TKey theKey, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(535)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TKey > SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _searchFrom( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipElement< TObject, TModus, TSpec, TStructuring > * layer_element, TKey theKey, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(588)

//____________________________________________________________________________
// _setAssoc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setAssoc( _RangeMaxCargo< TObject, TModus, TSpec, TStructuring > & me, SkipList< TObject, TModus, TSpec, TStructuring > * list );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(54)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setAssoc( _RangeCargo< TObject, TModus, TSpec, TStructuring > & me, SkipList< TObject, TModus, TSpec, TStructuring > * list);       	// "projects/library/seqan/chaining/rt_skip_element.h"(57)

//____________________________________________________________________________
// _setAssocStruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setAssocStruct( SkipElement< TObject, TModus, RT< TSpec >, TStructuring > * me, SkipList< TObject, TModus, RT< TSpec >, TStructuring > * list );       	// "projects/library/seqan/chaining/rt_skip_element.h"(84)

//____________________________________________________________________________
// _setCount

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setCount( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TSize count );       	// "projects/library/seqan/chaining/skip_base_element.h"(774)

//____________________________________________________________________________
// _setCurrentLayer

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setCurrentLayer( SkipList< TObject, TModus, TSpec, TStructuring > & me, TSize layer );       	// "projects/library/seqan/chaining/skip_list_impl.h"(395)

//____________________________________________________________________________
// _setDefConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setDefConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * left, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(873)
template <typename TObject, typename TSpec > inline void _setDefConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * left, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(882)

//____________________________________________________________________________
// _setDeferredCounts

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setDeferredCounts( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * preceding_elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * new_elem );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(93)
template <typename TObject, typename TModus, typename TSpec > inline void _setDeferredCounts( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipBaseElement< TObject, TModus, TSpec, Deferred > * preceding_elem, SkipBaseElement< TObject, TModus, TSpec, Deferred > * new_elem );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(102)

//____________________________________________________________________________
// _setDown

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _setDown( SkipElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * down );       	// "projects/library/seqan/chaining/skip_element.h"(161)

//____________________________________________________________________________
// _setDynConnects

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setDynConnects( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * pred, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * succ );       	// "projects/library/seqan/chaining/skip_list_base.h"(853)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setDynConnects( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * pred, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * succ );       	// "projects/library/seqan/chaining/skip_list_base.h"(862)

//____________________________________________________________________________
// _setHeight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setHeight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TSize height );       	// "projects/library/seqan/chaining/skip_base_element.h"(698)

//____________________________________________________________________________
// _setLeft

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setLeft( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * left );       	// "projects/library/seqan/chaining/skip_base_element.h"(542)
template <typename TObject, typename TModus, typename TSpec > inline void _setLeft( SkipBaseElement< TObject, TModus, TSpec, Deferred > & me, SkipBaseElement< TObject, TModus, TSpec, Deferred > * left );       	// "projects/library/seqan/chaining/skip_base_element.h"(550)

//____________________________________________________________________________
// _setLeftPosition

template <typename TBorder, typename TSpec, typename TSize, typename TPosition > inline void _setLeftPosition( Fragment< TBorder, TSpec > & me, TSize dim, TPosition value );       	// "projects/library/seqan/chaining/fragment.h"(114)

//____________________________________________________________________________
// _setLength

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _setLength( SkipList< TObject, TModus, TSpec, TStructuring > & me, TSize num_elems );       	// "projects/library/seqan/chaining/skip_list_impl.h"(197)

//____________________________________________________________________________
// _setMaxInfty

template <typename TObject, typename TSize > inline void _setMaxInfty( TObject & me, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(164)

//____________________________________________________________________________
// _setMaxObject

template <typename TObject, typename TSpec, typename TStructuring > inline void _setMaxObject( _RangeMaxCargo< TObject, SkipListStatic, TSpec, TStructuring > & me, TObject * obj );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(72)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setMaxObject( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me, TObject * maxObj );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(87)

//____________________________________________________________________________
// _setMeta

template <typename TFragType, typename TSpec > inline void _setMeta( _ChainPoint< TFragType, TSpec > & me, _MetaFragment< TFragType > & meta );       	// "projects/library/seqan/chaining/chain_point.h"(134)
template <typename TFragType, typename TSpec > inline void _setMeta( const _ChainPoint< TFragType, TSpec > & me, _MetaFragment< TFragType > & meta );       	// "projects/library/seqan/chaining/chain_point.h"(142)
template <typename TFragType > inline void _setMeta( _WrapperPoint< TFragType > & me, _MetaFragment< TFragType > & meta );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(97)

//____________________________________________________________________________
// _setMinInfty

template <typename TObject, typename TSize > inline void _setMinInfty( TObject & me, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(149)

//____________________________________________________________________________
// _setNext

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setNext( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * next );       	// "projects/library/seqan/chaining/skip_base_element.h"(658)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _setNext( SkipElement< TObject, TModus, TSpec, TStructuring > & me, SkipElement< TObject, TModus, TSpec, TStructuring > * next );       	// "projects/library/seqan/chaining/skip_element.h"(205)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setNext( SkipList< TObject, TModus, TSpec, TStructuring > & me, SkipList< TObject, TModus, TSpec, TStructuring > * next );       	// "projects/library/seqan/chaining/skip_list_impl.h"(335)

//____________________________________________________________________________
// _setNextBlock

template <typename TClass, typename TSpec, typename TParentAlloc > inline void _setNextBlock( Allocator< ClassPool< TClass, TSpec, TParentAlloc > > & , TClass & dest, TClass * block );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(98)

//____________________________________________________________________________
// _setObject

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setObject( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TObject * obj );       	// "projects/library/seqan/chaining/skip_base_element.h"(296)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setObject( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * data );       	// "projects/library/seqan/chaining/skip_base_element.h"(306)

//____________________________________________________________________________
// _setPred

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setPred( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * goPrevious );       	// "projects/library/seqan/chaining/skip_base_element.h"(488)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setPred( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * goPrevious );       	// "projects/library/seqan/chaining/skip_base_element.h"(496)
template <typename TFragType > inline void _setPred( _MetaFragment< TFragType > & me, _MetaFragment< TFragType > & pred );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(123)
template <typename TFragType > inline void _setPred( const _MetaFragment< TFragType > & me, _MetaFragment< TFragType > & pred );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(131)

//____________________________________________________________________________
// _setRight

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setRight( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_base_element.h"(624)
template <typename TObject, typename TSpec > inline void _setRight( SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > & me, SkipBaseElement< TObject, SkipListStatic, TSpec, Deferred > * right );       	// "projects/library/seqan/chaining/skip_base_element.h"(631)
template <typename TObject, typename TSpec > inline void _setRight( SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > & me, SkipBaseElement< TObject, SkipListDynamic, TSpec, Deferred > * right );       	// "projects/library/seqan/chaining/skip_base_element.h"(639)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void _setRight( SkipElement< TObject, TModus, TSpec, TStructuring > & me, SkipElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_element.h"(141)

//____________________________________________________________________________
// _setRightPosition

template <typename TBorder, typename TSpec, typename TSize, typename TPosition > inline void _setRightPosition( Fragment< TBorder, TSpec > & me, TSize dim, TPosition value );       	// "projects/library/seqan/chaining/fragment.h"(124)

//____________________________________________________________________________
// _setSucc

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setSucc( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * succ );       	// "projects/library/seqan/chaining/skip_base_element.h"(412)
template <typename TObject, typename TSpec, typename TStructuring > inline void _setSucc( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > & me, SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > * succ );       	// "projects/library/seqan/chaining/skip_base_element.h"(420)

//____________________________________________________________________________
// _setUp

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _setUp( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, SkipElement< TObject, TModus, TSpec, TStructuring > & up );       	// "projects/library/seqan/chaining/skip_base_element.h"(327)

//____________________________________________________________________________
// _sort

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _sort( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(284)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TExtraParam > SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _sort( SkipList< TObject, TModus, TSpec, TStructuring > & , SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right_border, TExtraParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(297)

//____________________________________________________________________________
// _sortRecursive

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _sortRecursive( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * right );       	// "projects/library/seqan/chaining/skip_list_base.h"(459)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TSize > inline void _sortRecursive( SkipList< TObject, TModus, RT< TSpec >, TStructuring > & list, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * elem, SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > * right, TSize dim );       	// "projects/library/seqan/chaining/rt_sl_compl_algos.h"(41)

//____________________________________________________________________________
// _sort_equals

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _sort_equals( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem );       	// "projects/library/seqan/chaining/skip_list_base.h"(333)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void _sort_equals( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * elem, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(343)
template <typename TObject, typename TModus, typename TSpec, typename TKey > void _sort_equals( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipBaseElement< TObject, TModus, TSpec, Deferred > * elem, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(352)

//____________________________________________________________________________
// _specialSearch

template <typename TObject, typename TModus, typename TSpec, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, Deferred > * _specialSearch( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipElement< TObject, TModus, TSpec, Deferred > * layer_element, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(629)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _specialSearch( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipElement< TObject, TModus, TSpec, TStructuring > * layer_element, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_base.h"(641)

//____________________________________________________________________________
// _split

template <typename TObject, typename TModus, typename TSpec, typename TParam, typename TKey > SkipBaseElement< TObject, TModus, TSpec, Deferred > * _split( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipBaseElement< TObject, TModus, TSpec, Deferred > * base, TKey theKey, SkipElement< TObject, TModus, TSpec, Deferred > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(727)

//____________________________________________________________________________
// _splitAction

template <typename TObject, typename TModus, typename TSpec, typename TParam, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, Deferred > * _splitAction( SkipList< TObject, TModus, TSpec, Deferred > & list, SkipBaseElement< TObject, TModus, TSpec, Deferred > * base, TKey theKey, SkipElement< TObject, TModus, TSpec, Deferred > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(703)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam, typename TKey > inline SkipBaseElement< TObject, TModus, TSpec, TStructuring > * _splitAction( SkipList< TObject, TModus, TSpec, TStructuring > & list, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * base, TKey theKey, SkipElement< TObject, TModus, TSpec, TStructuring > ** search_path, TParam & param );       	// "projects/library/seqan/chaining/skip_list_base.h"(715)

//____________________________________________________________________________
// _swapBases

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void _swapBases( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & first, SkipBaseElement< TObject, TModus, TSpec, TStructuring > & second );       	// "projects/library/seqan/chaining/skip_list_base.h"(223)

//____________________________________________________________________________
// _testBruteForce

template <typename TObject, typename TSize > inline bool _testBruteForce( TObject & elem, TObject & first, TObject & second, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(278)

//____________________________________________________________________________
// _testBruteForceMax

template <typename TObject, typename TSize > inline void _testBruteForceMax( TObject * elem, TObject * border, TObject *& max_object, TSize _dim );       	// "projects/library/seqan/chaining/rmt_base.h"(157)

//____________________________________________________________________________
// _testRange

template <typename TObject, typename TSize > inline bool _testRange( TObject & elem, TObject & first, TObject & second, TSize dim );       	// "projects/library/seqan/chaining/rt_base.h"(298)

//____________________________________________________________________________
// _testRangeMax

template <typename TObject, typename TBorder, typename TSize > inline void _testRangeMax( TObject * elem, TBorder * border, TObject *& max_object, TSize dim );       	// "projects/library/seqan/chaining/rmt_base.h"(175)

//____________________________________________________________________________
// _throwCoin

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename THeight > inline typename seqan::Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type _throwCoin( SkipList< TObject, TModus, TSpec, TStructuring > & , THeight max_height);       	// "projects/library/seqan/chaining/skip_list_base.h"(198)

//____________________________________________________________________________
// activate

template <typename TObject, typename TSpec, typename TStructuring > inline void activate( RangeTree< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & tree, TObject & obj );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(97)
template <typename TObject, typename TSpec, typename TStructuring, typename TWeight > inline void activate( RangeTree< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & tree, TObject & obj, TWeight prio );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(106)

//____________________________________________________________________________
// allocate

template <typename TClass, typename TParentAlloc, typename TSize > void allocate( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me, TClass *& dest, TSize number );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(174)
template <typename TClass, typename TParentAlloc, typename TSize > void allocate( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me, TClass *& dest, TSize number );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(303)

//____________________________________________________________________________
// append

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void append( SkipList< TObject, TModus, TSpec, TStructuring > & me , TParam & param);       	// "projects/library/seqan/chaining/skip_list_impl.h"(60)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void append( SkipList< TObject, TModus, TSpec, TStructuring > & me , TParam1 & param1, TParam2 & param2 );       	// "projects/library/seqan/chaining/skip_list_impl.h"(69)

//____________________________________________________________________________
// appendValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void appendValue( SkipList< TObject, TModus, TSpec, TStructuring > & me , TParam & param);       	// "projects/library/seqan/chaining/skip_list_impl.h"(77)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void appendValue( SkipList< TObject, TModus, TSpec, TStructuring > & me , TParam1 & param1, TParam2 & param2 );       	// "projects/library/seqan/chaining/skip_list_impl.h"(86)

//____________________________________________________________________________
// assign

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void assign( SkipList< TObject, TModus, TSpec, TStructuring > & me, TParam & param);       	// "projects/library/seqan/chaining/skip_list_impl.h"(95)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void assign( SkipList< TObject, TModus, TSpec, TStructuring > & me, TParam1 & param1, TParam2 & param2 );       	// "projects/library/seqan/chaining/skip_list_impl.h"(104)

//____________________________________________________________________________
// assignValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline void assignValue( SkipList< TObject, TModus, TSpec, TStructuring > & me , TParam & param);       	// "projects/library/seqan/chaining/skip_list_impl.h"(112)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam1, typename TParam2 > inline void assignValue( SkipList< TObject, TModus, TSpec, TStructuring > & me , TParam1 & param1, TParam2 & param2 );       	// "projects/library/seqan/chaining/skip_list_impl.h"(121)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue> inline void assignValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me, TValue const & _value);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(100)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue> inline void assignValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const * me, TValue const & _value);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(110)

//____________________________________________________________________________
// capacity

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type capacity( SkipList< TObject, TModus, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_list_impl.h"(152)
template <typename TObject, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, SkipListDynamic, TSpec, TStructuring > >::Type capacity( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_list_impl.h"(161)

//____________________________________________________________________________
// chain

template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type chain(TSource & source, TDest & dest, TScoring const & scoring, RangetreeChaining);       	// "projects/library/seqan/chaining/chain_base.h"(252)
template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type chain(TSource & source, TDest & dest, TScoring const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(326)
template <typename TSource, typename TDest, typename TValue> inline TValue chain(TSource & source, TDest & dest, Score<TValue, Zero> const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(335)
template <typename TSource, typename TDest, typename TValue> inline TValue chain(TSource & source, TDest & dest, Score<TValue, Manhattan> const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(344)
template <typename TSource, typename TDest, typename TValue> inline TValue chain(TSource & source, TDest & dest, Score<TValue, ChainSoP> const & scoring, Default);       	// "projects/library/seqan/chaining/chain_base.h"(353)
template <typename TSource, typename TDest, typename TScoring> inline typename Value<TScoring>::Type chain(TSource & source, TDest & dest, TScoring const & scoring);       	// "projects/library/seqan/chaining/chain_base.h"(364)

//____________________________________________________________________________
// clear

template <typename TClass, typename TParentAlloc > inline void clear( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(236)
template <typename TClass, typename TParentAlloc > void clear( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(350)

//____________________________________________________________________________
// compute_chain

template <typename TSource, typename TDest, typename TScoreValue, typename TScoreType, typename TStructuring > TScoreValue compute_chain( TSource & source, TDest & dest, Score< TScoreValue, TScoreType > const & score_, TStructuring structuring );       	// "projects/library/seqan/chaining/chain_base.h"(175)

//____________________________________________________________________________
// deallocate

template <typename TClass, typename TParentAlloc, typename TSize > inline void deallocate( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me, TClass * location, TSize count );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(226)
template <typename TClass, typename TParentAlloc, typename TSize > void deallocate( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me, TClass * location, TSize count );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(341)

//____________________________________________________________________________
// dimension

template <typename TFragType, typename TSpec > inline typename Size< TFragType >::Type dimension( _ChainPoint< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(149)
template <typename TFragType, unsigned int ISize > inline typename Size< TFragType >::Type dimension( _ChainPoint< TFragType, Array< ISize > > &);       	// "projects/library/seqan/chaining/chain_point.h"(156)
template <typename TFragType > inline typename Size< TFragType >::Type dimension( const _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(134)
template <typename TBorder, typename TSpec > inline typename Size< Fragment< TBorder, TSpec > >::Type dimension( Fragment< TBorder, TSpec > & me );       	// "projects/library/seqan/chaining/fragment.h"(49)

//____________________________________________________________________________
// dump

template <typename TFragType > inline void dump( _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(138)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void dump( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(317)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void dump( SkipBaseElement< TObject, TModus, RT< TSpec >, TStructuring > & me );       	// "projects/library/seqan/chaining/rt_skip_base_element.h"(42)

//____________________________________________________________________________
// erase

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > bool erase( SkipList< TObject, TModus, TSpec, TStructuring > & list, TKey theKey);       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(362)
template <typename TObject, typename TSpec, typename TStructuring, typename TKey > bool erase( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TKey theKey );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(371)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > bool erase( SkipList< TObject, TModus, TSpec, TStructuring > & list, TObject & obj );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(393)
template <typename TObject, typename TSpec, typename TStructuring > bool erase( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(404)

//____________________________________________________________________________
// fac

template <typename TSimpleType > inline TSimpleType fac( TSimpleType data );       	// "projects/library/seqan/chaining/tree_chain_utils.h"(36)

//____________________________________________________________________________
// getObject

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline TObject * getObject( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me );       	// "projects/library/seqan/chaining/skip_base_element.h"(274)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline TObject * getObject( SkipElement< TObject, TModus, TSpec, TStructuring > * me );       	// "projects/library/seqan/chaining/skip_element.h"(71)

//____________________________________________________________________________
// getValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename GetValue< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type getValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(203)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename GetValue< SkipBaseElement< TObject, TModus, TSpec, TStructuring > const >::Type getValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(211)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename GetValue< SkipBaseElement< TObject, TModus, TSpec, TStructuring > * >::Type getValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me );       	// "projects/library/seqan/chaining/skip_base_element.h"(219)

//____________________________________________________________________________
// goNext

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void goNext( SkipBaseElement< TObject, TModus, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(383)
template <typename TObject, typename TSpec, typename TStructuring > inline void goNext( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(391)

//____________________________________________________________________________
// goPrevious

template <typename TObject, typename TSpec, typename TStructuring > inline void goPrevious( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(460)
template <typename TObject, typename TSpec, typename TStructuring > inline void goPrevious( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(468)

//____________________________________________________________________________
// insert

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void insert( SkipList< TObject, TModus, TSpec, TStructuring > & list, TObject & obj );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(134)
template <typename TObject, typename TSpec, typename TStructuring > inline void insert( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(144)
template <typename TObject, typename TSpec, typename TStructuring, typename TParam > inline void insert( SkipList< TObject, SkipListDynamic, TSpec, TStructuring > & list, TObject & obj, TParam & param );       	// "projects/library/seqan/chaining/skip_list_dynamic.h"(217)

//____________________________________________________________________________
// key

template <typename TFragType, typename TSpec, typename TSize > inline typename Key< TFragType >::Type key( _ChainPoint< TFragType, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/chain_point.h"(52)
template <typename TFragType, typename TSpec, typename TSize > inline typename Key< TFragType >::Type key( const _ChainPoint< TFragType, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/chain_point.h"(62)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Key< TObject >::Type key( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_base_element.h"(726)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TParam > inline typename Key< TObject >::Type key( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TParam & );       	// "projects/library/seqan/chaining/skip_base_element.h"(735)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline typename Key< TObject >::Type key( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(242)
template <typename TFragType > inline typename Key< TFragType >::Type key( _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(50)
template <typename TFragType > inline typename Key< TFragType >::Type key( const _WrapperPoint< TFragType > & me );       	// "projects/library/seqan/chaining/chain_wrapper_point.h"(57)
template <typename TType, typename TIterType > inline typename Key< typename Value< Iter< TType, TIterType > >::Type >::Type key( Iter< TType, TIterType > & it );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(84)
template <typename TType, typename TIterType, typename TParam > inline typename Key< typename Value< Iter< TType, TIterType > >::Type >::Type key( Iter< TType, TIterType > & it, TParam & param );       	// "projects/library/seqan/chaining/skip_list_iterator.h"(92)

//____________________________________________________________________________
// leftPosition

template <typename TBorder, typename TSpec, typename TSize > inline TBorder leftPosition( Fragment< TBorder, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(57)
template <typename TBorder, typename TSpec, typename TSize > inline TBorder leftPosition( const Fragment< TBorder, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(65)

//____________________________________________________________________________
// length

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Size< SkipList< TObject, TModus, TSpec, TStructuring > >::Type length( SkipList< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_list_impl.h"(188)

//____________________________________________________________________________
// makeBeginFragment

template <typename TFragment> inline void makeBeginFragment(TFragment & me);       	// "projects/library/seqan/chaining/fragment.h"(134)

//____________________________________________________________________________
// makeEndFragment

template <typename TFragment, typename TFragments> inline void makeEndFragment(TFragment & me, TFragments & fragments);       	// "projects/library/seqan/chaining/fragment.h"(148)

//____________________________________________________________________________
// moveValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > & me, TPos & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(207)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > const & me, TPos & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(215)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > & me, TPos const & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(223)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void moveValue( SkipList< TObject, TModus, TSpec, TStructuring > const & me, TPos const & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(231)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue > inline void moveValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > *& it, TValue const & _value);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(120)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TValue > inline void moveValue( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const *& it, TValue const & _value);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(129)

//____________________________________________________________________________
// operator+

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter< SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > operator+ (Iter< SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(170)
template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > operator+ (TIntegral left, Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(184)

//____________________________________________________________________________
// operator+=

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & operator+= (Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(203)

//____________________________________________________________________________
// operator-

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > operator- (Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(221)

//____________________________________________________________________________
// operator-=

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TIntegral> inline Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & operator-= (Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(252)

//____________________________________________________________________________
// parentAllocator

template <typename TClass, typename TParentAlloc > inline TParentAlloc & parentAllocator( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(156)
template <typename TClass, typename TParentAlloc > inline TParentAlloc & parentAllocator( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me );       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(286)

//____________________________________________________________________________
// position

template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec> inline typename Position<Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(139)
template <typename TObject, typename TSLSpec, typename TStructuring, typename TIterator, typename TSpec, typename TContainer2> inline typename Position<Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<SkipList< TObject, SkipListDynamic, TSLSpec, TStructuring >, AdaptorIterator<TIterator, TSpec> > const & me, TContainer2 const &);       	// "projects/library/seqan/chaining/skip_list_iterator.h"(157)

//____________________________________________________________________________
// printElementValue

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void printElementValue( SkipElement< TObject, TModus, TSpec, TStructuring > & me );       	// "projects/library/seqan/chaining/skip_element.h"(329)

//____________________________________________________________________________
// printLayerScores

template <typename TObject, typename TSpec, typename TStructuring, typename TSize1, typename TSize2 > void printLayerScores( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * list, TSize1 layer, TSize2 _dim );       	// "projects/library/seqan/chaining/rmt_base.h"(202)
template <typename TObject, typename TSpec, typename TStructuring, typename TSize > void printLayerScores( SkipList< TObject, SkipListStatic, RT< TSpec >, TStructuring > * list, TSize layer, TSize _dim );       	// "projects/library/seqan/chaining/rt_base.h"(328)

//____________________________________________________________________________
// printScores

template <typename TObject, typename TSpec, typename TStructuring > void printScores( SkipList< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & list );       	// "projects/library/seqan/chaining/rmt_base.h"(270)

//____________________________________________________________________________
// priority

template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type priority( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_base_element.h"(40)
template <typename TFragType, typename TSpec > inline typename Weight< TFragType >::Type priority( _ChainPoint< TFragType, TSpec > & me );       	// "projects/library/seqan/chaining/chain_point.h"(163)
template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type priority( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(109)
template <typename TFragType > inline typename Weight< TFragType >::Type priority( _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(76)

//____________________________________________________________________________
// rangeMaxQuery

template <typename TObject, typename TSpec, typename TStructuring, typename TBorder > TObject * rangeMaxQuery( RangeTree< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > & tree, TBorder & border_obj );       	// "projects/library/seqan/chaining/rmt_common_algos.h"(58)

//____________________________________________________________________________
// rangeQuery

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TResultSet > void rangeQuery( RangeTree< TObject, TModus, TSpec, TStructuring > & me, TObject & first, TObject & second, TResultSet & results );       	// "projects/library/seqan/chaining/rt_base.h"(264)

//____________________________________________________________________________
// replace

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void replace( SkipList< TObject, TModus, TSpec, TStructuring > & me, TPos & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(241)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void replace( SkipList< TObject, TModus, TSpec, TStructuring > const & me, TPos & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(250)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos > void replace( SkipList< TObject, TModus, TSpec, TStructuring > & me, TPos const & pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(259)

//____________________________________________________________________________
// right

template <typename TObject, typename TSpec, typename TStructuring > inline void right( SkipBaseElement< TObject, SkipListStatic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(596)
template <typename TObject, typename TSpec, typename TStructuring > inline void right( SkipBaseElement< TObject, SkipListDynamic, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_base_element.h"(604)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > __inline void right( SkipElement< TObject, TModus, TSpec, TStructuring > *& me );       	// "projects/library/seqan/chaining/skip_element.h"(99)

//____________________________________________________________________________
// rightPosition

template <typename TBorder, typename TSpec, typename TSize > inline TBorder rightPosition( Fragment< TBorder, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(73)
template <typename TBorder, typename TSpec, typename TSize > inline TBorder rightPosition( const Fragment< TBorder, TSpec > & me, TSize dim );       	// "projects/library/seqan/chaining/fragment.h"(81)

//____________________________________________________________________________
// score

template <typename TValue, typename T> inline TValue score(Score<TValue, Manhattan> const & me, T const & left, T const & right);       	// "projects/library/seqan/chaining/score_manhattan.h"(134)
template <typename TFragType > inline typename Weight< TFragType >::Type score( _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(60)
template <typename TValue, typename T> inline TValue score( Score<TValue, ChainSoP> const & me, T const & left, T const & right);       	// "projects/library/seqan/chaining/score_chain_sop.h"(148)
template <typename TValue, typename T> inline TValue score(Score<TValue, Zero> const & me, T const & left, T const & right);       	// "projects/library/seqan/chaining/score_zero.h"(114)

//____________________________________________________________________________
// scoreChainGap

template <typename TValue, typename TFragment> inline TValue scoreChainGap(Score<TValue, Manhattan> const & me, TFragment & f1, TFragment & f2);       	// "projects/library/seqan/chaining/score_manhattan.h"(149)
template <typename TValue, typename TFragment> inline TValue scoreChainGap(Score<TValue, ChainSoP> const & me, TFragment & f1, TFragment & f2);       	// "projects/library/seqan/chaining/score_chain_sop.h"(163)
template <typename TValue, typename TFragment> inline TValue scoreChainGap(Score<TValue, Zero> const &, TFragment &, TFragment &);       	// "projects/library/seqan/chaining/score_zero.h"(126)

//____________________________________________________________________________
// searchElement

template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline typename Iterator< SkipList< TObject, TModus, TSpec, TStructuring > >::Type searchElement( SkipList< TObject, TModus, TSpec, TStructuring > & list, TKey theKey );       	// "projects/library/seqan/chaining/skip_list_base.h"(662)

//____________________________________________________________________________
// setKey

template <typename TFragType, typename TSpec, typename TSize, typename TKey > inline void setKey( _ChainPoint< TFragType, TSpec > & me, TSize dim, TKey val );       	// "projects/library/seqan/chaining/chain_point.h"(73)
template <typename TFragType, typename TSpec, typename TSize, typename TKey > inline void setKey( const _ChainPoint< TFragType, TSpec > & me, TSize dim, TKey val );       	// "projects/library/seqan/chaining/chain_point.h"(83)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void setKey( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me, TKey theKey);       	// "projects/library/seqan/chaining/skip_base_element.h"(709)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void setKey( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me, TKey theKey);       	// "projects/library/seqan/chaining/skip_base_element.h"(718)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > __inline void setKey( SkipElement< TObject, TModus, TSpec, TStructuring > & me, TKey pos );       	// "projects/library/seqan/chaining/skip_element.h"(251)

//____________________________________________________________________________
// setParentAllocator

template <typename TClass, typename TParentAlloc > inline void setParentAllocator( Allocator< ClassPool< TClass, Unlimited, TParentAlloc > > & me, TParentAlloc & alloc_);       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(165)
template <typename TClass, typename TParentAlloc > inline void setParentAllocator( Allocator< ClassPool< TClass, Limited, TParentAlloc > > & me, TParentAlloc & alloc_);       	// "projects/library/seqan/chaining/skip_pool_alloc.h"(295)

//____________________________________________________________________________
// setPriority

template <typename TFragType, typename TSpec, typename TPrio > inline void setPriority( _ChainPoint< TFragType, TSpec > & me, TPrio prio );       	// "projects/library/seqan/chaining/chain_point.h"(171)
template <typename TFragType, typename TWeight > inline void setPriority( _MetaFragment< TFragType > & me, TWeight prio );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(84)

//____________________________________________________________________________
// setScore

template <typename TFragType, typename TWeight > inline void setScore( _MetaFragment< TFragType > & me, TWeight score );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(68)

//____________________________________________________________________________
// setWeight

template <typename TFragType, typename TWeight> inline void setWeight( _MetaFragment< TFragType > & me, TWeight weight );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(52)
template <typename TBorder, typename TSpec, typename TWeight > inline typename Weight< Fragment< TBorder, TSpec > >::Type setWeight( Fragment< TBorder, TSpec > & me, TWeight weight );       	// "projects/library/seqan/chaining/fragment.h"(105)

//____________________________________________________________________________
// value

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > & me);       	// "projects/library/seqan/chaining/skip_base_element.h"(179)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > const & me);       	// "projects/library/seqan/chaining/skip_base_element.h"(187)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline typename Reference< SkipBaseElement< TObject, TModus, TSpec, TStructuring > >::Type value( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * me);       	// "projects/library/seqan/chaining/skip_base_element.h"(195)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TPos> inline typename Reference< SkipList< TObject, TModus, TSpec, TStructuring > >::Type value( SkipList< TObject, TModus, TSpec, TStructuring > & me, TPos pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(270)
template <typename TObject, typename TSpec, typename TStructuring, typename TPos> inline typename Reference< SkipList< TObject, SkipListStatic, TSpec, TStructuring > >::Type value( SkipList< TObject, SkipListStatic, TSpec, TStructuring > & me, TPos pos);       	// "projects/library/seqan/chaining/skip_list_impl.h"(287)

//____________________________________________________________________________
// valueConstruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void valueConstruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it );       	// "projects/library/seqan/chaining/skip_base_element.h"(236)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void valueConstruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it, TObject * obj );       	// "projects/library/seqan/chaining/skip_base_element.h"(245)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > inline void valueConstruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it, TObject * obj, TKey key );       	// "projects/library/seqan/chaining/skip_base_element.h"(255)
template <typename TObject, typename TModus, typename TSpec, typename TStructuring, typename TKey > __inline void valueConstruct( SkipElement< TObject, TModus, TSpec, TStructuring > * it, SkipElement< TObject, TModus, TSpec, TStructuring > * right, SkipBaseElement< TObject, TModus, TSpec, TStructuring > * down, TKey theKey );       	// "projects/library/seqan/chaining/skip_element.h"(344)

//____________________________________________________________________________
// valueDestruct

template <typename TObject, typename TModus, typename TSpec, typename TStructuring > inline void valueDestruct( SkipBaseElement< TObject, TModus, TSpec, TStructuring > * it );       	// "projects/library/seqan/chaining/skip_base_element.h"(228)

//____________________________________________________________________________
// weight

template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type weight( SkipBaseElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_base_element.h"(32)
template <typename TObject, typename TSpec, typename TStructuring > inline typename Weight< TObject >::Type weight( SkipElement< TObject, SkipListStatic, RT< MaxTree< TSpec > >, TStructuring > * me );       	// "projects/library/seqan/chaining/rmt_skip_element.h"(101)
template <typename TFragType > inline typename Weight< TFragType >::Type weight( _MetaFragment< TFragType > & me );       	// "projects/library/seqan/chaining/chain_meta_fragment.h"(44)
template <typename TBorder, typename TSpec > inline typename Weight< Fragment< TBorder, TSpec > >::Type weight( Fragment< TBorder, TSpec > & me );       	// "projects/library/seqan/chaining/fragment.h"(89)
template <typename TBorder, typename TSpec > inline typename Weight< Fragment< TBorder, TSpec > >::Type weight( const Fragment< TBorder, TSpec > & me );       	// "projects/library/seqan/chaining/fragment.h"(96)

} //namespace seqan

#endif

