 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BasicInfo

struct BasicInfo;       	// "projects/library/seqan/blast/blast_base.h"(17)

//____________________________________________________________________________
// BlastHit

template <typename TBlastHsp, typename TStoreSpec> class BlastHit;       	// "projects/library/seqan/blast/blast_hit.h"(10)

//____________________________________________________________________________
// BlastHsp

template <typename TBlastSpec , typename TInfoSpec > class BlastHsp;       	// "projects/library/seqan/blast/blast_hsp.h"(41)

//____________________________________________________________________________
// BlastReport

template <typename TBlastHsp , typename TStoreSpec > class BlastReport;       	// "projects/library/seqan/blast/blast_report.h"(12)

//____________________________________________________________________________
// FullInfo

struct FullInfo;       	// "projects/library/seqan/blast/blast_base.h"(15)

//____________________________________________________________________________
// Hit

template <typename T> struct Hit;       	// "projects/library/seqan/blast/blast_base.h"(67)

//____________________________________________________________________________
// HitIterator

struct HitIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(21)

//____________________________________________________________________________
// Hsp

template <typename T> struct Hsp;       	// "projects/library/seqan/blast/blast_base.h"(70)

//____________________________________________________________________________
// HspIterator

struct HspIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(24)

//____________________________________________________________________________
// NucleotideBlast

template <typename TSpec > class NucleotideBlast;       	// "projects/library/seqan/blast/blast_hsp.h"(19)

//____________________________________________________________________________
// ProteinBlast

template <typename TSpec > class ProteinBlast;       	// "projects/library/seqan/blast/blast_hsp.h"(25)

//____________________________________________________________________________
// SimpleBlastIterator

template <typename TSpec> struct SimpleBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(17)

//____________________________________________________________________________
// StoreReport

template <typename TInfoSpec > struct StoreReport;       	// "projects/library/seqan/blast/blast_base.h"(41)

//____________________________________________________________________________
// StreamBlastIterator

template <typename TSpec> struct StreamBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(32)

//____________________________________________________________________________
// StreamReport

template <typename TFile > struct StreamReport;       	// "projects/library/seqan/blast/blast_base.h"(58)

//____________________________________________________________________________
// TagBlastN_

struct TagBlastN_;       	// "projects/library/seqan/blast/blast_hsp.h"(11)

//____________________________________________________________________________
// TagBlastP_

struct TagBlastP_;       	// "projects/library/seqan/blast/blast_hsp.h"(13)

//____________________________________________________________________________
// TagBlastX_

struct TagBlastX_;       	// "projects/library/seqan/blast/blast_hsp.h"(14)

//____________________________________________________________________________
// TagBlast_

struct TagBlast_;       	// "projects/library/seqan/blast/blast_base.h"(76)

//____________________________________________________________________________
// TagKnownSource_

struct TagKnownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(773)

//____________________________________________________________________________
// TagMegaBlast_

struct TagMegaBlast_;       	// "projects/library/seqan/blast/blast_hsp.h"(12)

//____________________________________________________________________________
// TagRunBlastN_

struct TagRunBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(16)

//____________________________________________________________________________
// TagRunBlastP_

struct TagRunBlastP_;       	// "projects/library/seqan/blast/blast_run.h"(24)

//____________________________________________________________________________
// TagRunBlastX_

struct TagRunBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(27)

//____________________________________________________________________________
// TagRunMegaBlast_

struct TagRunMegaBlast_;       	// "projects/library/seqan/blast/blast_run.h"(19)

//____________________________________________________________________________
// TagRunTBlastN_

struct TagRunTBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(30)

//____________________________________________________________________________
// TagRunTBlastX_

struct TagRunTBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(33)

//____________________________________________________________________________
// TagTBlastN_

struct TagTBlastN_;       	// "projects/library/seqan/blast/blast_hsp.h"(15)

//____________________________________________________________________________
// TagTBlastX_

struct TagTBlastX_;       	// "projects/library/seqan/blast/blast_hsp.h"(16)

//____________________________________________________________________________
// TagUnknownSource_

struct TagUnknownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(770)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Blast

typedef Tag<TagBlast_> const Blast;       	// "projects/library/seqan/blast/blast_base.h"(77)

//____________________________________________________________________________
// BlastN

typedef NucleotideBlast<TagBlastN_> BlastN;       	// "projects/library/seqan/blast/blast_hsp.h"(30)

//____________________________________________________________________________
// BlastP

typedef ProteinBlast<TagBlastP_> BlastP;       	// "projects/library/seqan/blast/blast_hsp.h"(33)

//____________________________________________________________________________
// BlastX

typedef ProteinBlast<TagBlastX_> BlastX;       	// "projects/library/seqan/blast/blast_hsp.h"(34)

//____________________________________________________________________________
// KnownSource

typedef Tag<TagKnownSource_> const KnownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(774)

//____________________________________________________________________________
// MegaBlast

typedef NucleotideBlast<TagMegaBlast_> MegaBlast;       	// "projects/library/seqan/blast/blast_hsp.h"(31)

//____________________________________________________________________________
// RunBlastN

typedef Tag<TagRunBlastN_> const RunBlastN;       	// "projects/library/seqan/blast/blast_run.h"(17)

//____________________________________________________________________________
// RunBlastP

typedef Tag<TagRunBlastP_> const RunBlastP;       	// "projects/library/seqan/blast/blast_run.h"(25)

//____________________________________________________________________________
// RunBlastX

typedef Tag<TagRunBlastX_> const RunBlastX;       	// "projects/library/seqan/blast/blast_run.h"(28)

//____________________________________________________________________________
// RunMegaBlast

typedef Tag<TagRunMegaBlast_> const RunMegaBlast;       	// "projects/library/seqan/blast/blast_run.h"(20)

//____________________________________________________________________________
// RunTBlastN

typedef Tag<TagRunTBlastN_> const RunTBlastN;       	// "projects/library/seqan/blast/blast_run.h"(31)

//____________________________________________________________________________
// RunTBlastX

typedef Tag<TagRunTBlastX_> const RunTBlastX;       	// "projects/library/seqan/blast/blast_run.h"(34)

//____________________________________________________________________________
// TBlastN

typedef ProteinBlast<TagTBlastN_> TBlastN;       	// "projects/library/seqan/blast/blast_hsp.h"(35)

//____________________________________________________________________________
// TBlastX

typedef ProteinBlast<TagTBlastX_> TBlastX;       	// "projects/library/seqan/blast/blast_hsp.h"(36)

//____________________________________________________________________________
// UnknownSource

typedef Tag<TagUnknownSource_> const UnknownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(771)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _parseBlastHit

template <typename TFile, typename TChar, typename TBlastHit> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, TBlastHit & hit);       	// "projects/library/seqan/blast/blast_hit.h"(134)
template <typename TFile, typename TChar, typename TBlastSpec> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, BlastHit<TBlastSpec,StreamReport<TFile> > & hit);       	// "projects/library/seqan/blast/blast_stream_hit.h"(47)

//____________________________________________________________________________
// _parseBlastHsp

template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<NucleotideBlast<TSpec>,FullInfo > & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(147)
template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<ProteinBlast<TSpec>,FullInfo> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(413)
template <typename TFile, typename TChar, typename TBlastSpec, typename TInfoSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<TBlastSpec,TInfoSpec> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(674)

//____________________________________________________________________________
// _parse_lineUntil

template <typename TFile, typename TChar> inline bool _parse_lineUntil(TFile & file, TChar& c, TChar x);       	// "projects/library/seqan/blast/blast_parsing.h"(325)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_lineUntil(TFile & file, TChar& c, String<TChar> & word, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(351)

//____________________________________________________________________________
// _parse_readAlignmentString

template <typename TFile, typename TChar> inline String<char> _parse_readAlignmentString(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(91)

//____________________________________________________________________________
// _parse_readEValue

template <typename TFile, typename TChar> inline double _parse_readEValue(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(60)

//____________________________________________________________________________
// _parse_readFloat

template <typename TFile, typename TChar> inline float _parse_readFloat(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(110)

//____________________________________________________________________________
// _parse_readQueryAndDBName

template <typename TFile, typename TChar> typename Position<TFile>::Type _parse_readQueryAndDBName(TFile & file, TChar & c, String<char> & query_name, String<char> & db_name);       	// "projects/library/seqan/blast/blast_parsing.h"(411)

//____________________________________________________________________________
// _parse_readWord

template <typename TFile, typename TChar, typename TSize> inline String<char> _parse_readWord(TFile & file, TChar& c, TSize max_len);       	// "projects/library/seqan/blast/blast_parsing.h"(127)

//____________________________________________________________________________
// _parse_until

template <typename TFile, typename TChar> inline bool _parse_until(TFile & file, TChar& c, TChar x);       	// "projects/library/seqan/blast/blast_parsing.h"(281)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_until(TFile & file, TChar& c, String<TChar> & word, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(302)

//____________________________________________________________________________
// _parse_untilBeginLine

template <typename TFile, typename TChar> inline bool _parse_untilBeginLine(TFile & file, TChar& c, TChar x);       	// "projects/library/seqan/blast/blast_parsing.h"(171)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilBeginLine(TFile & file, TChar& c, String<TChar> & word, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(193)
template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilBeginLine(TFile & file, TChar& c, String<TChar> & word, TSize len, TSize num_lines);       	// "projects/library/seqan/blast/blast_parsing.h"(218)

//____________________________________________________________________________
// _parse_untilBeginLineOneOf

template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilBeginLineOneOf(TFile & file, TChar& c, String<TChar> & x, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(251)

//____________________________________________________________________________
// _parse_untilOneOf

template <typename TFile, typename TChar, typename TSize> inline bool _parse_untilOneOf(TFile & file, TChar& c, String<TChar> x, TSize len);       	// "projects/library/seqan/blast/blast_parsing.h"(382)

//____________________________________________________________________________
// _readParameters

template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & file, TChar & c, BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(359)
template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & file, TChar & c, BlastReport<TBlastHsp, StoreReport<BasicInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(451)

//____________________________________________________________________________
// _runBlast

template <typename TString, typename TParamString> void _runBlast(TString blast_path, TString db_path, TString db_name, TString query_path, TString query_name, TString out_path, TString outfile_name, Tag<TagRunBlastN_>, TParamString params);       	// "projects/library/seqan/blast/blast_run.h"(59)

//____________________________________________________________________________
// _streamPutFloatBlast

template <typename TStream> inline void _streamPutFloatBlast(TStream & target, float number, char const * format_string);       	// "projects/library/seqan/blast/blast_parsing.h"(22)
template <typename TStream> inline void _streamPutFloatBlast(TStream & target, float number);       	// "projects/library/seqan/blast/blast_parsing.h"(33)

//____________________________________________________________________________
// _streamPutHspInfo

template <typename TFile, typename TBlastSpec> inline void _streamPutHspInfo(TFile & target, BlastHsp<TBlastSpec,BasicInfo> const & hsp);       	// "projects/library/seqan/blast/blast_report.h"(551)
template <typename TFile, typename TBlastSpec> inline void _streamPutHspInfo(TFile & target, BlastHsp<TBlastSpec,FullInfo> const & hsp);       	// "projects/library/seqan/blast/blast_report.h"(566)

//____________________________________________________________________________
// atBegin

template <typename TBlastObject, typename TIteratorSpec> inline bool atBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(185)
template <typename TBlastHit, typename TFile> inline bool atBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(190)
template <typename TBlastHsp, typename TStoreSpec> inline bool atBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(165)
template <typename TBlastReport, typename TFile> inline bool atBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(182)

//____________________________________________________________________________
// atEnd

template <typename TBlastHsp, typename TSpec, typename TFile> inline bool atEnd(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(991)
template <typename TBlastReport> inline bool atEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(401)
template <typename TBlastHit, typename TFile> inline bool atEnd(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(340)
template <typename TBlastHsp, typename TStoreSpec> inline bool atEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(186)
template <typename TBlastReport, typename TFile> inline bool atEnd(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(378)

//____________________________________________________________________________
// bitScore

template <typename TBlastSpec> inline float & bitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1339)

//____________________________________________________________________________
// clear

template <typename TBlastHsp, typename TSpec> inline void clear(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(74)
template <typename TSpec> inline void clear(BlastHsp<NucleotideBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(302)
template <typename TSpec> inline void clear(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(581)
template <typename TBlastSpec> inline void clear(BlastHsp<TBlastSpec, BasicInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(660)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(174)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<BasicInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(339)

//____________________________________________________________________________
// databaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & databaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1287)

//____________________________________________________________________________
// databaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1216)

//____________________________________________________________________________
// databaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1252)

//____________________________________________________________________________
// databaseFrame

template <typename TSpec> inline int & databaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1425)

//____________________________________________________________________________
// databaseName

template <typename TBlastHsp, typename TSpec> inline String<char> & databaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(724)

//____________________________________________________________________________
// databaseOrientationPlus

template <typename TBlastSpec> inline bool databaseOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1397)

//____________________________________________________________________________
// databaseQueryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> databaseQueryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1295)

//____________________________________________________________________________
// eValue

template <typename TBlastSpec, typename TInfoSpec> inline double & eValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1304)

//____________________________________________________________________________
// eValueCutoff

template <typename TBlastHsp> inline double & eValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(797)

//____________________________________________________________________________
// entropy

template <typename TBlastHsp> inline float & entropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(940)

//____________________________________________________________________________
// gapExtension

template <typename TBlastHsp> inline float & gapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(845)

//____________________________________________________________________________
// gapOpen

template <typename TBlastHsp> inline float & gapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(829)

//____________________________________________________________________________
// gappedEntropy

template <typename TBlastHsp> inline float & gappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(957)

//____________________________________________________________________________
// gappedKappa

template <typename TBlastHsp> inline float & gappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(923)

//____________________________________________________________________________
// gappedLambda

template <typename TBlastHsp> inline float & gappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(888)

//____________________________________________________________________________
// gapsAllowed

template <typename TBlastHsp> inline bool gapsAllowed(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(862)

//____________________________________________________________________________
// getAlignment

template <typename TBlastHsp, typename TSpec, typename TSource> inline void getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, UnknownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(783)
template <typename TBlastHsp, typename TSpec, typename TSource> inline void getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(891)
template <typename TBlastHsp, typename TSpec, typename TSource> inline void getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, KnownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(911)
template <typename TBlastHsp, typename TAlign, typename TId> inline void getAlignment(TBlastHsp & hsp, Graph<TAlign> & ali, TId id0, TId id1);       	// "projects/library/seqan/blast/blast_hsp.h"(985)
template <typename TBlastHsp, typename TStringSet, typename TCargo, typename TSpec> inline void getAlignment(TBlastHsp & hsp, Graph<Alignment<TStringSet,TCargo,TSpec> > & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(1069)

//____________________________________________________________________________
// getBitScore

template <typename TBlastSpec> inline float getBitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1347)

//____________________________________________________________________________
// getDatabaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1224)

//____________________________________________________________________________
// getDatabaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1260)

//____________________________________________________________________________
// getDatabaseFrame

template <typename TSpec> inline int getDatabaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1433)

//____________________________________________________________________________
// getDatabaseName

template <typename TBlastHsp, typename TSpec> inline String<char> getDatabaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(744)

//____________________________________________________________________________
// getEValue

template <typename TBlastSpec, typename TInfoSpec> inline double getEValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1312)

//____________________________________________________________________________
// getEValueCutoff

template <typename TBlastHsp> inline double getEValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(805)

//____________________________________________________________________________
// getEntropy

template <typename TBlastHsp> inline float getEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(948)

//____________________________________________________________________________
// getGapExtension

template <typename TBlastHsp> inline float getGapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(853)

//____________________________________________________________________________
// getGapOpen

template <typename TBlastHsp> inline float getGapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(837)

//____________________________________________________________________________
// getGappedEntropy

template <typename TBlastHsp> inline float getGappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(965)

//____________________________________________________________________________
// getGappedKappa

template <typename TBlastHsp> inline float getGappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(931)

//____________________________________________________________________________
// getGappedLambda

template <typename TBlastHsp> inline float getGappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(896)

//____________________________________________________________________________
// getKappa

template <typename TBlastHsp> inline float getKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(914)

//____________________________________________________________________________
// getLambda

template <typename TBlastHsp> inline float getLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(879)

//____________________________________________________________________________
// getLength

template <typename TBlastHsp, typename TStoreSpec> inline unsigned int getLength(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(111)

//____________________________________________________________________________
// getMatrixName

template <typename TBlastHsp> inline String<char> getMatrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(821)

//____________________________________________________________________________
// getName

template <typename TBlastHsp, typename TStoreSpec> inline String<char> getName(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(95)

//____________________________________________________________________________
// getNext

template <typename TBlastHsp, typename TSpec, typename TFile> inline void getNext(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1002)

//____________________________________________________________________________
// getNextHitFilePos

template <typename TBlastHsp, typename TFile> inline void getNextHitFilePos(TFile & file, Iter<BlastReport<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(401)

//____________________________________________________________________________
// getNextHspFilePos

template <typename TBlastHsp, typename TFile> inline void getNextHspFilePos(TFile & file, Iter<BlastHit<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(363)

//____________________________________________________________________________
// getPercentGaps

template <typename TBlastSpec> inline unsigned int getPercentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1380)

//____________________________________________________________________________
// getPercentIdentity

template <typename TBlastSpec> inline unsigned int getPercentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1364)

//____________________________________________________________________________
// getPercentPositives

template <typename TSpec> inline unsigned int getPercentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1449)

//____________________________________________________________________________
// getQueryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getQueryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1277)

//____________________________________________________________________________
// getQueryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1206)

//____________________________________________________________________________
// getQueryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1242)

//____________________________________________________________________________
// getQueryFrame

template <typename TSpec> inline int getQueryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1416)

//____________________________________________________________________________
// getQueryName

template <typename TBlastHsp, typename TSpec> inline String<char> getQueryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(704)

//____________________________________________________________________________
// getScore

template <typename TBlastSpec> inline float getScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1331)

//____________________________________________________________________________
// getValue

template <typename TBlastReport> inline typename GetValue<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type getValue(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(337)
template <typename TBlastHit, typename TFile> inline typename GetValue<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type getValue(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(272)
template <typename TBlastHsp, typename TStoreSpec> inline typename GetValue<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type getValue(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(115)
template <typename TBlastReport, typename TFile> inline typename GetValue<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type getValue(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(307)

//____________________________________________________________________________
// goBegin

template <typename TBlastObject, typename TIteratorSpec> inline void goBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(204)
template <typename TBlastHit, typename TFile> inline void goBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(203)
template <typename TBlastHsp, typename TStoreSpec> inline void goBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(175)
template <typename TBlastReport, typename TFile> inline void goBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(195)

//____________________________________________________________________________
// goEnd

template <typename TBlastReport> inline void goEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(422)
template <typename TBlastHsp, typename TStoreSpec> inline void goEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(196)

//____________________________________________________________________________
// goNext

template <typename TBlastObject, typename TIteratorSpec> inline void goNext(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(228)
template <typename TBlastHit, typename TFile> inline void goNext(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(218)
template <typename TBlastHsp, typename TStoreSpec> inline void goNext(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(206)
template <typename TBlastReport, typename TFile> inline void goNext(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(226)

//____________________________________________________________________________
// goPrevious

template <typename TBlastObject, typename TIteratorSpec> inline void goPrevious(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(264)
template <typename TBlastHsp, typename TStoreSpec> inline void goPrevious(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(229)

//____________________________________________________________________________
// hostHit

template <typename TBlastHit> inline typename Host<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type const& hostHit(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(328)
template <typename TBlastHsp, typename TStoreSpec> inline typename Host<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type & hostHit(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(155)

//____________________________________________________________________________
// hostReport

template <typename TBlastReport> inline typename Host<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, SimpleBlastIterator<HitIterator> > & it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(379)
template <typename TBlastHit> inline typename Host<typename Host<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type>::Type const& hostReport(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(309)
template <typename TBlastReport> inline typename Host<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(353)

//____________________________________________________________________________
// kappa

template <typename TBlastHsp> inline float & kappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(906)

//____________________________________________________________________________
// lambda

template <typename TBlastHsp> inline float & lambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(871)

//____________________________________________________________________________
// length

template <typename TBlastHsp, typename TStoreSpec> inline unsigned int & length(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(103)

//____________________________________________________________________________
// matrixName

template <typename TBlastHsp> inline String<char> & matrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(813)

//____________________________________________________________________________
// name

template <typename TBlastHsp, typename TStoreSpec> inline String<char> & name(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(87)

//____________________________________________________________________________
// numHits

template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHits(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(764)

//____________________________________________________________________________
// numHsps

template <typename TBlastHsp, typename TSpec> inline unsigned int numHsps(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(120)
template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHsps(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(784)

//____________________________________________________________________________
// operator!=

template <typename TBlastObject, typename TIteratorSpec> inline bool operator!=(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(309)
template <typename TBlastHit> inline bool operator!=(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(260)
template <typename TBlastHsp, typename TStoreSpec> inline bool operator!=(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(274)
template <typename TBlastReport> inline bool operator!=(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(281)

//____________________________________________________________________________
// operator*

template <typename TBlastObject, typename TIteratorSpec> inline typename Reference<Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> > >::Type operator* (Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(163)
template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type operator* (Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(136)

//____________________________________________________________________________
// operator++

template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator++(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(238)
template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator++(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(216)

//____________________________________________________________________________
// operator--

template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator--(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(274)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> > operator--(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it, int);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(285)
template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator--(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(239)
template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > operator--(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it, int);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(250)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TBlastHsp, typename TInfoSpec> inline TStream & operator<< (TStream & target, BlastReport<TBlastHsp,StoreReport<TInfoSpec> >& source);       	// "projects/library/seqan/blast/blast_report.h"(658)

//____________________________________________________________________________
// operator==

template <typename TBlastObject, typename TIteratorSpec> inline bool operator==(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(298)
template <typename TBlastHit> inline bool operator==(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(249)
template <typename TBlastHsp, typename TStoreSpec> inline bool operator==(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(263)
template <typename TBlastReport> inline bool operator==(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(270)

//____________________________________________________________________________
// percentGaps

template <typename TBlastSpec> inline unsigned int & percentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1372)

//____________________________________________________________________________
// percentIdentity

template <typename TBlastSpec> inline unsigned int & percentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1356)

//____________________________________________________________________________
// percentPositives

template <typename TSpec> inline unsigned int & percentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1441)

//____________________________________________________________________________
// queryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & queryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1269)

//____________________________________________________________________________
// queryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1198)

//____________________________________________________________________________
// queryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1234)

//____________________________________________________________________________
// queryFrame

template <typename TSpec> inline int & queryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1408)

//____________________________________________________________________________
// queryName

template <typename TBlastHsp, typename TSpec> inline String<char> & queryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(684)

//____________________________________________________________________________
// queryOrientationPlus

template <typename TBlastSpec> inline bool queryOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1389)

//____________________________________________________________________________
// read

template <typename TBlastHsp, typename TFile> void read(TFile & file, BlastReport<TBlastHsp, StreamReport<TFile> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_stream_report.h"(73)
template <typename TFile, typename TBlastHsp, typename TInfoSpec> void read(TFile & file, BlastReport<TBlastHsp, StoreReport<TInfoSpec> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_report.h"(472)

//____________________________________________________________________________
// run

template <typename TBlast, typename TBlastReport, typename TString, typename TParamString> void run(Tag<TBlast> tag, TString blast_path, TString db_path, TString db_name, TString query_path, TString query_name, TBlastReport & blastObj, TParamString params );       	// "projects/library/seqan/blast/blast_run.h"(88)

//____________________________________________________________________________
// score

template <typename TBlastSpec> inline float & score(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1323)

//____________________________________________________________________________
// value

template <typename TBlastReport> inline typename Reference<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type value(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(360)
template <typename TBlastHit, typename TFile> inline typename Reference<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type value(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(295)
template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type value(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(126)
template <typename TBlastReport, typename TFile> inline typename Reference<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type value(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(340)

//____________________________________________________________________________
// write

template <typename TFile, typename TInfoSpec, typename TBlastHsp> inline void write(TFile & target, BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj, Blast);       	// "projects/library/seqan/blast/blast_report.h"(585)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

