 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_ALIGN_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_ALIGN_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Align

template <typename TSource, typename TSpec > class Align;       	// "projects/library/seqan/align/align_base.h"(121)

//____________________________________________________________________________
// AlignColIterator

template <typename TSpec> struct AlignColIterator;       	// "projects/library/seqan/align/align_cols_base.h"(146)

//____________________________________________________________________________
// AlignCols

template <typename TAlign> struct AlignCols;       	// "projects/library/seqan/align/align_cols_base.h"(47)

//____________________________________________________________________________
// AlignTrace

template <typename TSize , typename TSpec > struct AlignTrace;       	// "projects/library/seqan/align/align_trace.h"(34)

//____________________________________________________________________________
// ArrayGaps

struct ArrayGaps;       	// "projects/library/seqan/align/gaps_base.h"(31)
struct ArrayGaps;       	// "projects/library/seqan/align/gaps_array.h"(30)

//____________________________________________________________________________
// Col

template <typename T> struct Col;       	// "projects/library/seqan/align/align_base.h"(59)

//____________________________________________________________________________
// Cols

template <typename T> struct Cols;       	// "projects/library/seqan/align/align_base.h"(41)

//____________________________________________________________________________
// Gaps

template <typename TSource, typename TSpec > class Gaps;       	// "projects/library/seqan/align/gaps_base.h"(61)

//____________________________________________________________________________
// GapsIterator

template <typename TSpec> struct GapsIterator;       	// "projects/library/seqan/align/gaps_base.h"(35)

//____________________________________________________________________________
// LocalAlignmentFinder

template <typename TScoreValue > class LocalAlignmentFinder;       	// "projects/library/seqan/align/align_local_dynprog.h"(99)

//____________________________________________________________________________
// Matrix

template <typename TValue, typename TSpec > class Matrix;       	// "projects/library/seqan/align/matrix_base.h"(30)

//____________________________________________________________________________
// MiniGaps

struct MiniGaps;       	// "projects/library/seqan/align/gaps_skiplist.h"(48)

//____________________________________________________________________________
// Navi

template <typename TContainer, typename TSpec> struct Navi;       	// "projects/library/seqan/align/align_trace.h"(230)

//____________________________________________________________________________
// Navigator

template <typename T> struct Navigator;       	// "projects/library/seqan/align/align_trace.h"(215)

//____________________________________________________________________________
// Row

template <typename T> struct Row;       	// "projects/library/seqan/align/align_base.h"(91)

//____________________________________________________________________________
// Rows

template <typename T> struct Rows;       	// "projects/library/seqan/align/align_base.h"(73)

//____________________________________________________________________________
// ScoreAndID

template <typename TValue, typename TID> class ScoreAndID;       	// "projects/library/seqan/align/align_local_dynprog.h"(34)

//____________________________________________________________________________
// Source

template <typename T> struct Source;       	// "projects/library/seqan/align/gaps_base.h"(111)

//____________________________________________________________________________
// _HirschbergSet

class _HirschbergSet;       	// "projects/library/seqan/align/hirschberg_set.h"(50)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _CoordinatesToPositions

template <typename TSize, typename TSpec, typename TCoordinates> inline void _CoordinatesToPositions(AlignTrace<TSize, TSpec> & me, TCoordinates const & coordinates_, TSize & position_, unsigned char & bit_position);       	// "projects/library/seqan/align/align_trace.h"(154)

//____________________________________________________________________________
// _PositionsToCoordinates

template <typename TSize, typename TSpec, typename TCoordinates> inline void _PositionsToCoordinates(AlignTrace<TSize, TSpec> & me, TCoordinates & coordinates_, TSize position_, unsigned char bit_position );       	// "projects/library/seqan/align/align_trace.h"(181)

//____________________________________________________________________________
// _computeSize4Length

inline size_t _computeSize4Length(MiniGaps const &, size_t length);       	// "projects/library/seqan/align/gaps_skiplist.h"(149)

//____________________________________________________________________________
// _dataArr

template <typename TSource> inline String<typename Size<Gaps<TSource, ArrayGaps> >::Type> & _dataArr(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(132)
template <typename TSource> inline String<typename Size<Gaps<TSource, ArrayGaps> >::Type> const & _dataArr(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(139)

//____________________________________________________________________________
// _dataSource

template <typename TSource> inline Holder<TSource> & _dataSource(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(149)
template <typename TSource> inline Holder<TSource> const & _dataSource(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(156)

//____________________________________________________________________________
// _getBitsPerEntry

template <typename TSize, typename TSpec> inline unsigned int _getBitsPerEntry(AlignTrace<TSize, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(100)

//____________________________________________________________________________
// _goNext_gapsIterator

template <typename T> inline void _goNext_gapsIterator(T const & me);       	// "projects/library/seqan/align/gaps_array.h"(739)

//____________________________________________________________________________
// _goPrevious_gapsIterator

template <typename T> inline void _goPrevious_gapsIterator(T const & me);       	// "projects/library/seqan/align/gaps_array.h"(772)

//____________________________________________________________________________
// _gotoh

template <typename TScoreValue, typename TMatrixSpec, typename TString> TScoreValue _gotoh(Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(229)

//____________________________________________________________________________
// _gotoh_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TMatrixSpec> void _gotoh_trace(Align<TTargetSource, TTargetSpec> & target_, Matrix<TScoreValue, TMatrixSpec> & diag_matrix_, Matrix<TScoreValue, TMatrixSpec> & vert_matrix_, Matrix<TScoreValue, TMatrixSpec> & hori_matrix_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(373)

//____________________________________________________________________________
// _initMembers

template <typename TSize, typename TSpec> inline void _initMembers(AlignTrace<TSize, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(109)

//____________________________________________________________________________
// _init_to_resize

template <typename TSource, typename TSize> inline void _init_to_resize(Gaps<TSource, ArrayGaps> & me, TSize _size);       	// "projects/library/seqan/align/gaps_array.h"(233)

//____________________________________________________________________________
// _iterator_gaps_array

template <typename TGaps, typename TPosition> inline typename Iterator<TGaps, Standard>::Type _iterator_gaps_array(TGaps & gaps, TPosition view_position);       	// "projects/library/seqan/align/gaps_array.h"(343)

//____________________________________________________________________________
// _needleman_wunsch

template <typename TScoreValue, typename TMatrixSpec, typename TString> TScoreValue _needleman_wunsch(Matrix<TScoreValue, TMatrixSpec> & matrix_, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(35)

//____________________________________________________________________________
// _needleman_wunsch_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> void _needleman_wunsch_trace(Align<TTargetSource, TTargetSpec> & target_, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(135)

//____________________________________________________________________________
// _setEndPosition

template <typename TSource, typename TPosition> inline void _setEndPosition(Gaps<TSource, ArrayGaps> & me, TPosition _pos);       	// "projects/library/seqan/align/gaps_array.h"(183)

//____________________________________________________________________________
// _setSourceBeginPosition

template <typename TSource, typename TSourcePosition> inline void _setSourceBeginPosition(Gaps<TSource, ArrayGaps> & me, TSourcePosition _pos);       	// "projects/library/seqan/align/gaps_array.h"(203)

//____________________________________________________________________________
// _setSourceEndPosition

template <typename TSource, typename TSourcePosition> inline void _setSourceEndPosition(Gaps<TSource, ArrayGaps> & me, TSourcePosition _pos);       	// "projects/library/seqan/align/gaps_array.h"(222)

//____________________________________________________________________________
// assignSource

template <typename TSource, typename TSpec, typename TSource2, typename TPosition1, typename TPosition2> inline void assignSource(Gaps<TSource, TSpec> & me, TSource2 const & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_base.h"(881)
template <typename TSource, typename TSpec, typename TSource2> inline void assignSource(Gaps<TSource, TSpec> & me, TSource2 const & source_);       	// "projects/library/seqan/align/gaps_base.h"(895)

//____________________________________________________________________________
// assignValue

inline void assignValue(MiniGaps & me, unsigned int pos, unsigned int val);       	// "projects/library/seqan/align/gaps_skiplist.h"(178)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(334)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(343)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(352)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void assignValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(361)
template <typename TGaps, typename TSpec, typename TValue> inline void assignValue(Iter<TGaps, GapsIterator<TSpec> > & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(201)
template <typename TGaps, typename TSpec, typename TValue> inline void assignValue(Iter<TGaps, GapsIterator<TSpec> > const & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(213)

//____________________________________________________________________________
// atBegin

template <typename TGaps, typename TSpec> inline bool atBegin(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(810)

//____________________________________________________________________________
// atEnd

template <typename TGaps, typename TSpec> inline bool atEnd(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(820)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<Matrix <TValue, TSpec>, Tag<TTag> const>::Type begin(Matrix<TValue, TSpec> & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(292)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<Matrix <TValue, TSpec> const, Tag<TTag> const>::Type begin(Matrix<TValue, TSpec> const & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(299)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec>, Tag<TTag> const>::Type begin(Gaps<TSource, TSpec> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(242)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec> const, Tag<TTag> const>::Type begin(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(250)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type begin(AlignCols<TAlign> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(329)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type begin(AlignCols<TAlign> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(337)

//____________________________________________________________________________
// beginPosition

template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type beginPosition(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(309)
template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type beginPosition(AlignCols<TAlign> & me);       	// "projects/library/seqan/align/align_cols_base.h"(316)
template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> >::Type beginPosition(Gaps<TSource, ArrayGaps> & gaps);       	// "projects/library/seqan/align/gaps_array.h"(427)
template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> const>::Type beginPosition(Gaps<TSource, ArrayGaps> const & gaps);       	// "projects/library/seqan/align/gaps_array.h"(434)

//____________________________________________________________________________
// beginPosition_AlignCols

template <typename TAlignCols> inline typename Position<TAlignCols>::Type beginPosition_AlignCols(TAlignCols const & me);       	// "projects/library/seqan/align/align_cols_base.h"(281)

//____________________________________________________________________________
// clear

template <typename TSource> inline void clear(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(256)

//____________________________________________________________________________
// clearBit

template <typename TSize, typename TSpec, typename TSpec2> inline void clearBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(288)

//____________________________________________________________________________
// clearGaps

template <typename TSource, typename TSpec, typename TPosition1, typename TPosition2> inline void clearGaps(Gaps<TSource, TSpec> & me, TPosition1 view_pos_begin, TPosition2 view_pos_end);       	// "projects/library/seqan/align/gaps_base.h"(519)
template <typename TSource, typename TSpec> inline void clearGaps(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(552)
template <typename TSource> inline void clearGaps(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(246)

//____________________________________________________________________________
// col

template <typename TSource, typename TSpec, typename TPosition> inline typename Col< Align<TSource, TSpec> >::Type col(Align<TSource, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(340)
template <typename TSource, typename TSpec, typename TPosition> inline typename Col< Align<TSource, TSpec> const>::Type col(Align<TSource, TSpec> const & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(348)

//____________________________________________________________________________
// cols

template <typename TSource, typename TSpec> inline typename Cols< Align<TSource, TSpec> >::Type cols(Align<TSource, TSpec> & me);       	// "projects/library/seqan/align/align_base.h"(308)
template <typename TSource, typename TSpec> inline typename Cols< Align<TSource, TSpec> const>::Type cols(Align<TSource, TSpec> const & me);       	// "projects/library/seqan/align/align_base.h"(315)

//____________________________________________________________________________
// container

template <typename TAlign, typename TSpec> inline typename Cols<TAlign>::Type container(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(122)
template <typename TAlign, typename TSpec> inline typename Cols<TAlign>::Type container(Iter<TAlign, AlignColIterator<TSpec> > const & me);       	// "projects/library/seqan/align/align_iterator_base.h"(129)
template <typename TGaps, typename TSpec> inline TGaps & container(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_array.h"(661)
template <typename TGaps, typename TSpec> inline TGaps & container(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(669)
template <typename TContainer, typename TSpec> inline TContainer & container(Navi<TContainer, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(247)
template <typename TContainer, typename TSpec> inline TContainer const & container(Navi<TContainer, TSpec> const & me);       	// "projects/library/seqan/align/align_trace.h"(253)

//____________________________________________________________________________
// coordinate

template <typename TValue, typename TSpec, typename TPosition> inline typename Size< Matrix <TValue, TSpec> >::Type coordinate(Matrix<TValue, TSpec> & me, TPosition position_, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(273)
template <typename TValue, typename TSpec> inline typename Size< Matrix<TValue, TSpec> >::Type coordinate(Iter< Matrix<TValue, TSpec>, PositionIterator > & me, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(363)

//____________________________________________________________________________
// copyGaps

template <typename TSource, typename TSpec, typename TPosition1, typename TSourceGaps, typename TPosition2, typename TPosition3> inline void copyGaps(Gaps<TSource, TSpec> & target_gaps, TPosition1 target_view_pos_begin, TSourceGaps const & source_gaps, TPosition2 source_view_pos_begin, TPosition3 source_view_pos_end);       	// "projects/library/seqan/align/gaps_base.h"(569)

//____________________________________________________________________________
// countGaps

template <typename TSource, typename TSpec, typename TPosition> inline typename Size<Gaps<TSource, TSpec> >::Type countGaps(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(494)
template <typename TGaps, typename TSpec> inline typename Size<TGaps>::Type countGaps(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(707)

//____________________________________________________________________________
// createSource

template <typename TSource, typename TSpec> inline void createSource(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(767)

//____________________________________________________________________________
// dependentSource

template <typename TSource, typename TSpec> inline bool dependentSource(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(686)
template <typename TSource, typename TSpec> inline bool dependentSource(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(693)

//____________________________________________________________________________
// detach

template <typename TSource, typename TSpec> inline void detach(Align<TSource, TSpec> & me);       	// "projects/library/seqan/align/align_base.h"(360)
template <typename TSource, typename TSpec> inline void detach(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(782)

//____________________________________________________________________________
// dimension

template <typename TValue, typename TSpec> inline unsigned int dimension(Matrix<TValue, TSpec> & me);       	// "projects/library/seqan/align/matrix_base.h"(169)
template <typename TSize, typename TSpec> inline unsigned int dimension(AlignTrace<TSize, TSpec> & me);       	// "projects/library/seqan/align/align_trace.h"(60)

//____________________________________________________________________________
// emptySource

template <typename TSource, typename TSpec> inline bool emptySource(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(653)
template <typename TSource, typename TSpec> inline bool emptySource(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(661)

//____________________________________________________________________________
// end

template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<Matrix <TValue, TSpec>, Tag<TTag> const >::Type end(Matrix<TValue, TSpec> & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(309)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<Matrix <TValue, TSpec> const, Tag<TTag> const >::Type end(Matrix<TValue, TSpec> const & me, Tag<TTag> const);       	// "projects/library/seqan/align/matrix_base.h"(316)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec>, Tag<TTag> const>::Type end(Gaps<TSource, TSpec> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(263)
template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<Gaps<TSource, TSpec> const, Tag<TTag> const>::Type end(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(271)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type end(AlignCols<TAlign> & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(391)
template <typename TAlign, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type end(AlignCols<TAlign> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/align_cols_base.h"(399)

//____________________________________________________________________________
// endPosition

template <typename TAlign> inline typename Position<AlignCols<TAlign> >::Type endPosition(AlignCols<TAlign> & me);       	// "projects/library/seqan/align/align_cols_base.h"(371)
template <typename TAlign> inline typename Position<AlignCols<TAlign> const>::Type endPosition(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(378)
template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type endPosition(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(166)
template <typename TSource> inline typename Position<Gaps<TSource, ArrayGaps> >::Type endPosition(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(173)

//____________________________________________________________________________
// endPosition_AlignCols

template <typename TAlignCols> inline typename Position<TAlignCols>::Type endPosition_AlignCols(TAlignCols const & me);       	// "projects/library/seqan/align/align_cols_base.h"(349)

//____________________________________________________________________________
// findEntry

inline unsigned int findEntry(MiniGaps & me, unsigned int & val);       	// "projects/library/seqan/align/gaps_skiplist.h"(292)

//____________________________________________________________________________
// getBit

template <typename TSize, typename TSpec, typename TSpec2> inline bool getBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(270)

//____________________________________________________________________________
// getValue

inline unsigned int getValue(MiniGaps const & me, unsigned int pos);       	// "projects/library/seqan/align/gaps_skiplist.h"(158)
template <typename TAlign, typename TSpec, typename TPosition> inline typename GetValue<TAlign>::Type getValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(314)
template <typename TAlign, typename TSpec, typename TPosition> inline typename GetValue<TAlign>::Type getValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(322)
template <typename TGaps, typename TSpec> inline typename GetValue< Iter<TGaps, GapsIterator<TSpec> > >::Type getValue(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(179)
template <typename TGaps, typename TSpec> inline typename GetValue< Iter<TGaps, GapsIterator<TSpec> > const>::Type getValue(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(188)
template <typename TSource, typename TSpec, typename TPosition> inline typename GetValue<Gaps<TSource, TSpec> >::Type getValue(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(595)
template <typename TSource, typename TSpec, typename TPosition> inline typename GetValue<Gaps<TSource, TSpec> >::Type getValue(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(605)

//____________________________________________________________________________
// get_next_best_end_position

template <typename TScoreValue> typename LocalAlignmentFinder<TScoreValue>::TMatrixPosition get_next_best_end_position(LocalAlignmentFinder<TScoreValue> & sw , TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(588)

//____________________________________________________________________________
// globalAlignment

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const &, MyersBitVector);       	// "projects/library/seqan/align/align_myers.h"(156)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const &, MyersHirschberg);       	// "projects/library/seqan/align/align_myers.h"(358)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, Hirschberg);       	// "projects/library/seqan/align/align_hirschberg.h"(139)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_dynprog.h"(505)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, NeedlemanWunsch);       	// "projects/library/seqan/align/align_dynprog.h"(524)
template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue globalAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, Gotoh);       	// "projects/library/seqan/align/align_dynprog.h"(543)

//____________________________________________________________________________
// goNext

template <typename TAlign, typename TSpec> inline void goNext(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(139)
template <typename TValue, typename TSpec> inline void goNext(Iter< Matrix<TValue, TSpec>, PositionIterator > & me, unsigned int dimension_ );       	// "projects/library/seqan/align/matrix_base.h"(340)
template <typename TGaps, typename TSpec> inline void goNext(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_array.h"(757)
template <typename TGaps, typename TSpec> inline void goNext(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(763)
template <typename TSize, typename TSpec, typename TSpec2> inline void goNext(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me, unsigned int dimension_);       	// "projects/library/seqan/align/align_trace.h"(298)

//____________________________________________________________________________
// goPrevious

template <typename TAlign, typename TSpec> inline void goPrevious(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(182)
template <typename TValue, typename TSpec> inline void goPrevious(Iter< Matrix<TValue, TSpec>, PositionIterator > & me, unsigned int dimension_ );       	// "projects/library/seqan/align/matrix_base.h"(352)
template <typename TGaps, typename TSpec> inline void goPrevious(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_array.h"(796)
template <typename TGaps, typename TSpec> inline void goPrevious(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(802)
template <typename TSize, typename TSpec, typename TSpec2> inline void goPrevious(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me, unsigned int dimension_);       	// "projects/library/seqan/align/align_trace.h"(338)

//____________________________________________________________________________
// host

template <typename TAlign, typename TSpec> inline TAlign & host(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(95)
template <typename TAlign, typename TSpec> inline TAlign & host(Iter<TAlign, AlignColIterator<TSpec> > const & me);       	// "projects/library/seqan/align/align_iterator_base.h"(102)
template <typename TAlign> inline typename Host<AlignCols<TAlign> >::Type & host(AlignCols<TAlign> & me);       	// "projects/library/seqan/align/align_cols_base.h"(216)
template <typename TAlign> inline typename Host<AlignCols<TAlign> const>::Type & host(AlignCols<TAlign> const & me);       	// "projects/library/seqan/align/align_cols_base.h"(224)

//____________________________________________________________________________
// id

template <typename TSource, typename TSpec> inline void const * id(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(221)
template <typename TSource, typename TSpec> inline void const * id(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(228)

//____________________________________________________________________________
// insertGap

template <typename TGaps, typename TSpec> inline void insertGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(138)
template <typename TSource, typename TSpec, typename TPosition> inline void insertGap(Gaps<TSource, TSpec> & me, TPosition _view_pos);       	// "projects/library/seqan/align/gaps_base.h"(371)

//____________________________________________________________________________
// insertGaps

template <typename TSource, typename TSpec, typename TPosition, typename TSize> inline void insertGaps(Gaps<TSource, TSpec> & me, TPosition _view_pos, TSize _size);       	// "projects/library/seqan/align/gaps_base.h"(394)
template <typename TGaps, typename TSpec, typename TCount> inline void insertGaps(Iter<TGaps, GapsIterator<TSpec> > const & me, TCount size);       	// "projects/library/seqan/align/gaps_array.h"(831)

//____________________________________________________________________________
// insertValue

inline void insertValue(MiniGaps & me, unsigned int pos, unsigned int val);       	// "projects/library/seqan/align/gaps_skiplist.h"(247)

//____________________________________________________________________________
// isGap

template <typename TSource, typename TSpec, typename TPosition> inline bool isGap(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(466)
template <typename TGaps, typename TSpec> inline bool isGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(697)

//____________________________________________________________________________
// iter

template <typename TAlign, typename TPosition, typename TTag> inline typename Iterator<AlignCols<TAlign>, Tag<TTag> const>::Type iter(AlignCols<TAlign> & me, TPosition pos_, Tag<TTag> const);       	// "projects/library/seqan/align/align_cols_base.h"(239)
template <typename TAlign, typename TPosition, typename TTag> inline typename Iterator<AlignCols<TAlign> const, Tag<TTag> const>::Type iter(AlignCols<TAlign> const & me, TPosition pos_, Tag<TTag> const);       	// "projects/library/seqan/align/align_cols_base.h"(248)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, ArrayGaps>, Tag<TTag> const>::Type iter(Gaps<TSource, ArrayGaps> & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_array.h"(408)
template <typename TSource, typename TPosition, typename TTag> inline typename Iterator<Gaps<TSource, ArrayGaps> const, Tag<TTag> const>::Type iter(Gaps<TSource, ArrayGaps> const & gaps, TPosition view_pos, Tag<TTag> const);       	// "projects/library/seqan/align/gaps_array.h"(417)

//____________________________________________________________________________
// length

template <typename TValue, typename TSpec> inline typename Size<Matrix<TValue, TSpec> >::Type length(Matrix<TValue, TSpec> const & me, unsigned int dim_);       	// "projects/library/seqan/align/matrix_base.h"(194)
template <typename TValue, typename TSpec> inline typename Size<Matrix <TValue, TSpec> >::Type length(Matrix<TValue, TSpec> const & me);       	// "projects/library/seqan/align/matrix_base.h"(201)
template <typename TSource, typename TSpec> inline typename Size<Gaps<TSource, TSpec> >::Type length(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(283)
template <typename TSize, typename TSpec> inline TSize length(AlignTrace<TSize, TSpec> const & me, TSize _dim);       	// "projects/library/seqan/align/align_trace.h"(80)

//____________________________________________________________________________
// localAlignment

template <typename TSource, typename TSpec, typename TScoreValue> inline TScoreValue localAlignment(Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_, SmithWaterman);       	// "projects/library/seqan/align/align_local_dynprog.h"(730)

//____________________________________________________________________________
// moveNextBit

template <typename TSize, typename TSpec, typename TSpec2> inline void moveNextBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(375)

//____________________________________________________________________________
// movePreviousBit

template <typename TSize, typename TSpec, typename TSpec2> inline void movePreviousBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(392)

//____________________________________________________________________________
// moveSource

template <typename TSource, typename TSpec, typename TSource2, typename TPosition1, typename TPosition2> inline void moveSource(Gaps<TSource, TSpec> & me, TSource2 const & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_base.h"(936)
template <typename TSource, typename TSpec, typename TSource2> inline void moveSource(Gaps<TSource, TSpec> & me, TSource2 const & source_);       	// "projects/library/seqan/align/gaps_base.h"(950)

//____________________________________________________________________________
// moveValue

template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(373)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(382)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue & val);       	// "projects/library/seqan/align/align_iterator_base.h"(391)
template <typename TAlign, typename TSpec, typename TPosition, typename TValue> inline void moveValue(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_, TValue const & val);       	// "projects/library/seqan/align/align_iterator_base.h"(400)
template <typename TGaps, typename TSpec, typename TValue> inline void moveValue(Iter<TGaps, GapsIterator<TSpec> > & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(226)
template <typename TGaps, typename TSpec, typename TValue> inline void moveValue(Iter<TGaps, GapsIterator<TSpec> > const & me, TValue const & val);       	// "projects/library/seqan/align/gaps_iterator_base.h"(237)

//____________________________________________________________________________
// nextPosition

template <typename TValue, typename TSpec, typename TPosition> inline typename Position<Matrix <TValue, TSpec> >::Type nextPosition(Matrix<TValue, TSpec> & me, TPosition position_, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(253)

//____________________________________________________________________________
// operator!=

template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(261)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(269)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(277)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator!=(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(285)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator!= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1043)
template <typename TLeftSource, typename TLeftSpec, typename TRight > inline bool operator!=(Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1052)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator!= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1061)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator!= (Iter<TGaps1, GapsIterator<TSpec> > & _left, Iter<TGaps2, GapsIterator<TSpec> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(975)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator!= (Iter<TGaps1, GapsIterator<TSpec> > const & _left, Iter<TGaps2, GapsIterator<TSpec> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(983)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator!= (Iter<TGaps1, GapsIterator<TSpec> > & _left, Iter<TGaps2, GapsIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(990)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator!= (Iter<TGaps1, GapsIterator<TSpec> > const & _left, Iter<TGaps2, GapsIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(997)

//____________________________________________________________________________
// operator++

template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > & operator++(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(160)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > operator++(Iter<TAlign, AlignColIterator<TSpec> > & me, int);       	// "projects/library/seqan/align/align_iterator_base.h"(170)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const & operator++(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(91)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const operator++(Iter<TGaps, GapsIterator<TSpec> > const & me, int);       	// "projects/library/seqan/align/gaps_iterator_base.h"(100)
template <typename TSize, typename TSpec, typename TSpec2> inline Navi< AlignTrace<TSize, TSpec>, TSpec2> const & operator++ (Navi< AlignTrace<TSize, TSpec>, TSpec2> & me);       	// "projects/library/seqan/align/align_trace.h"(326)

//____________________________________________________________________________
// operator--

template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > & operator--(Iter<TAlign, AlignColIterator<TSpec> > & me);       	// "projects/library/seqan/align/align_iterator_base.h"(203)
template <typename TAlign, typename TSpec> inline Iter<TAlign, AlignColIterator<TSpec> > operator--(Iter<TAlign, AlignColIterator<TSpec> > & me, int);       	// "projects/library/seqan/align/align_iterator_base.h"(213)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const & operator--(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(112)
template <typename TGaps, typename TSpec> inline Iter<TGaps, GapsIterator<TSpec> > const operator--(Iter<TGaps, GapsIterator<TSpec> > const & me, int);       	// "projects/library/seqan/align/gaps_iterator_base.h"(121)
template <typename TSize, typename TSpec, typename TSpec2> inline Navi< AlignTrace<TSize, TSpec>, TSpec2> const & operator-- (Navi< AlignTrace<TSize, TSpec>, TSpec2> & me);       	// "projects/library/seqan/align/align_trace.h"(366)

//____________________________________________________________________________
// operator<

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator< (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1072)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator< (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1081)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator< (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1089)
template <typename TValue, typename TID> bool operator<(ScoreAndID<TValue,TID> & a, ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(75)
template <typename TValue, typename TID> bool operator<(const ScoreAndID<TValue,TID> & a, const ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(82)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSource, typename TSpec> inline TStream & operator<< (TStream & target, Align<TSource, TSpec> const & source);       	// "projects/library/seqan/align/align_base.h"(459)
template <typename TStream, typename TSource, typename TSpec> inline TStream & operator<< (TStream & target, Gaps<TSource, TSpec> const & source);       	// "projects/library/seqan/align/gaps_base.h"(987)

//____________________________________________________________________________
// operator<=

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator<= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1101)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator<= (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1110)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator<= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1118)

//____________________________________________________________________________
// operator==

inline bool operator== (_HirschbergSet const & lhs, _HirschbergSet const & rhs);       	// "projects/library/seqan/align/hirschberg_set.h"(287)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(226)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(234)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(242)
template <typename TAlign1, typename TAlign2, typename TSpec> inline bool operator==(Iter<TAlign1, AlignColIterator<TSpec> > const & _left, Iter<TAlign2, AlignColIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/align_iterator_base.h"(250)
template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator== (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1013)
template <typename TLeftSource, typename TLeftSpec, typename TRight > inline bool operator== (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1022)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator== (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1031)
template <typename TAlign> inline bool operator==(AlignCols<TAlign> const & left, AlignCols<TAlign> const & right);       	// "projects/library/seqan/align/align_cols_base.h"(410)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator== (Iter<TGaps1, GapsIterator<TSpec> > & _left, Iter<TGaps2, GapsIterator<TSpec> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(943)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator== (Iter<TGaps1, GapsIterator<TSpec> > const & _left, Iter<TGaps2, GapsIterator<TSpec> > & _right);       	// "projects/library/seqan/align/gaps_array.h"(951)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator== (Iter<TGaps1, GapsIterator<TSpec> > & _left, Iter<TGaps2, GapsIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(958)
template <typename TGaps1, typename TGaps2, typename TSpec> inline bool operator== (Iter<TGaps1, GapsIterator<TSpec> > const & _left, Iter<TGaps2, GapsIterator<TSpec> > const & _right);       	// "projects/library/seqan/align/gaps_array.h"(965)

//____________________________________________________________________________
// operator>

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator> (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1129)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator> (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1138)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator> (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1146)
template <typename TValue, typename TID> bool operator>(ScoreAndID<TValue,TID> & a, ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(59)
template <typename TValue, typename TID> bool operator>(const ScoreAndID<TValue,TID> & a, const ScoreAndID<TValue,TID> & b);       	// "projects/library/seqan/align/align_local_dynprog.h"(66)

//____________________________________________________________________________
// operator>=

template <typename TLeftSource, typename TLeftSpec, typename TRightSource, typename TRightSpec > inline bool operator>= (Gaps<TLeftSource, TLeftSpec> const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1157)
template <typename TLeftSource, typename TLeftSpec, typename TRight> inline bool operator>= (Gaps<TLeftSource, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/align/gaps_base.h"(1166)
template <typename TLeft, typename TRightSource, typename TRightSpec > inline bool operator>= (TLeft const & left, Gaps<TRightSource, TRightSpec> const & right);       	// "projects/library/seqan/align/gaps_base.h"(1174)

//____________________________________________________________________________
// previousPosition

template <typename TValue, typename TSpec, typename TPosition> inline typename Position<Matrix <TValue, TSpec> >::Type previousPosition(Matrix<TValue, TSpec> & me, TPosition position_, unsigned int dimension_);       	// "projects/library/seqan/align/matrix_base.h"(262)

//____________________________________________________________________________
// removeGap

template <typename TGaps, typename TSpec> inline void removeGap(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(149)
template <typename TSource, typename TSpec, typename TPosition> inline void removeGap(Gaps<TSource, TSpec> & me, TPosition _view_pos);       	// "projects/library/seqan/align/gaps_base.h"(416)

//____________________________________________________________________________
// removeGaps

template <typename TSource, typename TSpec, typename TPosition, typename TSize> inline void removeGaps(Gaps<TSource, TSpec> & me, TPosition _view_pos, TSize _size);       	// "projects/library/seqan/align/gaps_base.h"(444)
template <typename TGaps, typename TSpec, typename TCount> inline void removeGaps(Iter<TGaps, GapsIterator<TSpec> > const & me, TCount _size);       	// "projects/library/seqan/align/gaps_array.h"(888)

//____________________________________________________________________________
// removeValue

inline void removeValue(MiniGaps & me, unsigned int pos);       	// "projects/library/seqan/align/gaps_skiplist.h"(267)

//____________________________________________________________________________
// resize

template <typename TValue, typename TSpec> inline void resize(Matrix<TValue, TSpec> & me);       	// "projects/library/seqan/align/matrix_base.h"(224)

//____________________________________________________________________________
// row

template <typename TSource, typename TSpec, typename TPosition> inline typename Row< Align<TSource, TSpec> >::Type & row(Align<TSource, TSpec> & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(279)
template <typename TSource, typename TSpec, typename TPosition> inline typename Row< Align<TSource, TSpec> const>::Type & row(Align<TSource, TSpec> const & me, TPosition _pos);       	// "projects/library/seqan/align/align_base.h"(287)

//____________________________________________________________________________
// rows

template <typename TSource, typename TSpec> inline typename Rows< Align<TSource, TSpec> >::Type & rows(Align<TSource, TSpec> & me);       	// "projects/library/seqan/align/align_base.h"(246)
template <typename TSource, typename TSpec> inline typename Rows< Align<TSource, TSpec> const >::Type & rows(Align<TSource, TSpec> const & me);       	// "projects/library/seqan/align/align_base.h"(253)

//____________________________________________________________________________
// setBeginPosition

template <typename TSource, typename TPosition> inline void setBeginPosition(Gaps<TSource, ArrayGaps> & me, TPosition view_position);       	// "projects/library/seqan/align/gaps_array.h"(447)

//____________________________________________________________________________
// setBit

template <typename TSize, typename TSpec, typename TSpec2> inline void setBit(Navi< AlignTrace<TSize, TSpec>, TSpec2 > & me);       	// "projects/library/seqan/align/align_trace.h"(279)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename TSpec> inline void setContainer(Navi<TContainer, TSpec> & me, TContainer & container_);       	// "projects/library/seqan/align/align_trace.h"(260)

//____________________________________________________________________________
// setDimension

template <typename TValue, typename TSpec> inline void setDimension(Matrix<TValue, TSpec> & me, unsigned int dim_);       	// "projects/library/seqan/align/matrix_base.h"(179)
template <typename TSize, typename TSpec> inline unsigned int setDimension(AlignTrace<TSize, TSpec> & me, unsigned int _dim);       	// "projects/library/seqan/align/align_trace.h"(70)

//____________________________________________________________________________
// setHost

template <typename TAlign, typename TSpec> inline void setHost(Iter<TAlign, AlignColIterator<TSpec> > & me, TAlign & _host);       	// "projects/library/seqan/align/align_iterator_base.h"(112)

//____________________________________________________________________________
// setLength

template <typename TValue, typename TSpec, typename TSize> inline void setLength(Matrix<TValue, TSpec> & me, unsigned int dim_, TSize length_);       	// "projects/library/seqan/align/matrix_base.h"(212)
template <typename TSize, typename TSpec> inline void setLength(AlignTrace<TSize, TSpec> & me, unsigned int _dim, TSize _length);       	// "projects/library/seqan/align/align_trace.h"(91)

//____________________________________________________________________________
// setSource

template <typename TSource, typename TSpec, typename TPosition1, typename TPosition2> inline void setSource(Gaps<TSource, TSpec> & me, TSource & source_, TPosition1 source_begin_pos, TPosition2 source_end_pos);       	// "projects/library/seqan/align/gaps_base.h"(725)
template <typename TSource, typename TSpec> inline void setSource(Gaps<TSource, TSpec> & me, TSource & source_);       	// "projects/library/seqan/align/gaps_base.h"(739)

//____________________________________________________________________________
// setSourceBeginPosition

template <typename TSource, typename TPosition> inline void setSourceBeginPosition(Gaps<TSource, ArrayGaps> & me, TPosition source_position);       	// "projects/library/seqan/align/gaps_array.h"(464)

//____________________________________________________________________________
// setSourceEndPosition

template <typename TSource, typename TPosition> inline void setSourceEndPosition(Gaps<TSource, ArrayGaps> & me, TPosition source_position);       	// "projects/library/seqan/align/gaps_array.h"(531)

//____________________________________________________________________________
// smithWaterman

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue smithWaterman(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue> & sw_finder , Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(648)

//____________________________________________________________________________
// smithWatermanGetNext

template <typename TSource, typename TSpec, typename TScoreValue> TScoreValue smithWatermanGetNext(Align<TSource, TSpec> & align_, LocalAlignmentFinder<TScoreValue> & sw_finder , Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(700)

//____________________________________________________________________________
// smith_waterman_declump

template <typename TScoreValue, typename TSource, typename TSpec> void smith_waterman_declump(LocalAlignmentFinder<TScoreValue> & sw , Align<TSource, TSpec> & align_, Score<TScoreValue, Simple> const & score_);       	// "projects/library/seqan/align/align_local_dynprog.h"(286)

//____________________________________________________________________________
// smith_waterman_get_matrix

template <typename TScoreValue, typename TString> TScoreValue smith_waterman_get_matrix(LocalAlignmentFinder<TScoreValue> & sw, TString const & str1_, TString const & str2_, Score<TScoreValue, Simple> const & score_, TScoreValue cutoff);       	// "projects/library/seqan/align/align_local_dynprog.h"(174)

//____________________________________________________________________________
// smith_waterman_trace

template <typename TTargetSource, typename TTargetSpec, typename TScoreValue, typename TSourceSpec> typename Iterator<Matrix<TScoreValue, TSourceSpec>, Standard >::Type smith_waterman_trace(Align<TTargetSource, TTargetSpec> & target_, typename LocalAlignmentFinder<TScoreValue>::TBoolMatrix & fb_matrix, Iter< Matrix<TScoreValue, TSourceSpec>, PositionIterator > source_, Score<TScoreValue, Simple> const &);       	// "projects/library/seqan/align/align_local_dynprog.h"(481)

//____________________________________________________________________________
// source

template <typename TSource, typename TSpec> inline TSource & source(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(804)
template <typename TSource, typename TSpec> inline TSource & source(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(811)
template <typename TGaps, typename TSpec> inline typename Source<Iter<TGaps, GapsIterator<TSpec> > >::Type source(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_array.h"(679)
template <typename TGaps, typename TSpec> inline typename Source<Iter<TGaps, GapsIterator<TSpec> > >::Type source(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_array.h"(686)

//____________________________________________________________________________
// sourceBegin

template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<TSource, Tag<TTag> const>::Type sourceBegin(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(307)
template <typename TSource, typename TSpec> inline typename Iterator<TSource, typename DefaultGetIteratorSpec<TSource>::Type>::Type sourceBegin(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(314)

//____________________________________________________________________________
// sourceBeginPosition

template <typename TSource> inline typename Position<TSource>::Type sourceBeginPosition(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(193)

//____________________________________________________________________________
// sourceEnd

template <typename TSource, typename TSpec, typename TTag> inline typename Iterator<TSource, Tag<TTag> const>::Type sourceEnd(Gaps<TSource, TSpec> const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/align/gaps_base.h"(341)
template <typename TSource, typename TSpec> inline typename Iterator<TSource, typename DefaultGetIteratorSpec<TSource>::Type>::Type sourceEnd(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(348)

//____________________________________________________________________________
// sourceEndPosition

template <typename TSource> inline typename Position<TSource>::Type sourceEndPosition(Gaps<TSource, ArrayGaps> const & me);       	// "projects/library/seqan/align/gaps_array.h"(213)

//____________________________________________________________________________
// sourceLength

template <typename TSource> inline typename Size<TSource>::Type sourceLength(Gaps<TSource, ArrayGaps> & me);       	// "projects/library/seqan/align/gaps_array.h"(580)

//____________________________________________________________________________
// sourceSegment

template <typename TSource, typename TSpec> inline typename Infix<TSource>::Type sourceSegment(Gaps<TSource, TSpec> & me);       	// "projects/library/seqan/align/gaps_base.h"(835)
template <typename TSource, typename TSpec> inline typename Infix<TSource>::Type sourceSegment(Gaps<TSource, TSpec> const & me);       	// "projects/library/seqan/align/gaps_base.h"(843)

//____________________________________________________________________________
// toSourcePosition

template <typename TSource> inline typename Position<TSource>::Type toSourcePosition(Gaps<TSource, ArrayGaps> const & gaps, typename Position< Gaps<TSource, ArrayGaps> >::Type pos);       	// "projects/library/seqan/align/gaps_array.h"(307)

//____________________________________________________________________________
// toViewPosition

template <typename TSource> inline typename Position< Gaps<TSource, ArrayGaps> >::Type toViewPosition(Gaps<TSource, ArrayGaps> const & gaps, typename Position<TSource>::Type pos);       	// "projects/library/seqan/align/gaps_array.h"(270)

//____________________________________________________________________________
// value

template <typename TAlign, typename TSpec, typename TPosition> inline typename Reference<TAlign>::Type value(Iter<TAlign, AlignColIterator<TSpec> > & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(296)
template <typename TAlign, typename TSpec, typename TPosition> inline typename Reference<TAlign>::Type value(Iter<TAlign, AlignColIterator<TSpec> > const & me, TPosition pos_);       	// "projects/library/seqan/align/align_iterator_base.h"(304)
template <typename TGaps, typename TSpec> inline typename Reference< Iter<TGaps, GapsIterator<TSpec> > >::Type value(Iter<TGaps, GapsIterator<TSpec> > & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(160)
template <typename TGaps, typename TSpec> inline typename Reference< Iter<TGaps, GapsIterator<TSpec> > const>::Type value(Iter<TGaps, GapsIterator<TSpec> > const & me);       	// "projects/library/seqan/align/gaps_iterator_base.h"(168)
template <typename TValue, typename TSpec, typename TPosition> inline typename Reference<Matrix<TValue, TSpec> >::Type value(Matrix<TValue, TSpec> & me, TPosition position_);       	// "projects/library/seqan/align/matrix_base.h"(326)
template <typename TSource, typename TSpec, typename TPosition> inline typename Reference<Gaps<TSource, TSpec> >::Type value(Gaps<TSource, TSpec> & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(620)
template <typename TSource, typename TSpec, typename TPosition> inline typename Reference<Gaps<TSource, TSpec> const>::Type value(Gaps<TSource, TSpec> const & me, TPosition view_pos);       	// "projects/library/seqan/align/gaps_base.h"(629)
template <typename TAlign, typename TPosition> inline typename Value< AlignCols<TAlign> >::Type value(AlignCols<TAlign> & me, TPosition _pos);       	// "projects/library/seqan/align/align_cols_base.h"(261)
template <typename TAlign, typename TPosition> inline typename Value< AlignCols<TAlign> const>::Type value(AlignCols<TAlign> const & me, TPosition _pos);       	// "projects/library/seqan/align/align_cols_base.h"(269)

//____________________________________________________________________________
// write

template <typename TFile, typename TSource, typename TSpec, typename TIDString> inline void write(TFile & target, Align<TSource, TSpec> const & source, TIDString const &, Raw);       	// "projects/library/seqan/align/align_base.h"(384)
template <typename TFile, typename TSource, typename TIDString, typename TSpec> inline void write(TFile & target, Gaps<TSource, TSpec> const & source, TIDString const &, Raw);       	// "projects/library/seqan/align/gaps_base.h"(965)

//____________________________________________________________________________
// write_debug_matrix

template <typename TSource> void write_debug_matrix(TSource s1,TSource s2);       	// "projects/library/seqan/align/align_myers.h"(37)
template <typename TSource> void write_debug_matrix(TSource s1,TSource s2);       	// "projects/library/seqan/align/align_hirschberg.h"(15)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

