var DB = [
['Adaption', '(Glossary)', 'href="Page_Glossary.html#Glossary_Adaption" title="Functionality that allows to access built-in type or data types from external libraries in the same way as SeqAn classes.">'],
['Affine Gap Costs', '(Glossary)', 'href="Page_Glossary.html#Glossary_Affine Gap Costs" title="A scoring scheme that defines the score for a gap of length $n$ as $gap_open + (n-1)* gap_extend$.">'],
['Alignment', '(Glossary)', 'href="Page_Glossary.html#Glossary_Alignment" title="An arrangement of two or more sequences: Each character is connected to at most one character for each other sequence, and that the characters in each sequence are ordered in the same way as the connected characters in other sequences.">'],
['Blank', '(Glossary)', 'href="Page_Glossary.html#Glossary_Blank" title="One position within a @glos:gap@ area of an alignment.">'],
['Concept', '(Glossary)', 'href="Page_Glossary.html#Glossary_Concept" title="A kind of interface used in generic programmic that is not formulated in C++ but only a part of the documentation.">'],
['Gap', '(Glossary)', 'href="Page_Glossary.html#Glossary_Gap" title="A part of an @glos:alignment@ in which characters of one sequence are not aligned to characters of the other sequence.">'],
['Haystack', '(Glossary)', 'href="Page_Glossary.html#Glossary_Haystack" title="The sequence that is searched for @glos:needles@.">'],
['Index', '(Glossary)', 'href="Page_Glossary.html#Glossary_Index" title="A data structure for faster searching in sequences.">'],
['Linear Gap Costs', '(Glossary)', 'href="Page_Glossary.html#Glossary_Linear Gap Costs" title="A scoring scheme that defines the score for a gap to be proportional to the length of the gap.">'],
['Metafunction', '(Glossary)', 'href="Page_Glossary.html#Glossary_Metafunction" title=" A C++ construct that is used to determine types and constants at compile time.">'],
['Needle', '(Glossary)', 'href="Page_Glossary.html#Glossary_Needle" title="The sequence that is searched in the @glos:haystack@.">'],
['Scoring Scheme', '(Glossary)', 'href="Page_Glossary.html#Glossary_Scoring Scheme" title="A rule for calculating the similarity between two values or between a value and a @glos:blank@.">'],
['SeqAn', '(Glossary)', 'href="Page_Glossary.html#Glossary_SeqAn" title=" The C++ library for sequence analysis.">'],
['Specialization', '(Glossary)', 'href="Page_Glossary.html#Glossary_Specialization" title="A refinement of a class that was defined using @glos:Template Subclassing@.">'],
['Tag', '(Glossary)', 'href="Page_Glossary.html#Glossary_Tag" title="A type that acts as a switch when applied as argument to functions or @glos:Metafunction|metafunctions@.">'],
['Template Subclassing', '(Glossary)', 'href="Page_Glossary.html#Glossary_Template Subclassing" title="An alternative to inheritance for the refinement of classes that is based on class template specialization.">'],
['Trie', '(Glossary)', 'href="Page_Glossary.html#Glossary_Trie" title="A tree shaped automaton.">'],
['AAGroupsDayhoff', '(Spec)', 'href="Spec_AAGroupsDayhoff.html" title="Compressed amino acid alphabet (Dayhoff).">'],
['AAGroupsLiA10', '(Spec)', 'href="Spec_AAGroupsLiA10.html" title="Compressed amino acid alphabet (LiA10).">'],
['AAGroupsLiB10', '(Spec)', 'href="Spec_AAGroupsLiB10.html" title="Compressed amino acid alphabet (LiB10).">'],
['AAGroupsMurphy', '(Spec)', 'href="Spec_AAGroupsMurphy.html" title="Compressed amino acid alphabet (Murphy).">'],
['AAGroupsSeB10', '(Spec)', 'href="Spec_AAGroupsSeB10.html" title="Compressed amino acid alphabet (SeB10).">'],
['AAGroupsSeB14', '(Spec)', 'href="Spec_AAGroupsSeB14.html" title="Compressed amino acid alphabet (SeB14).">'],
['AAGroupsSeB6', '(Spec)', 'href="Spec_AAGroupsSeB6.html" title="Compressed amino acid alphabet (SeB6).">'],
['AAGroupsSeB8', '(Spec)', 'href="Spec_AAGroupsSeB8.html" title="Compressed amino acid alphabet (SeB8).">'],
['AAGroupsSeV10', '(Spec)', 'href="Spec_AAGroupsSeV10.html" title="Compressed amino acid alphabet (SeV10).">'],
['AAGroupsSolisD10', '(Spec)', 'href="Spec_AAGroupsSolisD10.html" title="Compressed amino acid alphabet (SolisD10).">'],
['AAGroupsSolisG10', '(Spec)', 'href="Spec_AAGroupsSolisG10.html" title="Compressed amino acid alphabet (SolisG10).">'],
['absFreqOfLettersInSeq', '(Function)', 'href="Function_absFreqOfLettersInSeq.html" title="Counts the number of times each residue of a fixed sequence alphabet occurs in a given sequence.">'],
['absFreqOfLettersInSetOfSeqs', '(Function)', 'href="Function_absFreqOfLettersInSetOfSeqs.html" title="Counts the number of times each residue of a fixed sequence alphabet occurs in a given set of sequences.">'],
['Adaptions', '', '<a target=_parent href="INDEXPAGE_Adaption.html">'],
['Adaptor Iterator', '(Spec)', 'href="Spec_Adaptor Iterator.html" title="Adapts iterators to Concept.Rooted Iterator.">'],
['addChild', '(Function)', 'href="Function_addChild.html" title="Adds a new child vertex to a parent vertex. Optionally a cargo can be attached to the parent-child edge.">'],
['addEdge', '(Function)', 'href="Function_addEdge.html" title="Adds a new edge to the graph, either with or without cargo.">'],
['addEdges', '(Function)', 'href="Function_addEdges.html" title="Shortcut to add multiple edges at once. Creates vertices implicitly.">'],
['addRef', '(Function)', 'href="Function_addRef.html" title="Called when dependency is added.">'],
['addValue', '(Function)', 'href="Function_addValue.html" title="Adds a value of a specific type to each element of a given Class.FrequencyDistribution object.">'],
['addVertex', '(Function)', 'href="Function_addVertex.html" title="Adds a new vertex to the graph.">'],
['Adjacency Iterator', '(Spec)', 'href="Spec_Adjacency Iterator.html" title="Adjacency iterator for Class.Graph.">'],
['adjustTop', '(Function)', 'href="Function_adjustTop.html" title="Adjusts the priority of the first item.">'],
['AhoCorasick', '(Spec)', 'href="Spec_AhoCorasick.html" title=" Multiple exact string matching using Aho-Corasick.">'],
['Align', '(Class)', 'href="Class_Align.html" title="An alignment of sequences.">'],
['AlignColIterator', '(Spec)', 'href="Spec_AlignColIterator.html" title="Iterator for Class.AlignCols pseudo container.">'],
['AlignCols', '(Class)', 'href="Class_AlignCols.html" title="Pseudo columns container for row-based alignment classes.">'],
['AlignConfig', '(Class)', 'href="Class_AlignConfig.html" title="The AlignConfig class encapsulates how DP is carried out. It indicates at what ends gaps are free, the so-called free ends-space alignments.">'],
['alignment', '(Function)', 'href="Function_alignment.html" title="Returns an alignment of the occurences of the Function.representative substring in the index text.">'],
['Alignment Graph', '(Spec)', 'href="Spec_Alignment Graph.html" title="An alignment graph.">'],
['Alignment Graph Format', '(Tag)', 'href="Tag_Alignment Graph Format.html" title="A file format to write an alignment graph.">'],
['Alignments', '(Page)', 'href="Page_Alignments.html" title="How to align sequences and managing alignments.">'],
['All Pairs Shortest Path', '(Demo)', 'href="Demo_All Pairs Shortest Path.html" title="Computing all-pairs shortest paths.">'],
['all_pairs_shortest_path', '(Function)', 'href="Function_all_pairs_shortest_path.html" title="Finds shortest paths between all pairs of vertices in a graph.">'],
['Alloc String', '(Spec)', 'href="Spec_Alloc String.html" title="Expandable string that is stored on heap.">'],
['allocate', '(Function)', 'href="Function_allocate.html" title="Allocates memory from heap.">'],
['Allocator', '(Class)', 'href="Class_Allocator.html" title="Manager for allocated memory.">'],
['Allocator', '(Concept)', 'href="Concept_Allocator.html" title="Object that manages memory allocation.">'],
['Allocator Usage', '(Tag)', 'href="Tag_Allocator Usage.html" title="The purpose of an allocated memory block.">'],
['Allocators', '(Demo)', 'href="Demo_Allocators.html" title="Examples for memory allocation.">'],
['AllowsFastRandomAccess', '(Metafunction)', 'href="Metafunction_AllowsFastRandomAccess.html" title="Determines whether a sequence efficiently supports random access.">'],
['Alphabet', '(Metafunction)', 'href="Metafunction_Alphabet.html" title="Access to the Alphabet type.">'],
['Alphabets', '(Demo)', 'href="Demo_Alphabets.html" title="Examples for common alphabets.">'],
['AminoAcid', '(Spec)', 'href="Spec_AminoAcid.html" title="Iupac code for amino acids.">'],
['Annotation', '(Class)', 'href="Class_Annotation.html" title="Class for annotating sequences.">'],
['append', '(Function)', 'href="Function_append.html" title="Concatenate two containers.">'],
['appendValue', '(Function)', 'href="Function_appendValue.html" title="Appends a value to a container.">'],
['Approximate Searching', '(Demo)', 'href="Demo_Approximate Searching.html" title="Approximate string matching.">'],
['areadAt', '(Function)', 'href="Function_areadAt.html" title="Asynchronously loads records from a specific position in a file.">'],
['aRequest', '(Class)', 'href="Class_aRequest.html" title="Associated with an asynchronous I/O request.">'],
['Array String', '(Spec)', 'href="Spec_Array String.html" title="Fast but non-expandable string.">'],
['arrayClearSpace', '(Function)', 'href="Function_arrayClearSpace.html" title="Destroys the begin of an array and keeps the rest.">'],
['arrayConstruct', '(Function)', 'href="Function_arrayConstruct.html" title="Construct objects in a given memory buffer.">'],
['arrayConstructCopy', '(Function)', 'href="Function_arrayConstructCopy.html" title="Copy constructs an array of objects into in a given memory buffer.">'],
['arrayConstructMove', '(Function)', 'href="Function_arrayConstructMove.html" title="Move constructs an array of objects into in a given memory buffer.">'],
['arrayCopy', '(Function)', 'href="Function_arrayCopy.html" title="Copies a range of objects into another range of objects.">'],
['arrayCopyBackward', '(Function)', 'href="Function_arrayCopyBackward.html" title="Copies a range of objects into another range of objects starting from the last element.">'],
['arrayCopyForward', '(Function)', 'href="Function_arrayCopyForward.html" title="Copies a range of objects into another range of objects starting from the first element.">'],
['arrayDestruct', '(Function)', 'href="Function_arrayDestruct.html" title="Destroys an array of objects.">'],
['arrayFill', '(Function)', 'href="Function_arrayFill.html" title="Assigns one object to each element of a range.">'],
['arrayMove', '(Function)', 'href="Function_arrayMove.html" title="Moves a range of objects into another range of objects.">'],
['arrayMoveBackward', '(Function)', 'href="Function_arrayMoveBackward.html" title="Moves a range of objects into another range of objects starting from the last element.">'],
['arrayMoveForward', '(Function)', 'href="Function_arrayMoveForward.html" title="Moves a range of objects into another range of objects starting from the first element.">'],
['assign', '(Function)', 'href="Function_assign.html" title="Assigns one object to another object.">'],
['assignCargo', '(Function)', 'href="Function_assignCargo.html" title="Assigns a new cargo to the edge.">'],
['assignNextS', '(Function)', 'href="Function_assignNextS.html" title="Assigns another EdgeStump to the next source pointer.">'],
['assignNextT', '(Function)', 'href="Function_assignNextT.html" title="Assigns another EdgeStump to the next target pointer.">'],
['assignProperty', '(Function)', 'href="Function_assignProperty.html" title="Assigns a property to an item in the property map.">'],
['assignRoot', '(Function)', 'href="Function_assignRoot.html" title="Assigns a new root vertex to the automaton.">'],
['assignSource', '(Function)', 'href="Function_Graph-23assignSource.html" title="Assigns a source vertex to an edge.">'],
['assignSource', '(Function)', 'href="Function_assignSource.html" title="Assigns the source to a new value.">'],
['assignStringSet', '(Function)', 'href="Function_assignStringSet.html" title="Assigns a new string set to an alignment graph.">'],
['assignTarget', '(Function)', 'href="Function_assignTarget.html" title="Assigns a target vertex to an edge.">'],
['assignValue', '(Function)', 'href="Function_assignValue.html" title="Assigns value to item.">'],
['assignValueById', '(Function)', 'href="Function_assignValueById.html" title="Adds a new string to the StringSet and returns an id.">'],
['Async', '(Spec)', 'href="Spec_Async.html" title="File structure supporting synchronous and asynchronous input/output access.">'],
['atBegin', '(Function)', 'href="Function_atBegin.html" title="Determines whether an iterator is at the beginning position.">'],
['atEnd', '(Function)', 'href="Function_atEnd.html" title="Determines whether an iterator is at the end position.">'],
['atNil', '(Function)', 'href="Function_atNil.html" title="Tests whether iterator is at nil position.">'],
['Automaton', '(Spec)', 'href="Spec_Automaton.html" title="An Automaton has directed edges, labeled with input symbols, and a distinct start state, called root. The input symbols require the use of a third parameter: The alphabet of the input symbols.">'],
['awriteAt', '(Function)', 'href="Function_awriteAt.html" title="Asynchronously saves records to a specific position in a file.">'],
['back', '(Function)', 'href="Function_back.html" title="The last item in container.">'],
['backgroundFrequency', '(Function)', 'href="Function_backgroundFrequency.html" title="Determines the background letter frequencies in a given dataset">'],
['begin', '(Function)', 'href="Function_begin.html" title="The begin of a container.">'],
['beginPosition', '(Function)', 'href="Function_beginPosition.html" title="Begin position of object in host.">'],
['beginRead', '(Function)', 'href="Function_beginRead.html" title="Initiates a read process.">'],
['beginWrite', '(Function)', 'href="Function_beginWrite.html" title="Initiates a write process.">'],
['Bellman-Ford Algorithm', '(Demo)', 'href="Demo_Bellman-Ford Algorithm.html" title="Computing single source shortest paths using Bellman-Ford algorithm.">'],
['bellman_ford_algorithm', '(Function)', 'href="Function_bellman_ford_algorithm.html" title="Computes shortest paths from a single source in a graph.">'],
['Bfs Iterator', '(Spec)', 'href="Spec_Bfs Iterator.html" title="Breath-first search iterator for Class.Graph.">'],
['binomialCoefficient', '(Function)', 'href="Function_binomialCoefficient.html" title="Calculates the binomial coefficient C(n,k).">'],
['BitsPerValue', '(Metafunction)', 'href="Metafunction_BitsPerValue.html" title="Number of bits needed to store a value.">'],
['Block String', '(Spec)', 'href="Spec_Block String.html" title="String optimized for push_back, top, and pop (Stack behaviour).">'],
['Blosum62', '(Shortcut)', 'href="Shortcut_Blosum62.html" title="Blosum62 scoring matrix.">'],
['BndmAlgo', '(Spec)', 'href="Spec_BndmAlgo.html" title=" Backward Nondeterministic Dawg Matching algorithm. Exact string matching using bit parallelism.">'],
['BomAlgo', '(Spec)', 'href="Spec_BomAlgo.html" title=" Backward Oracle Matching algorithm. Exact string matching using a factor oracle.">'],
['BottomUp Iterator', '(Spec)', 'href="Spec_BottomUp Iterator.html" title="Iterator for an efficient postorder depth-first search in a suffix tree.">'],
['Breadth-First Search', '(Demo)', 'href="Demo_Breadth-First Search.html" title="Breadth-first search through a graph.">'],
['breadth_first_search', '(Function)', 'href="Function_breadth_first_search.html" title="Implements a breadth-first search on a graph.">'],
['buildPam', '(Function)', 'href="Function_buildPam.html" title="Coordinates computation by invokating extrapolation, alphabet extension, rounding, scaling, type conversion and symmetrization.">'],
['Bundle2', '(Class)', 'href="Class_Bundle2.html" title="Stores references to two arbitrary objects.">'],
['bundle2', '(Function)', 'href="Function_bundle2.html" title="Returns a bundle of two objects.">'],
['Bundle3', '(Class)', 'href="Class_Bundle3.html" title="Stores references to three arbitrary objects.">'],
['bundle3', '(Function)', 'href="Function_bundle3.html" title="Returns a bundle of three objects.">'],
['Bundle5', '(Class)', 'href="Class_Bundle5.html" title="Stores references to five arbitrary objects.">'],
['bundle5', '(Function)', 'href="Function_bundle5.html" title="Returns a bundle of five objects.">'],
['bwtAt', '(Function)', 'href="Function_bwtAt.html" title="Shortcut for value(indexBWT(..), ..).">'],
['cancel', '(Function)', 'href="Function_cancel.html" title="Cancels an asynchronous request.">'],
['capacity', '(Function)', 'href="Function_capacity.html" title="The maximal length.">'],
['cargo', '(Function)', 'href="Function_cargo.html" title="Access to the cargo.">'],
['Cargo', '(Metafunction)', 'href="Metafunction_Cargo.html" title="Type of additional data stored in an object.">'],
['Caster', '(Spec)', 'href="Spec_Caster.html" title="Casts the input type in a specific output type.">'],
['chain', '(Function)', 'href="Function_chain.html" title="Computes the chain on a set of fragments.">'],
['Chained', '(Spec)', 'href="Spec_Chained.html" title="Splits a large file into a chain of smaller files.">'],
['char array', '(Adaption)', 'href="Adaption_char array.html" title="Zero terminated char[] or wchar_t[].">'],
['CharIterator', '(Shortcut)', 'href="Shortcut_CharIterator.html" title="Iterator for Shortcut.CharString.">'],
['CharString', '(Shortcut)', 'href="Shortcut_CharString.html" title="A string of char.">'],
['childAt', '(Function)', 'href="Function_childAt.html" title="Shortcut for value(indexChildTab(..), ..).">'],
['childrenAreLeaves', '(Function)', 'href="Function_childrenAreLeaves.html" title="Test whether iterator points to a node with only leaf-children.">'],
['childVertex', '(Function)', 'href="Function_childVertex.html" title="Returns the child vertex of an edge.">'],
['Chunk Pool Allocator', '(Spec)', 'href="Spec_Chunk Pool Allocator.html" title="Allocator that pools one or more consecutive memory blocks of a specific size.">'],
['Class Pool Allocator', '(Spec)', 'href="Spec_Class Pool Allocator.html" title="Allocator that pools memory blocks for a specific class.">'],
['Classes', '', '<a target=_parent href="INDEXPAGE_Class.html">'],
['clear', '(Function)', 'href="Function_Allocator-23clear.html" title="Deallocates all memory blocks.">'],
['clear', '(Function)', 'href="Function_clear.html" title="Resets an object.">'],
['clearEdges', '(Function)', 'href="Function_clearEdges.html" title="Removes all edges in a graph.">'],
['clearGaps', '(Function)', 'href="Function_clearGaps.html" title="Remove blanks from a gapped sequence.">'],
['clearVertices', '(Function)', 'href="Function_clearVertices.html" title="Removes all vertices in a graph.">'],
['close', '(Function)', 'href="Function_close.html" title="Closes a file.">'],
['CMode', '(Spec)', 'href="Spec_CMode.html" title=" Represents the C (&quot;constant&quot;) computation scheme for handling &quot;zero&quot; probabilities.">'],
['col', '(Function)', 'href="Function_col.html" title="A column in an alignment.">'],
['Col', '(Metafunction)', 'href="Metafunction_Col.html" title="Type of a column in an alignment.">'],
['collectLeaves', '(Function)', 'href="Function_collectLeaves.html" title="Returns all leaves underneath a given vertex.">'],
['cols', '(Function)', 'href="Function_cols.html" title="The container of columns in an alignment.">'],
['Cols', '(Metafunction)', 'href="Metafunction_Cols.html" title="Type of column container of an alignment.">'],
['Comparator', '(Metafunction)', 'href="Metafunction_Comparator.html" title="Type of comparator object">'],
['compare', '(Function)', 'href="Function_compare.html" title="Compares two objects.">'],
['CompareType', '(Metafunction)', 'href="Metafunction_CompareType.html" title="Type to convert other types for comparisons.">'],
['completeProfile', '(Function)', 'href="Function_completeProfile.html" title="Concatenates the background frequency with the profile for the motif component.">'],
['computeGenerousCapacity', '(Function)', 'href="Function_computeGenerousCapacity.html" title="Capacity for generous expansion.">'],
['ConcatDirect', '(Spec)', 'href="Spec_ConcatDirect.html" title="A string set storing the concatenation of all strings within one string.">'],
['Concepts', '', '<a target=_parent href="INDEXPAGE_Concept.html">'],
['Container', '(Concept)', 'href="Concept_Container.html" title="Object that contains other objects.">'],
['container', '(Function)', 'href="Function_container.html" title="Container of an iterator.">'],
['Container', '(Metafunction)', 'href="Metafunction_Container.html" title="Type of the container given an iterator.">'],
['convert', '(Function)', 'href="Function_convert.html" title="Converts a value into another value.">'],
['Convert', '(Metafunction)', 'href="Metafunction_Convert.html" title="Return type of a conversion.">'],
['convertAlignment', '(Function)', 'href="Function_convertAlignment.html" title="Converts an alignment graph into an alignment matrix.">'],
['convertImpl', '(Function)', 'href="Function_convertImpl.html" title="Implements Function.convert.">'],
['convertPatternToProfile', '(Function)', 'href="Function_convertPatternToProfile.html" title="Converts a pattern into a profile which consists of a set of frequency distributions.">'],
['convertResidueToFrequencyDist', '(Function)', 'href="Function_convertResidueToFrequencyDist.html" title="Coverts a residue to a frequency distribution (profile).">'],
['convertSetOfPatternsToProfile', '(Function)', 'href="Function_convertSetOfPatternsToProfile.html" title="Converts a set of sequence patterns into a profile.">'],
['countChildren', '(Function)', 'href="Function_countChildren.html" title="Count the number of children of a tree node.">'],
['Counter', '(Spec)', 'href="Spec_Counter.html" title="Extends the input stream by a second field which enumerates the elements.">'],
['countGaps', '(Function)', 'href="Function_countGaps.html" title="Count blanks at a specific position in a gapped sequence.">'],
['Counting IdManager', '(Spec)', 'href="Spec_Counting IdManager.html" title="Id Manager that just counts the number of ids in use.">'],
['countOccurrences', '(Function)', 'href="Function_countOccurrences.html" title="Returns the number of occurences of Function.representative in the index text.">'],
['create', '(Function)', 'href="Function_create.html" title="Makes an object to owner of its content.">'],
['createBWTable', '(Function)', 'href="Function_createBWTable.html" title="Creates a Burrows-Wheeler table from a given text and suffix array.">'],
['createChildTable', '(Function)', 'href="Function_createChildTable.html" title="Creates a child table from a given lcp table.">'],
['createCountArray', '(Function)', 'href="Function_createCountArray.html" title="Builds an index on a StringSet storing how often a q-gram occurs in each sequence.">'],
['createLCPTable', '(Function)', 'href="Function_createLCPTable.html" title="Creates a lcp table from a given text and suffix array.">'],
['createOracle', '(Function)', 'href="Function_createOracle.html" title="Creates a factor oracle.">'],
['createOracleOnReverse', '(Function)', 'href="Function_createOracleOnReverse.html" title="Creates a factor oracle for the reversed string.">'],
['createQGramIndex', '(Function)', 'href="Function_createQGramIndex.html" title="Builds a q-gram index on a sequence.">'],
['createQGramIndexDirOnly', '(Function)', 'href="Function_createQGramIndexDirOnly.html" title="Builds the directory of a q-gram index on a sequence.">'],
['createQGramIndexSAOnly', '(Function)', 'href="Function_createQGramIndexSAOnly.html" title="Builds the suffix array of a q-gram index on a sequence.">'],
['createRoot', '(Function)', 'href="Function_createRoot.html" title="Creates the root in a tree or an automaton.">'],
['createSource', '(Function)', 'href="Function_createSource.html" title="Creates a new source.">'],
['createSuffixArray', '(Function)', 'href="Function_createSuffixArray.html" title="Creates a suffix array from a given text.">'],
['createTrie', '(Function)', 'href="Function_createTrie.html" title="Creates a trie.">'],
['createTrieOnReverse', '(Function)', 'href="Function_createTrieOnReverse.html" title="Creates a trie for all reversed keywords.">'],
['CStyle String', '(Spec)', 'href="Spec_CStyle String.html" title="Allows adaption of strings to C-style strings.">'],
['dag_shortest_path', '(Function)', 'href="Function_dag_shortest_path.html" title="Computes shortest paths from a single source in a directed acyclic graph (DAG).">'],
['dddoc', '(Page)', 'href="Page_dddoc.html" title="The documentation system &quot;dot-dot-doc&quot;.">'],
['deallocate', '(Function)', 'href="Function_deallocate.html" title="Deallocates memory.">'],
['DeepestSpec', '(Metafunction)', 'href="Metafunction_DeepestSpec.html" title="The deepest spec of a class with nested template arguments.">'],
['Default', '(Tag)', 'href="Tag_Default.html" title="Tag that specifies default behavior.">'],
['DefaultFinder', '(Metafunction)', 'href="Metafunction_DefaultFinder.html" title="Default Class.Finder specialization type.">'],
['DefaultGetIteratorSpec', '(Metafunction)', 'href="Metafunction_DefaultGetIteratorSpec.html" title="Specifies default kind of iterator returned by functions.">'],
['DefaultIndexCreator', '(Metafunction)', 'href="Metafunction_DefaultIndexCreator.html" title="Default algorithm to create a demanded and not yet existing Metafunction.Fibre.">'],
['DefaultIndexSpec', '(Metafunction)', 'href="Metafunction_DefaultIndexSpec.html" title="Default Class.Index specialization type.">'],
['DefaultIndexStringSpec', '(Metafunction)', 'href="Metafunction_DefaultIndexStringSpec.html" title="Default Class.String specialization type of the Metafunction.Fibre of an Class.Index.">'],
['DefaultIteratorSpec', '(Metafunction)', 'href="Metafunction_DefaultIteratorSpec.html" title="Specifies default kind of iterator.">'],
['DefaultOverflowExplicit', '(Metafunction)', 'href="Metafunction_DefaultOverflowExplicit.html" title="The default overflow strategy for explicit resize.">'],
['DefaultOverflowImplicit', '(Metafunction)', 'href="Metafunction_DefaultOverflowImplicit.html" title="The default overflow strategy for implicit resize.">'],
['DefaultPattern', '(Metafunction)', 'href="Metafunction_DefaultPattern.html" title="Default Class.Pattern specialization type.">'],
['DefaultPrefixOrder', '(Metafunction)', 'href="Metafunction_DefaultPrefixOrder.html" title="The default prefix order.">'],
['degree', '(Function)', 'href="Function_degree.html" title="Number of incident edges for a given vertex.">'],
['dependent', '(Function)', 'href="Function_dependent.html" title="Test whether object depends on other objects.">'],
['Dependent', '(Spec)', 'href="Spec_Dependent.html" title="A string set storing references of the strings.">'],
['dependentSource', '(Function)', 'href="Function_dependentSource.html" title="Test if object depends from it\'s source.">'],
['Depth-First Search', '(Demo)', 'href="Demo_Depth-First Search.html" title=" Depth-first search through a graph.">'],
['depth_first_search', '(Function)', 'href="Function_depth_first_search.html" title="Implements a depth-first search on a graph.">'],
['detach', '(Function)', 'href="Function_detach.html" title="Makes an object independent from other objects.">'],
['determineConsensusSeq', '(Function)', 'href="Function_determineConsensusSeq.html" title="Determines the consensus pattern of a given profile.">'],
['Dfs Preorder Iterator', '(Spec)', 'href="Spec_Dfs Preorder Iterator.html" title="Depth-first search iterator for Class.Graph.">'],
['difference', '(Function)', 'href="Function_difference.html" title="The difference between two iterators.">'],
['Difference', '(Metafunction)', 'href="Metafunction_Difference.html" title="Type of an object that stores the difference between two iterators.">'],
['dijkstra', '(Function)', 'href="Function_dijkstra.html" title="Computes shortest paths from a single source in a graph.">'],
['Dijkstras Algorithm', '(Demo)', 'href="Demo_Dijkstras Algorithm.html" title="Computing single source shortest paths using Dijkstra algorithm.">'],
['dirAt', '(Function)', 'href="Function_dirAt.html" title="Shortcut for value(indexDir(..), ..).">'],
['Directed graph', '(Spec)', 'href="Spec_Directed graph.html" title="A directed graph that stores the edges in an adjacency list.">'],
['display', '(Function)', 'href="Function_display.html" title="Displays a given set of strings.">'],
['displayResult', '(Function)', 'href="Function_displayResult.html" title="Displays all found motif candidates. In the case of the Projection Motif Finder           the function displays the consensus pattern of the found motif candidate.">'],
['Distance Calculation', '(Tag)', 'href="Tag_Distance Calculation.html" title="A tag to specify how to calculate distance matrices.">'],
['Dna', '(Spec)', 'href="Spec_Dna.html" title="Alphabet for DNA.">'],
['Dna5', '(Spec)', 'href="Spec_Dna5.html" title="Alphabet for DNA including \'N\' character.">'],
['Dna5Iterator', '(Shortcut)', 'href="Shortcut_Dna5Iterator.html" title="Iterator for Shortcut.Dna5String.">'],
['Dna5String', '(Shortcut)', 'href="Shortcut_Dna5String.html" title="A string of Spec.Dna5.">'],
['Dna5StringComplement', '(Shortcut)', 'href="Shortcut_Dna5StringComplement.html" title="Modifier for the complement of a Shortcut.Dna5String.">'],
['Dna5StringReverse', '(Shortcut)', 'href="Shortcut_Dna5StringReverse.html" title="Modifier for the reverse of a Shortcut.Dna5String.">'],
['Dna5StringReverseComplement', '(Shortcut)', 'href="Shortcut_Dna5StringReverseComplement.html" title="Modifier for the reverse complement of a Shortcut.Dna5String.">'],
['DnaIterator', '(Shortcut)', 'href="Shortcut_DnaIterator.html" title="Iterator for Shortcut.DnaString.">'],
['DnaString', '(Shortcut)', 'href="Shortcut_DnaString.html" title="A string of Spec.Dna.">'],
['DnaStringComplement', '(Shortcut)', 'href="Shortcut_DnaStringComplement.html" title="Modifier for the complement of a Shortcut.DnaString.">'],
['DnaStringReverse', '(Shortcut)', 'href="Shortcut_DnaStringReverse.html" title="Modifier for the reverse of a Shortcut.DnaString.">'],
['DnaStringReverseComplement', '(Shortcut)', 'href="Shortcut_DnaStringReverseComplement.html" title="Modifier for the reverse complement of a Shortcut.DnaString.">'],
['DotDrawing', '(Tag)', 'href="Tag_DotDrawing.html" title="Switch to trigger drawing in dot format.">'],
['DPSearch', '(Spec)', 'href="Spec_DPSearch.html" title="A dynamic programming algorithm for approximate string-matching with a user-definable scoring function.">'],
['Echoer', '(Spec)', 'href="Spec_Echoer.html" title="Outputs tuples of the echoRepeats last elements of the input stream.">'],
['Edge Iterator', '(Spec)', 'href="Spec_Edge Iterator.html" title="Edge iterator for Class.Graph.">'],
['EdgeDescriptor', '(Metafunction)', 'href="Metafunction_EdgeDescriptor.html" title="Type of an object that represents an edge descriptor.">'],
['EdgeIdHandler', '(Metafunction)', 'href="Metafunction_EdgeIdHandler.html" title="Type of an object that represents an Id Manager.">'],
['EdgeStump', '(Class)', 'href="Class_EdgeStump.html" title="The EdgeStump class encapsulates a single edge. It represents either a list node in the adjacency list of a graph or an array field if edges are stored in an array.">'],
['EdgeType', '(Metafunction)', 'href="Metafunction_EdgeType.html" title="Edge type of a graph object.">'],
['EditEnvironment', '(Spec)', 'href="Spec_EditEnvironment.html" title="Outputs tuples of the tupleLen consecutive elements of the input stream.">'],
['em', '(Function)', 'href="Function_em.html" title="Represents the EM algorithm as used by MEME.">'],
['empty', '(Function)', 'href="Function_empty.html" title="Test a container for being empty.">'],
['EmptyEdges', '(Tag)', 'href="Tag_EmptyEdges.html" title="Consider a suffix tree with leaves for every suffix.">'],
['emptySource', '(Function)', 'href="Function_emptySource.html" title="Test if there is a source.">'],
['end', '(Function)', 'href="Function_end.html" title="The end of a container.">'],
['endPosition', '(Function)', 'href="Function_endPosition.html" title="End position of object in host.">'],
['endRead', '(Function)', 'href="Function_endRead.html" title="Terminates a read process.">'],
['endWrite', '(Function)', 'href="Function_endWrite.html" title="Terminates a write process.">'],
['EPatternBranching', '(Spec)', 'href="Spec_EPatternBranching.html" title=" Represents the ePatternBranching algorithm of Davila and Rajasekaran.">'],
['erase', '(Function)', 'href="Function_erase.html" title="Erases a part of a container">'],
['ESA Index Fibres', '(Tag)', 'href="Tag_ESA Index Fibres.html" title="Tag to select a specific fibre (e.g. table, object, ...) of an Spec.Index_ESA.ESA index.">'],
['Exact Searching', '(Demo)', 'href="Demo_Exact Searching.html" title="Exact string matching.">'],
['Examples', '', '<a target=_parent href="INDEXPAGE_Demo.html">'],
['External Property Map', '(Class)', 'href="Class_External Property Map.html" title="An external property map.">'],
['External String', '(Spec)', 'href="Spec_External String.html" title="String that is stored in external memory.">'],
['ExternalConfig', '(Tag)', 'href="Tag_ExternalConfig.html" title="Standard configuration for the Spec.External String.">'],
['ExternalConfigLarge', '(Tag)', 'href="Tag_ExternalConfigLarge.html" title="Large size type configuration for the Spec.External String.">'],
['ExternalConfigSize', '(Tag)', 'href="Tag_ExternalConfigSize.html" title="Arbitrary size type configuration for the Spec.External String.">'],
['factorial', '(Function)', 'href="Function_factorial.html" title="Calculates the factorial value of any integer number.">'],
['Fibre', '(Metafunction)', 'href="Metafunction_Fibre.html" title="Type of a specific bundle member (fibre).">'],
['File', '(Class)', 'href="Class_File.html" title="Represents a file.">'],
['File Format', '(Tag)', 'href="Tag_File Format.html" title="A file format.">'],
['File Format I/O', '(Demo)', 'href="Demo_File Format I-2FO.html" title="Accessing sequence data in files.">'],
['File Reader String', '(Spec)', 'href="Spec_File Reader String.html" title="Read sequence data from file.">'],
['FileFormat', '(Class)', 'href="Class_FileFormat.html" title="Object that stores a file format.">'],
['Files', '(Page)', 'href="Page_Files.html" title="File Input/Output.">'],
['fill', '(Function)', 'href="Function_fill.html" title="Resizes and fills a container.">'],
['Filter', '(Spec)', 'href="Spec_Filter.html" title="Applies a specific function to the input stream.">'],
['find', '(Function)', 'href="Function_find.html" title="Search for a Class.Pattern in a Class.Finder object.">'],
['findEdge', '(Function)', 'href="Function_findEdge.html" title="Finds an edge.">'],
['Finder', '(Class)', 'href="Class_Finder.html" title="Holds the haystack and a current search context.">'],
['Finder', '(Concept)', 'href="Concept_Finder.html" title="Object that stores information about the glos:haystack of a search and the current search position.">'],
['findMotif', '(Function)', 'href="Function_findMotif.html" title="Represents the main function which is used to start the search for noticeable motif patterns.">'],
['findVertex', '(Function)', 'href="Function_findVertex.html" title="Finds a vertex given a sequence id and a position.">'],
['FixedGappedShape', '(Spec)', 'href="Spec_FixedGappedShape.html" title="A fixed gapped shape.">'],
['FixedShape', '(Spec)', 'href="Spec_FixedShape.html" title="A fixed length ungapped shape (also called q-gram or k-mer).">'],
['Floyd-Warshall Algorithm', '(Demo)', 'href="Demo_Floyd-Warshall Algorithm.html" title="Computing all-pairs shortest paths using Floyd-Warshall algorithm.">'],
['floyd_warshall', '(Function)', 'href="Function_floyd_warshall.html" title="Finds shortest paths between all pairs of vertices in a graph.">'],
['flush', '(Function)', 'href="Function_flush.html" title="Waits for all open requests to complete.">'],
['ford_fulkerson', '(Function)', 'href="Function_ford_fulkerson.html" title="Computes a maximum flow in a directed graph.">'],
['Fragment', '(Class)', 'href="Class_Fragment.html" title="Data structure which represents an fragment">'],
['fragmentBegin', '(Function)', 'href="Function_fragmentBegin.html" title="Gets the begin position for this vertex descriptor in the sequence.">'],
['fragmentLength', '(Function)', 'href="Function_fragmentLength.html" title="Gets the length of the label of a given vertex descriptor in the sequence.">'],
['FrequencyDistribution', '(Class)', 'href="Class_FrequencyDistribution.html" title="Holds a collection of objects of a specific type, where each object represents           the frequency (absolute or relative probability) of a particular residue which is a member     of a fixed sequence alphabet.">'],
['front', '(Function)', 'href="Function_Container-23front.html" title="The first item in container.">'],
['front', '(Function)', 'href="Function_Pipelining-23front.html" title="Gets the first element of the remaining stream.">'],
['Functions', '', '<a target=_parent href="INDEXPAGE_Function.html">'],
['FunctorComplement', '(Class)', 'href="Class_FunctorComplement.html" title="Functor that returns the complement nucleotide to a given nucleotide.">'],
['FunctorConvert', '(Class)', 'href="Class_FunctorConvert.html" title="Functor that converts a TInValue type to a TOutValue type character.">'],
['FunctorLowcase', '(Class)', 'href="Class_FunctorLowcase.html" title="Functor that returns the lower case character to a given character.">'],
['FunctorUpcase', '(Class)', 'href="Class_FunctorUpcase.html" title="Functor that returns the upper case character to a given character.">'],
['GappedShape', '(Spec)', 'href="Spec_GappedShape.html" title="A variable gapped shape.">'],
['Gaps', '(Class)', 'href="Class_Gaps.html" title="Stores the gaps in a gapped sequences.">'],
['gapValue', '(Function)', 'href="Function_gapValue.html" title="Returns reference to a value that is used as gap character.">'],
['gapValueImpl', '(Function)', 'href="Function_gapValueImpl.html" title="Implements Function.gapValue.">'],
['getAdjacencyMatrix', '(Function)', 'href="Function_getAdjacencyMatrix.html" title="Returns an adjacency matrix representation of the graph.">'],
['getCargo', '(Function)', 'href="Function_getCargo.html" title="Get method for the edge cargo.">'],
['getDist', '(Function)', 'href="Function_getDist.html" title="returns the distance on which PAM matrix computation is based.">'],
['getEntropy', '(Function)', 'href="Function_getEntropy.html" title="returns entropy of the PAM matrix.">'],
['getFibre', '(Function)', 'href="Function_getFibre.html" title="Returns a specific Metafunction.Fibre of an Class.Index object.">'],
['getFirstCoveredPosition', '(Function)', 'href="Function_getFirstCoveredPosition.html" title="Finds the first position in a sequence that is not assigned to a nil vertex.">'],
['getFrequency', '(Function)', 'href="Function_getFrequency.html" title="Returns the number of sequences, which contain the Function.representative as a substring.">'],
['getIdLowerBound', '(Function)', 'href="Function_getIdLowerBound.html" title="Returns the smallest distributed id. That is, the return value is guaranteed to be the smallest id obtained so far.">'],
['getIdUpperBound', '(Function)', 'href="Function_getIdUpperBound.html" title="Returns the largest distributed id plus 1. That is, the return value is guaranteed to be an upper bound on all distributed ids.">'],
['getInfinity', '(Function)', 'href="Function_getInfinity.html" title="Utility function returning a value that represents infinity. Useful for various graph algorithms, e.g., Dijkstra.">'],
['getInfinityDistance', '(Function)', 'href="Function_getInfinityDistance.html" title="Utility function for various graph algorithms. The infinity distance can be used to indicate not reachable, e.g., in shortest path problem.">'],
['getLastCoveredPosition', '(Function)', 'href="Function_getLastCoveredPosition.html" title="Finds the last position in a sequence that is not assigned to a nil vertex.">'],
['getNextS', '(Function)', 'href="Function_getNextS.html" title="Get method for the next source pointer.">'],
['getNextT', '(Function)', 'href="Function_getNextT.html" title="Get method for the next target pointer.">'],
['getNil', '(Function)', 'href="Function_getNil.html" title="Utility function returning a value that represents nil. Useful for various graph algorithms, e.g., missing predecessors, vertices that have not been visited, etc.">'],
['getNilPredecessor', '(Function)', 'href="Function_getNilPredecessor.html" title="Utility function for various graph algorithms.">'],
['getOccurrence', '(Function)', 'href="Function_getOccurrence.html" title="Returns an occurence of the Function.representative substring in the index text.">'],
['getOccurrences', '(Function)', 'href="Function_getOccurrences.html" title="Returns all occurences of the Function.representative substring in the index text.">'],
['getOccurrencesBWT', '(Function)', 'href="Function_getOccurrencesBWT.html" title="Returns the characters left beside all occurence of the Function.representative substring in the index text.">'],
['getProjectedPosition', '(Function)', 'href="Function_getProjectedPosition.html" title="Finds the projected position given a sequence id and a position. Works only on alignment graphs of two sequences (Pairwise alignment).">'],
['getProperty', '(Function)', 'href="Function_getProperty.html" title="Get method for an item\'s property.">'],
['getRoot', '(Function)', 'href="Function_getRoot.html" title="Get method for the root of a tree or an automaton.">'],
['getScale', '(Function)', 'href="Function_getScale.html" title="Access function returning the distance dependent scaling factor used for PAM matrix computation">'],
['getScore', '(Function)', 'href="Function_getScore.html" title="Score of the last found match in approximate searching.">'],
['getSeqNo', '(Function)', 'href="Function_getSeqNo.html" title="Returns the sequence number of a position.">'],
['getSeqOffset', '(Function)', 'href="Function_getSeqOffset.html" title="Returns the local sequence offset of a position.">'],
['getSource', '(Function)', 'href="Function_getSource.html" title="Get method for the source.">'],
['getStringSet', '(Function)', 'href="Function_getStringSet.html" title="Gets the string set of an alignment graph.">'],
['getSuccessor', '(Function)', 'href="Function_getSuccessor.html" title="Gets the successor for a given vertex and an edge label. For an automaton a single character is required whereas for a word graph getSuccessor takes a string.">'],
['getTarget', '(Function)', 'href="Function_getTarget.html" title="Get method for the target.">'],
['getValue', '(Function)', 'href="Function_getValue.html" title="Access to the value.">'],
['GetValue', '(Metafunction)', 'href="Metafunction_GetValue.html" title="Type for reading values.">'],
['getValueById', '(Function)', 'href="Function_getValueById.html" title="Retrieves a string from the StringSet given an id.">'],
['GetVSTreeIteratorTraits', '(Metafunction)', 'href="Metafunction_GetVSTreeIteratorTraits.html" title="Default behaviour of Function.goNext when no second parameter is given.">'],
['Global Alignment Algorithms', '(Tag)', 'href="Tag_Global Alignment Algorithms.html" title="Global alignment algorithm used by globalAlignment.">'],
['Global Alignments', '(Demo)', 'href="Demo_Global Alignments.html" title="Computing an optimal global alignment between two sequences.">'],
['globalAlignment', '(Function)', 'href="Function_globalAlignment.html" title="Computes the best global alignment of the two sequences.">'],
['Glossary', '(Page)', 'href="Page_Glossary.html" title="List of terms used in SeqAn">'],
['goBegin', '(Function)', 'href="Function_goBegin.html" title="Iterates to the first position of a container.">'],
['goDown', '(Function)', 'href="Function_goDown.html" title="Iterates down one edge or a path in a tree.">'],
['goEnd', '(Function)', 'href="Function_goEnd.html" title="Iterates to the first position of a container.">'],
['goFurther', '(Function)', 'href="Function_goFurther.html" title="Iterates some steps further.">'],
['goNext', '(Function)', 'href="Function_goNext.html" title="Iterates to next position.">'],
['goNil', '(Function)', 'href="Function_goNil.html" title="Moves iterator to nil position.">'],
['goPrevious', '(Function)', 'href="Function_goPrevious.html" title="Iterates to pevious position.">'],
['goRight', '(Function)', 'href="Function_goRight.html" title="Iterates to the next sibling in a tree.">'],
['Gotohs Algorithm', '(Demo)', 'href="Demo_Gotohs Algorithm.html" title="Gotoh alignment code example">'],
['goUp', '(Function)', 'href="Function_goUp.html" title="Iterates up one edge to the parent in a tree.">'],
['Graph', '(Class)', 'href="Class_Graph.html" title="Generic graph.">'],
['Graph Iterator', '(Tag)', 'href="Tag_Graph Iterator.html" title="A specification of the iterator to traverse a graph.">'],
['Graphs', '(Page)', 'href="Page_Graphs.html" title="Graphs in SeqAn.">'],
['guessFileFormat', '(Function)', 'href="Function_guessFileFormat.html" title="Tries to determine the format of a file.">'],
['Guide Tree Configurator', '(Tag)', 'href="Tag_Guide Tree Configurator.html" title="A tag to configure the guide tree construction.">'],
['hammingDistance', '(Function)', 'href="Function_hammingDistance.html" title="Determines the Hamming distance between two sequences.">'],
['HammingDistance', '(Tag)', 'href="Tag_HammingDistance.html" title="Switch to trigger Hamming distance, which is a measure of character substitutions.">'],
['HardwiredShape', '(Class)', 'href="Class_HardwiredShape.html" title="A structure to define a fixed gapped shape.">'],
['hash', '(Function)', 'href="Function_hash.html" title="Computes a (lower) hash value for a shape applied to a sequence.">'],
['hash2', '(Function)', 'href="Function_hash2.html" title="Computes a unique hash value of a shape, even if it is shorter than its span.">'],
['hash2Next', '(Function)', 'href="Function_hash2Next.html" title="Computes a unique hash value for the adjacent shape, even if it is shorter than q.">'],
['hashNext', '(Function)', 'href="Function_hashNext.html" title="Computes the hash value for the adjacent shape.">'],
['hashUpper', '(Function)', 'href="Function_hashUpper.html" title="Computes an upper hash value for a shape applied to a sequence.">'],
['hasPrefix', '(Function)', 'href="Function_hasPrefix.html" title="Test whether a sequence is prefix of another sequence.">'],
['haystack', '(Function)', 'href="Function_haystack.html" title="Returns the haystack of a Class.Finder object.">'],
['Haystack', '(Metafunction)', 'href="Metafunction_Haystack.html" title="Returns the haystack type of a Class.Finder type.">'],
['Heaviest Increasing Subsequence', '(Demo)', 'href="Demo_Heaviest Increasing Subsequence.html" title="Heaviest increasing subsequence code example">'],
['heaviestIncreasingSubsequence', '(Function)', 'href="Function_heaviestIncreasingSubsequence.html" title="Computes the heaviest increasing subsequence.">'],
['Heuristic Matching', '(Demo)', 'href="Demo_Heuristic Matching.html" title="Path-growing code example">'],
['HideEmptyEdges', '(Tag)', 'href="Tag_HideEmptyEdges.html" title="Consider a suffix tree with no empty edges (default behaviour).">'],
['Hirschbergs Algorithm', '(Demo)', 'href="Demo_Hirschbergs Algorithm.html" title="Hirschberg with Gotoh alignment code example">'],
['Holder', '(Class)', 'href="Class_Holder.html" title="Manages relationship to another object.">'],
['Holder', '(Memfunc)', 'href="Memfunc_Holder.html" title="Constructor">'],
['Horspool', '(Spec)', 'href="Spec_Horspool.html" title=" Exact string matching using Horspool\'s algorithm (1980).">'],
['host', '(Function)', 'href="Function_host.html" title="The object a given object depends on.">'],
['Host', '(Metafunction)', 'href="Metafunction_Host.html" title="Type of the object a given object depends on.">'],
['hostGraph', '(Function)', 'href="Function_hostGraph.html" title="The graph this iterator is working on.">'],
['i1', '(Memvar)', 'href="Memvar_Pair-23i1.html" title="T1 object">'],
['i1', '(Memvar)', 'href="Memvar_Triple-23i1.html" title="T1 object">'],
['i2', '(Memvar)', 'href="Memvar_Pair-23i2.html" title="T2 object">'],
['i2', '(Memvar)', 'href="Memvar_Triple-23i2.html" title="T2 object">'],
['i3', '(Memvar)', 'href="Memvar_Triple-23i3.html" title="T3 object">'],
['id', '(Function)', 'href="Function_id.html" title="A value that identifies the underlying sequence.">'],
['Id', '(Metafunction)', 'href="Metafunction_Id.html" title="Type of an object that represents an id.">'],
['idCount', '(Function)', 'href="Function_idCount.html" title="Determines the number of ids that were obtained.">'],
['idInUse', '(Function)', 'href="Function_idInUse.html" title="Checks whether the given id is in use or not.">'],
['IdManager', '(Class)', 'href="Class_IdManager.html" title="Id manager that provides unique ids for vertices and edges.">'],
['idToPosition', '(Function)', 'href="Function_idToPosition.html" title="Retrieves the position of a string in the StringSet given an id.">'],
['in1', '(Memvar)', 'href="Memvar_Bundle2-23in1.html" title="TInput1 reference">'],
['in1', '(Memvar)', 'href="Memvar_Bundle3-23in1.html" title="TInput1 reference">'],
['in1', '(Memvar)', 'href="Memvar_Bundle5-23in1.html" title="TInput1 reference">'],
['in2', '(Memvar)', 'href="Memvar_Bundle2-23in2.html" title="TInput2 reference">'],
['in2', '(Memvar)', 'href="Memvar_Bundle3-23in2.html" title="TInput2 reference">'],
['in2', '(Memvar)', 'href="Memvar_Bundle5-23in2.html" title="TInput2 reference">'],
['in3', '(Memvar)', 'href="Memvar_Bundle3-23in3.html" title="TInput3 reference">'],
['in3', '(Memvar)', 'href="Memvar_Bundle5-23in3.html" title="TInput3 reference">'],
['in4', '(Memvar)', 'href="Memvar_Bundle5-23in4.html" title="TInput4 reference">'],
['in5', '(Memvar)', 'href="Memvar_Bundle5-23in5.html" title="TInput5 reference">'],
['inDegree', '(Function)', 'href="Function_inDegree.html" title="Number of incoming edges for a given vertex.">'],
['Index', '(Class)', 'href="Class_Index.html" title="Contains preprocessing data of a fixed text. Allows fast dictionary look-up and advanced computations.">'],
['Index Find Algorithm', '(Tag)', 'href="Tag_Index Find Algorithm.html" title="Tag to specify the index search algorithm.">'],
['Index Finder', '(Demo)', 'href="Demo_Index Finder.html" title="Example for using a Class.Finder of an Class.Index.">'],
['Index Finder StringSet', '(Demo)', 'href="Demo_Index Finder StringSet.html" title="Example for using a Class.Finder of an Class.Index of a Class.StringSet.">'],
['Index_ESA', '(Spec)', 'href="Spec_Index_ESA.html" title="An index based on an enhanced suffix array.">'],
['Index_QGram', '(Spec)', 'href="Spec_Index_QGram.html" title="An index based on an array of sorted q-grams.">'],
['indexBWT', '(Function)', 'href="Function_indexBWT.html" title="Shortcut for getFibre(.., ESA_BWT).">'],
['indexChildTab', '(Function)', 'href="Function_indexChildTab.html" title="Shortcut for getFibre(.., ESA_ChildTab).">'],
['indexCreate', '(Function)', 'href="Function_indexCreate.html" title="Creates a specific Metafunction.Fibre.">'],
['indexDir', '(Function)', 'href="Function_indexDir.html" title="Shortcut for getFibre(.., QGram_Dir).">'],
['indexLCP', '(Function)', 'href="Function_indexLCP.html" title="Shortcut for getFibre(.., ESA_LCP).">'],
['indexLCPE', '(Function)', 'href="Function_indexLCPE.html" title="Shortcut for getFibre(.., ESA_LCPE).">'],
['indexRawSA', '(Function)', 'href="Function_indexRawSA.html" title="Shortcut for getFibre(.., ESA_RawSA).">'],
['indexRawText', '(Function)', 'href="Function_indexRawText.html" title="Shortcut for getFibre(.., ESA_RawText).">'],
['indexRequire', '(Function)', 'href="Function_indexRequire.html" title="On-demand creation of a specific Metafunction.Fibre.">'],
['indexSA', '(Function)', 'href="Function_indexSA.html" title="Shortcut for getFibre(.., ESA_SA).">'],
['indexShape', '(Function)', 'href="Function_indexShape.html" title="Shortcut for getFibre(.., QGram_Shape).">'],
['indexSupplied', '(Function)', 'href="Function_indexSupplied.html" title="Returns whether a specific Metafunction.Fibre is present.">'],
['indexText', '(Function)', 'href="Function_indexText.html" title="Shortcut for getFibre(.., ESA_Text).">'],
['Indices', '(Page)', 'href="Page_Indices.html" title="Substring indices in SeqAn.">'],
['infimumValue', '(Function)', 'href="Function_infimumValue.html" title="Infimum for a given type.">'],
['infimumValueImpl', '(Function)', 'href="Function_infimumValueImpl.html" title="Implements Function.infimumValue.">'],
['infix', '(Function)', 'href="Function_infix.html" title="Creates infix object.">'],
['Infix', '(Metafunction)', 'href="Metafunction_Infix.html" title="Infix sequence type.">'],
['InfixSegment', '(Spec)', 'href="Spec_InfixSegment.html" title="An arbitrary segment.">'],
['insertGap', '(Function)', 'href="Function_insertGap.html" title="Insert one blank into a gapped sequence.">'],
['insertGaps', '(Function)', 'href="Function_insertGaps.html" title="Insert blanks into a gapped sequence.">'],
['insertValue', '(Function)', 'href="Function_insertValue.html" title="Inserts a single value into a container.">'],
['Installation', '(Page)', 'href="Page_Installation.html" title="Installation of SeqAn and compiling example programs.">'],
['InternalMap', '(Class)', 'href="Class_InternalMap.html" title="An internal property map using member ids.">'],
['InternalPointerMap', '(Class)', 'href="Class_InternalPointerMap.html" title="An internal property map using pointer to members.">'],
['InternalRawMap', '(Class)', 'href="Class_InternalRawMap.html" title="An internal property map using raw pointer to members.">'],
['IntervalTree', '(Class)', 'href="Class_IntervalTree.html" title="A datastructure that efficiently stores intervals.">'],
['inverseHash', '(Function)', 'href="Function_inverseHash.html" title="Determines the corresponding sequence pattern given the hash value.">'],
['IsContiguous', '(Metafunction)', 'href="Metafunction_IsContiguous.html" title="Determines whether a container stores its elements in a contiguous array.">'],
['isEqual', '(Function)', 'href="Function_isEqual.html" title="Operator &quot;==&quot;.">'],
['isGap', '(Function)', 'href="Function_isGap.html" title="Test a gapped sequence for gaps at a specific position.">'],
['isGreater', '(Function)', 'href="Function_isGreater.html" title="Operator &quot;>&quot;.">'],
['isGreaterOrEqual', '(Function)', 'href="Function_isGreaterOrEqual.html" title="Operator &quot;>=&quot;.">'],
['isLeaf', '(Function)', 'href="Function_Graph-23isLeaf.html" title="Tests whether a given vertex is a leaf or not.">'],
['isLeaf', '(Function)', 'href="Function_Index-23isLeaf.html" title="Test whether iterator points to a leaf.">'],
['isLeftMaximal', '(Function)', 'href="Function_isLeftMaximal.html" title="Test whether the occurences of an iterator\'s Function.representative mutually differ in the character left of the hits.">'],
['isLess', '(Function)', 'href="Function_isLess.html" title="Operator &quot;&lt;&quot;.">'],
['isLessOrEqual', '(Function)', 'href="Function_isLessOrEqual.html" title="Operator &quot;&lt;=&quot;.">'],
['isNotEqual', '(Function)', 'href="Function_isNotEqual.html" title="Operator &quot;!=&quot;.">'],
['isPartiallyLeftExtensible', '(Function)', 'href="Function_isPartiallyLeftExtensible.html" title="Test whether the characters left of the two occurences of Function.representative are equal.">'],
['isPrefix', '(Function)', 'href="Function_isPrefix.html" title="Test whether a sequence is prefix of another sequence.">'],
['isRightTerminal', '(Function)', 'href="Function_isRightTerminal.html" title="Test whether iterator points to a suffix.">'],
['isRoot', '(Function)', 'href="Function_Graph-23isRoot.html" title="Tests whether a given vertex is the root or not.">'],
['isRoot', '(Function)', 'href="Function_isRoot.html" title="Test whether iterator points to the root node.">'],
['IsSequence', '(Metafunction)', 'href="Metafunction_IsSequence.html" title="Determines whether a container stores its elements in sequential order.">'],
['IsSimple', '(Metafunction)', 'href="Metafunction_IsSimple.html" title="Tests type to be simple.">'],
['isUnique', '(Function)', 'href="Function_isUnique.html" title="Test whether the Function.representative occurs only once in every sequence.">'],
['Iter', '(Class)', 'href="Class_Iter.html" title="Iterator that is used to traverse containers.">'],
['iter', '(Function)', 'href="Function_iter.html" title="Iterator to item at given position.">'],
['Iter', '(Memfunc)', 'href="Memfunc_AdaptorIterator-23Iter.html" title="Constructor">'],
['Iter', '(Memfunc)', 'href="Memfunc_PositionIterator-23Iter.html" title="Constructor">'],
['Iterator', '(Concept)', 'href="Concept_Iterator.html" title="Object that iterates through container.">'],
['Iterator', '(Metafunction)', 'href="Metafunction_Iterator.html" title="Type of iterator objects that are used to traverse the container.">'],
['Iterator Basics', '(Demo)', 'href="Demo_Iterator Basics.html" title="Simple iterator functions.">'],
['Iterator Proxy', '(Spec)', 'href="Spec_Iterator Proxy.html" title="Proxy that is implemented by an iterator.">'],
['Iterator Spec', '(Tag)', 'href="Tag_Iterator Spec.html" title="Specifies the kind of an iterator.">'],
['Iupac', '(Spec)', 'href="Spec_Iupac.html" title="Iupac code for DNA.">'],
['IupacIterator', '(Shortcut)', 'href="Shortcut_IupacIterator.html" title="Iterator for Shortcut.IupacString.">'],
['IupacString', '(Shortcut)', 'href="Shortcut_IupacString.html" title="A string of Spec.Iupac.">'],
['Joiner', '(Spec)', 'href="Spec_Joiner.html" title="Joins two or three input streams.">'],
['Key', '(Metafunction)', 'href="Metafunction_Key.html" title="Key type of a key to object mapping.">'],
['Kruskals Algorithm', '(Demo)', 'href="Demo_Kruskals Algorithm.html" title="Kruskal\'s algorithm for computing a minimum spanning tree.">'],
['kruskals_algorithm', '(Function)', 'href="Function_kruskals_algorithm.html" title="Computes a minimum spanning tree on a graph.">'],
['label', '(Function)', 'href="Function_Automaton-23label.html" title="Returns the label of the out-edge this iterator points to.">'],
['label', '(Function)', 'href="Function_label.html" title="Gets the label that is associated with this vertex descriptor.">'],
['lca', '(Function)', 'href="Function_lca.html" title="Returns the last common ancestor of two tree nodes.">'],
['lcp', '(Function)', 'href="Function_lcp.html" title="Returns the length of the longest-common-prefix of two Suffix Tree nodes.">'],
['lcpAt', '(Function)', 'href="Function_lcpAt.html" title="Shortcut for value(indexLCP(..), ..).">'],
['lcpeAt', '(Function)', 'href="Function_lcpeAt.html" title="Shortcut for value(indexLCPE(..), ..).">'],
['lcpLength', '(Function)', 'href="Function_lcpLength.html" title="Length of longest common prefix.">'],
['length', '(Function)', 'href="Function_length.html" title="The number of items/characters.">'],
['LENGTH', '(Metafunction)', 'href="Metafunction_LENGTH.html" title="Number of elements in a fixed-size container.">'],
['LevenshteinDistance', '(Tag)', 'href="Tag_LevenshteinDistance.html" title="Switch to trigger Levenshtein distance, which is a measure of edit operations (character substitutions, deletions or insertions).">'],
['Lexical', '(Class)', 'href="Class_Lexical.html" title="Comparator for lexical comparison.">'],
['Library Generation', '(Tag)', 'href="Tag_Library Generation.html" title="A tag to specify how to generate a T-Coffee library.">'],
['Local Alignment Algorithms', '(Tag)', 'href="Tag_Local Alignment Algorithms.html" title="Local alignment algorithm used by localAlignment.">'],
['Local Alignments', '(Demo)', 'href="Demo_Local Alignments.html" title="Computing local alignments between two sequences.">'],
['localAlignment', '(Function)', 'href="Function_localAlignment.html" title="Computes the best local alignment of two sequences.">'],
['LocalAlignmentFinder', '(Class)', 'href="Class_LocalAlignmentFinder.html" title="Stores the information necessary for local alignment dynamic programming.">'],
['log2', '(Function)', 'href="Function_log2.html" title="Computes logarithm of base 2 for integer types">'],
['logarithmize', '(Function)', 'href="Function_logarithmize.html" title="Logarithmizes each element of a given Class.FrequencyDistribution object.">'],
['Logical Values', '(Tag)', 'href="Tag_Logical Values.html" title="Tag that represents true and false.">'],
['Longest Common Subsequence', '(Demo)', 'href="Demo_Longest Common Subsequence.html" title="Longest common subsequence code example">'],
['Longest Increasing Subsequence', '(Demo)', 'href="Demo_Longest Increasing Subsequence.html" title="Longest increasing subsequence code example">'],
['longestCommonSubsequence', '(Function)', 'href="Function_longestCommonSubsequence.html" title="Computes the longest common subsequence.">'],
['longestIncreasingSubsequence', '(Function)', 'href="Function_longestIncreasingSubsequence.html" title="Computes the longest increasing subsequence.">'],
['MapperConfig', '(Spec)', 'href="Spec_MapperConfig.html" title="Configuration of Mapper.">'],
['MapperConfigSize', '(Spec)', 'href="Spec_MapperConfigSize.html" title="Configuration of Mapper.">'],
['MapperSpec', '(Spec)', 'href="Spec_MapperSpec.html" title="Permutes all elements using a custom destination function.">'],
['matchRefinement', '(Function)', 'href="Function_matchRefinement.html" title="Refines (i.e. cuts into smaller parts) a set of pairwise segment matches in such a way that none of the segments partly overlap. They are either identical (fully overlapping) or non-overlapping.">'],
['Matrix', '(Class)', 'href="Class_Matrix.html" title="A simple n-dimensional matrix type.">'],
['Maximal Repeats', '(Demo)', 'href="Demo_Maximal Repeats.html" title="Example for using the Spec.MaxRepeats Iterator.">'],
['Maximal Unique Matches', '(Demo)', 'href="Demo_Maximal Unique Matches.html" title="Example for using the Spec.MUMs Iterator.">'],
['Maximum Flow', '(Demo)', 'href="Demo_Maximum Flow.html" title="Ford-Fulkerson maximum flow code example">'],
['MaxRepeats Iterator', '(Spec)', 'href="Spec_MaxRepeats Iterator.html" title="Iterator to search for all maximal repeats.">'],
['Metafunctions', '', '<a target=_parent href="INDEXPAGE_Metafunction.html">'],
['Metafunctions', '(Page)', 'href="Page_Metafunctions.html" title="Metafunctions are used for getting types and constants at compile time.">'],
['ModComplementDna', '(Shortcut)', 'href="Shortcut_ModComplementDna.html" title="Modifier specialization type for the complement of Spec.Dna alphabet sequences.">'],
['ModComplementDna5', '(Shortcut)', 'href="Shortcut_ModComplementDna5.html" title="Modifier specialization type for the complement of Spec.Dna5 alphabet sequences.">'],
['ModifiedIterator', '(Class)', 'href="Class_ModifiedIterator.html" title="Allows to modify arbitrary iterators by specializing what differs from an origin.">'],
['ModifiedString', '(Class)', 'href="Class_ModifiedString.html" title="Allows to modify arbitrary strings by specializing what differs from an origin.">'],
['Modifiers', '(Page)', 'href="Page_Modifiers.html" title="Modifiers give a different view to other classes.">'],
['ModReverse', '(Demo)', 'href="Demo_ModReverse.html" title="Modifier example for reverse strings.">'],
['ModReverse', '(Spec)', 'href="Spec_ModReverse.html" title="Mirrors the characters from begin to end.">'],
['ModView', '(Demo)', 'href="Demo_ModView.html" title="How to modify strings with a per-character functor.">'],
['ModView', '(Spec)', 'href="Spec_ModView.html" title="Transforms the characters of the THost string/iterator using a custom function.">'],
['Motif Finder', '(Demo)', 'href="Demo_Motif Finder.html" title="Examples for how to start a motif search using SeqAn\'s Motif Finder.">'],
['Motif Search', '(Page)', 'href="Page_Motif Search.html" title="Finding motifs in SeqAn.">'],
['MotifFinder', '(Class)', 'href="Class_MotifFinder.html" title="Holds the algorithm parameter values and the motif instance(s) found by the appropriate           motif discovery algorithm.">'],
['move', '(Function)', 'href="Function_move.html" title="Hands over content from one container to another container.">'],
['Move Switch', '(Tag)', 'href="Tag_Move Switch.html" title="Switch to force move.">'],
['moveSource', '(Function)', 'href="Function_moveSource.html" title="Moves the source to a new value.">'],
['moveValue', '(Function)', 'href="Function_moveValue.html" title="Assigns value to item.">'],
['MSA with Neighbor-Joining', '(Demo)', 'href="Demo_MSA with Neighbor-Joining.html" title="Progressive multiple sequence alignment using neighbor joining for building the guide tree.">'],
['MSA with UPGMA', '(Demo)', 'href="Demo_MSA with UPGMA.html" title="Progressive multiple sequence alignment using UPGMA for building the guide tree">'],
['Multi Pool Allocator', '(Spec)', 'href="Spec_Multi Pool Allocator.html" title="Allocator that pools memory blocks.">'],
['MultiMEMs Iterator', '(Spec)', 'href="Spec_MultiMEMs Iterator.html" title="Iterator to search for MultiMEMs.">'],
['MultipleShiftAnd', '(Spec)', 'href="Spec_MultipleShiftAnd.html" title=" Multiple exact string matching using bit parallelism. The total size of the patterns should fit into a computer word.">'],
['Mummy', '(Demo)', 'href="Demo_Mummy.html" title="Simple MUMmer clone.">'],
['MUMs Iterator', '(Spec)', 'href="Spec_MUMs Iterator.html" title="Iterator to search for all maximum unique matches.">'],
['MyersUkkonen', '(Spec)', 'href="Spec_MyersUkkonen.html" title="Provides fast approximate searching of one string in another using Myer\'s fast bit-parallel algorithm with application of the Ukkonen-trick.">'],
['Namer', '(Spec)', 'href="Spec_Namer.html" title="Extends the input stream by a second field which names the elements.">'],
['needle', '(Function)', 'href="Function_needle.html" title="Returns the needle of a Class.Pattern object (not implemented for some online-algorithms).">'],
['Needle', '(Metafunction)', 'href="Metafunction_Needle.html" title="Returns the needle type of a Class.Pattern type.">'],
['Needleman-Wunsch Algorithm', '(Demo)', 'href="Demo_Needleman-Wunsch Algorithm.html" title="Needleman-Wunsch alignment code example">'],
['Nested Modifiers', '(Demo)', 'href="Demo_Nested Modifiers.html" title="How to combine modifiers.">'],
['nextS', '(Function)', 'href="Function_nextS.html" title="Accesses the next source pointer.">'],
['nextT', '(Function)', 'href="Function_nextT.html" title="Accesses the next target pointer.">'],
['normalize', '(Function)', 'href="Function_normalize.html" title="Determines the normalized frequencies.">'],
['Nothing', '(Tag)', 'href="Tag_Nothing.html" title="Tag that represents an absent parameter or an absent type.">'],
['numChildren', '(Function)', 'href="Function_numChildren.html" title="Number of children of a given tree vertex.">'],
['numEdges', '(Function)', 'href="Function_numEdges.html" title="Number of edges in a graph.">'],
['numTreeEdges', '(Function)', 'href="Function_numTreeEdges.html" title="Number of tree edges.">'],
['numVertices', '(Function)', 'href="Function_numVertices.html" title="Number of vertices in a graph.">'],
['Object', '(Metafunction)', 'href="Metafunction_Object.html" title="Object type of a key to object mapping.">'],
['obtainId', '(Function)', 'href="Function_obtainId.html" title="Obtains a new id from the id manager.">'],
['OMOPS', '(Tag)', 'href="Tag_OMOPS.html" title="Represents the One or More Occurences Per Sequence model.">'],
['OOPS', '(Tag)', 'href="Tag_OOPS.html" title="Represents the One Occurrence Per Sequence model.">'],
['open', '(Function)', 'href="Function_open.html" title="Opens a file.">'],
['openTemp', '(Function)', 'href="Function_openTemp.html" title="Opens a temporary file.">'],
['Oracle', '(Spec)', 'href="Spec_Oracle.html" title="A factor oracle.">'],
['orderOccurrences', '(Function)', 'href="Function_orderOccurrences.html" title="Sorts a string of occurrences.">'],
['ordValue', '(Function)', 'href="Function_ordValue.html" title="Maps an alphabet 1-to-1 to the interval [0..ValueSize).">'],
['Out-Edge Iterator', '(Spec)', 'href="Spec_Out-Edge Iterator.html" title="Out-edge iterator for Class.Graph.">'],
['outDegree', '(Function)', 'href="Function_outDegree.html" title="Number of outgoing edges for a given vertex.">'],
['Overflow Strategy', '(Tag)', 'href="Tag_Overflow Strategy.html" title="The strategy for resizing containers.">'],
['Owner', '(Spec)', 'href="Spec_Owner.html" title="A string set storing the strings as members.">'],
['Packed String', '(Spec)', 'href="Spec_Packed String.html" title="A string that stores as many values in one machine word as possible.">'],
['Pair', '(Class)', 'href="Class_Pair.html" title="Stores two arbitrary objects.">'],
['Pair', '(Memfunc)', 'href="Memfunc_Pair-23Pair.html" title="Constructor">'],
['Pam', '(Spec)', 'href="Spec_Pam.html" title="Pam scoring matrices.">'],
['parentEdgeLabel', '(Function)', 'href="Function_parentEdgeLabel.html" title="Returns a substring representing the edge from an iterator node to its parent.">'],
['parentVertex', '(Function)', 'href="Function_parentVertex.html" title="Returns the parent vertex of an edge.">'],
['parseString', '(Function)', 'href="Function_parseString.html" title="Parses a string one character at a time and moves accordingly in the automaton.">'],
['Pattern', '(Class)', 'href="Class_Pattern.html" title="Holds the needle and preprocessing data (depends on algorithm).">'],
['Pattern', '(Concept)', 'href="Concept_Pattern.html" title="Object that stores information about the glos:needle of a search.">'],
['Peptide', '(Shortcut)', 'href="Shortcut_Peptide.html" title="A string of Spec.AminoAcid.">'],
['PeptideIterator', '(Shortcut)', 'href="Shortcut_PeptideIterator.html" title="Iterator for Shortcut.Peptide.">'],
['Pipe', '(Class)', 'href="Class_Pipe.html" title="Pipes are pop-passive pipeline modules.">'],
['Pipe', '(Memfunc)', 'href="Memfunc_Filter-23Pipe.html" title="Constructor">'],
['Pipe', '(Memfunc)', 'href="Memfunc_Namer-23Pipe.html" title="Constructor">'],
['Pipe', '(Memfunc)', 'href="Memfunc_Pipe-23Pipe.html" title="Constructor">'],
['PMode', '(Spec)', 'href="Spec_PMode.html" title=" Represents the P computation scheme for handling &quot;zero&quot; probabilities.">'],
['PMS1', '(Spec)', 'href="Spec_PMS1.html" title=" Represents the PMS1 algorithm developed by Rajasekaran et al.">'],
['PMSP', '(Spec)', 'href="Spec_PMSP.html" title=" Represents the PMSP algorithm of Davila et al.">'],
['Pool', '(Class)', 'href="Class_Pool.html" title="Pools are push- and pop-passive pipeline modules.">'],
['PoolConfig', '(Spec)', 'href="Spec_PoolConfig.html" title="Configuration of Pool.">'],
['PoolConfigSize', '(Spec)', 'href="Spec_PoolConfigSize.html" title="Configuration of Pool.">'],
['PoolSpec', '(Spec)', 'href="Spec_PoolSpec.html" title="Stores/Retrieves all elements to/from disk.">'],
['pop', '(Function)', 'href="Function_PriorityType-23pop.html" title="Deletes item with the highest priority and adjusts the priority queue.">'],
['pop', '(Function)', 'href="Function_pop.html" title="Pops the first element of the remaining stream.">'],
['posGlobalize', '(Function)', 'href="Function_posGlobalize.html" title="Converts a local/global to a global position.">'],
['position', '(Function)', 'href="Function_position.html" title="Position of an iterator.">'],
['Position', '(Metafunction)', 'href="Metafunction_Position.html" title="Type of an object that represents a position in a container.">'],
['Position Iterator', '(Spec)', 'href="Spec_Position Iterator.html" title="Adapts Metafunction.Position.position to Concept.Rooted Iterator.iterator.">'],
['positionToId', '(Function)', 'href="Function_positionToId.html" title="Retrieves the id of a string in the StringSet given a position.">'],
['posLocalize', '(Function)', 'href="Function_posLocalize.html" title="Converts a local/global to a local position.">'],
['posOfMax', '(Function)', 'href="Function_posOfMax.html" title="Determines the residue position in a given Class.FrequencyDistribution object with the maximum frequency.">'],
['Postorder', '(Tag)', 'href="Tag_Postorder.html" title="Postorder depth-first search.">'],
['PostorderEmptyEdges', '(Tag)', 'href="Tag_PostorderEmptyEdges.html" title="Postorder depth-first search in a suffix tree with leaves for every suffix.">'],
['prefix', '(Function)', 'href="Function_prefix.html" title="Creates prefix object.">'],
['Prefix', '(Metafunction)', 'href="Metafunction_Prefix.html" title="Prefix sequence type.">'],
['Prefix Order', '(Tag)', 'href="Tag_Prefix Order.html" title="Specify whether a prefix is smaller or greater.">'],
['PrefixSegment', '(Spec)', 'href="Spec_PrefixSegment.html" title="First part of a sequence.">'],
['Preorder', '(Tag)', 'href="Tag_Preorder.html" title="Preorder depth-first search.">'],
['PreorderEmptyEdges', '(Tag)', 'href="Tag_PreorderEmptyEdges.html" title="Preorder depth-first search in a suffix tree with leaves for every suffix.">'],
['Prims Algorithm', '(Demo)', 'href="Demo_Prims Algorithm.html" title="Prim\'s algorithm for computing a minimum spanning tree.">'],
['prims_algorithm', '(Function)', 'href="Function_prims_algorithm.html" title="Computes a minimum spanning tree on a graph.">'],
['PriorityHeap', '(Spec)', 'href="Spec_PriorityHeap.html" title="Stores the priority data on a heap.">'],
['PriorityType', '(Class)', 'href="Class_PriorityType.html" title="Stores items in such a way that the item with the highest priority is at the top.">'],
['Projection', '(Spec)', 'href="Spec_Projection.html" title=" Represents the PROJECTION algorithm of Buhler and Tompa.">'],
['property', '(Function)', 'href="Function_property.html" title="Accesses the property of an item in the property map.">'],
['Proxy', '(Class)', 'href="Class_Proxy.html" title="Emulates object of another class.">'],
['Pseudocount', '(Class)', 'href="Class_Pseudocount.html" title="Holds the pseudocounts for each residue of a given sequence alphabet.">'],
['push', '(Function)', 'href="Function_PriorityType-23push.html" title="Inserts a new item and adjusts the priority queue if necessary.">'],
['push', '(Function)', 'href="Function_push.html" title="Appends an item at the end of an input stream.">'],
['QGram Index Fibres', '(Tag)', 'href="Tag_QGram Index Fibres.html" title="Tag to select a specific fibre (e.g. table, object, ...) of an Spec.Index_QGram.q-gram index.">'],
['rawtextAt', '(Function)', 'href="Function_rawtextAt.html" title="Shortcut for value(indexRawText(..), ..).">'],
['read', '(Function)', 'href="Function_Fileformat-23read.html" title="Loads a record from file.">'],
['read', '(Function)', 'href="Function_read.html" title="Loads records from a file.">'],
['readAt', '(Function)', 'href="Function_readAt.html" title="Loads records from a specific position in a file.">'],
['readFeature', '(Function)', 'href="Function_readFeature.html" title="Finds the first feature specified by \'key\' starting from position \'start\' in the feature table (the feature table can be obtained by calling readLineType with the two-character code &quot;FT&quot;).">'],
['readLineType', '(Function)', 'href="Function_readLineType.html" title="Reads the information belonging to the two-character line code specified.">'],
['readMeta', '(Function)', 'href="Function_readMeta.html" title="Read meta information from file.">'],
['Reference', '(Metafunction)', 'href="Metafunction_Reference.html" title="Reference type.">'],
['releaseAll', '(Function)', 'href="Function_releaseAll.html" title="Releases all ids handled by this id manager at once.">'],
['releaseId', '(Function)', 'href="Function_releaseId.html" title="Releases a given id so it can be redistributed later on.">'],
['releaseRef', '(Function)', 'href="Function_releaseRef.html" title="Called when dependency is released.">'],
['removeAllChildren', '(Function)', 'href="Function_removeAllChildren.html" title="Removes all children from the tree given a parent.">'],
['removeChild', '(Function)', 'href="Function_removeChild.html" title="Removes a child from the tree given a parent.">'],
['removeEdge', '(Function)', 'href="Function_removeEdge.html" title="Removes an edge from the graph. For automatons a label is required.">'],
['removeGap', '(Function)', 'href="Function_removeGap.html" title="Removes one blank from a gapped sequence.">'],
['removeGaps', '(Function)', 'href="Function_removeGaps.html" title="Removes blanks from a gapped sequence.">'],
['removeInEdges', '(Function)', 'href="Function_removeInEdges.html" title="Removes the incoming edges of a given vertex.">'],
['removeOutEdges', '(Function)', 'href="Function_removeOutEdges.html" title="Removes the outgoing edges of a given vertex.">'],
['removeValueById', '(Function)', 'href="Function_removeValueById.html" title="Removes a string from the StringSet given an id.">'],
['removeVertex', '(Function)', 'href="Function_removeVertex.html" title="Removes a vertex.">'],
['replace', '(Function)', 'href="Function_replace.html" title="Replaces a part of a container with another container.">'],
['repLength', '(Function)', 'href="Function_repLength.html" title="Returns the length of the substring representing the path from root to iterator node.">'],
['representative', '(Function)', 'href="Function_representative.html" title="Returns a substring representing the path from root to iterator node.">'],
['reserve', '(Function)', 'href="Function_reserve.html" title="Increases the capacity.">'],
['resize', '(Function)', 'href="Function_resize.html" title="Changes the length.">'],
['resizeEdgeMap', '(Function)', 'href="Function_resizeEdgeMap.html" title="Initializes an edge map">'],
['resizeSpace', '(Function)', 'href="Function_resizeSpace.html" title="Makes free space in container">'],
['resizeVertexMap', '(Function)', 'href="Function_resizeVertexMap.html" title="Initializes a vertex map.">'],
['rewind', '(Function)', 'href="Function_rewind.html" title="Sets the current file pointer to the beginning.">'],
['Rna5', '(Spec)', 'href="Spec_Rna5.html" title="Rna5 alphabet.">'],
['root', '(Function)', 'href="Function_root.html" title="Gets a reference to the root of the tree.">'],
['Rooted Iterator', '(Concept)', 'href="Concept_Rooted Iterator.html" title="Iterator that knows its container.">'],
['Rooted Iterators', '(Demo)', 'href="Demo_Rooted Iterators.html" title="Example for some functions for handling (rooted) iterators.">'],
['row', '(Function)', 'href="Function_row.html" title="A row in an alignment.">'],
['Row', '(Metafunction)', 'href="Metafunction_Row.html" title="Type of a row in an alignment.">'],
['rows', '(Function)', 'href="Function_rows.html" title="The container of rows in an alignment.">'],
['Rows', '(Metafunction)', 'href="Metafunction_Rows.html" title="Type of row container of an alignment.">'],
['saAt', '(Function)', 'href="Function_saAt.html" title="Shortcut for value(indexSA(..), ..).">'],
['Sampler', '(Spec)', 'href="Spec_Sampler.html" title="Outputs m-tuples beginning at a position of difference cover DC.">'],
['SAValue', '(Metafunction)', 'href="Metafunction_SAValue.html" title="The default alphabet type of a suffix array, i.e. the type to store a position of a string or string set.">'],
['Score', '(Class)', 'href="Class_Score.html" title="A scoring scheme.">'],
['score', '(Function)', 'href="Function_score.html" title="The score for aligning two values according to a scoring scheme.">'],
['Score', '(Memfunc)', 'href="Memfunc_Score.html" title="Constructor">'],
['Score', '(Memfunc)', 'href="Memfunc_Score-23Score.html" title="Constructor">'],
['Score ChainSoP', '(Spec)', 'href="Spec_Score ChainSoP.html" title="Scoring scheme for chaining that uses a special method for scoring the gaps between two fragments.">'],
['Score Manhattan', '(Spec)', 'href="Spec_Score Manhattan.html" title="Scoring scheme for chaining that computes gap scores using manhattan distance.">'],
['Score Matrix', '(Spec)', 'href="Spec_Score Matrix.html" title="A general scoring matrix.">'],
['Score Zero', '(Spec)', 'href="Spec_Score Zero.html" title="Scoring scheme for chaining that set gap scores to 0">'],
['scoreGap', '(Function)', 'href="Function_scoreGap.html" title="Score for gaps.">'],
['scoreGapExtend', '(Function)', 'href="Function_scoreGapExtend.html" title="Score for extending gaps.">'],
['scoreGapOpen', '(Function)', 'href="Function_scoreGapOpen.html" title="Score for opening a gap.">'],
['scoreLimit', '(Function)', 'href="Function_scoreLimit.html" title="The minimal score a match must reach in approximate searching.">'],
['scoreMatch', '(Function)', 'href="Function_scoreMatch.html" title="Match score.">'],
['scoreMismatch', '(Function)', 'href="Function_scoreMismatch.html" title="Mismatch score.">'],
['Scoring', '(Page)', 'href="Page_Scoring.html" title="Scoring schemes used for alignments and approximative search.">'],
['scoringScheme', '(Function)', 'href="Function_scoringScheme.html" title="The glos:scoring scheme used for finding or aligning.">'],
['Searching', '(Page)', 'href="Page_Searching.html" title="Searching in SeqAn.">'],
['seek', '(Function)', 'href="Function_seek.html" title="Changes the current file pointer.">'],
['Segment', '(Class)', 'href="Class_Segment.html" title="A contiguous part of a sequence.">'],
['Segment', '(Memfunc)', 'href="Memfunc_InfixSegment-23Segment.html" title="Constructor">'],
['Segment', '(Memfunc)', 'href="Memfunc_PrefixSegment-23Segment.html" title="Constructor">'],
['Segment', '(Memfunc)', 'href="Memfunc_SuffixSegment-23Segment.html" title="Constructor">'],
['SeqAn - The Library for Sequence Analysis - Documentation', '', '<a target=_parent href="index.html">'],
['sequenceId', '(Function)', 'href="Function_sequenceId.html" title="Gets the sequence id that is associated with this vertex descriptor.">'],
['Sequences', '(Page)', 'href="Page_Sequences.html" title="Sequences in SeqAn.">'],
['setBegin', '(Function)', 'href="Function_setBegin.html" title="Sets begin of object in host.">'],
['setBeginPosition', '(Function)', 'href="Function_setBeginPosition.html" title="Sets begin position of object in host.">'],
['setEnd', '(Function)', 'href="Function_setEnd.html" title="Sets end of object in host.">'],
['setEndPosition', '(Function)', 'href="Function_setEndPosition.html" title="Sets begin position of object in host.">'],
['setEOF', '(Function)', 'href="Function_setEOF.html" title="Sets the file end to the current pointer.">'],
['setHaystack', '(Function)', 'href="Function_setHaystack.html" title="Sets the haystack of a Class.Finder object.">'],
['SetHorspool', '(Spec)', 'href="Spec_SetHorspool.html" title=" Multiple exact string matching using set horspool algorithm.">'],
['setHost', '(Function)', 'href="Function_setHost.html" title="Sets the host of an object.">'],
['setNeedle', '(Function)', 'href="Function_setNeedle.html" title="Sets the needle of a Class.Pattern object and optionally induces preprocessing.">'],
['setPosition', '(Function)', 'href="Function_setPosition.html" title="Sets the position of a finder.">'],
['setScoreLimit', '(Function)', 'href="Function_setScoreLimit.html" title="Sets the minimal score a match must reach in approximate searching.">'],
['setScoringScheme', '(Function)', 'href="Function_setScoringScheme.html" title="Sets the glos:scoring scheme used for finding or aligning.">'],
['setSource', '(Function)', 'href="Function_setSource.html" title="Let an external object be the source.">'],
['setValue', '(Function)', 'href="Function_setValue.html" title="Makes holder dependent.">'],
['Shape', '(Class)', 'href="Class_Shape.html" title="Stores hash value and shape for an ungapped or gapped q-gram.">'],
['Shape', '(Memfunc)', 'href="Memfunc_GappedShape-23Shape.html" title="Constructor">'],
['Shape', '(Memfunc)', 'href="Memfunc_Shape-23Shape.html" title="Constructor">'],
['Shape', '(Memfunc)', 'href="Memfunc_SimpleShape-23Shape.html" title="Constructor">'],
['shareResources', '(Function)', 'href="Function_shareResources.html" title="Determines whether two sequences share the same resource.">'],
['ShiftAnd', '(Spec)', 'href="Spec_ShiftAnd.html" title=" Exact string matching using bit parallelism. The Shift-And algorithm is applicable to search small patterns in texts using a small alphabet.">'],
['Shifter', '(Spec)', 'href="Spec_Shifter.html" title="Shifts the input stream by delta elements.">'],
['ShiftOr', '(Spec)', 'href="Spec_ShiftOr.html" title=" Exact string matching using bit parallelism. The Shift-Or algorithm is applicable to search small patterns in texts using a small alphabet.">'],
['Shortcuts', '', '<a target=_parent href="INDEXPAGE_Shortcut.html">'],
['Shortest Path in DAGs', '(Demo)', 'href="Demo_Shortest Path in DAGs.html" title="Computing single source shortest paths in a directed acyclic graph.">'],
['shrinkToFit', '(Function)', 'href="Function_shrinkToFit.html" title="Resizes container to minimum capacity">'],
['Simple Allocator', '(Spec)', 'href="Spec_Simple Allocator.html" title="General purpose allocator.">'],
['Simple Score', '(Spec)', 'href="Spec_Simple Score.html" title="Simple scoring scheme that has scores for matches, mismatches, opening gaps and extending gaps.">'],
['Simple Type', '(Concept)', 'href="Concept_Simple Type.html" title="Object that does not need constructors, destructors or copy assignment operators.">'],
['SimpleIterator', '(Spec)', 'href="Spec_SimpleIterator.html" title="A simple iterator.">'],
['SimpleShape', '(Spec)', 'href="Spec_SimpleShape.html" title="A variable length ungapped shape (also called q-gram or k-mer).">'],
['SimpleType', '(Class)', 'href="Class_SimpleType.html" title="Implementation for &quot;simple&quot; types.">'],
['Single Pool Allocator', '(Spec)', 'href="Spec_Single Pool Allocator.html" title="Allocator that pools memory blocks of specific size.">'],
['size', '(Function)', 'href="Function_size.html" title="Gets the file size.">'],
['Size', '(Metafunction)', 'href="Metafunction_Size.html" title="Type of an object that is suitable to hold size information.">'],
['Smith-Waterman Algorithm', '(Demo)', 'href="Demo_Smith-Waterman Algorithm.html" title="Smith-Waterman local alignment code example.">'],
['smithWaterman', '(Function)', 'href="Function_smithWaterman.html" title="Computes the best local alignment of the (two) sequences given in align.">'],
['smithWatermanGetNext', '(Function)', 'href="Function_smithWatermanGetNext.html" title="Computes next best local alignment.">'],
['SorterConfig', '(Spec)', 'href="Spec_SorterConfig.html" title="Configuration of Sorter.">'],
['SorterConfigSize', '(Spec)', 'href="Spec_SorterConfigSize.html" title="Configuration of Sorter.">'],
['SorterSpec', '(Spec)', 'href="Spec_SorterSpec.html" title="Sorts all elements using a custom compare function.">'],
['source', '(Function)', 'href="Function_source.html" title="The source of an object.">'],
['Source', '(Metafunction)', 'href="Metafunction_Source.html" title="The underlying sequence for alignments or gaps data structures.">'],
['Source', '(Spec)', 'href="Spec_Source.html" title="Pipelining adaptor for arbitrary containers or iterators.">'],
['sourceBegin', '(Function)', 'href="Function_sourceBegin.html" title="Begin of the source segment.">'],
['sourceEnd', '(Function)', 'href="Function_sourceEnd.html" title="End of the source segment.">'],
['sourceSegment', '(Function)', 'href="Function_sourceSegment.html" title="The used part of the source.">'],
['sourceVertex', '(Function)', 'href="Function_sourceVertex.html" title="Returns the source vertex of an edge.">'],
['Spec', '(Metafunction)', 'href="Metafunction_Spec.html" title="The spec of a class.">'],
['Specializations', '', '<a target=_parent href="INDEXPAGE_Spec.html">'],
['std::basic_string', '(Adaption)', 'href="Adaption_std-3A-3Abasic_string.html" title="Standard library string class.">'],
['std::FILE *', '(Adaption)', 'href="Adaption_std-3A-3AFILE -2A.html" title="Standard library C style streams.">'],
['std::iostream', '(Adaption)', 'href="Adaption_std-3A-3Aiostream.html" title="Standard library stream classes.">'],
['String', '(Class)', 'href="Class_String.html" title="General purpose container for sequences.">'],
['String', '(Memfunc)', 'href="Memfunc_ExtString-23String.html" title="Constructor">'],
['String Basics', '(Demo)', 'href="Demo_String Basics.html" title="Basic string class handling.">'],
['StringSet', '(Class)', 'href="Class_StringSet.html" title="A container class for a set of strings.">'],
['stringSet', '(Function)', 'href="Function_stringSet.html" title="Gets the string set of an alignment graph.">'],
['stringSetLimits', '(Function)', 'href="Function_stringSetLimits.html" title="Retrieves a string of delimiter positions of a Class.StringSet which is needed for local&lt;->global position conversions.">'],
['stringToShape', '(Function)', 'href="Function_stringToShape.html" title="Takes a shape given as a string of \'1\' (relevant position) and \'0\' (irrelevant position) and converts it into a Shape object.">'],
['Striped', '(Spec)', 'href="Spec_Striped.html" title="Stripes a file across multiple files.">'],
['Strongly Connected Components', '(Demo)', 'href="Demo_Strongly Connected Components.html" title="Computing all strongly-connected-components of a graph.">'],
['strongly_connected_components', '(Function)', 'href="Function_strongly_connected_components.html" title="Decomposes a directed graph into its strongly connected components.">'],
['subset', '(Function)', 'href="Function_subset.html" title="Creates a subset of a given StringSet.">'],
['suffix', '(Function)', 'href="Function_suffix.html" title="Creates suffix object.">'],
['Suffix', '(Metafunction)', 'href="Metafunction_Suffix.html" title="Suffix sequence type.">'],
['Suffix Array', '(Demo)', 'href="Demo_Suffix Array.html" title="Example for how to create a suffix array and use it as a dictionary.">'],
['SuffixSegment', '(Spec)', 'href="Spec_SuffixSegment.html" title="End part segment of a sequence.">'],
['sum', '(Function)', 'href="Function_sum.html" title="Determines the sum of all frequencies in a given Class.FrequencyDistribution object.">'],
['Supermaximal Repeats', '(Demo)', 'href="Demo_Supermaximal Repeats.html" title="Example for using the Spec.SuperMaxRepeats Iterator.">'],
['SuperMaxRepeats Iterator', '(Spec)', 'href="Spec_SuperMaxRepeats Iterator.html" title="Iterator to search for all supermaximal repeats.">'],
['SuperMaxRepeatsFast Iterator', '(Spec)', 'href="Spec_SuperMaxRepeatsFast Iterator.html" title="Iterator to search for all supermaximal repeats (for enh. suffix arrays only).">'],
['supremumValue', '(Function)', 'href="Function_supremumValue.html" title="Supremum for a given type.">'],
['supremumValueImpl', '(Function)', 'href="Function_supremumValueImpl.html" title="Implements Function.supremumValue.">'],
['Sync', '(Spec)', 'href="Spec_Sync.html" title="File structure supporting synchronous input/output access.">'],
['T-Coffee', '(Demo)', 'href="Demo_T-Coffee.html" title="T-Coffee code example">'],
['Tags', '', '<a target=_parent href="INDEXPAGE_Tag.html">'],
['target', '(Function)', 'href="Function_target.html" title="Accesses the target of an EdgeStump.">'],
['targetVertex', '(Function)', 'href="Function_targetVertex.html" title="Returns the target vertex of an edge.">'],
['TCM', '(Tag)', 'href="Tag_TCM.html" title="Represents the Two-Component-Mixture Sequence model.">'],
['tell', '(Function)', 'href="Function_tell.html" title="Gets the current file pointer.">'],
['Template Subclassing', '(Page)', 'href="Page_Template Subclassing.html" title="Template subclassing is used in SeqAn as a generic alternative for class inheritance.">'],
['toCString', '(Function)', 'href="Function_toCString.html" title="Access sequence as c-style string.">'],
['top', '(Function)', 'href="Function_PriorityType-23top.html" title="Reference to the item with the highest priority.">'],
['TopDown Iterator', '(Spec)', 'href="Spec_TopDown Iterator.html" title="Iterator for Suffix Trees that can go down and right beginning from the root.">'],
['TopDownHistory Iterator', '(Spec)', 'href="Spec_TopDownHistory Iterator.html" title="Iterator for Suffix Trees that can go down, right, and up.">'],
['Topological Sort', '(Demo)', 'href="Demo_Topological Sort.html" title="Topological sort of a graph.">'],
['topological_sort', '(Function)', 'href="Function_topological_sort.html" title="Performs a topological sort on a directed acyclic graph (DAG).">'],
['ToStdAllocator', '(Class)', 'href="Class_ToStdAllocator.html" title="Emulates standard conform allocator.">'],
['ToStdAllocator', '(Memfunc)', 'href="Memfunc_ToStdAllocator.html" title="Constructor">'],
['TraceBack', '(Spec)', 'href="Spec_TraceBack.html" title=" Trace back values.">'],
['TraceBackGotoh', '(Spec)', 'href="Spec_TraceBackGotoh.html" title=" Trace back values for gotoh.">'],
['Transitive Closure', '(Demo)', 'href="Demo_Transitive Closure.html" title="Transitive closure code example">'],
['transitive_closure', '(Function)', 'href="Function_transitive_closure.html" title="Determines whether there is a path between any two given vertices or not.">'],
['transpose', '(Function)', 'href="Function_transpose.html" title="Transposes a graph, either in-place or from source to dest.">'],
['Tree', '(Spec)', 'href="Spec_Tree.html" title="A Tree has a distinct root and directed edges. The source vertex of each edge is the parent vertex, the target vertex of each edge is the child. Trees provide fast access to child vertices and the parent.">'],
['Trie', '(Spec)', 'href="Spec_Trie.html" title="A keyword trie.">'],
['Triple', '(Class)', 'href="Class_Triple.html" title="Stores three arbitrary objects.">'],
['Triple', '(Memfunc)', 'href="Memfunc_Triple-23Triple.html" title="Constructor">'],
['Tristate Holder', '(Spec)', 'href="Spec_Tristate Holder.html" title="Holder that can be empty, dependent, or owner.">'],
['Tuple', '(Class)', 'href="Class_Tuple.html" title="A plain fixed-length string.">'],
['Tupler', '(Spec)', 'href="Spec_Tupler.html" title="Outputs tuples of the tupleLen consecutive elements of the input stream.">'],
['Undirected graph', '(Spec)', 'href="Spec_Undirected graph.html" title="An undirected graph that stores the edges in an adjacency list.">'],
['UnicodeIterator', '(Shortcut)', 'href="Shortcut_UnicodeIterator.html" title="Iterator for Shortcut.UnicodeString.">'],
['UnicodeString', '(Shortcut)', 'href="Shortcut_UnicodeString.html" title="A string of wchar_t.">'],
['value', '(Function)', 'href="Function_value.html" title="Reference to the value.">'],
['Value', '(Metafunction)', 'href="Metafunction_Value.html" title="Type of the items in the container.">'],
['valueById', '(Function)', 'href="Function_valueById.html" title="Retrieves a string from the StringSet given an id.">'],
['valueConstruct', '(Function)', 'href="Function_valueConstruct.html" title="Constructs an object at specified position.">'],
['valueDestruct', '(Function)', 'href="Function_valueDestruct.html" title="Destoys an object at specified position.">'],
['ValueSize', '(Metafunction)', 'href="Metafunction_ValueSize.html" title="Number of different values a value type object can have.">'],
['Vertex Iterator', '(Spec)', 'href="Spec_Vertex Iterator.html" title="Vertex iterator for Class.Graph.">'],
['VertexDescriptor', '(Metafunction)', 'href="Metafunction_VertexDescriptor.html" title="Type of an object that represents a vertex descriptor.">'],
['VertexIdHandler', '(Metafunction)', 'href="Metafunction_VertexIdHandler.html" title="Type of an object that represents an Id Manager.">'],
['VSTree Iterator', '(Spec)', 'href="Spec_VSTree Iterator.html" title="Abstract iterator for Suffix Trees.">'],
['waitFor', '(Function)', 'href="Function_waitFor.html" title="Waits for an asynchronous request to complete.">'],
['weight', '(Function)', 'href="Function_weight.html" title="Number of relevant positions in a shape.">'],
['WEIGHT', '(Metafunction)', 'href="Metafunction_WEIGHT.html" title="Number of relevant positions in a shape.">'],
['Weight', '(Metafunction)', 'href="Metafunction_Weight.html" title="Type of the weight of an item.">'],
['Wildcard Searching', '(Demo)', 'href="Demo_Wildcard Searching.html" title="String matching using wildcards.">'],
['WildShiftAnd', '(Spec)', 'href="Spec_WildShiftAnd.html" title=" Exact string matching with wildcards using bit parallelism. The Shift-And algorithm is applicable to search small patterns in texts using a small alphabet.">'],
['Word Graph', '(Spec)', 'href="Spec_Word Graph.html" title="A special automaton that stores words instead of single characters along its edges.">'],
['write', '(Function)', 'href="Function_Fileformat-23write.html" title="Writes to stream.">'],
['write', '(Function)', 'href="Function_write.html" title="Saves records to a file.">'],
['writeAt', '(Function)', 'href="Function_writeAt.html" title="Saves records to a specific position in a file.">'],
['ZOOPS', '(Tag)', 'href="Tag_ZOOPS.html" title="Represents the Zero or One Occurence Per Sequence model.">'],
['~Holder', '(Memfunc)', 'href="Memfunc_~Holder.html" title="Destructor">'],
['~Score', '(Memfunc)', 'href="Memfunc_~Score.html" title="Destructor">'],
false];
