#include <iostream>
#include <seqan/index.h>

using namespace std;
using namespace seqan;

int main ()
{
	String<char> myString = "How many wood would a woodchuck chuck.";

	typedef Index< String<char> > TMyIndex;
	TMyIndex myIndex(myString);

	Iterator< TMyIndex, SuperMaxRepeats >::Type myRepeatIterator(myIndex, 3);

	while (!atEnd(myRepeatIterator)) 
	{
		for(unsigned i = 0; i < countOccurrences(myRepeatIterator); ++i)
			cout << getOccurrences(myRepeatIterator)[i] << ", ";

		cout << repLength(myRepeatIterator) << "   ";

		cout << "\t\"" << representative(myRepeatIterator) << '\"' << endl;

		++myRepeatIterator;
	}

	return 0;
}
