#include <seqan/graph.h>
#include <iostream>

using namespace seqan;

int main() {
	typedef String<Dna> TString;
	typedef StringSet<TString, Dependent<> > TStringSet;
	typedef Graph<Alignment<TStringSet, Dna> > TGraph;
	TStringSet str;
	TString str0("TTGACACCCTCCCAATTGTA"); appendValue(str, str0);
	TString str1("ACCCCAGGCTTTACACAT"); appendValue(str, str1);
	Score<int> score_type = Score<int>(2,-1,-1,-2);
	typedef Fragment<> TFragment;
	typedef String<TFragment, Block<> > TFragmentString;
	TFragmentString matches;
	int score = localAlignment(matches, str, score_type, SmithWaterman() );
	std::cout << "Scoring schema: Match=2, Mismatch=-1, Gap-extension=-1, Gap-opening=-2" << std::endl;
	std::cout << str0 << std::endl;
	std::cout << str1 << std::endl;
	std::cout << "Local match: " << std::endl;
	std::cout << label(matches[0], str, 0) << std::endl;
	std::cout << label(matches[0], str, 1) << std::endl;
	std::cout << "Score: " << score << std::endl;
	return 0;
}

