#include <seqan/graph.h>
#include <iostream>

using namespace seqan;

int main() {
	typedef String<char> TString;
	typedef StringSet<TString, Dependent<> > TStringSet;
	typedef Graph<Alignment<TStringSet, void> > TGraph;
	TStringSet str;
	TString str0("Myannealing");appendValue(str, str0);
	TString str1("annual"); appendValue(str, str1);
	Score<int> score_type = Score<int>(0,-1,-1,0);
	TGraph g(str);
	int score = globalAlignment(g, score_type, NeedlemanWunsch() );
	std::cout << "Scoring schema: Match=0, Mismatch=-1, Gap=-1" << std::endl;
	std::cout << g << std::endl;
	std::cout << "Score: " << score << std::endl;
	AlignConfig<true,false,false,true> ac;
	int score2 = globalAlignment(stringSet(g), score_type, ac, NeedlemanWunsch() );
	std::cout << "Score with ends free-space alignment: " << score2 << std::endl;
	return 0;
}
