#include <seqan/graph.h>
#include <iostream>

using namespace seqan;


int main() {
	typedef String<AminoAcid> TString;
	typedef StringSet<TString, Dependent<> > TStringSet;
	typedef Graph<Alignment<TStringSet, unsigned int, Default> > TGraph;
	TString str1 = "GARFIELDTHELASTFATCAT";
	TString str2 = "GARFIELDTHEFASTCAT";
	TString str3 = "GARFIELDTHEVERYFASTCAT";
	TString str4 = "THEFATCAT";
	TStringSet strSet;
	assignValueById(strSet, str1);
	assignValueById(strSet, str2);
	assignValueById(strSet, str3);
	assignValueById(strSet, str4);
	Graph<Alignment<TStringSet, void, WithoutEdgeId> > gOut(strSet);
	tCoffeeProteinAlignment(strSet, gOut);
	std::cout << gOut << std::endl;
	return 0;
}
