#include <seqan/graph.h>
#include <iostream>

using namespace seqan;

int main() {
	typedef String<char> TString;
	typedef StringSet<TString, Dependent<> > TStringSet;
	typedef Graph<Alignment<TStringSet, void> > TGraph;
	TStringSet str;
	TString str0("TarfieldandGarfieldarestupid.");appendValue(str, str0);
	TString str1("Garfield");appendValue(str, str1);
	Score<int> score_type = Score<int>(2,-1,-1,-4);
	TGraph g(str);
	int score = globalAlignment(g, score_type, Gotoh());
	std::cout << "Scoring schema: Match=2, Mismatch=-1, Gap-extension=-1, Gap-opening=-4" << std::endl;
	std::cout << g << std::endl;
	std::cout << "Score: " << score << std::endl;
	AlignConfig<true,false,false,true> ac;
	int score2 = globalAlignment(g, score_type, ac, Gotoh() );
	std::cout << g << std::endl;
	std::cout << "Score with ends free-space alignment: " << score2 << std::endl;
	return 0;
}
