#include <seqan/graph.h>
#include <iostream>

using namespace seqan;

int main() {
	typedef Graph<Directed<> > TGraph;
	typedef VertexDescriptor<TGraph>::Type TVertexDescriptor;
	typedef EdgeDescriptor<TGraph>::Type TEdgeDescriptor;
	typedef Size<TGraph>::Type TSize;
	TSize numEdges = 5;
	TVertexDescriptor edges[] = {3,0, 1,2, 2,1, 1,3, 3,2};
	TGraph g;
	addEdges(g, edges, numEdges);
	std::cout << g << ::std::endl;
	Matrix<bool> closure;
	transitive_closure(g,closure);
	TSize len = length(closure, 0);
	for (TSize row=0;row < len;++row) {
		for (TSize col=0;col < len;++col) {
			std::cout << getValue(closure, row*len+col) << ",";
		}
		std::cout << ::std::endl;
	}
	return 0;
}
