
#include <seqan/graph.h>
#include <iostream>

using namespace seqan;


int main() 
{
	typedef Graph<Directed<> > TGraph;
	typedef VertexDescriptor<TGraph>::Type TVertexDescriptor;
	typedef EdgeDescriptor<TGraph>::Type TEdgeDescriptor;
	typedef Size<TGraph>::Type TSize;
	TSize numEdges = 8;
	TVertexDescriptor edges[] = {0,3, 0,1, 1,4, 2,4, 2,5, 3,1, 4,3, 5,5};
	TGraph g;
	addEdges(g, edges, numEdges);
	std::cout << g << ::std::endl;
	char names[] = {'u', 'v', 'w', 'x', 'y', 'z'};
	String<char> nameMap;
	resizeVertexMap(g,nameMap, names);
	String<unsigned int> predMap;
	String<unsigned int> discoveryTimeMap;
	String<unsigned int> finishingTimeMap;
	depth_first_search(g, predMap, discoveryTimeMap, finishingTimeMap);
	std::cout << "Depth-First search: " << ::std::endl;
	typedef Iterator<Graph<>, VertexIterator>::Type TVertexIterator;
	TVertexIterator it(g);
	while(!atEnd(it)) {
		std::cout << "Vertex " << getProperty(nameMap, getValue(it)) << ": ";
		std::cout << "Discovery time = " << getProperty(discoveryTimeMap, getValue(it)) << ",";
		std::cout << "Finishing time = " << getProperty(finishingTimeMap, getValue(it)) << ",";
		typedef Value<String<unsigned int> >::Type TPredVal;
		TPredVal pre = getProperty(predMap, getValue(it));
		if (pre != getNilPredecessor(g)) {
			std::cout << "Predecessor = " << getProperty(nameMap, pre) << ::std::endl;
		} else {
			std::cout << "Predecessor = nil" << ::std::endl;
		}
		goNext(it);
	}
	return 0;
}
