#include <iostream>
#include <fstream>
#include <cstdio>

#include <seqan/sequence.h>
#include <seqan/file.h>

using namespace seqan;
using namespace std;

int main()
{
	FILE * fl = fopen("testfile.fa", "wb");
    write(fl, "aacagtattagaccactaggaccct", "a test file", Fasta());
	close (fl);
	fstream fstrm;
	fstrm.open("testfile.fa", ios_base::in | ios_base::binary);
	String<char> fasta_tag;
	String<Dna> fasta_seq;

	readMeta(fstrm, fasta_tag, Fasta());
	cout << fasta_tag << "\n";	//prints "a test file"

	read(fstrm, fasta_seq, Fasta());
	cout << fasta_seq << "\n";	//prints the sequence
	fstrm.close();
	String<Dna, FileReader<Fasta> > fr("testfile.fa");
	cout << fr << "\n";			//prints the sequence

	return 0;
}

