#include <iostream>
#include <seqan/align.h>
#include <seqan/graph.h>

using namespace std;
using namespace seqan;

int main()
{
	DnaString seq1 = "atcgaatgcgga";
	DnaString seq2 = "actcgttgca";
	Score<int> score(0, -1, -2, -1);
	Align<DnaString, ArrayGaps> align;
	resize(rows(align), 2);
	assignSource(row(align, 0), seq1);
	assignSource(row(align, 1), seq2);

	cout << "Score = " << globalAlignment(align, score) << endl;
	cout << align << endl;
	cout << "Score = " << globalAlignment(align, score, MyersHirschberg()) << endl;
	cout << align << endl;
	typedef StringSet<DnaString, Dependent<> > TStringSet;
	typedef Graph<Alignment<TStringSet, void> > TAlignmentGraph;

	TStringSet string_set;
	appendValue(string_set, seq1);
	appendValue(string_set, seq2);
	TAlignmentGraph alignment_graph(string_set);

	cout << "Score = " << globalAlignment(alignment_graph, score, Hirschberg()) << endl;
	cout << alignment_graph << endl;

	return 0;
}
