FONT='Helvetica, 13pt'
set ytics font FONT
set ylabel 'normalized found intervals [%]' font FONT offset -3
set xtics font FONT
set xlabel 'error rate [%]' font FONT offset 0,-0.5
#unset key

set style line 1 lw 4 ps 1.5
set style line 2 lw 4 ps 1.5
set style line 3 lw 4 ps 1.5 lc 8 pt 6
set style line 4 lw 4 ps 1.5
set style line 5 lw 4 ps 1.5 lc -1 pt 8
set style line 6 lw 4 ps 1.5

set terminal pdf enhanced

# ---------------------------------------------------------------------------
# Drosophila, SRR026674, edit distance.
# ---------------------------------------------------------------------------

set yrange [80:101]

set key on Left reverse width 6 bottom center horizontal height 3 width 8 spacing 4 font FONT 

set output 'all_drosophila_SRR026674_10k_edit.pdf'
plot 'all_drosophila_SRR026674.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_drosophila_SRR026674.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_drosophila_SRR026674.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_drosophila_SRR026674.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_drosophila_SRR026674.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_drosophila_SRR026674.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_drosophila_SRR026674.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_drosophila_SRR026674_10k_edit.pdf'
plot 'all-best_drosophila_SRR026674.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_drosophila_SRR026674.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_drosophila_SRR026674.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR026674.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR026674.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_drosophila_SRR026674.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_drosophila_SRR026674.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [80:101]

set output 'any-best_drosophila_SRR026674_10k_edit.pdf'
plot 'any-best_drosophila_SRR026674.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_drosophila_SRR026674.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_drosophila_SRR026674.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_drosophila_SRR026674.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_drosophila_SRR026674.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_drosophila_SRR026674.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_drosophila_SRR026674.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

#unset key

# ---------------------------------------------------------------------------
# Drosophila, SRR034673, edit distance.
# ---------------------------------------------------------------------------

set yrange [30:101]

set output 'all_drosophila_SRR034673_10k_edit.pdf'
plot 'any-best_drosophila_SRR034673.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_drosophila_SRR034673.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_drosophila_SRR034673.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set output 'all-best_drosophila_SRR034673_10k_edit.pdf'
plot 'all-best_drosophila_SRR034673.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR034673.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR034673.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set yrange [30:101]

set output 'any-best_drosophila_SRR034673_10k_edit.pdf'
plot 'all-best_drosophila_SRR034673.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR034673.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR034673.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

# ---------------------------------------------------------------------------
# Drosophila, SRR049254, edit distance
# ---------------------------------------------------------------------------

set yrange [75:101]

set output 'all_drosophila_SRR049254_10k_edit.pdf'
plot 'all_drosophila_SRR049254.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_drosophila_SRR049254.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_drosophila_SRR049254.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_drosophila_SRR049254.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_drosophila_SRR049254.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_drosophila_SRR049254.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_drosophila_SRR049254.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_drosophila_SRR049254_10k_edit.pdf'
plot 'all-best_drosophila_SRR049254.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_drosophila_SRR049254.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_drosophila_SRR049254.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR049254.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR049254.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_drosophila_SRR049254.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_drosophila_SRR049254.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [75:100.4]

set output 'any-best_drosophila_SRR049254_10k_edit.pdf'
plot 'any-best_drosophila_SRR049254.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_drosophila_SRR049254.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_drosophila_SRR049254.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_drosophila_SRR049254.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_drosophila_SRR049254.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_drosophila_SRR049254.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_drosophila_SRR049254.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

# ---------------------------------------------------------------------------
# Drosophila, SRR026674, Hamming distance.
# ---------------------------------------------------------------------------

set yrange [80:101]
#set key on Left reverse width 6 bottom center horizontal height 1 font FONT

set output 'all-best_drosophila_SRR026674_10k_hamming.pdf'
plot 'all_drosophila_SRR026674.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_drosophila_SRR026674.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_drosophila_SRR026674.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_drosophila_SRR026674.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_drosophila_SRR026674.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_drosophila_SRR026674.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_drosophila_SRR026674.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_drosophila_SRR026674_10k_hamming.pdf'
plot 'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_drosophila_SRR026674.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [97:100.4]

set output 'any-best_drosophila_SRR026674_10k_hamming.pdf'
plot 'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_drosophila_SRR026674.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

#unset key

# ---------------------------------------------------------------------------
# Drosophila, SRR034673, Hamming distance.
# ---------------------------------------------------------------------------

set yrange [0:101]

set output 'all_drosophila_SRR034673_10k_hamming.pdf'
plot 'all_drosophila_SRR034673.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_drosophila_SRR034673.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_drosophila_SRR034673.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set output 'all-best_drosophila_SRR034673_10k_hamming.pdf'
plot 'all-best_drosophila_SRR034673.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR034673.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR034673.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set yrange [0:101]

set output 'any-best_drosophila_SRR034673_10k_hamming.pdf'
plot 'any-best_drosophila_SRR034673.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_drosophila_SRR034673.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_drosophila_SRR034673.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

# ---------------------------------------------------------------------------
# Drosophila, SRR049254, Hamming distance
# ---------------------------------------------------------------------------

set yrange [60:101]

set output 'all_drosophila_SRR049254_10k_hamming.pdf'
plot 'all_drosophila_SRR049254.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_drosophila_SRR049254.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_drosophila_SRR049254.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_drosophila_SRR049254.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_drosophila_SRR049254.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_drosophila_SRR049254.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_drosophila_SRR049254.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_drosophila_SRR049254_10k_hamming.pdf'
plot 'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_drosophila_SRR049254.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [75:101]

set output 'any-best_drosophila_SRR049254_10k_hamming.pdf'
plot 'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_drosophila_SRR049254.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

# ---------------------------------------------------------------------------
# Saccharomyces, SRR000853, edit distance.
# ---------------------------------------------------------------------------

set yrange [40:101]

set output 'all_saccharomyces_SRR000853_10k_edit.pdf'
plot 'all_saccharomyces_SRR000853.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_saccharomyces_SRR000853.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_saccharomyces_SRR000853.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set output 'all-best_saccharomyces_SRR000853_10k_edit.pdf'
plot 'all-best_saccharomyces_SRR000853.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_saccharomyces_SRR000853.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_saccharomyces_SRR000853.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set yrange [48:101]

set output 'any-best_saccharomyces_SRR000853_10k_edit.pdf'
plot 'any-best_saccharomyces_SRR000853.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_saccharomyces_SRR000853.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_saccharomyces_SRR000853.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

# ---------------------------------------------------------------------------
# Saccharomyces, SRR003673, edit distance.
# ---------------------------------------------------------------------------

set yrange [85:101]

#set key on Left reverse width 6 bottom center horizontal height 1 font FONT

set output 'all_saccharomyces_SRR003673_10k_edit.pdf'
plot 'all_saccharomyces_SRR003673.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_saccharomyces_SRR003673.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_saccharomyces_SRR003673.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_saccharomyces_SRR003673.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_saccharomyces_SRR003673.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_saccharomyces_SRR003673.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_saccharomyces_SRR003673.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_saccharomyces_SRR003673_10k_edit.pdf'
plot 'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_saccharomyces_SRR003673.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [96:100.4]

set output 'any-best_saccharomyces_SRR003673_10k_edit.pdf'
plot 'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_saccharomyces_SRR003673.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

#unset key


# ---------------------------------------------------------------------------
# Saccharomyces, SRR038098, edit distance.
# ---------------------------------------------------------------------------

set yrange [95:101]

set output 'all_saccharomyces_SRR038098_10k_edit.pdf'
plot 'all_saccharomyces_SRR038098.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_saccharomyces_SRR038098.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_saccharomyces_SRR038098.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_saccharomyces_SRR038098.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_saccharomyces_SRR038098.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_saccharomyces_SRR038098.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_saccharomyces_SRR038098.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_saccharomyces_SRR038098_10k_edit.pdf'
plot 'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_saccharomyces_SRR038098.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [96:100.4]

set output 'any-best_saccharomyces_SRR038098_10k_edit.pdf'
plot 'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_saccharomyces_SRR038098.10k_edit.csv' using 1:8 with linespoints title 'Soap2*' ls 7


# ---------------------------------------------------------------------------
# Saccharomyces, SRR000853, Hamming distance.
# ---------------------------------------------------------------------------

set yrange [48:101]

set output 'all_saccharomyces_SRR000853_10k_hamming.pdf'
plot 'all_saccharomyces_SRR000853.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_saccharomyces_SRR000853.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_saccharomyces_SRR000853.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set output 'all-best_saccharomyces_SRR000853_10k_hamming.pdf'
plot 'all-best_saccharomyces_SRR000853.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_saccharomyces_SRR000853.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_saccharomyces_SRR000853.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

set yrange [48:101]

set output 'any-best_saccharomyces_SRR000853_10k_hamming.pdf'
plot 'any-best_saccharomyces_SRR000853.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_saccharomyces_SRR000853.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_saccharomyces_SRR000853.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5

# ---------------------------------------------------------------------------
# Saccharomyces, SRR003673, Hamming distance.
# ---------------------------------------------------------------------------

set yrange [85:101]

#set key on Left reverse width 6 bottom center horizontal height 1 font FONT

set output 'all_saccharomyces_SRR003673_10k_hamming.pdf'
plot 'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_saccharomyces_SRR003673.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_saccharomyces_SRR003673_10k_hamming.pdf'
plot 'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [96:100.4]

set output 'any-best_saccharomyces_SRR003673_10k_hamming.pdf'
plot 'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_saccharomyces_SRR003673.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

#unset key


# ---------------------------------------------------------------------------
# Saccharomyces, SRR038098, Hamming distance.
# ---------------------------------------------------------------------------

set yrange [85:101]

set output 'all_saccharomyces_SRR038098_10k_hamming.pdf'
plot 'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all_saccharomyces_SRR038098.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set output 'all-best_saccharomyces_SRR038098_10k_hamming.pdf'
plot 'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'all-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7

set yrange [96:100.4]

set output 'any-best_saccharomyces_SRR038098_10k_hamming.pdf'
plot 'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:2 with linespoints title 'Bowtie' ls 1, \
     'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:3 with linespoints title 'Bowtie*' ls 2, \
     'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:4 with linespoints title 'Bwa' ls 3, \
     'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:5 with linespoints title 'Razers' ls 4, \
     'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:6 with linespoints title 'Shrimp2' ls 5, \
     'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:7 with linespoints title 'Soap2' ls 6, \
     'any-best_saccharomyces_SRR038098.10k_hamming.csv' using 1:8 with linespoints title 'Soap2*' ls 7



set output 'test.pdf'
test
